/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.commands;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentDependencyCheckerUtil;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.ErrorJob;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.RollbackJob;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.internal.commands.AbstractInstallCommand;
import com.ibm.cic.agent.core.internal.commands.HeadlessApplicationException;
import com.ibm.cic.agent.core.internal.commands.XMLElement;
import com.ibm.cic.agent.core.internal.headless.IRollbackCommand;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.ExtensionCategory;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Version;

public class RollbackCommand
extends AbstractInstallCommand
implements IRollbackCommand {
    public RollbackCommand() {
        super("rollback");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IStatus execute(Agent agent, AgentJob[] agentJobs, IProgressMonitor monitor) {
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, new int[]{2, 2, 2, 20, 1});
        try {
            SplitProgressMonitor jobLoopMonitor = new SplitProgressMonitor(spm.next(), agentJobs.length);
            try {
                AgentJob[] agentJobArray = agentJobs;
                int n = agentJobs.length;
                int n2 = 0;
                while (n2 < n) {
                    AgentJob agentJob = agentJobArray[n2];
                    this.prepareJob(status, agent, agentJob, jobLoopMonitor.next());
                    if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                        CicMultiStatus cicMultiStatus = status;
                        return cicMultiStatus;
                    }
                    if (jobLoopMonitor.isCanceled()) {
                        status.add(Status.CANCEL_STATUS);
                        CicMultiStatus cicMultiStatus = status;
                        return cicMultiStatus;
                    }
                    ++n2;
                }
                jobLoopMonitor.done();
                status.add(RollbackCommand.performLocationPermissionCheck(agentJobs));
                if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                    CicMultiStatus cicMultiStatus = status;
                    return cicMultiStatus;
                }
                status.add(BitModeUtils.check64bitImSupported(agentJobs));
                if (status.isErrorOrCancel()) {
                    CicMultiStatus cicMultiStatus = status;
                    return cicMultiStatus;
                }
                jobLoopMonitor = new SplitProgressMonitor(spm.next(), agentJobs.length);
                Set offeringsSeenBefore = AgentJob.getOfferingSetFromJobs(agentJobs);
                AgentJob[] agentJobArray2 = agentJobs;
                int n3 = agentJobs.length;
                n = 0;
                while (n < n3) {
                    AgentJob agentJob = agentJobArray2[n];
                    this.checkJob(status, agent, agentJob, offeringsSeenBefore, jobLoopMonitor.next());
                    if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                        CicMultiStatus cicMultiStatus = status;
                        return cicMultiStatus;
                    }
                    if (jobLoopMonitor.isCanceled()) {
                        status.add(Status.CANCEL_STATUS);
                        CicMultiStatus cicMultiStatus = status;
                        return cicMultiStatus;
                    }
                    ++n;
                }
            }
            finally {
                jobLoopMonitor.done();
            }
            status.add(AgentDependencyCheckerUtil.checkOfferingFixDependenciesMultipleProfiles(agentJobs, spm.next()));
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                CicMultiStatus cicMultiStatus = status;
                return cicMultiStatus;
            }
            status.add(agent.install(agentJobs, spm.next()));
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                CicMultiStatus cicMultiStatus = status;
                return cicMultiStatus;
            }
            this.outputCompletedAgentJobs(agent, agentJobs);
            return status;
        }
        finally {
            try {
                status.add(agent.unprepare(agentJobs, spm.next()));
            }
            finally {
                spm.done();
                monitor.done();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void prepareJob(CicMultiStatus status, Agent agent, AgentJob agentJob, IProgressMonitor monitor) {
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, new int[]{1, 1, 1});
        try {
            IOfferingOrFix offeringOrFix = agentJob.getOfferingOrFix();
            status.add(agent.prepare(offeringOrFix, ExtensionCategory.ALL, spm.next()));
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                return;
            }
            status.add(this.prepareInstalledFixes(agent, agentJob.getProfile(), spm.next()));
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                return;
            }
            IOffering baseOffering = null;
            if (agentJob instanceof RollbackJob) {
                baseOffering = ((RollbackJob)agentJob).getRollbackFromOffering();
            }
            if (baseOffering != null) {
                status.add(agent.prepare((IOfferingOrFix)baseOffering, ExtensionCategory.ALL, spm.next()));
                if (!StatusUtil.isErrorOrCancel((IStatus)status)) return;
                return;
            }
            spm.next().done();
            return;
        }
        finally {
            spm.done();
            monitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkJob(CicMultiStatus status, Agent agent, AgentJob agentJob, Set offeringsSeenBefore, IProgressMonitor monitor) {
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, new int[]{1});
        try {
            IOfferingOrFix offeringOrFix = agentJob.getOfferingOrFix();
            status.add(agent.evaluatePrecheckBundles(offeringOrFix, agentJob));
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                return;
            }
            status.add(agent.evaluatePrereqBundles(offeringOrFix, agentJob));
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                return;
            }
            status.add(RollbackCommand.checkPrerequisite(agent, agentJob, offeringsSeenBefore, spm.next()));
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                return;
            }
            status.add(agentJob.checkOfferingApplicability());
            if (!StatusUtil.isErrorOrCancel((IStatus)status)) return;
            return;
        }
        finally {
            spm.done();
            monitor.done();
        }
    }

    @Override
    public AgentJob[] getAsInputJobs(Agent agent, boolean isWizardMode) {
        ArrayList<AgentJob> result = new ArrayList<AgentJob>();
        String installLocation = null;
        for (XMLElement child : this.children()) {
            AgentJob[] childJobs = this.getAsInputJob(agent, child, isWizardMode, null);
            result.addAll(Arrays.asList(childJobs));
            if (!CmdLine.CL.containsCommand("rollback") || !child.getName().equals("offering") || childJobs.length != 1 || !(childJobs[0] instanceof RollbackJob)) continue;
            String childInstallLocation = ((RollbackJob)childJobs[0]).getProfile().getInstallLocation();
            if (installLocation == null) {
                installLocation = childInstallLocation;
                continue;
            }
            if (childInstallLocation.compareTo(installLocation) == 0) continue;
            result.addAll(Arrays.asList(ErrorJob.create(false, Messages.RollbackCommand_MultiplePackagesMustBelongToSameProfile, new Object[0])));
        }
        AgentJob[] jobs = AgentJob.toArray(result);
        this.initializeProfilePlatformProperties(jobs);
        this.setAcceptLicense(jobs);
        return jobs;
    }

    private IOffering getRecommendedOfferingForRollback(Agent agent, String profileId, String offeringId) {
        Profile profile = agent.getProfile(profileId);
        SimpleIdentity identity = new SimpleIdentity(offeringId);
        IOffering[] previouslyInstalledOfferings = agent.getInstalledOfferings(profile, (IIdentity)identity);
        Version recommendedVersion = null;
        IOffering recommendedOffering = null;
        if (previouslyInstalledOfferings != null && previouslyInstalledOfferings.length > 1) {
            IOffering[] iOfferingArray = previouslyInstalledOfferings;
            int n = previouslyInstalledOfferings.length;
            int n2 = 0;
            while (n2 < n) {
                IOffering offering = iOfferingArray[n2];
                Version currentVersion = offering.getVersion();
                if (!(offering.getVersion().equals((Object)agent.getInstalledOffering(profile, (IIdentity)identity).getVersion()) || recommendedVersion != null && currentVersion.compareTo(recommendedVersion) <= 0)) {
                    recommendedVersion = currentVersion;
                    recommendedOffering = offering;
                }
                ++n2;
            }
        }
        return recommendedOffering;
    }

    @Override
    protected AgentJob[] getAsInputJob(Agent agent, XMLElement unit, boolean isWizardMode, Profile defaultProfile) {
        IOffering offering;
        String profileId = unit.getAttribute("profile");
        String idString = unit.getAttribute("id");
        String versionString = unit.getAttribute("version");
        String features = unit.getAttribute("features");
        String installLocation = unit.getAttribute("installLocation");
        Profile profile = agent.getProfile(profileId);
        if (idString == null) {
            if (unit.getName().equals("offering")) {
                return ErrorJob.create(false, Messages.RollbackCommand_MustSpecifyId, new Object[0]);
            }
            return AgentJob.NO_JOBS;
        }
        if (profile == null && installLocation != null && (profile = agent.getProfileByInstallLocation(installLocation)) == null) {
            return ErrorJob.create(false, Messages.RollbackCommand_NoProfileFoundForInstallationDir, idString, installLocation);
        }
        if (versionString == null) {
            if (profile == null) {
                List profiles = agent.getProfilesByOfferingOrFixId(idString);
                if (profiles.isEmpty()) {
                    if (agent.isSkipInstall() && agent.isRecordMode()) {
                        return ErrorJob.create(true, Messages.Cmd_modifyIInvalidAppDataError, new Object[0]);
                    }
                    return ErrorJob.create(false, Messages.RollbackCommand_PackageNotFoundInProfile, idString);
                }
                if (profiles.size() > 1) {
                    return ErrorJob.create(false, Messages.RollbackCommand_InstalledInMoreThenOneLocationOff, idString);
                }
                profile = (Profile)profiles.get(0);
            }
            if ((offering = this.getRecommendedOfferingForRollback(agent, profile.getProfileId(), idString)) == null) {
                return ErrorJob.create(false, Messages.RollbackCommand_LastVersionNotAllowed, idString);
            }
            versionString = offering.getVersion().toString();
        } else {
            Version version;
            try {
                version = RollbackCommand.getVersion(idString, versionString);
            }
            catch (HeadlessApplicationException e) {
                return ErrorJob.create(false, e.getStatus());
            }
            if (profile == null && installLocation == null) {
                List profiles = agent.getProfilesByOfferingOrFixId(idString);
                ArrayList<Profile> profilesFound = new ArrayList<Profile>();
                int i = 0;
                while (i < profiles.size()) {
                    IOffering[] previouslyInstalledOfferings;
                    Profile currentProfile = (Profile)profiles.get(i);
                    IOffering currentOffering = currentProfile.findOffering(idString);
                    Version latestVersion = currentOffering.getVersion();
                    IOffering[] iOfferingArray = previouslyInstalledOfferings = agent.getInstalledOfferings(currentProfile, currentOffering.getIdentity());
                    int n = previouslyInstalledOfferings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IOffering prevOffering = iOfferingArray[n2];
                        if (prevOffering.getVersion().compareTo(version) == 0 && latestVersion.compareTo(prevOffering.getVersion()) > 0) {
                            profilesFound.add(currentProfile);
                        }
                        ++n2;
                    }
                    ++i;
                }
                if (profilesFound.size() == 0) {
                    if (agent.isSkipInstall() && agent.isRecordMode()) {
                        return ErrorJob.create(true, Messages.Cmd_modifyIInvalidAppDataError, new Object[0]);
                    }
                    return ErrorJob.create(false, Messages.RollbackCommand_OfferingVersionNotFoundInProfile, idString, versionString);
                }
                if (profilesFound.size() == 1) {
                    profile = (Profile)profilesFound.get(0);
                } else if (profilesFound.size() > 1) {
                    return ErrorJob.create(false, Messages.RollbackCommand_InstalledInMoreThenOneLocationOffVsn, idString, version.toString());
                }
            }
        }
        if (features != null && features.length() != 0) {
            return ErrorJob.create(false, (IStatus)Statuses.WARNING.get(Messages.RollbackCommand_Attribute_Ignored_In_Element, new Object[]{"features", features, "rollback"}));
        }
        try {
            if (profile == null) {
                if (agent.isSkipInstall() && agent.isRecordMode()) {
                    return ErrorJob.create(true, Messages.Cmd_modifyIInvalidAppDataError, new Object[0]);
                }
                return ErrorJob.create(true, Messages.HeadlessApplication_Cannot_Find_Profile, profileId);
            }
            IStatus stat = this.setProfileData(profile);
            if (!stat.isOK()) {
                return ErrorJob.create(true, stat);
            }
            offering = this.getInstalledOffering(agent, profile, idString, versionString);
            if (offering == null) {
                return ErrorJob.create(true, Messages.RollbackCommand_NotInstalled, idString, versionString);
            }
            if (!agent.isRollbackAllowed(profile, offering)) {
                return ErrorJob.create(true, Messages.RollbackCommand_NotAllowed, idString, versionString);
            }
            RollbackJob job = new RollbackJob(profile, (IOfferingOrFix)offering, profile.getInstallRegistry().getInstalledOffering(offering.getIdentity()));
            return new AgentJob[]{job};
        }
        catch (HeadlessApplicationException e) {
            return ErrorJob.create(false, e.getStatus());
        }
    }

    @Override
    public void addOffering(IOfferingOrFix offeringOrFix, Profile profile, IFeature[] features) {
        super.addOffering(offeringOrFix, profile, null);
    }
}

