/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.commands;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.internal.commands.AbstractCommand;
import com.ibm.cic.agent.core.internal.commands.XMLElement;
import com.ibm.cic.agent.core.internal.headless.IImportCommand;
import com.ibm.cic.agent.core.internal.headless.IInput;
import com.ibm.cic.agent.core.internal.headless.IProfileCommand;
import com.ibm.cic.agent.core.utils.AgentUserOptions;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ProfileCommand
extends AbstractCommand
implements IProfileCommand {
    private boolean isModify = false;
    private boolean hasUserData = false;
    private static final Logger log = Logger.getLogger(ProfileCommand.class);

    public ProfileCommand() {
        super("profile");
    }

    public ProfileCommand(String id) {
        super("profile");
        this.addAttribute("id", id);
    }

    @Override
    public int getExecutionPoint() {
        return 2;
    }

    private String getNormalizedInstallLocation() {
        String returnValue = this.getAttribute("installLocation");
        if (returnValue != null) {
            returnValue = new File(returnValue).getAbsolutePath();
        }
        return returnValue;
    }

    @Override
    public IStatus execute(Agent agent, IProgressMonitor monitor) {
        Profile existingProfile;
        String id = this.getAttribute("id");
        if (!Profile.isValidId(id).isOK()) {
            return new Status(4, Agent.PI_AGENT, 0, NLS.bind((String)Messages.Profile_Invalid_Profile_Id, (Object)id), null);
        }
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        String profileKind = this.getAttribute("kind");
        if (profileKind == null) {
            profileKind = "product";
        }
        Profile profile = existingProfile = "self".equals(profileKind) ? agent.getAgentProfile() : agent.getProfile(id);
        if (existingProfile == null) {
            IStatus propertyStatus;
            IStatus kindStatus = this.isValidKind(profileKind);
            if (!kindStatus.isOK()) {
                return kindStatus;
            }
            boolean shouldPartition = (AgentUserOptions.PARTITION_ENABLED_PROPERTY.isSet() || this.isPortable()) && !Agent.getInstance().isSkipInstall();
            Profile profile2 = new Profile(id, profileKind, shouldPartition);
            String installLocation = this.getNormalizedInstallLocation();
            if (installLocation != null) {
                status.add(profile2.setInstallLocation(installLocation));
            }
            if (!(propertyStatus = this.processProfileProperties(profile2, false)).isOK()) {
                return propertyStatus;
            }
            if (!this.shouldSkipProfileQualification(profile2)) {
                status.add(agent.qualifyNewProfile(profile2));
                if (status.isOK()) {
                    status.add(agent.initializeNewProfile(profile2));
                }
            }
            agent.addProfile(profile2);
        } else {
            status.add(this.processProfileProperties(existingProfile, true));
        }
        return status;
    }

    private boolean isPortable() {
        for (XMLElement child : this.children()) {
            String childName = child.getName();
            if (!"data".equals(childName)) continue;
            String key = child.getAttribute("key");
            String value = child.getAttribute("value");
            if (!key.equals("cic.selector.portable")) continue;
            return Boolean.valueOf(value);
        }
        return false;
    }

    private IStatus processProfileProperties(Profile profile, boolean isExistingProfile) {
        CicMultiStatus ms = Statuses.OK.getMultiStatus();
        for (XMLElement child : this.children()) {
            String childName = child.getName();
            if (!"data".equals(childName)) continue;
            String key = child.getAttribute("key");
            String value = child.getAttribute("value");
            if (isExistingProfile) {
                String currentValue = null;
                boolean modifiableProperty = true;
                if (key.equals("installLocation")) {
                    currentValue = profile.getInstallLocation();
                    modifiableProperty = false;
                } else if (key.equals("cic.selector.arch")) {
                    currentValue = profile.getArch();
                    modifiableProperty = false;
                } else if (key.equals("eclipseLocation") || key.equals("locale")) {
                    currentValue = profile.getData(key);
                    modifiableProperty = false;
                } else if (!Profile.isUserData(key) && !this.isModify()) {
                    currentValue = profile.getData(key);
                    modifiableProperty = false;
                }
                if (!modifiableProperty) {
                    if (currentValue == null) {
                        log.warning(Messages.ProfileCommand_PropertyCannotBeAdded, new Object[]{key});
                        continue;
                    }
                    if (currentValue.equals(value)) continue;
                    log.warning(Messages.AbstractCommand_PropertyCannotBeModified, new Object[]{key, currentValue, value});
                    continue;
                }
                ms.add(profile.setData(key, value));
                this.checkIfUserData(key);
                continue;
            }
            if (key.equals("installLocation")) {
                ms.add(profile.setInstallLocation(value));
                continue;
            }
            ms.add(profile.setData(key, value));
            this.checkIfUserData(key);
        }
        return ms;
    }

    private void checkIfUserData(String key) {
        if (Profile.isUserData(key) && !"user.import.profile".equals(key)) {
            this.hasUserData = true;
        }
    }

    private boolean shouldSkipProfileQualification(Profile profile) {
        IImportCommand[] importCommands;
        String id = profile.getProfileId();
        if (id == null) {
            return false;
        }
        IInput input = this.getInput();
        if (input == null) {
            return false;
        }
        IImportCommand[] iImportCommandArray = importCommands = input.getImportCommands();
        int n = importCommands.length;
        int n2 = 0;
        while (n2 < n) {
            IImportCommand importCommand = iImportCommandArray[n2];
            if (id.equals(importCommand.getProfileId())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private IStatus isValidKind(String kind) {
        IStatus status = Profile.isValidKind(kind);
        if (!status.isOK()) {
            return status;
        }
        if (!"self".equals(kind) && !"product".equals(kind)) {
            return new Status(4, Agent.PI_AGENT, 0, NLS.bind((String)Messages.Profile_Invalid_Profile_Kind, (Object)kind), null);
        }
        return Status.OK_STATUS;
    }

    @Override
    public void setInstallLocation(String installLocation) {
        this.addAttribute("installLocation", installLocation);
    }

    @Override
    public void setProfileKind(String profileKind) {
        this.addAttribute("kind", profileKind);
    }

    @Override
    public String getProfileId() {
        return this.getAttribute("id");
    }

    public boolean isModify() {
        return this.isModify;
    }

    @Override
    public void setModify(boolean isModify) {
        this.isModify = isModify;
    }

    @Override
    public boolean needAccessRepositories() {
        return false;
    }

    @Override
    public boolean hasUserDataSpecified() {
        return this.hasUserData;
    }
}

