/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.commands;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.internal.commands.InputModel;
import com.ibm.cic.agent.core.internal.commands.InputParser;
import com.ibm.cic.agent.core.internal.commands.InputVariableSubstitution;
import com.ibm.cic.agent.core.internal.commands.InstallCommand;
import com.ibm.cic.agent.core.internal.commands.XMLElement;
import com.ibm.cic.agent.core.internal.headless.IAcceptLicenseCommand;
import com.ibm.cic.agent.core.internal.headless.ICommand;
import com.ibm.cic.agent.core.internal.headless.IImportCommand;
import com.ibm.cic.agent.core.internal.headless.IInput;
import com.ibm.cic.agent.core.internal.headless.IInstallCommand;
import com.ibm.cic.agent.core.internal.headless.IModifyCommand;
import com.ibm.cic.agent.core.internal.headless.IPreferenceCommand;
import com.ibm.cic.agent.core.internal.headless.IProfileCommand;
import com.ibm.cic.agent.core.internal.headless.IRollbackCommand;
import com.ibm.cic.agent.core.internal.headless.IServerCommand;
import com.ibm.cic.agent.core.internal.headless.IUninstallCommand;
import com.ibm.cic.agent.core.internal.headless.IUpdateCommand;
import com.ibm.cic.agent.core.internal.headless.IVariablesCommand;
import com.ibm.cic.agent.core.internal.response.IDocumentRoot;
import com.ibm.cic.agent.core.internal.response.Response;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.RuntimeStatusException;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusFormatter;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.XMLWriter;
import com.ibm.cic.common.downloads.ContentInfo;
import com.ibm.cic.common.downloads.DownloadUtil;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadSession;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.logging.UidUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.xml.sax.SAXException;

public class Input
implements IInput {
    private static final Logger logger = Logger.getLogger(Input.class);
    private final List<ICommand> commandList = new ArrayList<ICommand>();
    private final File logfile;
    private XMLElement xmlElement = null;
    private boolean isCleanMode = false;
    private boolean isTemporaryMode = false;
    private boolean isRebootLater = false;
    private boolean isAcceptLicense = false;
    private File inputFile = null;
    private String inputFilePath = null;
    private InputStream inputStream = null;
    private final int fileFormat = 1;
    private IDocumentRoot documentRoot;
    private final Response response = null;
    private boolean isAgentRepoSkipped = false;
    private final InputVariableSubstitution variables = new InputVariableSubstitution();

    public Input() {
        this(null);
    }

    public Input(File logfile) {
        this.logfile = logfile;
    }

    public String toString() {
        if (this.commandList.size() == 0) {
            return "<empty>";
        }
        StringBuffer sb = new StringBuffer();
        for (ICommand iCommand : this.commandList) {
            sb.append(iCommand);
        }
        return sb.toString();
    }

    @Override
    public IStatus load(InputStream stream) {
        IStatus ret = Status.OK_STATUS;
        try {
            CicMultiStatus status = Statuses.ST.createMultiStatus();
            this.inputStream = stream;
            this.xmlElement = new InputParser(this.getInputFilePath()).parse(this.inputStream, InputModel.getRootRule(), status);
            if (CmdLine.CL.containsCommand("-acceptLicense")) {
                CicMultiStatus filteredStatus = Statuses.ST.createMultiStatus();
                IStatus[] iStatusArray = status.getLeaves();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus childStatus = iStatusArray[n2];
                    if (childStatus.getSeverity() != 2 || !childStatus.getMessage().contains(Messages.InputModel_acceptLicenseDeprecated)) {
                        filteredStatus.add(childStatus);
                    }
                    ++n2;
                }
                status = filteredStatus;
            }
            if (this.xmlElement != null) {
                this.handleInstallationDirectoryOption();
                for (XMLElement child : this.xmlElement.children()) {
                    ICommand command = (ICommand)((Object)child);
                    command.setInput(this);
                    this.addCommand(command);
                }
            } else {
                status.add((IStatus)Statuses.ERROR.get(Messages.Input_NoValidCommandFound, new Object[0]));
            }
            if (!status.isOK()) {
                ret = status;
            }
        }
        catch (SAXException e) {
            ret = Statuses.ERROR.get(e.getMessage(), new Object[0]);
        }
        catch (ParserConfigurationException e) {
            ret = Statuses.ERROR.get((Throwable)e, e.getMessage(), new Object[0]);
        }
        catch (IOException e) {
            ret = Statuses.ERROR.get((Throwable)e, e.getMessage(), new Object[0]);
        }
        if (StatusUtil.isErrorOrCancel((IStatus)ret) || this.xmlElement == null) {
            ret = this.createErrorStatus(ret);
        }
        return ret;
    }

    private void handleInstallationDirectoryOption() {
        String installDir = CmdLine.CL.getInstallationDirectory();
        if (installDir == null) {
            return;
        }
        for (XMLElement child : this.xmlElement.children()) {
            if (!(child instanceof InstallCommand)) continue;
            for (XMLElement element : child.children()) {
                if (!"offering".equals(element.getName()) || element.getAttribute("installLocation") != null || element.getAttribute("profile") != null) continue;
                element.addAttribute("installLocation", installDir);
            }
        }
    }

    @Override
    public IStatus substituteVariables(IInput cmdVarInput) {
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        if (cmdVarInput != null) {
            status.add(this.addCommandLineVars(cmdVarInput));
        }
        if (!StatusUtil.isError((IStatus)status)) {
            status.add(this.executeCommands(Agent.getInstance(), 16, null));
        }
        if (!StatusUtil.isError((IStatus)status)) {
            status.add(this.variables.validate());
        }
        if (!StatusUtil.isError((IStatus)status)) {
            try {
                for (ICommand command : this.commandList) {
                    this.performVariableSubstitution((XMLElement)((Object)command));
                }
            }
            catch (CoreException e) {
                status.add(e.getStatus());
            }
        }
        return status;
    }

    private IStatus addCommandLineVars(IInput cmdVarInput) {
        Input input = (Input)cmdVarInput;
        IStatus status = cmdVarInput.executeCommands(Agent.getInstance(), 16, null);
        this.addCmdLineVariables(input);
        if (status.isOK() && !input.onlyVariablesCommands()) {
            status = Statuses.WARNING.get(Messages.CommandsFromInputFileWarning, new Object[0]);
        }
        return status;
    }

    private boolean onlyVariablesCommands() {
        return this.commandList.size() == this.getCommands(IVariablesCommand.class).size();
    }

    private void performVariableSubstitution(XMLElement element) throws CoreException {
        Map<String, String> attributes = element.getAttributes();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String substitutedValue;
            String value = entry.getValue();
            if (value.equals(substitutedValue = this.variables.performVariableSubstitutions(value))) continue;
            element.addAttribute(entry.getKey(), substitutedValue);
        }
        for (XMLElement child : element.children()) {
            this.performVariableSubstitution(child);
        }
    }

    private IStatus createErrorStatus(IStatus error) {
        CicMultiStatus ms = Statuses.ST.createMultiStatus(Messages.Input_FailedReadResponseFile, new Object[0]);
        ms.add(error);
        return ms;
    }

    @Override
    public IStatus load(File file) {
        this.inputFile = file;
        this.inputFilePath = file.getAbsolutePath();
        try {
            return this.load(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            return this.createErrorStatus((IStatus)Statuses.ERROR.get(e.getMessage(), new Object[0]));
        }
    }

    @Override
    public void save(File file) throws FileNotFoundException {
        this.save(file, false);
    }

    @Override
    public void save(File file, boolean maskSensitiveAttrs) throws FileNotFoundException {
        FileUtil.ensureDestinationDirectory((File)file);
        if (this.documentRoot == null) {
            this.saveOld(file, maskSensitiveAttrs);
        } else {
            PrintWriter writer = new PrintWriter(Encodings.UTF8.writer(file));
            int size = this.documentRoot.getChildrenSize();
            int i = 0;
            while (i < size) {
                this.documentRoot.getChild(i).save(writer);
                ++i;
            }
            writer.close();
            if (!maskSensitiveAttrs) {
                this.inputFile = file;
            }
        }
    }

    @Override
    public String toXML() {
        assert (this.documentRoot == null);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.saveOld(os, false, false);
        return Encodings.UTF8.toString(os);
    }

    private void saveOld(File file, boolean maskSensitiveAttrs) throws FileNotFoundException {
        FileOutputStream os = new FileOutputStream(file);
        try {
            this.saveOld(os, maskSensitiveAttrs, true);
        }
        finally {
            FileUtil.close((Closeable)os);
        }
        if (!maskSensitiveAttrs) {
            this.inputFile = file;
        }
    }

    private void saveOld(OutputStream os, boolean maskSensitiveAttrs, boolean includeXmlPI) {
        try (XMLWriter writer = new XMLWriter(os, includeXmlPI);){
            writer.start("agent-input");
            writer.attribute("clean", this.isCleanMode(), false);
            writer.attribute("temporary", this.isTemporaryMode(), false);
            writer.attribute("rebootLater", this.isRebootLater(), false);
            for (ICommand command : this.commandList) {
                command.save(writer, maskSensitiveAttrs);
            }
            writer.end("agent-input");
        }
    }

    @Override
    public IStatus executeCommands(Agent agent, int executionPoint, IProgressMonitor monitor) {
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        ICommand[] commands = this.getCommands(executionPoint);
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, this.getWeights(commands));
        boolean modify = CmdLine.CL.containsCommand("modify");
        boolean rollback = CmdLine.CL.containsCommand("rollback");
        try {
            ICommand[] iCommandArray = commands;
            int n = commands.length;
            int n2 = 0;
            while (n2 < n) {
                ICommand command = iCommandArray[n2];
                try {
                    result.add(command.execute(agent, spm.next()));
                }
                catch (RuntimeStatusException e) {
                    result.add(e.getStatus());
                }
                catch (Throwable e) {
                    result.add((IStatus)Statuses.ERROR.get(e, e.toString(), new Object[0]));
                }
                if (spm.isCanceled()) {
                    result.add((IStatus)ICicStatus.CANCEL_STATUS);
                    break;
                }
                if (result.isErrorOrCancel()) {
                    if (modify) break;
                    if (rollback) {
                        break;
                    }
                }
                ++n2;
            }
        }
        finally {
            spm.done();
        }
        if (this.logfile != null) {
            this.recordLog(this.logfile, (IStatus)result);
        }
        return StatusUtil.toSingleStatus((IStatus)result);
    }

    private int[] getWeights(ICommand[] commands) {
        int[] weights = new int[commands.length];
        int i = 0;
        while (i < weights.length) {
            weights[i] = commands[i].getWeight();
            ++i;
        }
        return weights;
    }

    @Override
    public boolean isEmpty() {
        return this.commandList.isEmpty();
    }

    @Override
    public void addCommand(ICommand command) {
        this.commandList.add(command);
        if (command instanceof IAcceptLicenseCommand) {
            ((IAcceptLicenseCommand)command).setAcceptLicense(this.isAcceptLicense());
        }
    }

    @Override
    public void clear() {
        this.commandList.clear();
    }

    @Override
    public void removeCommand(ICommand command) {
        this.commandList.remove(command);
    }

    public void recordLog(File file, IStatus status) {
        try {
            File fileDir = file.getAbsoluteFile().getParentFile();
            if (!fileDir.exists()) {
                fileDir.mkdirs();
            }
            try (XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(file), true);){
                writer.start("result");
                this.recordStatus(writer, status);
                writer.end("result");
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e, e.getMessage(), new Object[0]);
        }
    }

    private void recordStatus(XMLWriter writer, IStatus status) {
        if (status.isOK()) {
            return;
        }
        if (!status.isMultiStatus() || !status.getMessage().isEmpty()) {
            String element;
            String uid = UidUtil.getUid((IStatus)status);
            if (status.matches(4)) {
                element = "error";
            } else if (status.matches(2)) {
                element = "warning";
            } else if (status.matches(1)) {
                element = "info";
                uid = null;
            } else {
                element = null;
            }
            if (element != null) {
                writer.start(element);
                writer.attribute("uid", (Object)uid);
                writer.cdata(StatusFormatter.toString((IStatus)status));
                writer.end();
            }
        }
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                this.recordStatus(writer, child);
                ++n2;
            }
        }
    }

    @Override
    public IInstallCommand[] getInstallCommands() {
        List<IInstallCommand> commands = this.getCommands(IInstallCommand.class);
        return commands.toArray(new IInstallCommand[commands.size()]);
    }

    @Override
    public IUpdateCommand[] getUpdateCommands() {
        List<IUpdateCommand> commands = this.getCommands(IUpdateCommand.class);
        return commands.toArray(new IUpdateCommand[commands.size()]);
    }

    @Override
    public IModifyCommand[] getModifyCommands() {
        List<IModifyCommand> commands = this.getCommands(IModifyCommand.class);
        return commands.toArray(new IModifyCommand[commands.size()]);
    }

    @Override
    public IUninstallCommand[] getUninstallCommands() {
        List<IUninstallCommand> commands = this.getCommands(IUninstallCommand.class);
        return commands.toArray(new IUninstallCommand[commands.size()]);
    }

    @Override
    public IRollbackCommand[] getRollbackCommands() {
        List<IRollbackCommand> commands = this.getCommands(IRollbackCommand.class);
        return commands.toArray(new IRollbackCommand[commands.size()]);
    }

    @Override
    public boolean isCleanMode() {
        if (!this.isCleanMode && this.xmlElement != null) {
            this.isCleanMode = Boolean.valueOf(this.xmlElement.getAttribute("clean"));
        }
        return this.isCleanMode;
    }

    @Override
    public void setCleanMode(boolean clean) {
        this.isCleanMode = clean;
    }

    @Override
    public boolean isTemporaryMode() {
        if (!this.isTemporaryMode && this.xmlElement != null) {
            this.isTemporaryMode = Boolean.valueOf(this.xmlElement.getAttribute("temporary"));
        }
        return this.isTemporaryMode;
    }

    @Override
    public void setTemporaryMode(boolean temporary) {
        this.isTemporaryMode = temporary;
    }

    @Override
    public boolean isRebootLater() {
        if (!this.isRebootLater && this.xmlElement != null) {
            this.isRebootLater = Boolean.valueOf(this.xmlElement.getAttribute("rebootLater"));
        }
        return this.isRebootLater;
    }

    @Override
    public void setRebootLater(boolean rebootLater) {
        this.isRebootLater = rebootLater;
    }

    @Override
    public boolean isAcceptLicense() {
        if (!this.isAcceptLicense) {
            if (CmdLine.CL.containsCommand("-acceptLicense")) {
                this.isAcceptLicense = true;
            } else if (this.xmlElement != null && Boolean.TRUE.toString().equals(this.xmlElement.getAttribute("acceptLicense"))) {
                this.isAcceptLicense = true;
            }
        }
        return this.isAcceptLicense;
    }

    @Override
    public void setAcceptLicense(boolean isAcceptLicense) {
        this.isAcceptLicense = isAcceptLicense;
    }

    @Override
    public boolean isSettingEclipseCacheLocation() {
        for (IPreferenceCommand prefCmd : this.getCommands(IPreferenceCommand.class)) {
            if (!"com.ibm.cic.common.core.preferences.eclipseCache".equals(prefCmd.getPreferenceName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public File getInputFile() {
        return this.inputFile;
    }

    @Override
    public boolean onlyUninstallAgent() {
        for (IUninstallCommand command : this.getCommands(IUninstallCommand.class)) {
            List offeringIds = command.getOfferingIds();
            if (offeringIds.size() != 1 || !"com.ibm.cic.agent".equals(offeringIds.get(0))) continue;
            return true;
        }
        return false;
    }

    @Override
    public IStatus executeProfileCommands(Agent agent, boolean isModify, IProgressMonitor monitor) {
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        List<IProfileCommand> profileCommands = this.getCommands(IProfileCommand.class);
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, profileCommands.size());
        try {
            for (IProfileCommand profileCommand : profileCommands) {
                profileCommand.setModify(isModify);
                result.add(profileCommand.execute(agent, spm.next()));
                if (!spm.isCanceled()) continue;
                result.add(Status.CANCEL_STATUS);
                break;
            }
        }
        finally {
            spm.done();
            monitor.done();
        }
        return result;
    }

    @Override
    public IProfileCommand getProfileCommand(String profileId) {
        for (IProfileCommand profileCommand : this.getCommands(IProfileCommand.class)) {
            if (!profileCommand.getProfileId().equals(profileId)) continue;
            return profileCommand;
        }
        return null;
    }

    @Override
    public IProfileCommand[] getProfileCommands() {
        List<IProfileCommand> commands = this.getCommands(IProfileCommand.class);
        return commands.toArray(new IProfileCommand[commands.size()]);
    }

    @Override
    public void normalizeLocations(IInput.ILocationNormalizer locationNormalizer) {
        for (ICommand command : this.commandList) {
            command.normalizeLocations(locationNormalizer);
        }
    }

    @Override
    public List getRepositories() {
        ArrayList result = new ArrayList();
        for (IServerCommand serverCommand : this.getCommands(IServerCommand.class)) {
            result.addAll(serverCommand.getRepositories());
        }
        return result;
    }

    @Override
    public ICommand[] getCommands(int executionPoint) {
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        for (ICommand command : this.commandList) {
            if ((command.getExecutionPoint() & executionPoint) == 0) continue;
            commands.add(command);
        }
        return commands.toArray(new ICommand[commands.size()]);
    }

    @Override
    public IImportCommand[] getImportCommands() {
        List<IImportCommand> commands = this.getCommands(IImportCommand.class);
        return commands.toArray(new IImportCommand[commands.size()]);
    }

    @Override
    public IPreferenceCommand[] getPreferenceCommands() {
        List<IPreferenceCommand> commands = this.getCommands(IPreferenceCommand.class);
        return commands.toArray(new IPreferenceCommand[commands.size()]);
    }

    @Override
    public boolean needAccessRepositoris() {
        for (ICommand command : this.commandList) {
            if (!command.needAccessRepositories()) continue;
            return true;
        }
        return false;
    }

    @Override
    public IStatus load(String file) {
        this.inputFilePath = file;
        try {
            URL url = new URL(file);
            try {
                return this.load(DownloadUtil.getValidatedStream((IDownloadSession)IDownloadSession.NO_SESSION, (URL)url, (IContentInfo)ContentInfo.EMPTY_CONTENT_INFO, (IProgressMonitor)new NullProgressMonitor()));
            }
            catch (Exception e) {
                return Statuses.ERROR.get((Throwable)e, e.getLocalizedMessage(), new Object[0]);
            }
        }
        catch (MalformedURLException malformedURLException) {
            return this.load(new File(file));
        }
    }

    @Override
    public String getInputFilePath() {
        if (this.inputFile != null) {
            return this.inputFile.getAbsolutePath();
        }
        if (this.inputFilePath != null) {
            return this.inputFilePath;
        }
        if (this.inputStream != null) {
            return this.inputStream.toString();
        }
        return null;
    }

    @Override
    public IStatus execute() {
        return this.response.execute();
    }

    public int getFileFormat() {
        return 1;
    }

    @Override
    public IDocumentRoot getDocumentRoot() {
        return this.documentRoot;
    }

    @Override
    public void setDocumentRoot(IDocumentRoot documentRoot) {
        this.documentRoot = documentRoot;
    }

    @Override
    public List getInputAsJobs() {
        ArrayList ret = new ArrayList();
        if (this.documentRoot != null) {
            this.response.computeJobs(ret);
        }
        return ret;
    }

    @Override
    public Response getResponse() {
        return this.response;
    }

    @Override
    public boolean isNewFormat() {
        return this.getFileFormat() == 2;
    }

    @Override
    public boolean isAgentRepoSkipped() {
        return this.isAgentRepoSkipped;
    }

    @Override
    public void setAgentRepoSkipped(boolean agentRepoSkipped) {
        this.isAgentRepoSkipped = agentRepoSkipped;
    }

    @Override
    public void addVariable(String name, String value) {
        this.variables.addInputFileVar(name, value);
    }

    @Override
    public String getVariableValue(String name) {
        return this.variables.getValue(name);
    }

    private void addCmdLineVariables(Input cmdLineInput) {
        for (String varName : cmdLineInput.getVariableNames()) {
            this.variables.addCmdLineVar(varName, cmdLineInput.getVariableValue(varName));
        }
    }

    private Collection<String> getVariableNames() {
        return this.variables.getVariableNames();
    }

    private <T extends ICommand> List<T> getCommands(Class<T> clazz) {
        ArrayList<ICommand> commands = new ArrayList<ICommand>(this.commandList.size());
        for (ICommand command : this.commandList) {
            if (!clazz.isInstance(command)) continue;
            commands.add(command);
        }
        return commands;
    }
}

