/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.internal.commands;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.IImportCommandExtension;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.internal.commands.AbstractCommand;
import com.ibm.cic.agent.core.internal.commands.ImportExtensionFactory;
import com.ibm.cic.agent.core.internal.commands.XMLElement;
import com.ibm.cic.agent.core.internal.headless.IImportCommand;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.console.PrompterUtils;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.Statuses;
import java.io.File;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class ImportCommand
extends AbstractCommand
implements IImportCommand {
    private static final String DEFAULT_IMPORT_TYPE = "WAS";

    public ImportCommand() {
        super("import");
    }

    @Override
    public IStatus execute(Agent agent, IProgressMonitor monitor) {
        PrompterUtils.ConsoleCredentialPrompter credentialPrompts = CmdLine.CL.getConsoleCredentialPrompter();
        try {
            String importTypeAttribute = this.getAttribute("type");
            String importType = importTypeAttribute == null || importTypeAttribute.trim().isEmpty() ? DEFAULT_IMPORT_TYPE : importTypeAttribute.trim();
            IImportCommandExtension importCommand = null;
            try {
                importCommand = ImportExtensionFactory.getInstance().getImportExtensionCommand(importType);
            }
            catch (CoreException e) {
                IStatus iStatus = e.getStatus();
                credentialPrompts.restore();
                return iStatus;
            }
            if (importCommand == null) {
                ICicStatus iCicStatus = Statuses.ERROR.get(Messages.ImportCommand_ImportExtensionTypeNotFound, new Object[]{importType});
                return iCicStatus;
            }
            Properties props = new Properties();
            for (XMLElement element : this.children()) {
                if (!element.getName().equals("data")) continue;
                props.put(element.getAttribute("key"), element.getAttribute("value"));
            }
            String profileId = this.getAttribute("profile");
            if (profileId != null && !profileId.trim().isEmpty()) {
                Profile importProfile = agent.getProfile(profileId.trim());
                if (importProfile == null) {
                    ICicStatus iCicStatus = Statuses.ERROR.get(Messages.HeadlessApplication_Cannot_Find_Profile, new Object[]{profileId});
                    return iCicStatus;
                }
                IStatus iStatus = importCommand.executeImport(agent, monitor, importProfile, props);
                return iStatus;
            }
            String installLocation = this.getNormalizedInstallLocation();
            if (installLocation != null && !installLocation.trim().isEmpty()) {
                IStatus iStatus = importCommand.executeImport(agent, monitor, installLocation.trim(), props);
                return iStatus;
            }
            ICicStatus iCicStatus = Statuses.ERROR.get(Messages.ImportCommand_MissingAttributes, new Object[]{"profile", "installLocation", "import"});
            return iCicStatus;
        }
        finally {
            credentialPrompts.restore();
        }
    }

    @Override
    public int getExecutionPoint() {
        return 4;
    }

    @Override
    public void setImportType(String type) {
        this.addAttribute("type", type);
    }

    @Override
    public void setProfileId(String profileId) {
        this.addAttribute("profile", profileId);
    }

    @Override
    public String getProfileId() {
        return this.getAttribute("profile");
    }

    @Override
    public void setInstallLocation(String installLocation) {
        this.addAttribute("installLocation", installLocation);
    }

    private String getNormalizedInstallLocation() {
        String returnValue = this.getAttribute("installLocation");
        if (returnValue != null) {
            returnValue = new File(returnValue).getAbsolutePath();
        }
        return returnValue;
    }
}

