/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.custompanel.api;

import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.ICustomPanelData;
import com.ibm.cic.agent.core.custompanel.api.TemplateWidgetContainer;
import com.ibm.cic.agent.core.sharedUI.SharedUIUtils;
import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class TemplateCustomPanel {
    private static final Logger log = Logger.getLogger();
    private final String panelTitle;
    private ICustomPanelData customPanelData;
    private final Map<String, AbstractUserData> userDataMap = new HashMap<String, AbstractUserData>();
    private int tempUserDataCount = 0;
    private String offeringId;

    public TemplateCustomPanel(String title) {
        this.panelTitle = title;
    }

    public abstract void createWidgets(TemplateWidgetContainer var1);

    protected UserData createUserData(String id, String description) {
        return this.createUserData(id, description, false);
    }

    protected UserData createUserData(String id, String description, boolean sensitive) {
        UserData userData = new UserData(id, description, sensitive);
        this.addUserData(id, userData);
        return userData;
    }

    protected ProfileOnlyUserData createProfileOnlyUserData(String id, String description) {
        return this.createProfileOnlyUserData(id, description, false);
    }

    protected ProfileOnlyUserData createProfileOnlyUserData(String id, String description, boolean sensitive) {
        ProfileOnlyUserData userData = new ProfileOnlyUserData(id, description, sensitive);
        this.addUserData(id, userData);
        return userData;
    }

    protected WidgetOnlyUserData createTemporaryUserData() {
        return this.createTemporaryUserData(false);
    }

    protected WidgetOnlyUserData createTemporaryUserData(boolean sensitive) {
        String id = "temp." + this.tempUserDataCount++;
        WidgetOnlyUserData userData = new WidgetOnlyUserData(id, sensitive);
        this.addUserData(id, userData);
        return userData;
    }

    private void addUserData(String id, AbstractUserData userData) {
        assert (this.customPanelData == null) : "User data cannot be created outside of panel constructor";
        if (!Profile.isUserData(id) && !(userData instanceof WidgetOnlyUserData)) assert (false) : NLS.bind((String)"User data id must start with \"{0}\": {1}", (Object)"user.", (Object)id);
        if (this.userDataMap.put(id, userData) != null) assert (false) : NLS.bind((String)"More than user user data has this id: {0}", (Object)id);
    }

    Collection<AbstractUserData> getUserData() {
        return this.userDataMap.values();
    }

    void setOfferingId(String offeringId) {
        this.offeringId = offeringId;
    }

    public abstract void validate(IProgressMonitor var1);

    public abstract void updateWidgets(UserData var1);

    protected void preProcessUserData() {
    }

    protected void postProcessUserData() {
    }

    public String getOfferingId() {
        return this.offeringId;
    }

    public String getPanelTitle() {
        return this.panelTitle;
    }

    public boolean shouldSkip() {
        return false;
    }

    public boolean canAddPanelToWizard() {
        return true;
    }

    public IStatus performFinish(IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    void initCustomPanelData(ICustomPanelData data) {
        this.customPanelData = data;
    }

    public final ICustomPanelData getCustomPanelData() {
        return this.customPanelData;
    }

    public String getHelpRef() {
        return "";
    }

    public boolean updateWidgetsOnVisible() {
        return false;
    }

    public static abstract class AbstractUserData {
        private final String id;
        private final String description;
        private boolean sensitive = false;
        private final List<IStatus> statuses = new ArrayList<IStatus>(1);
        private char[] defaultValueChars = new char[0];
        private char[] valueChars = null;
        private static final int MASK_LEN = 30;
        private SecureRandom random = null;
        private byte[] mask = null;
        private byte[] maskedBytes = null;
        private byte[] defaultMaskedBytes = null;

        AbstractUserData(String id, String description) {
            this.id = id;
            this.description = description;
        }

        AbstractUserData(String id, String description, boolean sensitive) {
            this(id, description);
            this.sensitive = sensitive;
        }

        public String toString() {
            String value = !this.sensitive ? (this.valueChars != null ? String.valueOf(this.valueChars) : String.valueOf('[') + String.valueOf(this.defaultValueChars) + ']') : (this.maskedBytes != null ? "**********" : (this.defaultMaskedBytes != null ? "[**********]" : "[]"));
            return String.valueOf(this.id) + '=' + value;
        }

        public <T extends AbstractUserData> T defaultValue(String v) {
            return this.defaultValueChars(v == null ? null : v.toCharArray());
        }

        public <T extends AbstractUserData> T defaultValueChars(char[] v) {
            if (this.defaultValueChars != null && this.defaultValueChars.length > 0) {
                SharedUIUtils.clearText(this.defaultValueChars);
                this.defaultValueChars = null;
            }
            if (this.defaultMaskedBytes != null && this.defaultMaskedBytes.length > 0) {
                SharedUIUtils.clearBytes(this.defaultMaskedBytes);
                this.defaultMaskedBytes = null;
            }
            if (v == null) {
                this.defaultValueChars = new char[0];
                this.defaultMaskedBytes = new byte[0];
            } else if (this.sensitive) {
                this.defaultMaskedBytes = this.maskBytes(this.toBytes(v));
            } else {
                this.defaultValueChars = new char[v.length];
                System.arraycopy(v, 0, this.defaultValueChars, 0, v.length);
            }
            return (T)this;
        }

        @Deprecated
        public <T extends AbstractUserData> T sensitive(boolean b) {
            if (b && !this.sensitive) {
                if (this.defaultValueChars != null) {
                    this.defaultMaskedBytes = this.maskBytes(this.toBytes(this.defaultValueChars));
                    SharedUIUtils.clearText(this.defaultValueChars);
                    this.defaultValueChars = new char[0];
                }
                if (this.valueChars != null) {
                    this.maskedBytes = this.maskBytes(this.toBytes(this.valueChars));
                    SharedUIUtils.clearText(this.valueChars);
                    this.valueChars = null;
                }
            } else if (!b && this.sensitive) {
                if (this.defaultMaskedBytes != null) {
                    this.defaultValueChars = this.unmaskChars(this.defaultMaskedBytes);
                    SharedUIUtils.clearBytes(this.defaultMaskedBytes);
                }
                if (this.maskedBytes != null) {
                    this.valueChars = this.unmaskChars(this.maskedBytes);
                    SharedUIUtils.clearBytes(this.maskedBytes);
                }
            }
            this.sensitive = b;
            return (T)this;
        }

        public String getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isSensitive() {
            return this.sensitive;
        }

        public String getValue() {
            char[] chars = this.getValueChars();
            if (chars == null) {
                return null;
            }
            String s = String.valueOf(chars);
            if (this.sensitive) {
                SharedUIUtils.clearText(chars);
            }
            return s;
        }

        public char[] getValueChars() {
            if (this.sensitive) {
                byte[] v = this.maskedBytes != null ? this.maskedBytes : this.defaultMaskedBytes;
                char[] mChars = this.unmaskChars(v);
                return mChars;
            }
            char[] vChars = this.valueChars != null ? this.valueChars : this.defaultValueChars;
            int length = vChars.length;
            char[] returnChars = new char[length];
            System.arraycopy(vChars, 0, returnChars, 0, length);
            return returnChars;
        }

        public void setValue(String value) {
            this.setValueChars(value == null ? null : value.toCharArray());
        }

        public void setValueChars(char[] value) {
            if (this.maskedBytes != null) {
                SharedUIUtils.clearBytes(this.maskedBytes);
                this.maskedBytes = null;
            }
            if (value == null) {
                this.valueChars = null;
            } else if (!this.sensitive && !Arrays.equals(this.valueChars, value)) {
                log.debug("Change {0} to {1}", new Object[]{this, String.valueOf(value)});
                int length = value.length;
                this.valueChars = new char[length];
                System.arraycopy(value, 0, this.valueChars, 0, length);
            } else if (this.sensitive) {
                this.maskedBytes = this.maskBytes(this.toBytes(value));
            }
        }

        private void generateMask() {
            if (this.mask == null) {
                this.mask = new byte[30];
            }
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(this.mask);
        }

        private byte[] toBytes(char[] chars) {
            if (chars == null) {
                return null;
            }
            if (chars.length == 0) {
                return new byte[0];
            }
            return Encodings.UTF8.toBytes(chars);
        }

        private char[] toChars(byte[] bytes) {
            if (bytes == null) {
                return null;
            }
            if (bytes.length == 0) {
                return new char[0];
            }
            return Encodings.UTF8.toChars(bytes);
        }

        private byte[] maskBytes(byte[] bytes) {
            if (bytes == null || bytes.length == 0) {
                return bytes;
            }
            if (this.mask == null) {
                this.generateMask();
            }
            int len = bytes.length;
            int i = 0;
            while (i < len) {
                int n = i;
                bytes[n] = (byte)(bytes[n] ^ this.mask[i % 30]);
                ++i;
            }
            return bytes;
        }

        private char[] unmaskChars(byte[] b) {
            if (b == null || b.length == 0) {
                return new char[0];
            }
            byte[] wrk = new byte[b.length];
            System.arraycopy(b, 0, wrk, 0, b.length);
            this.maskBytes(wrk);
            char[] rc = this.toChars(wrk);
            SharedUIUtils.clearBytes(wrk);
            return rc;
        }

        public void warning(String msg, Object ... args) {
            this.status((IStatus)Statuses.WARNING.get(msg, args));
        }

        public void error(String msg, Object ... args) {
            this.status((IStatus)Statuses.ERROR.get(msg, args));
        }

        public void status(IStatus status) {
            this.statuses.add(status);
        }

        List<IStatus> getStatuses() {
            return this.statuses;
        }

        public List<IStatus> getStatuses(int severityMask) {
            ArrayList<IStatus> returnList = new ArrayList<IStatus>(1);
            for (IStatus status : this.statuses) {
                if (!status.matches(severityMask)) continue;
                returnList.add(status);
            }
            return returnList;
        }

        void clearStatuses() {
            this.statuses.clear();
        }
    }

    public static class ProfileOnlyUserData
    extends AbstractUserData {
        ProfileOnlyUserData(String id, String description) {
            this(id, description, false);
        }

        ProfileOnlyUserData(String id, String description, boolean sensitive) {
            super(id, description, sensitive);
        }
    }

    public static class UserData
    extends AbstractUserData {
        UserData(String id, String description) {
            this(id, description, false);
        }

        UserData(String id, String description, boolean sensitive) {
            super(id, description, sensitive);
        }
    }

    public static class WidgetOnlyUserData
    extends UserData {
        WidgetOnlyUserData(String id) {
            this(id, false);
        }

        WidgetOnlyUserData(String id, boolean sensitive) {
            super(id, null, sensitive);
        }
    }
}

