/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core.cmd;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentInstall;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.cmd.CmdManager;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.cmd.ACmdLine;
import com.ibm.cic.common.core.cmd.ACmdManager;
import com.ibm.cic.common.core.cmd.CmdUtils;
import com.ibm.cic.common.core.cmd.ICmdLink;
import com.ibm.cic.common.core.console.PrompterUtils;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CmdLine
extends ACmdLine {
    public static final CmdLine CL = new CmdLine();
    private static final String IS_LIVEINPUT = "LIVEINPUT";

    private CmdLine() {
    }

    protected ACmdManager createCommandManager() {
        return new CmdManager();
    }

    protected boolean isDoNotReportCommand(ICmdLink lnk) {
        return super.isDoNotReportCommand(lnk) || lnk.getParent().id() == "-silent";
    }

    public boolean isSilentMode() {
        return CL.containsCommand("-silent");
    }

    public boolean shouldPrompt() {
        return CL.containsCommand("-prompt");
    }

    public String getResponseFile() {
        return this.replacePlatformLocationVar(CL.getParam1StrVal("input"));
    }

    public boolean isUrlInput() {
        return CL.containsCommand("-url") || CL.containsCommand("-installUrl");
    }

    public boolean isLiveInput() {
        return CL.containsCommand("-liveInput") || System.getProperty(IS_LIVEINPUT) != null;
    }

    public PrompterUtils.ConsoleCredentialPrompter getConsoleCredentialPrompter() {
        return PrompterUtils.ConsoleCredentialPrompter.create((String)"imcl", (boolean)this.shouldPrompt());
    }

    public String getCommandApplicationDataLocation() {
        String return_value = CL.getParam1StrVal("-skipInstall");
        if (return_value == null) {
            return_value = CL.getParam1StrVal("-dataLocation");
        }
        return return_value;
    }

    public String getInstallationDirectory() {
        File file;
        String return_value = CL.getParam1StrVal("-installationDirectory");
        if (return_value != null && !(file = new File(return_value)).isAbsolute()) {
            return_value = file.getAbsolutePath();
        }
        return return_value;
    }

    public String getSharedResourcesDirectory() {
        File file;
        String return_value = CL.getParam1StrVal("-sharedResourcesDirectory");
        if (return_value != null && !(file = new File(return_value)).isAbsolute()) {
            return_value = file.getAbsolutePath();
        }
        return return_value;
    }

    public Map<String, String> getVariables() {
        Map<String, String> vars = (Map<String, String>)this.getParam1ObjVal("-variables");
        return vars != null ? vars : Collections.emptyMap();
    }

    public Map<String, String> getProperties() {
        Map<String, String> props = (Map<String, String>)this.getParam1ObjVal("-properties");
        return props != null ? props : Collections.emptyMap();
    }

    public String replacePlatformLocationVar(String value) {
        String platformLocation;
        if (value != null && (platformLocation = AgentInstall.getInstance().isAgentInstallerRunning() ? AgentInstall.getInstance().getInstallerLocation().getAbsolutePath() : Agent.getInstance().getAgentSelfLocation().getAbsolutePath()) != null) {
            StringBuffer result = new StringBuffer();
            int pos = value.indexOf("@osgi.install.area");
            if (pos >= 0) {
                if (pos > 0) {
                    result.append(value.substring(0, pos - 1));
                }
                result.append(platformLocation);
                if (pos + "@osgi.install.area".length() < value.length()) {
                    result.append(value.substring(pos + "@osgi.install.area".length()));
                }
                value = result.toString();
            }
        }
        return value;
    }

    public String[] ignoreArguments(String[] arguments) {
        return this.filterOutCommands(arguments, new String[]{"-accessRights", "input", "-toolId", "-silent"});
    }

    public boolean isConsoleMode() {
        return CL.containsCommand("-consoleMode");
    }

    public boolean isInteractiveMode() {
        return !CL.isSilentMode() || CL.isConsoleMode();
    }

    public boolean isServerMode() {
        return CL.containsCommand("-server");
    }

    public boolean isSecureServerMode() {
        return CL.containsCommand("-secure");
    }

    public boolean isEnterpriseDeploymentTools() {
        return CL.containsCommand("-enterpriseDeploymentTools");
    }

    public String getRestartScriptLocation() {
        return CL.getParam1StrVal("-restartScriptLocation");
    }

    public IStatus processHelpCommand() {
        IStatus status = super.processHelpCommand();
        if (status == null) {
            return null;
        }
        String s = this.getParam1StrVal("-toolId");
        if ("iimcl".equals(s) && status.isOK() && !status.isMultiStatus()) {
            status = new Status(0, Agent.PI_AGENT, String.valueOf(Messages.CmdLine_Imcl_Install_Kit_Help_Prefix) + "\n\n" + status.getMessage());
        }
        return status;
    }

    public boolean reinstallIM() {
        return CL.containsCommand("-reinstallIM");
    }

    public String getMaskedString() {
        StringBuilder maskedStr = new StringBuilder();
        String[] cmdLineArgs = CL.getCommandLine();
        int i = 0;
        while (i < cmdLineArgs.length) {
            maskedStr.append(cmdLineArgs[i]);
            if (cmdLineArgs[i].equals("-properties")) {
                LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
                for (Map.Entry<String, String> entry : CL.getProperties().entrySet()) {
                    String key;
                    properties.put(key, Profile.isUserData(key = entry.getKey()) ? "****" : entry.getValue());
                }
                maskedStr.append(" ");
                maskedStr.append(CmdUtils.toMapParam(properties));
                ++i;
            }
            maskedStr.append(" ");
            ++i;
        }
        return maskedStr.toString().trim();
    }
}

