/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.CacheLocationManager;
import com.ibm.cic.agent.core.FeatureSizeInfo;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.utils.MaxInstallSizeInfo;
import com.ibm.cic.common.core.utils.DeviceSystem;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.downloads.FormatUtil;
import com.ibm.cic.common.downloads.SizeInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class SpaceInfoUtils {
    public static long getAvailableSpaceInLong(String location) {
        if (location == null || location.trim().length() == 0) {
            return 0L;
        }
        return DeviceSystem.getFreeSpace((File)new File(location));
    }

    public static String getAvailableSpace(String location) {
        long size = SpaceInfoUtils.getAvailableSpaceInLong(location);
        if (size == -1L) {
            return FormatUtil.formatBytes((long)0L);
        }
        return FormatUtil.formatBytes((long)size);
    }

    public static Map<Profile, List<AgentJob>> createProfileJobsMap(List<AgentJob> jobs) {
        HashMap<Profile, List<AgentJob>> profileJobListMap = new HashMap<Profile, List<AgentJob>>();
        for (AgentJob job : jobs) {
            Profile profile = job.getProfile();
            ArrayList<AgentJob> jobList = (ArrayList<AgentJob>)profileJobListMap.get(profile);
            if (jobList == null) {
                jobList = new ArrayList<AgentJob>();
                jobList.add(job);
                profileJobListMap.put(profile, jobList);
                continue;
            }
            jobList.add(job);
        }
        return profileJobListMap;
    }

    public static List<Long> getEclipseCacheLocationSizeListMap(List<AgentJob> selectedJobs, IProgressMonitor monitor) {
        List<Long> eclipseCacheLocationSizeList = null;
        FeatureSizeInfo cacheLocationSizeInfo = null;
        Map<Profile, List<AgentJob>> profileJobListMap = SpaceInfoUtils.createProfileJobsMap(selectedJobs);
        for (Map.Entry<Profile, List<AgentJob>> entry : profileJobListMap.entrySet()) {
            Profile profile = entry.getKey();
            if (profile.isLicenseProfile() || profile.isAgentProfile()) continue;
            FeatureSizeInfo totalSizeInfo = SpaceInfoUtils.getTotalSizeInfo(entry.getValue(), monitor);
            if (cacheLocationSizeInfo == null) {
                cacheLocationSizeInfo = totalSizeInfo;
                continue;
            }
            cacheLocationSizeInfo.add(totalSizeInfo);
        }
        if (cacheLocationSizeInfo != null) {
            long cacheLocationInstallSize = cacheLocationSizeInfo.getCacheLocationSizeInfo().getInstallSize();
            long maxInstallSize = cacheLocationSizeInfo.getMaxInstallSize();
            long tempSize = maxInstallSize - cacheLocationInstallSize;
            eclipseCacheLocationSizeList = Arrays.asList(cacheLocationInstallSize, tempSize, maxInstallSize);
        }
        return eclipseCacheLocationSizeList;
    }

    public static Map<String, List<Long>> getInstallLocationDriveSizeListMap(List<AgentJob> selectedJobs, IProgressMonitor monitor) {
        HashMap<String, List<Long>> driveSizeListMap = new HashMap<String, List<Long>>();
        Map<Profile, List<AgentJob>> profileJobListMap = SpaceInfoUtils.createProfileJobsMap(selectedJobs);
        for (Map.Entry<Profile, List<AgentJob>> entry : profileJobListMap.entrySet()) {
            Profile profile = entry.getKey();
            if (profile.isLicenseProfile()) continue;
            FeatureSizeInfo sizeInfo = SpaceInfoUtils.getTotalSizeInfo(entry.getValue(), monitor);
            if (!profile.isAgentProfile()) {
                long installLocationSize = sizeInfo.getInstallLocationSizeInfo().getInstallSize();
                String installLocationDrive = PlatformUtils.getLocationDevice((String)profile.getInstallLocation());
                List<Long> sizeList = Arrays.asList(installLocationSize, 0L, installLocationSize);
                SpaceInfoUtils.pushToDriveSizeListMap(driveSizeListMap, installLocationDrive, sizeList);
                continue;
            }
            MaxInstallSizeInfo imCacheSizeInfo = sizeInfo.getCacheLocationSizeInfo();
            long imInstallSize = imCacheSizeInfo.getInstallSize() + sizeInfo.getInstallLocationSizeInfo().getInstallSize();
            long imTempSize = imCacheSizeInfo.getMaxSize() - imCacheSizeInfo.getInstallSize();
            long imTotalSize = imInstallSize + imTempSize;
            List<Long> sizeList = Arrays.asList(imInstallSize, imTempSize, imTotalSize);
            String imInstallLocationDrive = PlatformUtils.getLocationDevice((String)profile.getInstallLocation());
            SpaceInfoUtils.pushToDriveSizeListMap(driveSizeListMap, imInstallLocationDrive, sizeList);
        }
        return driveSizeListMap;
    }

    private static void pushToDriveSizeListMap(Map<String, List<Long>> driveSizeMap, String driveLabel, List<Long> sizeValueList) {
        List<Long> sizeForDrive;
        if ("win32".equals(Platform.getOS())) {
            driveLabel = driveLabel.toUpperCase();
        }
        if ((sizeForDrive = driveSizeMap.get(driveLabel)) == null) {
            driveSizeMap.put(driveLabel, sizeValueList);
        } else {
            ArrayList<Long> newSizeList = new ArrayList<Long>();
            int i = 0;
            while (i < sizeValueList.size()) {
                newSizeList.add(sizeValueList.get(i) + sizeForDrive.get(i));
                ++i;
            }
            driveSizeMap.put(driveLabel, newSizeList);
        }
    }

    private static void pushToDriveSizeMap(Map<String, Long> driveSizeMap, String driveLabel, Long sizeValue) {
        Long sizeForDrive;
        if ("win32".equals(Platform.getOS())) {
            driveLabel = driveLabel.toUpperCase();
        }
        if ((sizeForDrive = driveSizeMap.get(driveLabel)) == null) {
            driveSizeMap.put(driveLabel, sizeValue);
        } else {
            driveSizeMap.put(driveLabel, sizeForDrive + sizeValue);
        }
    }

    private static FeatureSizeInfo getTotalSizeInfo(List<AgentJob> selected, IProgressMonitor monitor) {
        AgentJob[] selectedJobs = selected.toArray(new AgentJob[selected.size()]);
        SizeInfo installLocationSize = new SizeInfo();
        MaxInstallSizeInfo cacheLocationSize = new MaxInstallSizeInfo();
        Agent.getInstance().getSizeInfo(selectedJobs, installLocationSize, cacheLocationSize, monitor);
        return new FeatureSizeInfo(installLocationSize, cacheLocationSize);
    }

    public static IStatus verifySpaceInfo(List<Long> eclipseCacheLocationSizeList, Map<String, List<Long>> installLocationSizeMap, Map<String, Long> resultSizeMap) {
        return SpaceInfoUtils.verifySpaceInfo(eclipseCacheLocationSizeList, installLocationSizeMap, resultSizeMap, null);
    }

    public static IStatus verifySpaceInfo(List<Long> eclipseCacheLocationSizeList, Map<String, List<Long>> installLocationSizeMap, Map<String, Long> resultSizeMap, String errMessage) {
        if (resultSizeMap == null) {
            resultSizeMap = new HashMap<String, Long>();
        } else {
            resultSizeMap.clear();
        }
        if (eclipseCacheLocationSizeList != null && eclipseCacheLocationSizeList.size() == 3) {
            String string = PlatformUtils.getLocationDevice((String)CacheLocationManager.getInstance().getCacheLocation());
            SpaceInfoUtils.pushToDriveSizeMap(resultSizeMap, string, eclipseCacheLocationSizeList.get(2));
        }
        for (Map.Entry<String, List<Long>> entry : installLocationSizeMap.entrySet()) {
            String drive = entry.getKey();
            List<Long> sizeList = entry.getValue();
            if (sizeList == null || sizeList.size() != 3) continue;
            SpaceInfoUtils.pushToDriveSizeMap(resultSizeMap, drive, sizeList.get(2));
        }
        for (Map.Entry<String, Object> entry : resultSizeMap.entrySet()) {
            String driveName = entry.getKey();
            long requiredSize = (Long)entry.getValue();
            long availableSpace = SpaceInfoUtils.getAvailableSpaceInLong(driveName);
            if (availableSpace >= requiredSize) continue;
            return errMessage != null ? Statuses.ERROR.get(errMessage, new Object[]{driveName}) : Statuses.ERROR.get(Messages.SpaceInfoUtils_Insufficient_Disk_Space, new Object[]{driveName, FormatUtil.formatBytes((long)availableSpace), FormatUtil.formatBytes((long)requiredSize)});
        }
        return Status.OK_STATUS;
    }

    public static IStatus validateAvailableSpace(List<AgentJob> agentJobs) {
        List<Long> eclipseCacheLocationSizeList = SpaceInfoUtils.getEclipseCacheLocationSizeListMap(agentJobs, (IProgressMonitor)new NullProgressMonitor());
        Map<String, List<Long>> installLocationSizeMap = SpaceInfoUtils.getInstallLocationDriveSizeListMap(agentJobs, (IProgressMonitor)new NullProgressMonitor());
        return SpaceInfoUtils.verifySpaceInfo(eclipseCacheLocationSizeList, installLocationSizeMap, null);
    }
}

