/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.agent.internal.core.MetadataReplacer;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.internal.CICWriter;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.repository.IContentRepository;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.utils.IdentityUtil;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.PlatformUtils;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.osgi.framework.Version;

public class ReplaceMetadataApplication
implements IApplication {
    private static final String SHOW_METADATA_REPLACEMENTS = "-showMetadataReplacements";
    private boolean showMetadataReplacements = false;
    private String repositoryPath;
    private String offeringIdPrefix;
    private Version offeringVersion;
    private String suIdPrefix;
    private String iuIdPrefix;

    public Object start(IApplicationContext context) throws Exception {
        try {
            CicCommonSettings.setAccessRightsMode((CicCommonSettings.AccessRights)CicCommonSettings.AccessRights.NON_ADMIN_MODE);
            CicCommonSettings.setIsNativeAdministrator((boolean)false);
            CicCommonSettings.setInstanceArea();
            String[] args = (String[])context.getArguments().get("application.args");
            this.processArgs(CmdLine.CL.ignoreArguments(args));
            this.processRepositories();
            return IApplication.EXIT_OK;
        }
        catch (Throwable t) {
            System.err.println(t.toString());
            PlatformUtils.disableErrorOutput();
            return 1;
        }
    }

    public void stop() {
    }

    private void processArgs(String[] args) {
        String[] remainingArgs = new String[args.length];
        int j = 0;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.equalsIgnoreCase(SHOW_METADATA_REPLACEMENTS)) {
                this.showMetadataReplacements = true;
            } else if (arg.startsWith("-")) {
                this.usageError();
            } else {
                remainingArgs[j++] = arg;
            }
            ++n2;
        }
        if (j != 5) {
            this.usageError();
        }
        this.repositoryPath = remainingArgs[0];
        this.offeringIdPrefix = remainingArgs[1];
        this.offeringVersion = new Version(remainingArgs[2]);
        this.suIdPrefix = remainingArgs[3];
        this.iuIdPrefix = remainingArgs[4];
    }

    private void usageError() {
        throw new IllegalArgumentException(Messages.ReplaceMetadataApplication_usageError);
    }

    private void processRepositories() throws Exception {
        String[] repositoryLocations;
        String[] stringArray = repositoryLocations = this.repositoryPath.split(";");
        int n = repositoryLocations.length;
        int n2 = 0;
        while (n2 < n) {
            String repositoryLocation = stringArray[n2];
            this.processRepository(repositoryLocation);
            ++n2;
        }
    }

    private void processRepository(String repositoryLocation) throws Exception {
        RepositoryGroup group = new RepositoryGroup(repositoryLocation);
        try {
            IRepository repo = group.addExistingRepository(repositoryLocation, true);
            if (repo == null) {
                throw new IOException(NLS.bind((String)Messages.ReplaceMetadataApplication_repositoryOpenFailed, (Object)repositoryLocation));
            }
            System.out.println(NLS.bind((String)Messages.ReplaceMetadataApplication_repositoryLocation, (Object)repositoryLocation));
            List offerings = repo.getAllOfferings(null);
            for (IOffering offering : offerings) {
                if (!offering.getIdentity().getId().startsWith(this.offeringIdPrefix) || !offering.getVersion().equals((Object)this.offeringVersion)) continue;
                this.processOffering(offering);
            }
        }
        finally {
            group.removeAllRepositories();
        }
    }

    private void processOffering(IOffering offering) throws Exception {
        IStatus status = RepositoryUtils.resolve((IOfferingOrFix)offering, null);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        System.out.println("  " + NLS.bind((String)Messages.ReplaceMetadataApplication_offering, (Object)IdentityUtil.getVersionedId((IContent)offering)));
        IContentRepository contentRepository = RepositoryUtils.getContentRepository((IContent)offering);
        List allSus = contentRepository.getAllSus(null);
        for (IShareableUnit su : allSus) {
            if (!su.getIdentity().getId().startsWith(this.suIdPrefix)) continue;
            this.processSu(su);
        }
    }

    private void processSu(IShareableUnit su) throws Exception {
        System.out.println("    " + NLS.bind((String)Messages.ReplaceMetadataApplication_su, (Object)IdentityUtil.getVersionedId((IContent)su)));
        List children = su.getInstallableUnits();
        for (IInstallableUnit iu : children) {
            if (!iu.getIdentity().getId().startsWith(this.iuIdPrefix)) continue;
            this.processIu(iu);
        }
    }

    private void processIu(IInstallableUnit iu) throws Exception {
        String replaceMetadata = String.valueOf(IdentityUtil.getVersionedId((IContent)iu)) + ";matchHash";
        String hash = MetadataReplacer.computeHash(iu);
        if (this.showMetadataReplacements) {
            this.displayMetadataReplacements(iu, replaceMetadata, hash);
        } else {
            this.displayProperties(iu, replaceMetadata, hash);
        }
    }

    private void displayProperties(IInstallableUnit iu, String replaceMetadata, String hash) {
        this.displayProperty("replace.metadata", replaceMetadata);
        this.displayProperty("hash.value.to.match", hash);
    }

    private void displayMetadataReplacements(IInstallableUnit iu, String replaceMetadata, String hash) throws Exception {
        IInstallableUnit fixedIu = (IInstallableUnit)iu.clone();
        fixedIu.setVersion(null);
        fixedIu.setIdentity((IIdentity)new SimpleIdentity(String.valueOf(iu.getIdentity().getId()) + ".fixed"));
        LinkedProperties properties = fixedIu.getProperties();
        properties.setProperty("replace.metadata", replaceMetadata);
        properties.setProperty("hash.value.to.match", hash);
        CICWriter writer = new CICWriter();
        writer.setMode(1);
        String xml = CICWriter.toXML((CICWriter)writer, (IContent)fixedIu);
        String indent = "  ";
        xml = String.valueOf(indent) + xml.replaceAll("\\n", "\n" + indent);
        xml = xml.substring(0, xml.length() - indent.length());
        System.out.print(xml);
    }

    private void displayProperty(String name, String value) {
        System.out.println("      <property name='" + name + "' value='" + value + "'/>");
    }
}

