/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.common.core.artifactrepo.IAlternativeRepositories;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.internal.repository.RepositoryInfo;
import com.ibm.cic.common.core.model.FixUtil;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IInstallableUnitContainer;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.IShareableItem;
import com.ibm.cic.common.core.model.IVersionedIdentity;
import com.ibm.cic.common.core.model.Walker;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.internal.ContentKeyWrapper;
import com.ibm.cic.common.core.repository.IReopenRepositoryPrompter;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

class ProvideAlternativeRepositories
implements IAlternativeRepositories {
    private final IHelper helper;
    private final InstallRegistry installRegistry;
    private final IRepositoryGroup arg;
    private boolean wantAbort;
    private final LinkedHashMap mapPrimary;
    private boolean enabled;

    ProvideAlternativeRepositories(IHelper helper, boolean wantAbort) {
        this.helper = helper;
        this.installRegistry = InstallRegistry.getInstance();
        this.mapPrimary = new LinkedHashMap();
        this.wantAbort = wantAbort;
        this.enabled = false;
        this.arg = new RepositoryGroup("ProvideAlternativeRepositories");
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setWantAbort(boolean wantAbort) {
        this.wantAbort = wantAbort;
    }

    public boolean isEnabled() {
        return !this.mapPrimary.isEmpty() || this.enabled;
    }

    public void addInstalledOfferingRepositories(Profile profile, IOffering offering, VersionRange offeringTolerance) {
        IIdentity offeringId = offering.getIdentity();
        Version offeringVersion = offering.getVersion();
        log.debug("Enter adding primary repos for installed offering {0} {1} {2}", new Object[]{offeringId, offeringVersion, offeringTolerance});
        this.addInstalledOfferingsAndFixes(this.mapPrimary, profile, offeringId, offeringVersion, offeringTolerance);
        log.debug("Done adding primary repos for installed offering {0} {1} {2}", new Object[]{offeringId, offeringVersion, offeringTolerance});
        this.setEnabled(true);
    }

    public void addPrimaryInstalledFixRepositories(Profile profile, IFix fix) {
        IVersionedIdentity applicable = FixUtil.getSingleApplicableOfferingVersion((IFix)fix);
        if (applicable == null) {
            return;
        }
        IIdentity offeringId = applicable.getIdentity();
        Version ov = applicable.getVersion();
        log.debug("Enter adding primary repos for fix {0} of offering {1} {2}", new Object[]{fix, offeringId, ov});
        VersionRange offeringTolerance = new VersionRange(new Version(ov.getMajor(), 0, 0), true, ov, true);
        log.debug("Using offering tolerance {0}", new Object[]{offeringTolerance});
        this.addInstalledOfferingsAndFixes(this.mapPrimary, profile, offeringId, ov, offeringTolerance);
        this.removeFix(this.mapPrimary, fix);
        log.debug("Removing fix itself:{0}", new Object[]{fix});
        log.debug("Done adding primary repos for fix {0} of offering {1} {2}", new Object[]{fix, offeringId, ov});
        this.setEnabled(true);
    }

    private void addInstalledOfferingsAndFixes(LinkedHashMap mapOfferingorFixToRepoInfo, Profile profile, IIdentity offeringId, Version offeringVersion, VersionRange offeringTolerance) {
        InstallRegistry.ProfileInstallRegistry registry = profile.getInstallRegistry();
        ProvideAlternativeRepositories.addOfferingsOrFixesRepoInfo(IAlternativeRepositories.SKIP_NONE_FILTER, mapOfferingorFixToRepoInfo, registry, (IOfferingOrFix[])registry.getInstalledFixes(offeringId, offeringVersion), null);
        ProvideAlternativeRepositories.addOfferingsOrFixesRepoInfo(IAlternativeRepositories.SKIP_NONE_FILTER, mapOfferingorFixToRepoInfo, registry, (IOfferingOrFix[])registry.getInstalledOfferings(offeringId), offeringTolerance);
    }

    private void removeFix(LinkedHashMap mapOfferingorFixToRepoInfo, IFix fix) {
        mapOfferingorFixToRepoInfo.remove(fix);
    }

    private static void addOfferingsOrFixesRepoInfo(IAlternativeRepositories.ISkipRepositoryFilter skipRepoFilter, LinkedHashMap mapOfferingorFixToRepoInfo, InstallRegistry.ProfileInstallRegistry profileRegistry, IOfferingOrFix[] offeringOrFixes, VersionRange tolerance) {
        IOfferingOrFix[] iOfferingOrFixArray = offeringOrFixes;
        int n = offeringOrFixes.length;
        int n2 = 0;
        while (n2 < n) {
            IOfferingOrFix installedOof = iOfferingOrFixArray[n2];
            if (tolerance == null || tolerance.isIncluded(installedOof.getVersion())) {
                ProvideAlternativeRepositories.addOfferingOrFixRepoInfo(skipRepoFilter, mapOfferingorFixToRepoInfo, installedOof, profileRegistry);
            }
            ++n2;
        }
    }

    private static void addOfferingsOrFixesRepoInfo(IAlternativeRepositories.ISkipRepositoryFilter skipRepoFilter, LinkedHashMap mapOfferingorFixToRepoInfo, InstallRegistry installRegistry, IOfferingOrFix[] offeringOrFixes, VersionRange tolerance) {
        IOfferingOrFix[] iOfferingOrFixArray = offeringOrFixes;
        int n = offeringOrFixes.length;
        int n2 = 0;
        while (n2 < n) {
            IOfferingOrFix installedOof = iOfferingOrFixArray[n2];
            if (tolerance == null || tolerance.isIncluded(installedOof.getVersion())) {
                InstallRegistry.ProfileInstallRegistry profileRegistry = ProvideAlternativeRepositories.getProfileRegistry(installRegistry, installedOof);
                if (profileRegistry == null) {
                    log.debug("Failed to determine ProfileInstallRegistry for {0}", new Object[]{installedOof});
                } else {
                    ProvideAlternativeRepositories.addOfferingOrFixRepoInfo(skipRepoFilter, mapOfferingorFixToRepoInfo, installedOof, profileRegistry);
                }
            }
            ++n2;
        }
    }

    private static void addOfferingOrFixRepoInfo(IAlternativeRepositories.ISkipRepositoryFilter skipRepoFilter, LinkedHashMap mapOfferingorFixToRepoInfo, IOfferingOrFix installedOof, InstallRegistry.ProfileInstallRegistry profileRegistry) {
        String serializedRepoInfo = profileRegistry.getInstalledRepositoryInfo(installedOof);
        if (serializedRepoInfo != null) {
            RepositoryInfo repoInfo = RepositoryInfo.deserialize((String)serializedRepoInfo);
            if (skipRepoFilter.skip((IRepositoryInfo)repoInfo)) {
                log.debug("Skipping repo {0} for {1} due to filter", new Object[]{repoInfo.getLocation(), installedOof});
                return;
            }
            ContentKeyWrapper key = new ContentKeyWrapper((IContent)installedOof);
            IRepositoryInfo currentRepoInfo = (IRepositoryInfo)mapOfferingorFixToRepoInfo.get(key);
            if (currentRepoInfo == null) {
                log.debug("Adding repo {0} for {1} : {2}", new Object[]{repoInfo.getLocation(), installedOof, serializedRepoInfo});
                mapOfferingorFixToRepoInfo.put(key, repoInfo);
            } else {
                log.debug("Skipping repo {0} for {1} : already included {2}", new Object[]{repoInfo.getLocation(), installedOof, currentRepoInfo.getLocation()});
            }
        }
    }

    private static InstallRegistry.ProfileInstallRegistry getProfileRegistry(InstallRegistry installRegistry, IOfferingOrFix installed) {
        for (InstallRegistry.ProfileInstallRegistry registry : installRegistry.getProfileInstallRegistries()) {
            if (!registry.isInstalled(installed)) continue;
            return registry;
        }
        return null;
    }

    public void done() {
        this.arg.removeAllRepositories();
    }

    public IAlternativeRepositories.IAlternativeArtifactRepositories getAlternativeRepos(IAlternativeRepositories.ISkipRepositoryFilter skipRepoFilter, Object artifactParent, IArtifact artifact, IProgressMonitor monitor) {
        return this.determineAlternativeRepos(skipRepoFilter, (IInstallableUnit)artifactParent, artifact, monitor);
    }

    private AlternativeArtifactRepos determineAlternativeRepos(IAlternativeRepositories.ISkipRepositoryFilter skipRepoFilter, IInstallableUnit artifactParentIu, IArtifact artifact, IProgressMonitor monitor) {
        IInstallableUnitContainer iuParent = artifactParentIu.getParent();
        log.debug("enter determine repos for {0} of {1}", new Object[]{artifact, iuParent});
        Set installedOfferingsWithSu = Collections.EMPTY_SET;
        if (iuParent instanceof IOfferingOrFix) {
            IOfferingOrFix oof = (IOfferingOrFix)iuParent;
            installedOfferingsWithSu.add(new ContentKeyWrapper((IContent)oof));
            log.debug("Artifact is in installed offerings {0}", new Object[]{installedOfferingsWithSu});
        }
        if (iuParent instanceof IShareableItem) {
            IShareableItem su = (IShareableItem)iuParent;
            installedOfferingsWithSu = this.findInstalledOfferingsContainingArtifact(su, artifact, monitor);
            log.debug("{0} in SU {1} is included by installed offerings {2}", new Object[]{artifact, su, installedOfferingsWithSu});
        }
        LinkedHashMap<ContentKeyWrapper, IRepositoryInfo> mapForArtifact = new LinkedHashMap<ContentKeyWrapper, IRepositoryInfo>(installedOfferingsWithSu.size());
        for (ContentKeyWrapper primaryKey : this.mapPrimary.keySet()) {
            if (!installedOfferingsWithSu.contains(primaryKey)) continue;
            IRepositoryInfo repoInfo = (IRepositoryInfo)this.mapPrimary.get(primaryKey);
            if (!skipRepoFilter.skip(repoInfo)) {
                mapForArtifact.put(primaryKey, repoInfo);
            }
            installedOfferingsWithSu.remove(primaryKey);
            log.debug("Using primary oof {0}: remove this from other installed offerings", new Object[]{primaryKey});
        }
        IOfferingOrFix[] offeringOrFixes = new IOfferingOrFix[installedOfferingsWithSu.size()];
        int i = 0;
        for (ContentKeyWrapper contentWrapper : installedOfferingsWithSu) {
            offeringOrFixes[i] = (IOfferingOrFix)contentWrapper.getContent();
            ++i;
        }
        if (installedOfferingsWithSu.size() > 0) {
            log.debug("Adding repositories for non primary offerings and fixes: {0}", new Object[]{installedOfferingsWithSu});
        }
        ProvideAlternativeRepositories.addOfferingsOrFixesRepoInfo(skipRepoFilter, mapForArtifact, this.installRegistry, offeringOrFixes, null);
        return new AlternativeArtifactRepos(mapForArtifact, artifact);
    }

    private boolean hasArtifact(IOfferingOrFix oof, IShareableItem su, IArtifact artifact, IProgressMonitor monitor) {
        final boolean[] artifactFound = new boolean[1];
        final IArtifact artifactToBeFound = artifact;
        final IIdentity suIdentityToBeChecked = su.getIdentity();
        Walker oofWalker = new Walker(){

            public void doInstallableUnit(IInstallableUnit iu) throws Exception {
                IInstallableUnitContainer iuContainer = iu.getParent();
                if (iuContainer != null && suIdentityToBeChecked.equals(iuContainer.getIdentity()) && iu.getAdapterData().getArtifacts().contains(artifactToBeFound)) {
                    artifactFound[0] = true;
                }
            }

            protected boolean canHaveUnresolvedIncludes() {
                return true;
            }
        };
        oofWalker.walkIncludesUnchecked((IContent)oof, monitor);
        return artifactFound[0];
    }

    private Set findInstalledOfferingsContainingArtifact(IShareableItem su, IArtifact artifact, IProgressMonitor monitor) {
        Version v = su.getVersion();
        VersionRange tolerance = new VersionRange(new Version(v.getMajor(), 0, 0), true, v, true);
        Collection<IOfferingOrFix> c = this.installRegistry.findInstalledShareableEntityContainers(su.getIdentity(), tolerance, monitor);
        log.debug("SU {0} is referenced by {1}", new Object[]{su, c});
        LinkedHashSet<ContentKeyWrapper> includeSet = new LinkedHashSet<ContentKeyWrapper>(c.size());
        for (IOfferingOrFix oof : c) {
            if (!this.hasArtifact(oof, su, artifact, (IProgressMonitor)new SubProgressMonitor(monitor, 0))) continue;
            includeSet.add(new ContentKeyWrapper((IContent)oof));
        }
        log.debug("artifact {0} is referenced by {1}", new Object[]{artifact, c});
        return includeSet;
    }

    class AlternativeArtifactRepos
    implements IAlternativeRepositories.IAlternativeArtifactRepositories {
        private final LinkedHashMap mapOfferingOrFixToRepoInfo;
        private final IArtifact artifact;
        boolean findPriorityBasedLocation = true;

        AlternativeArtifactRepos(LinkedHashMap mapOfferingOrFixToRepoInfo, IArtifact artifact) {
            this.mapOfferingOrFixToRepoInfo = mapOfferingOrFixToRepoInfo;
            this.artifact = artifact;
        }

        public int count() {
            return this.mapOfferingOrFixToRepoInfo.size();
        }

        public boolean hasNext() {
            return this.count() > 0;
        }

        private IReopenRepositoryPrompter.ReopenRepositoryResult addExistingRepo(IRepositoryInfo repoInfo) {
            IRepository r = null;
            repoInfo.setProperty("AskForDisk1", (Object)Boolean.FALSE);
            IStatus status = ProvideAlternativeRepositories.this.arg.canAddExistingRepository(repoInfo, null);
            if (status.isOK()) {
                try {
                    r = ProvideAlternativeRepositories.this.arg.addExistingRepository(repoInfo, this.findPriorityBasedLocation);
                }
                catch (CoreException e) {
                    status = e.getStatus();
                }
                catch (IOException e) {
                    log.debug((Throwable)e);
                }
            }
            return new IReopenRepositoryPrompter.ReopenRepositoryResult(status, ProvideAlternativeRepositories.this.arg, r);
        }

        public IReopenRepositoryPrompter.ReopenRepositoryResult nextRepo(IArtifactSession session) {
            try {
                Iterator iter = this.mapOfferingOrFixToRepoInfo.entrySet().iterator();
                Map.Entry entry = iter.next();
                ContentKeyWrapper civ = (ContentKeyWrapper)entry.getKey();
                IOfferingOrFix oof = (IOfferingOrFix)civ.getContent();
                IRepositoryInfo repoInfo = (IRepositoryInfo)entry.getValue();
                iter.remove();
                IReopenRepositoryPrompter.ReopenRepositoryResult reopenResult = this.addExistingRepo(repoInfo);
                if (reopenResult.getRepository() != null) {
                    log.debug("Opened install repository: {0}", new Object[]{repoInfo});
                    IReopenRepositoryPrompter.ReopenRepositoryResult reopenRepositoryResult = reopenResult;
                    return reopenRepositoryResult;
                }
                IReopenRepositoryPrompter reopenPrompter = ProvideAlternativeRepositories.this.helper.getReopenPrompter();
                if (reopenPrompter == null) {
                    log.debug("No prompter: repository no longer available: {0}", new Object[]{repoInfo});
                    IReopenRepositoryPrompter.ReopenRepositoryResult reopenRepositoryResult = IReopenRepositoryPrompter.ReopenRepositoryResult.noLongerAvailable();
                    return reopenRepositoryResult;
                }
                IReopenRepositoryPrompter.ReopenRepositoryResult result = reopenPrompter.promptOpenRepository(ProvideAlternativeRepositories.this.arg, oof, repoInfo, session, this.artifact, ProvideAlternativeRepositories.this.wantAbort);
                log.debug("promptOpen returns {0}", new Object[]{result});
                IReopenRepositoryPrompter.ReopenRepositoryResult reopenRepositoryResult = result;
                return reopenRepositoryResult;
            }
            finally {
                this.removeAlreadyOpenedInRemaining();
            }
        }

        private void removeAlreadyOpenedInRemaining() {
            Iterator iter = this.mapOfferingOrFixToRepoInfo.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                IRepositoryInfo repoInfo = (IRepositoryInfo)entry.getValue();
                if (!ProvideAlternativeRepositories.this.helper.isAlreadyOpen(ProvideAlternativeRepositories.this.arg, repoInfo)) continue;
                log.debug("Removing duplicates of now opened repositories", new Object[]{repoInfo});
                iter.remove();
            }
        }
    }

    static interface IHelper {
        public boolean isAlreadyOpen(IRepositoryGroup var1, IRepositoryInfo var2);

        public IReopenRepositoryPrompter getReopenPrompter();
    }
}

