/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.AbstractVariableSubstitution;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentInstall;
import com.ibm.cic.agent.core.AgentRegistry;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.CacheLocationManager;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.SubstitutionOperation;
import com.ibm.cic.agent.core.VariableSubstitution;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.core.internal.commands.Input;
import com.ibm.cic.agent.core.internal.headless.IUninstallCommand;
import com.ibm.cic.agent.core.utils.AgentUserOptions;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.definitions.LanguageCode;
import com.ibm.cic.common.core.definitions.ProfileArch;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallationContext;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.utils.OfferingOrFixProperty;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.model.utils.SupportedPlatforms;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.UnmodifiableProperties;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.core.utils.XMLUtil;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public class Profile
implements IProfile,
IAdaptable {
    public static final String INSTALL_LOCATION = "installLocation";
    public static final String CACHE_LOCATION = "cacheLocation";
    public static final String LOCALE = "locale";
    public static final String PLATFORMXML_TIMESAMP = "platformXMLtimestamp";
    public static final String PROP_NAME_NL = "cic.selector.nl";
    public static final String PROP_NAME_WS = "cic.selector.ws";
    public static final String PROP_NAME_OS = "cic.selector.os";
    public static final String PROP_NAME_ARCH = "cic.selector.arch";
    private static final String[] settableProperties = new String[]{"eclipseLocation", "cic.selector.nl", "cic.selector.ws", "cic.selector.os", "cic.selector.arch"};
    public static final String LICENSE_PROFILE_NAME = "SDP Licenses";
    public static final String LICENSE_PROFILE_LOCATION = "SDPpaks";
    public static final String SKIP_LOCATION_VALIDATION = "skipLocValidation";
    public static final String INTUITIVE_UNINSTALL_INSTALL_ORDER_REQUIRED = AgentUserOptions.CIC_INTUITIVE_UNINSTALL_INSTALL_ORDER_REQUIRED.getName();
    private static final String OLD_AGENT_PROFILE_ID = "Self";
    private static final char USER_DATA_OFFERING_SEP = ',';
    private static final String OVERRIDE_PROFILE_VALIDATION_PROPERTY = "cic.override.import.profileValidation";
    public static final String IMPORT_PROFILE_PROPERTY = "user.import.profile";
    private static final String[] defaultAdaptors = new String[]{"native"};
    private static final Set VALID_KINDS = new HashSet<String>(Arrays.asList("self", "license", "product", "existingEclipse"));
    private String profileId;
    private String profileKind;
    private String installLocation;
    private InstallContext rootContext = null;
    private final LinkedProperties data = new LinkedProperties();
    private Set<String> sensitiveData = Collections.emptySet();
    private int maxInstallLocationLength = -1;
    private boolean shadow = false;
    private final boolean isDataPartitioned;

    public static IStatus isValidId(String id) {
        return PlatformUtils.validateFileName((String)id);
    }

    public static IStatus isValidKind(String kind) {
        if (kind == null) {
            kind = "null";
        }
        if (!VALID_KINDS.contains(kind)) {
            return Statuses.ERROR.get(Messages.Profile_Invalid_Profile_Kind, new Object[]{kind});
        }
        if ("self".equals(kind) && Agent.getInstance().getAgentProfile() != null || "license".equals(kind) && Profile.getProfile(LICENSE_PROFILE_NAME) != null) {
            return Statuses.ERROR.get(Messages.Profile_Duplicate_Profile_Kind, new Object[]{kind});
        }
        return Status.OK_STATUS;
    }

    public Profile(String profileId, String profileKind) {
        this(profileId, profileKind, null, false);
        this.rootContext = this.createRootContext();
    }

    public Profile(String profileId, String profileKind, boolean isDataPartitioned) {
        this(profileId, profileKind, null, isDataPartitioned);
        this.rootContext = this.createRootContext();
    }

    public Profile(String profileId, String profileKind, InstallContext rootContext, boolean isDataPartitioned) {
        if (!Profile.isValidId(profileId).isOK()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.Profile_Invalid_Profile_Id, (Object)profileId));
        }
        this.profileId = profileId;
        if (profileKind != null) {
            this.setProfileKind(profileKind);
        }
        this.doSetProperty(LOCALE, CicCommonSettings.getNl());
        this.rootContext = rootContext;
        if (rootContext != null && rootContext.getEnclosingProfile() != this) {
            rootContext.setEnclosingProfile(this);
        }
        this.isDataPartitioned = isDataPartitioned;
    }

    private InstallContext createRootContext() {
        InstallContext ic = new InstallContext(this, this.makeRootContextId(), "root", "");
        ic.addAdaptorTypes(defaultAdaptors);
        return ic;
    }

    @Override
    public String getProfileId() {
        return this.profileId;
    }

    @Override
    public String getProfileKind() {
        return this.profileKind;
    }

    public final void setProfileKind(String profileKind) {
        IStatus status = Profile.isValidKind(profileKind);
        if (!status.isOK()) {
            throw new IllegalArgumentException(status.getMessage());
        }
        this.profileKind = profileKind;
    }

    public boolean isProductProfile() {
        return "product".equals(this.profileKind);
    }

    public boolean isAgentProfile() {
        return "self".equals(this.profileKind);
    }

    public boolean isLicenseProfile() {
        return "license".equals(this.profileKind);
    }

    public boolean isExistingEclipseProfile() {
        return "existingEclipse".equals(this.profileKind);
    }

    private boolean isImportProfile() {
        return Boolean.valueOf(this.getUserData(IMPORT_PROFILE_PROPERTY));
    }

    private void setImportProfile(boolean isImport) {
        this.setUserData(IMPORT_PROFILE_PROPERTY, String.valueOf(isImport));
    }

    public InstallContext getRootContext() {
        return this.rootContext;
    }

    public void setRootContext(InstallContext context) {
        assert (context == null || context.getEnclosingProfile() == this);
        this.rootContext = context != null ? context : this.createRootContext();
    }

    public InstallContext[] getAllInstallContexts() {
        ArrayList<InstallContext> allInstallContexts = new ArrayList<InstallContext>();
        allInstallContexts.add(this.rootContext);
        this.rootContext.getAllSubcontexts(allInstallContexts);
        return allInstallContexts.toArray(new InstallContext[allInstallContexts.size()]);
    }

    public InstallContext findInstallContext(String id) {
        LinkedHashSet<InstallContext> contexts = new LinkedHashSet<InstallContext>();
        this.rootContext.findInstallContexts(id, contexts);
        if (contexts.isEmpty()) {
            return null;
        }
        return (InstallContext)contexts.iterator().next();
    }

    @Override
    public String getPropertyFromInstallContext(String contextId, String propertyId) {
        InstallContext context = this.findInstallContext(contextId);
        return context != null ? context.getProperty(propertyId) : null;
    }

    public IStatus findMatchingContexts(IInstallationContext contextData, Set contexts) {
        return this.rootContext.findMatchingContexts(contextData, contexts);
    }

    public boolean hasDefaultValue(String key) {
        String value = this.getData(key);
        if (value == null || value.isEmpty()) {
            return true;
        }
        if (key.equals(PROP_NAME_NL)) {
            return value.equals(LanguageCode.ENGLISH.getId());
        }
        if (key.equals("eclipseLocation")) {
            return value.equals(this.getInstallLocation());
        }
        if (key.equals("eclipseContext")) {
            return value.equals("com.ibm.sdp.eclipse.ide");
        }
        if (key.equals(IMPORT_PROFILE_PROPERTY)) {
            return Boolean.valueOf(value) == false;
        }
        if (key.equals(PROP_NAME_OS)) {
            return value.equals(Platform.getOS());
        }
        if (key.equals(PROP_NAME_ARCH)) {
            return Collections.singleton(value).equals(SupportedPlatforms.getInstance().getArchValues(this.getData(PROP_NAME_OS)));
        }
        if (key.equals(PROP_NAME_WS)) {
            return Collections.singleton(value).equals(SupportedPlatforms.getInstance().getWsValues(this.getData(PROP_NAME_OS), this.getData(PROP_NAME_ARCH)));
        }
        return false;
    }

    @Override
    public String getData(String key) {
        if (key.equals(INSTALL_LOCATION)) {
            throw new IllegalArgumentException("Please use Profile.getInstallLocation");
        }
        String result = this.data.getProperty(key);
        if (result == null) {
            result = InstallRegistry.getInstance().getProperty(key);
        }
        return result;
    }

    @Override
    public String removeUserData(String key) {
        String result = this.getUserData(key);
        this.removeData(key);
        return result;
    }

    public boolean isSensitiveUserData(String key) {
        return this.sensitiveData.contains(key);
    }

    public void setSensitiveUserData(String key, String offeringId) {
        this.setSensitiveUserData(Profile.createKey(key, offeringId));
    }

    public void setSensitiveUserData(String key) {
        if (this.sensitiveData.isEmpty()) {
            this.sensitiveData = new HashSet<String>(4);
        }
        this.sensitiveData.add(key);
    }

    @Override
    @Deprecated
    public String setUserData(String key, String value) {
        String result = this.getUserData(key);
        this.setData(key, value);
        return result;
    }

    @Override
    @Deprecated
    public String setOfferingUserData(String key, String value, String offeringId) {
        return this.setUserData(Profile.createKey(key, offeringId), value);
    }

    @Override
    public String getUserData(String key) {
        if (!Profile.isUserData(key)) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.Profile_Bad_User_Data_Key_Prefix, (Object)key, (Object)"user."));
        }
        return this.getData(key);
    }

    @Override
    public String getOfferingUserData(String key, String offeringId) {
        return this.getUserData(Profile.createKey(key, offeringId));
    }

    @Override
    public IStatus saveUserData(IProgressMonitor monitor) {
        try {
            this.getInstallRegistry().commit(monitor);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    public void cleanUserData(Set installedOfferingIds) {
        Iterator i = this.data.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String id = Profile.getUserDataOfferingId(key);
            if (id == null || installedOfferingIds.contains(new SimpleIdentity(id))) continue;
            i.remove();
        }
    }

    public static boolean isUserData(String key) {
        return key.startsWith("user.");
    }

    public static String createKey(String key, String offeringId) {
        if (offeringId.indexOf(44) >= 0) {
            throw new IllegalArgumentException(NLS.bind((String)"Invalid offering id: {0}", (Object)offeringId));
        }
        return String.valueOf(key) + ',' + offeringId;
    }

    public static String getUserDataOfferingId(String key) {
        int i;
        if (Profile.isUserData(key) && (i = key.lastIndexOf(44)) >= 0) {
            return key.substring(i + 1);
        }
        return null;
    }

    @Override
    public IStatus setData(String key, String value) {
        if (value.equals(this.getData(key))) {
            return Status.OK_STATUS;
        }
        if (!this.isOverrideableProperty(key)) {
            throw new IllegalArgumentException("Property is not overrideable: " + key);
        }
        if (INSTALL_LOCATION.equals(key)) {
            throw new IllegalArgumentException("Please use Profile.setInstallLocation(String val)");
        }
        if ("eclipseLocation".equals(key)) {
            return this.setEclipseLocation(value);
        }
        return this.doSetProperty(key, value);
    }

    public void removeData(String key) {
        this.data.remove((Object)key);
    }

    private IStatus doSetProperty(String key, String value) {
        IStatus status = Status.OK_STATUS;
        if (!AgentUserOptions.CIC_CCB_CLASSIC_ECLIPSE.isSet() && !AgentUserOptions.CIC_SUPPRESS_PLATFORM_CHECKS.isSet()) {
            if (key.equals(PROP_NAME_WS)) {
                Set allowedValues = SupportedPlatforms.getInstance().getWsValues(Platform.getOS(), Platform.getOSArch());
                status = this.validatePredefinedSelector(key, value, allowedValues.toArray(new String[allowedValues.size()]));
            } else if (key.equals(PROP_NAME_OS)) {
                status = this.validatePredefinedSelector(key, value, Platform.getOS());
            } else if (key.equals(PROP_NAME_ARCH)) {
                status = CicCommonSettings.is64BitOs() ? this.validatePredefinedSelector(key, value, BitModeUtils.get32bitArch(), BitModeUtils.get64bitArch()) : this.validatePredefinedSelector(key, value, BitModeUtils.get32bitArch());
            }
        }
        if (!StatusUtil.isErrorOrCancel((IStatus)status)) {
            this.data.setProperty(key, value);
        }
        return status;
    }

    private IStatus validatePredefinedSelector(String key, String value, String ... allowedValues) {
        if (value.indexOf(44) >= 0) {
            throw new IllegalArgumentException(NLS.bind((String)"Predefined selector values may not contain comma: {0}={1}", (Object)key, (Object)value));
        }
        if (value.equals("*")) {
            throw new IllegalArgumentException(NLS.bind((String)"Predefined selector value for {0} may not be {1}", (Object)key, (Object)value));
        }
        boolean matches = false;
        String[] stringArray = allowedValues;
        int n = allowedValues.length;
        int n2 = 0;
        while (n2 < n) {
            String allowedValue = stringArray[n2];
            if (allowedValue.equals(value)) {
                matches = true;
                break;
            }
            ++n2;
        }
        if (!matches) {
            return Statuses.ERROR.get(Messages.Profile_selectorDoesNotMatch, new Object[]{key, value, Util.toString((Object[])allowedValues, (Util.Formatter)Util.Formatter.DEFAULT)});
        }
        return Status.OK_STATUS;
    }

    private boolean allowRelatedInstallLocations(Profile that) {
        return this.isImportProfile() && that.allowRelatedInstallLocations();
    }

    public boolean allowRelatedInstallLocations() {
        if (Boolean.getBoolean(OVERRIDE_PROFILE_VALIDATION_PROPERTY)) {
            return true;
        }
        IOffering[] offerings = this.getInstalledOfferings();
        int i = 0;
        while (i < offerings.length) {
            if (!OfferingProperty.validateImportProfile((IOfferingOrFix)offerings[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setNeedsRequalification() {
        if (this.isExistingEclipseProfile()) {
            InstallContext eclipseContext;
            String[] keys;
            this.setProfileKind("product");
            Set keySet = this.data.keySet();
            String[] stringArray = keys = keySet.toArray(new String[keySet.size()]);
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (key.startsWith("existing.jre.for.eclipse.ide.")) {
                    this.data.remove((Object)key);
                }
                ++n2;
            }
            this.data.remove((Object)"existing.eclipse.ide.platform.version");
            this.data.remove((Object)PLATFORMXML_TIMESAMP);
            this.data.remove((Object)"existing.eclipseproduct.id");
            this.data.remove((Object)"existing.eclipseproduct.name");
            this.data.remove((Object)"existing.eclipseproduct.version");
            String contextId = this.data.getProperty("eclipseContext");
            if (contextId != null && (eclipseContext = this.findInstallContext(contextId)) != null) {
                eclipseContext.delete();
            }
        }
    }

    public boolean isInstallLocationChangeable() {
        return this.getInstallRegistry().isEmpty();
    }

    @Override
    public String getInstallLocation() {
        return this.installLocation;
    }

    public IStatus setInstallLocation(String installLocation) {
        IStatus status = this.validateLocation(installLocation, true);
        if (!this.hasDifferentEclipseAndInstall()) {
            this.doSetEclipseLocation(installLocation);
        }
        this.installLocation = installLocation;
        return status;
    }

    public String getLogicalInstallLocation() {
        if (this.isAgentProfile()) {
            return AgentInstall.getInstance().getLogicalInstallLocation(new File(this.installLocation)).getPath();
        }
        return this.installLocation;
    }

    public void massageAgentInstallLocation() {
        if (!this.isAgentProfile()) {
            return;
        }
        if (!this.isInstallLocationChangeable()) {
            return;
        }
        String massagedInstallLocation = AgentInstall.getInstance().massageAgentInstallLocation(this.installLocation);
        this.doSetEclipseLocation(massagedInstallLocation);
        this.installLocation = massagedInstallLocation;
    }

    public IStatus cleanInstallLocation() {
        return this.cleanInstallLocation(false);
    }

    private IStatus cleanInstallLocation(boolean removeDataPartition) {
        if (this.installLocation == null) {
            return Status.OK_STATUS;
        }
        if (this.getInstallRegistry().isEmpty()) {
            if (this.isExistingEclipseProfile() && this.hasEclipseLocation() && this.isInstallLocationRelated(this.getEclipseLocation())) {
                return Status.OK_STATUS;
            }
            File installDir = new File(this.getInstallLocation());
            if (removeDataPartition && this.isDataPartitioned()) {
                FileUtil.rm_r((File)new File(this.getDataLocation()), (boolean)true);
                FileUtil.removeEmptyDirs((File)installDir, (boolean)true, (String[])new String[0]);
            } else {
                FileUtil.removeEmptyDirs((File)installDir, (boolean)true, (String[])new String[]{".ibmim"});
            }
            return Status.OK_STATUS;
        }
        return Statuses.ST.createMultiStatus(NLS.bind((String)Messages.Agent_Profile_Not_Empty, (Object)this, (Object)this.getInstallRegistry().contentsToString()), new Object[0]);
    }

    @Override
    public String getEclipseLocation() {
        return this.getData("eclipseLocation");
    }

    @Override
    public boolean hasEclipseLocation() {
        String location = this.getEclipseLocation();
        return location != null && location.length() > 0;
    }

    public IStatus setEclipseLocation(String eclipseLocation) {
        IStatus status = this.validateLocation(eclipseLocation, false);
        if (status.isOK()) {
            this.doSetEclipseLocation(eclipseLocation);
        }
        return status;
    }

    private void doSetEclipseLocation(String eclipseLocation) {
        this.doSetProperty("eclipseLocation", eclipseLocation);
        this.doSetProperty("eclipseContext", "com.ibm.sdp.eclipse.ide");
    }

    private boolean isOverrideableProperty(String key) {
        return !CACHE_LOCATION.equals(key);
    }

    public IStatus validateInstallLocation(boolean allowExistingInstallLocation) {
        File file = new File(this.installLocation);
        if (!file.exists()) {
            return Status.OK_STATUS;
        }
        if (!file.isDirectory()) {
            return Statuses.ERROR.get(Messages.AgentUtil_Installation_Location_Not_Directory, new Object[]{file});
        }
        if (!FileUtil.canRead((File)file)) {
            return Statuses.WARNING.get(Messages.AgentUtil_Installation_Directory_Not_Readable, new Object[]{file});
        }
        if (FileUtil.isEmptyDir((File)file)) {
            return Status.OK_STATUS;
        }
        if (this.profileKind.equals("license")) {
            return Status.OK_STATUS;
        }
        if (Agent.getInstance().isSkipInstall()) {
            return Status.OK_STATUS;
        }
        if (!this.getInstallRegistry().isEmpty()) {
            return Status.OK_STATUS;
        }
        if (allowExistingInstallLocation) {
            Logger.getGlobalLogger().info(Messages.AgentUtil_Installation_Location_Not_Empty_Existing_Install, new Object[]{file});
            return Status.OK_STATUS;
        }
        if (AgentUserOptions.CIC_AGENT_ALLOW_NONEMPTY_LOCATION.isSet()) {
            Logger.getGlobalLogger().warning(Messages.AgentUtil_Installation_Directory_Not_EmptyWarning, new Object[]{file});
            return Status.OK_STATUS;
        }
        return Statuses.ERROR.get(Messages.AgentUtil_Installation_Directory_Not_EmptyError, new Object[]{file});
    }

    public IStatus validateEclipseLocationCollision() {
        if (!this.hasDifferentEclipseAndInstall()) {
            return Status.OK_STATUS;
        }
        String eclipseLocation = this.getEclipseLocation();
        List<Profile> others = Arrays.asList(Agent.getInstance().getProfiles());
        for (Profile other : this.getProfilesForLocationCheck(others)) {
            String otherEclipseLocation;
            String otherInstallLocation = other.getLogicalInstallLocation();
            if (FileUtil.filesAreSame((String)eclipseLocation, (String)otherInstallLocation)) {
                return Statuses.ERROR.get(Messages.Profile_Eclipse_Directory_Install_Same, new Object[]{otherInstallLocation, other.getProfileId(), this.getProfileId()});
            }
            if (other.isInstallLocationRelated(eclipseLocation) && !this.allowRelatedInstallLocations(other)) {
                return Statuses.ERROR.get(Messages.Profile_Eclipse_Directory_Install_Collision, new Object[]{otherInstallLocation, other.getProfileId(), this.getProfileId()});
            }
            if (!other.hasDifferentEclipseAndInstall() || !FileUtil.filesAreSame((String)eclipseLocation, (String)(otherEclipseLocation = other.getEclipseLocation()))) continue;
            return Statuses.ERROR.get(Messages.Profile_Eclipse_Directory_Same, new Object[]{otherInstallLocation, otherEclipseLocation, other.getProfileId(), this.getProfileId()});
        }
        return Status.OK_STATUS;
    }

    IStatus validateInstallLocationCollision() {
        return this.validateInstallLocationCollision(Arrays.asList(Agent.getInstance().getProfiles()));
    }

    private IStatus validateInstallLocationCollision(List others) {
        assert (this.installLocation != null);
        for (Profile other : this.getProfilesForLocationCheck(others)) {
            boolean otherIsInstalled;
            String otherInstallLocation = other.getLogicalInstallLocation();
            boolean bl = otherIsInstalled = Profile.getProfile(other.getProfileId()) != null;
            if (FileUtil.filesAreSame((String)this.installLocation, (String)otherInstallLocation)) {
                return Statuses.ERROR.get(otherIsInstalled ? Messages.Profile_Install_Directory_Same : Messages.Profile_Install_Directory_Same2, new Object[]{otherInstallLocation, other.getProfileId(), this.getProfileId()});
            }
            if (this.isInstallLocationRelated(otherInstallLocation) && !this.allowRelatedInstallLocations(other)) {
                return Statuses.ERROR.get(otherIsInstalled ? Messages.Profile_Install_Directory_Collision : Messages.Profile_Install_Directory_Collision2, new Object[]{otherInstallLocation, other.getProfileId(), this.getProfileId()});
            }
            if (!other.hasDifferentEclipseAndInstall()) continue;
            String otherEclipseLocation = other.getEclipseLocation();
            if (FileUtil.filesAreSame((String)this.installLocation, (String)otherEclipseLocation)) {
                return Statuses.ERROR.get(Messages.Profile_Install_Directory_Eclipse_Same, new Object[]{otherInstallLocation, otherEclipseLocation, other.getProfileId(), this.getProfileId()});
            }
            if (!this.isInstallLocationRelated(otherEclipseLocation) || this.allowRelatedInstallLocations(other)) continue;
            return Statuses.ERROR.get(Messages.Profile_Install_Directory_Eclipse_Collision, new Object[]{otherInstallLocation, otherEclipseLocation, other.getProfileId(), this.getProfileId()});
        }
        return Status.OK_STATUS;
    }

    private List getProfilesForLocationCheck(List others) {
        if (this.isAgentProfile() || this.isLicenseProfile()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Profile> result = new ArrayList<Profile>(others.size());
        for (Profile other : others) {
            if (this.profileId.equals(other.getProfileId())) continue;
            result.add(other);
        }
        return result;
    }

    public boolean hasDifferentEclipseAndInstall() {
        return this.hasEclipseLocation() && !FileUtil.filesAreSame((String)this.getEclipseLocation(), (String)this.installLocation);
    }

    private boolean isInstallLocationRelated(String location) {
        String logicalInstallLocation = this.getLogicalInstallLocation();
        return FileUtil.directoriesAreRelated((String)logicalInstallLocation, (String)location);
    }

    IStatus validateCacheLocationCollision(String cacheLocation) {
        String logicalInstallLocation;
        if (Agent.getInstance().isPortable()) {
            return Status.OK_STATUS;
        }
        if (cacheLocation == null) {
            cacheLocation = CacheLocationManager.getInstance().getCacheLocation();
        }
        if (FileUtil.filesAreSame((String)cacheLocation, (String)(logicalInstallLocation = this.getLogicalInstallLocation()))) {
            return Statuses.ERROR.get(Messages.Profile_Install_And_Cache_Directory_Same, new Object[]{logicalInstallLocation, cacheLocation});
        }
        if (!CicCommonSettings.isPortable() && FileUtil.directoriesAreRelated((String)cacheLocation, (String)logicalInstallLocation)) {
            return Statuses.ERROR.get(Messages.Profile_Install_And_Cache_Directory_Collision, new Object[]{logicalInstallLocation, cacheLocation});
        }
        return Status.OK_STATUS;
    }

    IStatus validateDataLocationCollision() {
        String logicalInstallLocation;
        String dataLocation = CicCommonSettings.getApplicationDataLocation();
        if (!FileUtil.directoriesAreRelated((String)dataLocation, (String)(logicalInstallLocation = this.getLogicalInstallLocation()))) {
            return Status.OK_STATUS;
        }
        return Statuses.ERROR.get(Messages.Profile_Install_And_Data_Location_Collision, new Object[]{logicalInstallLocation, dataLocation});
    }

    IStatus validateRegistryLocationCollision() {
        String logicalInstallLocation;
        File registryFile = AgentRegistry.getInstance().getRegistryFile();
        if (registryFile == null) {
            return Status.OK_STATUS;
        }
        if (CicCommonSettings.getAccessRightsMode().isGroupMode()) {
            return Status.OK_STATUS;
        }
        String registryLocation = registryFile.getParent();
        if (!FileUtil.directoriesAreRelated((String)registryLocation, (String)(logicalInstallLocation = this.getLogicalInstallLocation()))) {
            return Status.OK_STATUS;
        }
        return Statuses.ERROR.get(Messages.Profile_Install_And_Registry_Location_Collision, new Object[]{logicalInstallLocation, registryLocation});
    }

    public LinkedProperties getAllData() {
        return new UnmodifiableProperties(this.data);
    }

    public String toString() {
        return XMLUtil.simpleElement((String)"profile", (String[])new String[]{"id", this.profileId, "kind", this.getProfileKind(), INSTALL_LOCATION, this.installLocation});
    }

    public final String makeRootContextId() {
        return String.valueOf(this.profileId) + "." + "root";
    }

    public InstallRegistry.ProfileInstallRegistry getInstallRegistry() {
        return InstallRegistry.getInstance().getProfileInstallRegistry(this);
    }

    private File getProfileAgentData(String key) {
        return new File(this.getDataLocation(), key);
    }

    public File getAdapterStorage(String adapterId) {
        File adaptersDir = this.getProfileAgentData("adapters");
        File adapterSpecificDir = new File(adaptersDir, adapterId);
        File adapterSpecificProfileDir = new File(adapterSpecificDir, this.getProfileId());
        return adapterSpecificProfileDir;
    }

    public boolean needsRestart() {
        return this.rootContext != null && this.rootContext.needsRestart(true);
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public static Map validateLocationCollision(Profile[] profiles, Set<Profile> profilesWithExistingLocations) {
        IStatus status;
        Profile profile;
        Profile[] existing = Agent.getInstance().getProfiles();
        ArrayList<Profile> others = new ArrayList<Profile>(profiles.length + existing.length);
        LinkedHashMap<Profile, IStatus> result = new LinkedHashMap<Profile, IStatus>(others.size());
        Profile[] profileArray = profiles;
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            profile = profileArray[n2];
            status = profile.validate();
            if (status.isOK()) {
                status = profile.validateCacheLocationCollision(null);
            }
            if (status.isOK()) {
                status = profile.validateDataLocationCollision();
            }
            if (status.isOK()) {
                status = profile.validateRegistryLocationCollision();
            }
            if (status.isOK()) {
                status = profile.validateEclipseLocationCollision();
            }
            if (status.isOK()) {
                status = profile.validateInstallLocationCollision();
            }
            if (status.isOK()) {
                boolean allowExistingInstallLocation = profilesWithExistingLocations.contains(profile);
                status = profile.validateInstallLocation(allowExistingInstallLocation);
            }
            result.put(profile, status);
            if (status.isOK()) {
                others.add(profile);
            }
            ++n2;
        }
        profileArray = profiles;
        n = profiles.length;
        n2 = 0;
        while (n2 < n) {
            profile = profileArray[n2];
            status = (IStatus)result.get(profile);
            if (status.isOK() && !(status = profile.validateInstallLocationCollision(others)).isOK()) {
                result.put(profile, status);
            }
            ++n2;
        }
        return result;
    }

    public static Profile makeNewImportProfileForOffering(IOffering offering) {
        return Profile.makeNewProfileForOffering(offering, null, null, false, true);
    }

    public static Profile makeNewProfileForOffering(IOffering offering, String profileId, String installLocation, boolean noAlternativeLocation) {
        return Profile.makeNewProfileForOffering(offering, profileId, installLocation, noAlternativeLocation, false);
    }

    private static Profile makeNewProfileForOffering(IOffering offering, String profileId, String installLocation, boolean noAlternativeLocation, boolean importedProfile) {
        if (offering == null && (profileId == null || installLocation == null)) {
            throw new IllegalArgumentException("offering may not be null");
        }
        if (profileId == null) {
            profileId = Profile.makeNewProfileIdForOffering(offering, true);
        }
        if (installLocation == null) {
            installLocation = PlatformUtils.getDefaultInstallLocation((IOffering)offering);
        }
        try {
            installLocation = VariableSubstitution.getInstance().performVariableSubstitutions(installLocation, AbstractVariableSubstitution.AllowAbsolutePath.TRUE);
        }
        catch (AbstractVariableSubstitution.VariableSubstitutionException variableSubstitutionException) {}
        boolean shouldSetPortableMode = OfferingOrFixProperty.supportsPortable((IOfferingOrFix)offering) && CicCommonSettings.isPortable();
        boolean isAgentOffering = Agent.getInstance().isAgentOffering((IOfferingOrFix)offering);
        boolean shouldPartition = (AgentUserOptions.PARTITION_ENABLED_PROPERTY.isSet() || shouldSetPortableMode) && !Agent.getInstance().isSkipInstall();
        Profile profile = new Profile(profileId, isAgentOffering ? "self" : "product", shouldPartition);
        profile.setInstallLocation(installLocation);
        profile.setImportProfile(importedProfile);
        if (shouldSetPortableMode) {
            profile.setPortableMode();
        }
        if (noAlternativeLocation) {
            return profile;
        }
        profile.makeNonConflictingInstallLocation();
        return profile;
    }

    public void makeNonConflictingInstallLocation() {
        if (!this.hasInstallLocationCollision()) {
            return;
        }
        String location = this.getInstallLocation();
        int index = 1;
        while (index < 1000) {
            String indexString = "_" + index;
            String tryLocation = String.valueOf(location) + indexString;
            this.setInstallLocation(tryLocation);
            if (!this.hasInstallLocationCollision()) {
                return;
            }
            ++index;
        }
        this.setInstallLocation(location);
    }

    public static String makeNewProfileIdForOffering(IOffering offering, Set<String> existingProfileIds) {
        return Profile.makeNewProfileIdForOffering(offering, true, existingProfileIds);
    }

    private static String makeNewProfileIdForOffering(IOffering offering, boolean ignoreMissingDefaultProfileLocation) {
        HashSet<String> existingProfileIds = new HashSet<String>();
        Profile[] profileArray = InstallRegistry.getInstance().getProfiles();
        int n = profileArray.length;
        int n2 = 0;
        while (n2 < n) {
            Profile profile = profileArray[n2];
            existingProfileIds.add(profile.getProfileId());
            ++n2;
        }
        return Profile.makeNewProfileIdForOffering(offering, ignoreMissingDefaultProfileLocation, existingProfileIds);
    }

    private static String makeNewProfileIdForOffering(IOffering offering, boolean ignoreMissingDefaultProfileLocation, Set<String> existingProfileIds) {
        String profileId = OfferingProperty.getDefaultProfile((IOfferingOrFix)offering);
        try {
            profileId = VariableSubstitution.getInstance().performVariableSubstitutions(profileId);
        }
        catch (AbstractVariableSubstitution.VariableSubstitutionException variableSubstitutionException) {}
        if (profileId == null || (profileId = profileId.trim()).length() == 0) {
            if (!ignoreMissingDefaultProfileLocation) {
                return null;
            }
            profileId = String.valueOf(offering.getName()) + " " + offering.getVersion().toString();
        }
        String id = profileId;
        int i = 1;
        while (existingProfileIds.contains(id)) {
            id = String.valueOf(profileId) + "_" + i;
            ++i;
        }
        return id;
    }

    void refactorAgentProfileId() throws IOException {
        assert (this.isAgentProfile()) : "refactorAgentProfileId() called on non-agent profile";
        if (!OLD_AGENT_PROFILE_ID.equals(this.getProfileId())) {
            return;
        }
        if (!this.agentProfileCreatedByIM10x()) {
            return;
        }
        IOffering agentOffering = Agent.getInstance().getAgentOffering();
        if (agentOffering == null) {
            throw new IOException("refactorAgentProfileId(): agent offering not found");
        }
        File oldEclipseAdapterStorage = this.getAdapterStorage("eclipse");
        File oldNativeAdapterStorage = this.getAdapterStorage("native");
        String newId = Profile.makeNewProfileIdForOffering(agentOffering, false);
        InstallRegistry.getInstance().refactorAgentProfileId(this, newId);
        InstallRegistry.getInstance().removeProfile(this);
        this.profileId = newId;
        InstallRegistry.getInstance().addProfile(this);
        File newEclipseAdapterStorage = this.getAdapterStorage("eclipse");
        File newNativeAdapterStorage = this.getAdapterStorage("native");
        this.renameAgentAdapterStorage(oldEclipseAdapterStorage, newEclipseAdapterStorage);
        this.renameAgentAdapterStorage(oldNativeAdapterStorage, newNativeAdapterStorage);
        Agent.getInstance().getHistoryStore().refactorAgentProfileId(OLD_AGENT_PROFILE_ID, this.profileId);
        this.refactorAgentProfileIdInUninstallXml();
    }

    private boolean agentProfileCreatedByIM10x() {
        IOffering[] installedOfferings;
        IOffering[] iOfferingArray = installedOfferings = this.getInstallRegistry().getInstalledOfferings((IIdentity)new SimpleIdentity("com.ibm.cic.agent"));
        int n = installedOfferings.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering offering = iOfferingArray[n2];
            Version version = offering.getVersion();
            if (version.getMajor() == 1 && version.getMinor() == 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void refactorAgentProfileIdInUninstallXml() {
        File uninstallDir = Agent.getInstance().getUninstallLocation();
        File uninstallXml = new File(uninstallDir, "uninstall.xml");
        Input input = new Input();
        try {
            IUninstallCommand[] uninstallCommands;
            IStatus status = input.load(uninstallXml);
            if (status.getSeverity() == 4) {
                Logger.getGlobalLogger().status(status);
                return;
            }
            IUninstallCommand[] iUninstallCommandArray = uninstallCommands = input.getUninstallCommands();
            int n = uninstallCommands.length;
            int n2 = 0;
            while (n2 < n) {
                IUninstallCommand uninstallCommand = iUninstallCommandArray[n2];
                uninstallCommand.refactorAgentProfileId(this.profileId);
                ++n2;
            }
            input.save(uninstallXml);
        }
        catch (Exception e) {
            Logger.getGlobalLogger().error((Throwable)e);
        }
    }

    private void renameAgentAdapterStorage(File oldStorage, File newStorage) throws IOException {
        if (oldStorage.isDirectory() && !oldStorage.renameTo(newStorage)) {
            throw new IOException("unable to rename \"" + oldStorage.getPath() + "\"");
        }
    }

    public String getDefaultInstallLocation(IOffering offering) throws AbstractVariableSubstitution.VariableSubstitutionException {
        String defaultInstallLocation = PlatformUtils.getDefaultInstallLocation((IOffering)offering);
        SubstitutionOperation op = new SubstitutionOperation(this.getRootContext());
        return op.performVariableSubstitutions(defaultInstallLocation, AbstractVariableSubstitution.AllowAbsolutePath.TRUE);
    }

    private boolean hasInstallLocationCollision() {
        return !this.validateInstallLocationCollision().isOK() || !this.validateCacheLocationCollision(null).isOK();
    }

    boolean skipLocationValidation() {
        String skip = this.getData(SKIP_LOCATION_VALIDATION);
        return Boolean.TRUE.toString().equals(skip);
    }

    private IStatus validateLocation(String location, boolean checkLength) {
        assert (location != null);
        if (this.skipLocationValidation()) {
            return Status.OK_STATUS;
        }
        if (location.length() == 0) {
            return Profile.createValidationErrorStatus(Messages.Profile_Install_Directory_Required, -1, new Object[0]);
        }
        if (checkLength && this.maxInstallLocationLength > -1 && location.length() > this.maxInstallLocationLength) {
            String msg = NLS.bind((String)Messages.Profile_Install_Directory_Length, (Object)this.maxInstallLocationLength);
            return Profile.createValidationErrorStatus(msg, -3, new Object[0]);
        }
        IStatus status = PlatformUtils.validatePath((String)location);
        if (!status.isOK()) {
            return Profile.createValidationErrorStatus(String.valueOf(NLS.bind((String)Messages.Profile_Invalid_Install_Location, (Object)location)) + " " + status.getMessage(), -4, new Object[0]);
        }
        if (CicCommonSettings.getAccessRightsMode().isGroupMode()) {
            status = AgentUtil.validateInstallDirectoryPermissions(location);
            if (!status.isOK()) {
                return Profile.createValidationErrorStatus(status.getMessage(), -4, new Object[0]);
            }
        } else if (!FileUtil.directoryIsWriteable((String)location)) {
            return Profile.createValidationErrorStatus(Messages.Profile_Writable_Install_Location, -5, location);
        }
        return Status.OK_STATUS;
    }

    private static IStatus validateId(Profile profile, String id) {
        if (id.length() == 0) {
            return Profile.createValidationErrorStatus(Messages.Profile_Install_Location_Name_Required, -1, new Object[0]);
        }
        Profile profile2 = Profile.getProfile(id);
        if (profile2 != null && profile != profile2 && !FileUtil.filesAreSame((String)profile2.getInstallLocation(), (String)profile.getInstallLocation())) {
            return Profile.createValidationErrorStatus(Messages.Profile_Install_Location_Name_Exists, -1, new Object[0]);
        }
        IStatus status = Profile.isValidId(id);
        if (!status.isOK()) {
            String msg = String.valueOf(Messages.Profile_Install_Location_Name_Invalid) + " " + status.getMessage();
            return Profile.createValidationErrorStatus(msg, status.getCode(), new Object[0]);
        }
        return Status.OK_STATUS;
    }

    IStatus validate() {
        IStatus status = Profile.validateId(this, this.getProfileId());
        if (status.isOK()) {
            status = this.validateLocation(this.installLocation, true);
        }
        return status;
    }

    private static IStatus createValidationErrorStatus(String message, int code, Object ... args) {
        return Statuses.ERROR.getMultiStatus(code, null, message, args);
    }

    public void setMaxInstallLocationLength(int length) {
        this.maxInstallLocationLength = length;
    }

    public static Profile getLicenseProfile(Agent agent) {
        Profile licprofile = agent.getProfile(LICENSE_PROFILE_NAME);
        if (licprofile == null) {
            licprofile = Profile.initializeLicenseProfile(agent.getAgentProfile());
            agent.addProfile(licprofile);
        }
        return licprofile;
    }

    public static void setLicenseProfileInstallLocation() {
        Profile.setLicenseProfileInstallLocation(Agent.getInstance().getAgentProfile());
    }

    public static void setLicenseProfileInstallLocation(Profile agentProfile) {
        Profile licenseProfile = Profile.getProfile(LICENSE_PROFILE_NAME);
        if (licenseProfile == null || !licenseProfile.isInstallLocationChangeable()) {
            return;
        }
        String installLocation = Profile.getLicenseProfileInstallLocation(agentProfile);
        licenseProfile.setInstallLocation(installLocation);
    }

    private static Profile initializeLicenseProfile(Profile agentProfile) {
        Profile licprofile = new Profile(LICENSE_PROFILE_NAME, "license");
        String installLocation = Profile.getLicenseProfileInstallLocation(agentProfile);
        licprofile.setInstallLocation(installLocation);
        licprofile.getRootContext().addAdaptorType("eclipse");
        licprofile.getRootContext().addAdaptorType("native");
        return licprofile;
    }

    private static String getLicenseProfileInstallLocation(Profile agentProfile) {
        File installLocation;
        if (agentProfile != null) {
            File agentInstallPath = new File(agentProfile.getInstallLocation());
            installLocation = new File(agentInstallPath.getParent(), LICENSE_PROFILE_LOCATION);
        } else {
            String defaultInstallLocation = PlatformUtils.getDefaultInstallRootLocation((boolean)BitModeUtils.is64bitIM());
            String defaultAgentFolderName = "win32".equals(Platform.getOS()) ? "Installation Manager" : "InstallationManager";
            installLocation = new File(String.valueOf(defaultInstallLocation) + File.separatorChar + "IBM" + File.separatorChar + defaultAgentFolderName + File.separatorChar + LICENSE_PROFILE_LOCATION);
        }
        return installLocation.getAbsolutePath();
    }

    private static Profile getProfile(String id) {
        return Agent.getInstance().getProfile(id);
    }

    public static boolean isUserSettableProperty(String propertyName) {
        if (Profile.isUserData(propertyName)) {
            return true;
        }
        String[] stringArray = settableProperties;
        int n = settableProperties.length;
        int n2 = 0;
        while (n2 < n) {
            String settableProperty = stringArray[n2];
            if (settableProperty.equals(propertyName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isPhantom() {
        return false;
    }

    public boolean isShadow() {
        return this.shadow;
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    public Profile convertShadow() {
        if (!this.shadow) {
            return this;
        }
        Profile profile = new Profile(this.profileId, this.profileKind, this.rootContext, this.isDataPartitioned);
        profile.data.putAll(this.data);
        profile.installLocation = this.installLocation;
        return profile;
    }

    @Override
    public IOffering[] getInstalledOfferings() {
        return this.getInstallRegistry().getInstalledOfferings();
    }

    @Override
    public IFix[] getInstalledFixes() {
        return this.getInstallRegistry().getInstalledFixes();
    }

    @Override
    public IFix[] getInstalledFixes(IOffering offering) {
        return this.getInstallRegistry().getInstalledFixes(offering);
    }

    @Override
    public boolean isInstalled(IOfferingOrFix offeringOrFix) {
        return this.getInstallRegistry().isInstalled(offeringOrFix);
    }

    @Override
    public IOffering findOffering(String offeringId) {
        IOffering return_value = null;
        IOffering[] installedOfferings = this.getInstalledOfferings();
        if (installedOfferings != null) {
            IOffering[] iOfferingArray = installedOfferings;
            int n = installedOfferings.length;
            int n2 = 0;
            while (n2 < n) {
                IOffering installedOffering = iOfferingArray[n2];
                if (installedOffering.getIdentity().getId().equals(offeringId)) {
                    return_value = installedOffering;
                    break;
                }
                ++n2;
            }
        }
        return return_value;
    }

    public String getCacheLocation() {
        if (CicCommonSettings.isPortable()) {
            return new File(this.installLocation, ".ibmim/shared").getAbsolutePath();
        }
        return InstallRegistry.getInstance().getCacheLocation();
    }

    public String getDataLocation() {
        if (this.isDataPartitioned()) {
            return new File(this.installLocation, ".ibmim/data").getAbsolutePath();
        }
        Agent.getInstance().initializeAgentPreferences();
        return CicCommonSettings.getApplicationDataLocation();
    }

    @Override
    public String getWS() {
        String result = this.data.getProperty(PROP_NAME_WS);
        if (result == null) {
            return SupportedPlatforms.getInstance().getLegacyWs(this.getOS(), this.getArch());
        }
        return result;
    }

    @Override
    public String getOS() {
        String result = this.data.getProperty(PROP_NAME_OS);
        if (result == null) {
            return Platform.getOS();
        }
        return result;
    }

    @Override
    public String getArch() {
        String result = this.data.getProperty(PROP_NAME_ARCH);
        if (result == null) {
            return BitModeUtils.get32bitArch();
        }
        return result;
    }

    @Override
    public boolean isPortable() {
        return Boolean.valueOf(this.data.getProperty("cic.selector.portable"));
    }

    public void setPortableMode() {
        this.data.setProperty("cic.selector.portable", "true");
    }

    @Override
    public boolean is32bit() {
        if (AgentUserOptions.CIC_CCB_CLASSIC_ECLIPSE.isSet()) {
            return true;
        }
        return ProfileArch.is32bitArch((String)this.getArch());
    }

    @Override
    public boolean is64bit() {
        if (AgentUserOptions.CIC_CCB_CLASSIC_ECLIPSE.isSet()) {
            return false;
        }
        return ProfileArch.is64bitArch((String)this.getArch());
    }

    public IStatus evaluateVariableSelector(String selIdStr, String selValStr) {
        InstallContext installContext = this.getRootContext();
        if (installContext != null) {
            SubstitutionOperation operation = new SubstitutionOperation(installContext);
            try {
                String selId = operation.performVariableSubstitutions(selIdStr);
                String selVal = operation.performVariableSubstitutions(selValStr);
                if (selId != null && selId.equals(selVal)) {
                    return Status.OK_STATUS;
                }
            }
            catch (AbstractVariableSubstitution.VariableSubstitutionException variableSubstitutionException) {}
        }
        return Status.CANCEL_STATUS;
    }

    public boolean shouldBeVisible() {
        return CicCommonSettings.isPortable() == this.isPortable();
    }

    public boolean isDataPartitioned() {
        return this.isDataPartitioned;
    }

    public IStatus cleanDataLocation() {
        if (this.isDataPartitioned()) {
            Agent.getInstance().getHistoryStore().moveProfileHistoryStorage(this, true);
            return this.cleanInstallLocation(true);
        }
        return Status.OK_STATUS;
    }

    public IStatus copyAgentBundleCache(IProgressMonitor monitor) {
        if (this.isDataPartitioned()) {
            File profileBundlesLoc = this.getProfileAgentData("bundles");
            FileUtil.rm_r((File)profileBundlesLoc, (boolean)false);
            File globalBundlesLoc = Agent.getInstance().getAgentBundleLocation();
            try {
                FileUtil.copyDir((File)globalBundlesLoc, (File)profileBundlesLoc, (IProgressMonitor)monitor);
            }
            catch (IOException e) {
                return Statuses.ERROR.get((Throwable)e, Messages.Profile_Cannot_Copy_Agent_Data, new Object[]{globalBundlesLoc.getAbsolutePath(), profileBundlesLoc.getAbsolutePath()});
            }
        } else {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public File getHistoryStorage() {
        return this.getProfileAgentData("histories");
    }
}

