/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.RollbackJob;
import com.ibm.cic.agent.core.UpdateOfferingJob;
import com.ibm.cic.agent.core.api.IAgent;
import com.ibm.cic.agent.core.api.IAgentJob;
import com.ibm.cic.agent.core.api.IPostSessionContext;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.core.api.PostSessionExtender;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.extensions.ExtensionManager;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class PostSessionManager {
    private static final String PT_POST_SESSION = "postSessionExtenders";
    private static final String PT_CLASS_ATTR = "class";
    private static PostSessionManager instance;
    private static final Logger log;

    static {
        log = Logger.getLogger(PostSessionManager.class);
    }

    public static PostSessionManager getInstance() {
        if (instance == null) {
            instance = new PostSessionManager();
        }
        return instance;
    }

    private PostSessionManager() {
    }

    public IStatus run(AgentJob[] jobs, IProgressMonitor monitor) {
        Collection profileJobsList = AgentUtil.groupByProfile(jobs, true);
        CicMultiStatus retStatus = Statuses.ST.createMultiStatus();
        for (AgentJob[] profileJobs : profileJobsList) {
            Profile thisProfile = profileJobs[0].getProfile();
            PostSessionContext context = new PostSessionContext(thisProfile, profileJobs);
            IConfigurationElement[] loadedElements = ExtensionManager.getInstance().getConfigurationElements(Agent.PI_AGENT, PT_POST_SESSION);
            IOfferingOrFix[] installedOfferingOrFixList = this.getInstalledOfferingOrFixList(thisProfile);
            Set bundlesFromInstalled = this.getBundles(installedOfferingOrFixList);
            if (log.isDebugLoggable()) {
                log.debug("Post session bundles from installed offering version or fix=" + bundlesFromInstalled);
            }
            HashSet postSessionExtsFromInstalled = new HashSet();
            retStatus.add(this.getPostSessionExtenders(bundlesFromInstalled, loadedElements, new HashSet(), postSessionExtsFromInstalled));
            IOfferingOrFix[] uninstalledOfferingOrFixList = this.getUninstalledOfferingOrFixList(profileJobs);
            Set bundlesFromUninstalled = this.getBundles(uninstalledOfferingOrFixList);
            if (log.isDebugLoggable()) {
                log.debug("Post session bundles from uninstalled offering version or fix=" + bundlesFromUninstalled);
            }
            HashSet postSessionExtsFromUninstalled = new HashSet();
            retStatus.add(this.getPostSessionExtenders(bundlesFromUninstalled, loadedElements, postSessionExtsFromInstalled, postSessionExtsFromUninstalled));
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            retStatus.add(this.runPostUninstallActions(postSessionExtsFromUninstalled, context, (IProgressMonitor)sm.newChild(1)));
            sm.setWorkRemaining(1);
            retStatus.add(this.runPostInstallActions(postSessionExtsFromInstalled, context, (IProgressMonitor)sm.newChild(1)));
        }
        return retStatus;
    }

    private IOfferingOrFix[] getUninstalledOfferingOrFixList(AgentJob[] jobs) {
        ArrayList<IOfferingOrFix> offeringOrFixList = new ArrayList<IOfferingOrFix>();
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                IOfferingOrFix uninstalledOfferingOrFix;
                block7: {
                    UpdateOfferingJob updateJob;
                    IOffering updateToOffering;
                    IOffering offeringInProfile;
                    String offeringId;
                    AgentJob job;
                    block8: {
                        block6: {
                            job = agentJobArray[n2];
                            uninstalledOfferingOrFix = null;
                            if (!job.isUninstall()) break block6;
                            uninstalledOfferingOrFix = job.getOfferingOrFix();
                            break block7;
                        }
                        if (!job.isRollback()) break block8;
                        RollbackJob rollbackJob = (RollbackJob)job;
                        IOffering rollbackToOffering = rollbackJob.getOffering();
                        if (rollbackToOffering == null) break block7;
                        offeringId = rollbackToOffering.getIdentity().getId();
                        offeringInProfile = rollbackJob.getProfile().findOffering(offeringId);
                        if (!rollbackToOffering.equals(offeringInProfile)) break block9;
                        uninstalledOfferingOrFix = rollbackJob.getRollbackFromOffering();
                        break block7;
                    }
                    if (!job.isUpdate() || (updateToOffering = (updateJob = (UpdateOfferingJob)job).getOffering()) == null) break block7;
                    offeringId = updateToOffering.getIdentity().getId();
                    offeringInProfile = updateJob.getProfile().findOffering(offeringId);
                    if (!updateToOffering.equals(offeringInProfile)) break block9;
                    uninstalledOfferingOrFix = updateJob.getUpdatedOffering();
                }
                if (uninstalledOfferingOrFix != null) {
                    offeringOrFixList.add(uninstalledOfferingOrFix);
                }
            }
            ++n2;
        }
        return offeringOrFixList.toArray(new IOfferingOrFix[offeringOrFixList.size()]);
    }

    private IOfferingOrFix[] getInstalledOfferingOrFixList(IProfile profile) {
        IOffering[] offerings;
        ArrayList<Object> offeringOrFixList = new ArrayList<Object>();
        IOffering[] iOfferingArray = offerings = profile.getInstalledOfferings();
        int n = offerings.length;
        int n2 = 0;
        while (n2 < n) {
            IFix[] fixes;
            IOffering offering = iOfferingArray[n2];
            offeringOrFixList.add(offering);
            IFix[] iFixArray = fixes = profile.getInstalledFixes(offering);
            int n3 = fixes.length;
            int n4 = 0;
            while (n4 < n3) {
                IFix fix = iFixArray[n4];
                offeringOrFixList.add(fix);
                ++n4;
            }
            ++n2;
        }
        return offeringOrFixList.toArray(new IOfferingOrFix[offeringOrFixList.size()]);
    }

    private IStatus getPostSessionExtenders(Set bundleSet, IConfigurationElement[] loadedElements, Set excludedElements, Set postSessionExtenders) {
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        for (PostSessionBundle bundle : bundleSet) {
            IConfigurationElement element = this.findMatchingConfigElement(bundle, loadedElements);
            if (element != null) {
                if (excludedElements.contains(element)) continue;
                postSessionExtenders.add(element);
                continue;
            }
            IStatus result = this.bundleNotFoundWarning(bundle);
            status.add(result);
            log.statusNotOK(result);
        }
        if (!status.isOK()) {
            return status;
        }
        return Status.OK_STATUS;
    }

    private Set getBundles(IOfferingOrFix[] offeringOrFixList) {
        HashSet bundleSet = new HashSet();
        IOfferingOrFix[] iOfferingOrFixArray = offeringOrFixList;
        int n = offeringOrFixList.length;
        int n2 = 0;
        while (n2 < n) {
            IOfferingOrFix offeringOrFix = iOfferingOrFixArray[n2];
            String postSessionBundlesPropertyValue = OfferingProperty.getPostSessionBundlesProperty((IOfferingOrFix)offeringOrFix);
            if (postSessionBundlesPropertyValue != null) {
                Set bundlesFromBundleListStr = this.getBundlesFromBundleListStr(postSessionBundlesPropertyValue);
                bundleSet.addAll(bundlesFromBundleListStr);
            }
            ++n2;
        }
        return bundleSet;
    }

    private Set getBundlesFromBundleListStr(String bundleListStr) {
        String[] bundleStrs;
        HashSet<PostSessionBundle> bundleSet = new HashSet<PostSessionBundle>();
        String[] stringArray = bundleStrs = bundleListStr.split(",");
        int n = bundleStrs.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                String bundleStr2 = stringArray[n2];
                String bundleStr = bundleStr2.trim();
                if (bundleStr.length() != 0) {
                    String[] bundleSegments = bundleStr.split(":");
                    String bundleId = null;
                    String className = null;
                    switch (bundleSegments.length) {
                        case 1: {
                            bundleId = bundleSegments[0];
                            break;
                        }
                        case 2: {
                            bundleId = bundleSegments[0];
                            className = bundleSegments[1];
                            break;
                        }
                        default: {
                            log.error("Invalid format:" + bundleStr);
                            break block6;
                        }
                    }
                    bundleSet.add(new PostSessionBundle(bundleId, className));
                }
            }
            ++n2;
        }
        return bundleSet;
    }

    private IStatus runPostInstallActions(Set postSessionExtSet, IPostSessionContext context, IProgressMonitor monitor) {
        return this.runActions(postSessionExtSet, context, true, monitor);
    }

    private IStatus runPostUninstallActions(Set postSessionExtSet, IPostSessionContext context, IProgressMonitor monitor) {
        return this.runActions(postSessionExtSet, context, false, monitor);
    }

    private IStatus runActions(Set postSessionExts, IPostSessionContext context, boolean runPostInstall, IProgressMonitor monitor) {
        CicMultiStatus retStatus = Statuses.ST.createMultiStatus();
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)postSessionExts.size());
        for (IConfigurationElement element : postSessionExts) {
            IStatus result;
            try {
                Object extensionClass = element.createExecutableExtension(PT_CLASS_ATTR);
                result = Status.OK_STATUS;
                if (extensionClass instanceof PostSessionExtender) {
                    if (runPostInstall) {
                        log.debug("Run post session install action from " + extensionClass.getClass());
                        result = ((PostSessionExtender)extensionClass).runPostInstall(context, (IProgressMonitor)sm.newChild(1));
                    } else {
                        log.debug("Run post session uninstall action from " + extensionClass.getClass());
                        result = ((PostSessionExtender)extensionClass).runPostUninstall(context, (IProgressMonitor)sm.newChild(1));
                    }
                    if (result.isOK()) continue;
                    result = this.convertErrorToWarning(result);
                    retStatus.add(result);
                    log.statusNotOK(result);
                    continue;
                }
                result = new Status(2, Agent.PI_AGENT, 0, NLS.bind((String)Messages.PostSessionExtender_class_not_instance_of, (Object[])new Object[]{element.getAttribute(PT_CLASS_ATTR), PT_POST_SESSION, PostSessionExtender.class.getName()}), null);
                retStatus.add(result);
                log.statusNotOK(result);
            }
            catch (Exception e) {
                result = new Status(2, Agent.PI_AGENT, 0, e.getLocalizedMessage(), (Throwable)e);
                retStatus.add(result);
                log.statusNotOK(result);
            }
        }
        return retStatus;
    }

    private IConfigurationElement findMatchingConfigElement(PostSessionBundle bundle, IConfigurationElement[] elements) {
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            IContributor contributor = element.getContributor();
            String bundleId = contributor.getName();
            String actionClassName = element.getAttribute(PT_CLASS_ATTR);
            if (bundle.getBundleId().equals(bundleId) && (bundle.getClassName() == null || actionClassName.endsWith(bundle.getClassName()))) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    private IStatus bundleNotFoundWarning(PostSessionBundle bundle) {
        if (bundle.getClassName() != null) {
            return new Status(2, Agent.PI_AGENT, 0, NLS.bind((String)Messages.PostSessionExtender_bundle_class_not_found, (Object)bundle.getClassName(), (Object)bundle.getBundleId()), null);
        }
        return new Status(2, Agent.PI_AGENT, 0, NLS.bind((String)Messages.PostSessionExtender_bundle_not_found, (Object)bundle.getBundleId()), null);
    }

    private IStatus convertErrorToWarning(IStatus status) {
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            return Statuses.WARNING.get(status.getCode(), MultiStatusUtil.getAnyException((IStatus)status), MultiStatusUtil.getFailureMessage((IStatus)status, (String)"\n"), new Object[0]);
        }
        return status;
    }

    private static class PostSessionBundle {
        private final String bundleId;
        private final String className;

        PostSessionBundle(String bundleId, String className) {
            if (bundleId == null) {
                throw new IllegalArgumentException("bundleId cannot be null.");
            }
            this.bundleId = bundleId;
            this.className = className;
        }

        public String getBundleId() {
            return this.bundleId;
        }

        public String getClassName() {
            return this.className;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.bundleId == null ? 0 : this.bundleId.hashCode());
            result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PostSessionBundle other = (PostSessionBundle)obj;
            if (!this.bundleId.equals(other.bundleId)) {
                return false;
            }
            return !(this.className == null ? other.className != null : !this.className.equals(other.className));
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.bundleId);
            if (this.className != null) {
                sb.append(":" + this.className);
            }
            return sb.toString();
        }
    }

    private static class PostSessionContext
    implements IPostSessionContext {
        private AgentJob[] jobs = null;
        private IProfile profile = null;

        public PostSessionContext(IProfile profile, AgentJob[] jobs) {
            this.jobs = jobs;
            this.profile = profile;
        }

        @Override
        public IAgent getAgent() {
            return Agent.getInstance();
        }

        @Override
        public IProfile getProfile() {
            return this.profile;
        }

        @Override
        public IAgentJob[] getJobs() {
            return this.jobs;
        }
    }
}

