/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.IInstallOperation;
import com.ibm.cic.agent.core.InstallTransaction;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.internal.core.InstallContextAdapter;
import com.ibm.cic.agent.internal.core.InstallOrderManager;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.Action;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IInstallationContext;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.InstallableUnitPair;
import com.ibm.cic.common.core.model.InstallationContextScope;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.UnmodifiableProperties;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class InstallContext
implements IAdaptable {
    private static final Logger log = Logger.getLogger(InstallContext.class);
    public static final String ROOT_INSTALL_CONTEXT_NAME = "root";
    private static final String CREATING_CONTENT = "creatingContent";
    private static final String CREATED_DIRECTORY = "createdDir.";
    private static final String DO_NOT_MERGE = "doNotMerge";
    private static final String P2_MANAGED_INSTALL_CONTEXT = "p2managed";
    private final String contextId;
    private String contextName;
    private String contextDescription;
    private final Set<String> adaptorTypes = new HashSet<String>(2);
    private final boolean isShareable;
    private final boolean isQualifiable;
    private final InstallationContextScope scope;
    private Profile parentProfile;
    private InstallContext parentContext;
    private final Map<String, InstallContext> subcontexts = new LinkedHashMap<String, InstallContext>(2);
    private boolean needsRestart = false;
    private final LinkedProperties properties = new LinkedProperties();
    private InstallTransaction installableUnitTransaction = null;
    private InstallTransaction adaptorTransaction = null;
    private InstallContextAdapter installContextAdapter = null;
    private final Map<String, Action> iuActionsMap = new HashMap<String, Action>();
    private final Map<String, Action> originalIuActionsMap = new HashMap<String, Action>();
    private InstallOrderManager installOrderManager = null;

    public InstallContext(InstallContext parentContext, IInstallationContext contextData) {
        this(parentContext, contextData.getIdentity().getId(), contextData.getName(), InstallContext.getDescription(contextData), contextData.isShareable(), contextData.isQualifiable(), contextData.getScope());
        this.addAdaptorTypes(contextData.getAdaptorTypes());
        this.installContextAdapter = new InstallContextAdapter(this, contextData);
        this.installContextAdapter.initialize(this);
    }

    public InstallContext(Object parent, String id, String name, String description) {
        this(parent, id, name, description, true, false, InstallationContextScope.NONE_SCOPE);
    }

    public InstallContext(Object parent, String id, String name, String description, boolean isShareable, boolean isQualifiable, InstallationContextScope scope) {
        this.contextId = id;
        this.contextName = name;
        this.contextDescription = description;
        this.isShareable = isShareable;
        this.isQualifiable = isQualifiable;
        this.scope = scope;
        if (parent instanceof Profile) {
            this.parentProfile = (Profile)parent;
            this.parentContext = null;
        } else {
            this.parentContext = (InstallContext)parent;
            this.parentProfile = this.parentContext.parentProfile;
            this.parentContext.addSubcontext(this);
            this.setLocalProperty(CREATING_CONTENT, "");
        }
    }

    public String getId() {
        return this.contextId;
    }

    public String getFullId() {
        if (this.isRootContext()) {
            return "<root>";
        }
        if (this.parentContext.isRootContext()) {
            return this.getId();
        }
        return String.valueOf(this.parentContext.getFullId()) + '/' + this.getId();
    }

    public String getName() {
        return this.contextName;
    }

    public void setName(String name) {
        this.contextName = name;
    }

    public String getDescription() {
        return this.contextDescription;
    }

    public void setDescription(String description) {
        this.contextDescription = description;
    }

    public String[] getAdaptorTypes() {
        return this.adaptorTypes.toArray(new String[this.adaptorTypes.size()]);
    }

    public boolean allowsAdaptorType(String adaptorType) {
        return adaptorType != null && this.adaptorTypes.contains(adaptorType);
    }

    public void addAdaptorType(String adaptor) {
        if (adaptor != null && !"".equals(adaptor)) {
            this.adaptorTypes.add(adaptor);
        }
    }

    public void addAdaptorTypes(String ... adaptors) {
        String[] stringArray = adaptors;
        int n = adaptors.length;
        int n2 = 0;
        while (n2 < n) {
            String adaptor = stringArray[n2];
            this.addAdaptorType(adaptor);
            ++n2;
        }
    }

    public File getAdapterStorage(String adapterId) {
        File profileAdapterStorage = this.parentProfile.getAdapterStorage(adapterId);
        if (this.parentContext == null) {
            return profileAdapterStorage;
        }
        String contextPath = this.getProfileRelativePath(File.separatorChar);
        return new File(profileAdapterStorage, contextPath);
    }

    private String getProfileRelativePath(char separator) {
        InstallContext eic;
        ArrayList<InstallContext> list = new ArrayList<InstallContext>();
        InstallContext ic = this;
        while ((eic = ic.parentContext) != null) {
            list.add(ic);
            ic = eic;
        }
        StringBuilder sb = new StringBuilder();
        int i = list.size() - 1;
        while (i >= 0) {
            InstallContext ic2 = (InstallContext)list.get(i);
            if (sb.length() != 0) {
                sb.append(separator);
            }
            sb.append(ic2.getId());
            --i;
        }
        return sb.toString();
    }

    public String getUniqueId() {
        String profileId = this.parentProfile.getProfileId();
        if (this.parentContext == null) {
            return profileId;
        }
        String contextPath = this.getProfileRelativePath(' ');
        return String.valueOf(profileId) + ' ' + contextPath;
    }

    public boolean isShareable() {
        return this.isShareable;
    }

    public boolean isQualifiable() {
        return this.isQualifiable;
    }

    public InstallationContextScope getScope() {
        return this.scope;
    }

    void setCreatingContent(IContent creatingContent) {
        this.setLocalProperty(CREATING_CONTENT, creatingContent.getIdentity());
    }

    IStatus allowsContent(IOffering content) {
        if (content != null && !this.isShareable) {
            String creatingContent = this.getLocalProperty(CREATING_CONTENT);
            if (creatingContent != null) {
                IIdentity id = content.getIdentity();
                if (creatingContent.equals(id.getId())) {
                    return Status.OK_STATUS;
                }
                return Statuses.ERROR.get(Messages.InstallContext_Nonmatching_Content_In_Nonshareable_Context, new Object[]{content.getIdentity(), this});
            }
            log.warning(Messages.InstallContext_Unspecified_Nonshareable_Context_Creator, new Object[]{this.contextId});
            return Status.OK_STATUS;
        }
        return Status.OK_STATUS;
    }

    public boolean doNotMerge() {
        return Boolean.valueOf(this.getProperty(DO_NOT_MERGE));
    }

    public String getProperty(String key) {
        String value = this.properties.getProperty(key);
        if (value == null) {
            if (this.parentContext != null) {
                value = this.parentContext.getProperty(key);
            } else if (this.parentProfile != null) {
                value = key.equals("installLocation") ? this.parentProfile.getInstallLocation() : (key.equals("cacheLocation") ? this.parentProfile.getCacheLocation() : this.parentProfile.getData(key));
            }
        }
        return value;
    }

    public String getLocation(String key) {
        String value = this.getProperty(key);
        if (value != null && !new File(value).isAbsolute()) {
            value = key.equals("installLocation") ? this.getInstallLocation() : new File(this.getInstallLocation(), value).getAbsolutePath();
        }
        return value;
    }

    public String getInstallLocation() {
        File contextInstallLocation = new File(this.getProperty("installLocation"));
        if (contextInstallLocation.isAbsolute()) {
            return contextInstallLocation.getAbsolutePath();
        }
        if (contextInstallLocation.getPath().equals(".")) {
            return new File(this.parentContext.getInstallLocation()).getAbsolutePath();
        }
        return new File(this.parentContext.getInstallLocation(), contextInstallLocation.getPath()).getAbsolutePath();
    }

    public String getLocalProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String setLocalProperty(String key, Object value) {
        String oldValue = this.getLocalProperty(key);
        this.properties.setProperty(key, String.valueOf(value));
        return oldValue;
    }

    public boolean createdDirectory(File directory) {
        return Boolean.valueOf(this.getLocalProperty(CREATED_DIRECTORY + directory.getAbsolutePath()));
    }

    public void setCreatedDirectory(File directory) {
        if (!this.createdDirectory(directory)) {
            this.setLocalProperty(CREATED_DIRECTORY + directory.getAbsolutePath(), true);
        }
    }

    public LinkedProperties getLocalProperties() {
        return new UnmodifiableProperties(this.properties);
    }

    boolean is32bit() {
        return this.parentProfile == null || this.parentProfile.is32bit();
    }

    boolean is64bit() {
        return this.parentProfile != null && this.parentProfile.is64bit();
    }

    public Profile getEnclosingProfile() {
        assert (this.parentProfile != null);
        return this.parentProfile;
    }

    void setEnclosingProfile(Profile newParentProfile) {
        assert (newParentProfile != null);
        if (this.parentProfile != newParentProfile) {
            if (this.parentContext == null && this.parentProfile != null && this.parentProfile.getRootContext() == this) {
                this.parentProfile.setRootContext(null);
            }
            this.parentProfile = newParentProfile;
            for (InstallContext child : this.subcontexts.values()) {
                child.setEnclosingProfile(newParentProfile);
            }
        }
    }

    boolean needsRestart(boolean recursive) {
        if (this.needsRestart) {
            return true;
        }
        if (recursive) {
            for (InstallContext child : this.subcontexts.values()) {
                if (!child.needsRestart(recursive)) continue;
                return true;
            }
        }
        return false;
    }

    public void setNeedsRestart(boolean restart) {
        this.needsRestart = restart;
    }

    public InstallContext getParentContext() {
        return this.parentContext;
    }

    public boolean isRootContext() {
        return this.parentContext == null;
    }

    private void addSubcontext(InstallContext subcontext) {
        this.subcontexts.put(subcontext.getId(), subcontext);
    }

    public InstallContext[] getSubcontexts() {
        return this.subcontexts.values().toArray(new InstallContext[this.subcontexts.size()]);
    }

    public InstallContext getSubcontext(String id) {
        return this.subcontexts.get(id);
    }

    List<InstallContext> getAllSubcontexts(List<InstallContext> allSubcontexts) {
        for (InstallContext subcontext : this.subcontexts.values()) {
            allSubcontexts.add(subcontext);
            subcontext.getAllSubcontexts(allSubcontexts);
        }
        return allSubcontexts;
    }

    void delete() {
        for (InstallContext child : this.subcontexts.values()) {
            child.delete();
        }
        this.subcontexts.clear();
        if (this.parentContext == null) {
            if (this.parentProfile != null && this.parentProfile.getRootContext() == this) {
                this.parentProfile.setRootContext(null);
            }
        } else {
            this.parentContext.subcontexts.remove(this.getId());
            this.parentContext = null;
        }
        this.parentProfile = null;
    }

    void findInstallContexts(String id, Set<InstallContext> contexts) {
        if (this.getId().equals(id)) {
            contexts.add(this);
        }
        for (InstallContext child : this.subcontexts.values()) {
            child.findInstallContexts(id, contexts);
        }
    }

    IStatus findMatchingContexts(IInstallationContext contextData, Set<InstallContext> contexts) {
        this.findInstallContexts(contextData.getIdentity().getId(), contexts);
        return Status.OK_STATUS;
    }

    public String toString() {
        return "InstallContext " + this.contextId;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    private static String getDescription(IInstallationContext data) {
        return data.getInformation() != null ? data.getInformation().getDescription() : "";
    }

    public InstallRegistry.ContextInstallRegistry getInstallRegistry() {
        InstallRegistry.ContextInstallRegistry parentRegistry = this.parentContext != null ? this.parentContext.getInstallRegistry() : this.parentProfile.getInstallRegistry();
        return parentRegistry.getContextInstallRegistry(this.getId());
    }

    public Collection<IInstallableUnit> getInstalledIUs() {
        return this.getInstallRegistry().getInstalledIUs();
    }

    void setInstallableUnitTransaction(InstallTransaction installableUnitTransaction) {
        this.installableUnitTransaction = installableUnitTransaction;
    }

    public IStatus performOperationReturnStatus(IInstallOperation operation, IProgressMonitor monitor) {
        IStatus status = this.installableUnitTransaction != null ? this.installableUnitTransaction.performOperation(operation, monitor) : operation.perform(InstallTransaction.NULL, monitor);
        return status;
    }

    public void performOperation(IInstallOperation operation, IProgressMonitor monitor) throws CoreException {
        IStatus status = this.performOperationReturnStatus(operation, monitor);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    public boolean isInstallableUnitTransactionUndoable() {
        return this.installableUnitTransaction != null && this.installableUnitTransaction.isUndoable();
    }

    public boolean isInstallableUnitTransactionUndoing() {
        return this.installableUnitTransaction != null && this.installableUnitTransaction.isUndoing();
    }

    public void setNeedArtifacts(boolean needArtifacts) {
        if (this.installableUnitTransaction != null) {
            this.installableUnitTransaction.setNeedArtifacts(needArtifacts);
        }
    }

    void setAdaptorTransaction(InstallTransaction adaptorTransaction) {
        this.adaptorTransaction = adaptorTransaction;
    }

    public boolean isAdaptorTransactionUndoable() {
        return this.adaptorTransaction != null && this.adaptorTransaction.isUndoable();
    }

    public boolean isAdaptorTransactionUndoing() {
        return this.adaptorTransaction != null && this.adaptorTransaction.isUndoing();
    }

    public void installIUs() {
        if (this.installContextAdapter != null) {
            this.installContextAdapter.installAllUnits();
        }
    }

    public boolean isP2Managed() {
        String value = this.getLocalProperty(P2_MANAGED_INSTALL_CONTEXT);
        return Boolean.valueOf(value);
    }

    public void setIsP2Managed(boolean isP2Managed) {
        this.setLocalProperty(P2_MANAGED_INSTALL_CONTEXT, isP2Managed);
    }

    public void setIUAction(InstallableUnitPair pair, Action action) {
        String qualifiedIuId = pair.getQualifiedId().getId();
        Action preValue = this.iuActionsMap.put(qualifiedIuId, action);
        if (action == Action.REINSTALL) {
            assert (preValue == Action.NONE || preValue == Action.INSTALL || preValue == Action.UNINSTALL);
            this.originalIuActionsMap.put(qualifiedIuId, preValue);
        } else assert (preValue == null);
    }

    public Action getIUAction(IInstallableUnit iu) {
        Action action = this.getIUAction(iu.getQualifiedId().getId());
        assert (action != null);
        return action;
    }

    private Action getIUAction(String qualifiedIuId) {
        return this.getIUAction(qualifiedIuId, this);
    }

    Action getIUAction(String qualifiedIuId, InstallContext referencingInstallContext) {
        return InstallContext.getIUAction(this.iuActionsMap, qualifiedIuId, referencingInstallContext);
    }

    public Action getOriginalIUAction(IInstallableUnit iu) {
        String qualifiedIuId = iu.getQualifiedId().getId();
        return InstallContext.getIUAction(this.originalIuActionsMap, qualifiedIuId, this);
    }

    private static Action getIUAction(Map<String, Action> map, String qualifiedIuId, InstallContext referencingInstallContext) {
        assert (referencingInstallContext != null);
        Action action = map.get(qualifiedIuId);
        if (action != null && referencingInstallContext.isInstallableUnitTransactionUndoing()) {
            action = action.getUndoAction();
        }
        return action;
    }

    public void clearIUActions() {
        this.iuActionsMap.clear();
        this.originalIuActionsMap.clear();
        this.installOrderManager = null;
    }

    public void setInstallOrderManager(InstallOrderManager installOrderManager) {
        this.installOrderManager = installOrderManager;
    }

    boolean isDependsOnOrSame(IInstallableUnit unit, String qualifiedIuId, InstallContext installContext) {
        return this.installOrderManager.isDependsOnOrSame(unit, this, qualifiedIuId, installContext);
    }
}

