/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.CacheManager;
import com.ibm.cic.agent.core.IAgentObserverRegistrar;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.downloads.DownloadInProgressManager;
import java.util.EventListener;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;

public interface IAgentEventManager
extends IAgentObserverRegistrar {
    public void fireBeforeInstallSession(AgentJob[] var1);

    public void fireBeforeInstallOfferingOrFix(AgentJob var1);

    public void fireAfterInstallOfferingOrFix(AgentJob var1, IStatus var2);

    public void fireAfterInstallSession(AgentJob[] var1, IStatus var2);

    public void fireBeforeUninstallSession(AgentJob[] var1);

    public void fireBeforeUninstallOfferingOrFix(AgentJob var1);

    public void fireAfterUninstallOfferingOrFix(AgentJob var1, IStatus var2);

    public void fireAfterUninstallSession(AgentJob[] var1, IStatus var2);

    public void fireBeginFetch(Object var1, IOfferingOrFix var2, CicMultiStatus var3);

    public void fireFetchCompleted(Object var1, IOfferingOrFix var2, CicMultiStatus var3, CacheManager.ArtifactsToDownload var4);

    public static final class AgentFetchCompletePhaseEvent
    extends AgentPhaseEvent {
        private long downloadedArtifactsSize;
        private long artifactsSize;
        private List partiallyDownloadedArtifactsInfo = new LinkedList();

        public AgentFetchCompletePhaseEvent(Object source, IOfferingOrFix offeringOrFix, IStatus status, CacheManager.ArtifactsToDownload downloaded) {
            super(source, offeringOrFix, "Download artifacts", status);
            this.downloadedArtifactsSize = downloaded.getDownloadedArtifactsSize();
            this.artifactsSize = downloaded.getAssignedArtifactsSize();
            List<DownloadInProgressManager.IDownloadInProgress> partialDownloads = downloaded.getPartialDownloads();
            for (DownloadInProgressManager.IDownloadInProgress dip : partialDownloads) {
                Object artifact = CacheManager.ArtifactsToDownload.getPartialArtifact(dip);
                this.partiallyDownloadedArtifactsInfo.add(new PartiallyDownloadedArtifactInfo(String.valueOf(artifact), CacheManager.ArtifactsToDownload.getPartialDownloadSize(dip)));
            }
        }

        public long getDownloadedArtifactsSize() {
            return this.downloadedArtifactsSize;
        }

        public void setDownloadedArtifactsSize(long downloadedArtifactsSize) {
            this.downloadedArtifactsSize = downloadedArtifactsSize;
        }

        public long getArtifactsSize() {
            return this.artifactsSize;
        }

        public void setArtifactsSize(long artifactsSize) {
            this.artifactsSize = artifactsSize;
        }

        public List getPartiallyDownloadedArtifactsInfo() {
            return this.partiallyDownloadedArtifactsInfo;
        }

        public void setPartiallyDownloadedArtifactsInfo(List partiallyDownloadedArtifactsInfo) {
            this.partiallyDownloadedArtifactsInfo = partiallyDownloadedArtifactsInfo;
        }

        public static final class PartiallyDownloadedArtifactInfo {
            private String name;
            private long size;

            public PartiallyDownloadedArtifactInfo(String name, long size) {
                this.name = name;
                this.size = size;
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public long getSize() {
                return this.size;
            }

            public void setSize(long size) {
                this.size = size;
            }
        }
    }

    public static final class AgentJobEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;
        private transient IStatus status;

        public AgentJobEvent(AgentJob job) {
            this(job, null);
        }

        public AgentJobEvent(AgentJob job, IStatus status) {
            super(job);
            this.status = status;
        }

        public AgentJob getAgentJob() {
            return (AgentJob)this.getSource();
        }

        public IStatus getStatus() {
            return this.status;
        }
    }

    public static interface AgentJobListener
    extends EventListener {
        public IStatus beforeInstallOfferingOrFix(AgentJobEvent var1);

        public void afterInstallOfferingOrFix(AgentJobEvent var1);

        public IStatus beforeUninstallOfferingOrFix(AgentJobEvent var1);

        public void afterUninstallOfferingOrFix(AgentJobEvent var1);
    }

    public static class AgentPhaseEvent
    extends EventObject {
        public static final String PHASE_FETCH_NAME = "Download artifacts";
        private final String phaseName;
        private final IStatus status;
        private final IOfferingOrFix offeringOrFix;

        public AgentPhaseEvent(Object source, IOfferingOrFix offeringOrFix, String phaseName, IStatus status) {
            super(source);
            this.phaseName = phaseName;
            this.status = status;
            this.offeringOrFix = offeringOrFix;
        }

        public String getPhaseName() {
            return this.phaseName;
        }

        public IStatus getStatus() {
            return this.status;
        }

        public IOfferingOrFix getOfferingOrFix() {
            return this.offeringOrFix;
        }
    }

    public static final class AgentSessionEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;
        private transient IStatus status;

        public AgentSessionEvent(AgentJob[] jobs) {
            this(jobs, null);
        }

        public AgentSessionEvent(AgentJob[] jobs, IStatus status) {
            super(jobs);
            this.status = status;
        }

        public AgentJob[] getAgentJobs() {
            return (AgentJob[])this.getSource();
        }

        public IStatus getStatus() {
            return this.status;
        }
    }

    public static interface AgentSessionListener
    extends EventListener {
        public IStatus beforeInstallSession(AgentSessionEvent var1);

        public void afterInstallSession(AgentSessionEvent var1);

        public IStatus beforeUninstallSession(AgentSessionEvent var1);

        public void afterUninstallSession(AgentSessionEvent var1);
    }

    public static interface BeginFetchListener
    extends EventListener {
        public void beginFetch(AgentPhaseEvent var1);
    }

    public static interface FetchCompletedListener
    extends EventListener {
        public void fetchCompleted(AgentFetchCompletePhaseEvent var1);
    }
}

