/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.AbstractVariableSubstitution;
import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.SubstitutionOperation;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.PlatformUtils;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class CacheLocationManager {
    public static final String COMMON_CACHE_LOCATION = "com.ibm.cic.common.core.preferences.eclipseCache";
    private String portableCacheLocation = "";
    private static CacheLocationManager m_instance;
    private boolean m_settingCacheLocationByPreference = false;

    public static CacheLocationManager getInstance() {
        if (m_instance == null) {
            m_instance = new CacheLocationManager();
        }
        return m_instance;
    }

    public void setCacheLocation(String a_cacheLocation) {
        if (!(Agent.getInstance().isCleanMode() || Agent.getInstance().isTemporaryMode() || this.isCacheLocationChangeable())) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.Agent_Cache_Location_Not_Changeable, (Object)this.getCacheLocation(), (Object)a_cacheLocation));
        }
        if (CicCommonSettings.isPortable()) {
            this.portableCacheLocation = a_cacheLocation;
        } else if (this.isCacheLocationChangeable()) {
            InstallRegistry.getInstance().setCacheLocation(a_cacheLocation);
        }
    }

    public String getCacheLocation() {
        if (CicCommonSettings.isPortable()) {
            return this.portableCacheLocation;
        }
        String return_value = InstallRegistry.getInstance().getCacheLocation();
        if (return_value == null) {
            return_value = "";
        }
        return return_value;
    }

    public boolean isSettingCacheLocationByPreference() {
        return this.m_settingCacheLocationByPreference;
    }

    public void setSettingCacheLocationByPreference(boolean a_settingCacheLocationByPreference) {
        this.m_settingCacheLocationByPreference = a_settingCacheLocationByPreference;
    }

    public boolean isCacheLocationChangeable() {
        InstallRegistry ir = InstallRegistry.getInstance();
        for (InstallRegistry.ProfileInstallRegistry registry : ir.getProfileInstallRegistries()) {
            if (registry.isEmpty() || registry.isAgentProfile() || registry.isLicenseProfile() || registry.isPortableProfile() || CicCommonSettings.isPortable()) continue;
            return false;
        }
        return true;
    }

    public String calculateDefaultCacheLocation(List jobs) throws AbstractVariableSubstitution.VariableSubstitutionException {
        String return_value = null;
        int smallestAllowedCacheLocationLen = 100000;
        for (AgentJob job : jobs) {
            int maxAllowed;
            IOffering offering = job.getOffering();
            if (offering != null && !Agent.isExtensionOffering((IOfferingOrFix)offering) && smallestAllowedCacheLocationLen > (maxAllowed = PlatformUtils.getMaxCacheLocationLengthForOffering((IOffering)offering))) {
                smallestAllowedCacheLocationLen = maxAllowed;
                return_value = PlatformUtils.getDefaultSharedLocation((IOffering)offering);
            }
            if (return_value == null) continue;
            boolean for64bit = BitModeUtils.jobsSupport64bits(jobs) && !BitModeUtils.jobsDefaultProfileIs32bit(jobs);
            SubstitutionOperation sub = new SubstitutionOperation(job.getProfile().getRootContext(), for64bit);
            return_value = sub.performVariableSubstitutions(return_value, AbstractVariableSubstitution.AllowAbsolutePath.TRUE);
        }
        return return_value;
    }

    public String getEclipseCacheLocation(List jobs) throws AbstractVariableSubstitution.VariableSubstitutionException {
        String eclipseCacheLocation = null;
        if (this.isCacheLocationChangeable()) {
            eclipseCacheLocation = this.isSettingCacheLocationByPreference() ? this.getCacheLocation() : this.calculateDefaultCacheLocation(jobs);
        }
        if (eclipseCacheLocation == null) {
            eclipseCacheLocation = this.getCacheLocation();
        }
        return eclipseCacheLocation;
    }
}

