/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import org.osgi.framework.Version;

public class AgentSettings {
    private static final String IM_DEFAULT_VERSION = "1.8.3";
    public static final String IM_PROPERTY_VERSION = "im.version";
    private static final String IM_DEFAULT_INTERNAL_VERSION = "1.8.3000";
    public static final String IM_PROPERTY_INTERNAL_VERSION = "im.internal.version";

    public static Version getRunningAgentVersion() {
        return Versions.IM_VERSION.getVersion();
    }

    public static String getRunningAgentVersionStr() {
        return Versions.IM_VERSION.getVersion().toString();
    }

    public static Version getRunningAgentInternalVersion() {
        return Versions.IM_INTERNAL_VERSION.getVersion();
    }

    public static String getRunningAgentInternalVersionStr() {
        return Versions.IM_INTERNAL_VERSION.getVersion().toString();
    }

    public static void reset() {
        Versions.reset();
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            try {
                System.out.println(Versions.valueOf(args[0]).getVersion());
                return;
            }
            catch (Exception exception) {}
        }
        System.out.println("ERROR_Invalid_AgentProperties_Argument");
    }

    public static enum Versions {
        IM_VERSION{

            @Override
            protected void setVersion() {
                try {
                    String v = System.getProperty("im.installer.version");
                    if (v != null) {
                        this.m_version = new Version(v);
                        return;
                    }
                }
                catch (Throwable throwable) {}
                this.m_version = new Version(System.getProperty(AgentSettings.IM_PROPERTY_VERSION, AgentSettings.IM_DEFAULT_VERSION));
            }
        }
        ,
        IM_INTERNAL_VERSION{

            @Override
            protected void setVersion() {
                try {
                    String v = System.getProperty("im.installer.internal.version");
                    if (v != null) {
                        this.m_version = new Version(v);
                        return;
                    }
                }
                catch (Throwable throwable) {}
                this.m_version = new Version(System.getProperty(AgentSettings.IM_PROPERTY_INTERNAL_VERSION, AgentSettings.IM_DEFAULT_INTERNAL_VERSION));
            }
        };

        protected Version m_version;

        private Versions() {
            this.setVersion();
        }

        protected abstract void setVersion();

        static void reset() {
            Versions[] versionsArray = Versions.values();
            int n = versionsArray.length;
            int n2 = 0;
            while (n2 < n) {
                Versions v = versionsArray[n2];
                v.setVersion();
                ++n2;
            }
        }

        public Version getVersion() {
            return this.m_version;
        }
    }
}

