/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.AgentActivator;
import com.ibm.cic.agent.core.VariableSubstitution;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.repository.IInstallKitContext;
import com.ibm.cic.common.core.repository.RepositoryContext;
import com.ibm.cic.common.core.utils.AbstractPlatformPolicyFactory;
import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.logging.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class AgentRegistry {
    protected static final String REQUIRED_INSTALL_LOCATION_NAME = "eclipse";
    private File installedAgentLocation = null;
    private Version installedAgentVersion = Version.emptyVersion;
    private Version installedAgentInternalVersion = Version.emptyVersion;
    private File installedAgentAppDataLocation = null;
    private boolean is64bit = false;
    private String registryLocation = null;
    private File registryFile = null;
    private PPAgentRegistry ppReg = new PPAgentRegistry();
    private static AgentRegistry instance = null;
    private static final Logger log = Logger.getLogger(AgentRegistry.class, (Plugin)AgentActivator.getDefault());

    private AgentRegistry() {
        String agentRegistryLocation = System.getProperty("AGENT_REGISTRY_LOCATION");
        if (agentRegistryLocation != null) {
            this.ppReg.getPolicy().getInstalledAgentValues(agentRegistryLocation);
        } else {
            this.ppReg.getPolicy().getInstalledAgentValues();
        }
        IInstallKitContext installKitContext = (IInstallKitContext)RepositoryContext.getInstance().findContext("InstallKit");
        installKitContext.setInstalledAgentVersions(new IInstallKitContext.IProvideAgentVersions(){

            public Version getDisplayVersion() {
                return AgentRegistry.this.getInstalledAgentVersion();
            }

            public Version getInternalVersion() {
                return AgentRegistry.this.getInstalledAgentInternalVersion();
            }
        });
    }

    public static AgentRegistry getInstance() {
        if (instance == null) {
            instance = new AgentRegistry();
        }
        return instance;
    }

    @Deprecated
    public static void refresh() {
        instance = null;
    }

    public void reset() {
        this.installedAgentLocation = null;
        this.installedAgentVersion = Version.emptyVersion;
        this.installedAgentInternalVersion = Version.emptyVersion;
        this.installedAgentAppDataLocation = null;
    }

    public File getInstalledAgentLocation() {
        return this.installedAgentLocation;
    }

    public Version getInstalledAgentVersion() {
        return this.installedAgentVersion;
    }

    public Version getInstalledAgentInternalVersion() {
        return this.installedAgentInternalVersion;
    }

    public boolean isInstalledAgent64Bit() {
        return this.is64bit;
    }

    public File getInstalledAgentAppDataLocation() {
        return this.installedAgentAppDataLocation;
    }

    public String getRegistryLocation() {
        return this.registryLocation;
    }

    public File getRegistryFile() {
        return this.registryFile;
    }

    public static Version getVersion(String value) {
        if (value == null) {
            return Version.emptyVersion;
        }
        return new Version(value);
    }

    public boolean runningInstanceOfIMMatches() {
        boolean return_value = this.isRunningInWorkspace();
        if (!return_value) {
            Location installLocation = Platform.getInstallLocation();
            if (installLocation != null) {
                File cuLocation = new File(installLocation.getURL().getFile());
                if (CmdLine.CL.isServerMode()) {
                    cuLocation = cuLocation.getParentFile();
                }
                if (!(return_value = cuLocation.equals(this.getInstalledAgentLocation()))) {
                    log.debug(Messages.CommonSettings_Error_OnlyInstallingNonAdminCanRunIM);
                } else {
                    log.debug("Registry informaion is matching the running process");
                }
            } else {
                return_value = true;
            }
        } else {
            log.debug("IM is running in eclipse workspace");
        }
        return return_value;
    }

    private boolean isRunningInWorkspace() {
        File adapterLocation = new File(PlatformUtils.getInstallLocation((Bundle)AgentActivator.getDefault().getBundle()));
        boolean return_value = adapterLocation.isDirectory();
        return return_value;
    }

    public class PPAgentRegistry
    extends AbstractPlatformPolicyFactory {
        protected Object createLinuxPolicy() {
            return new PPAgentRegistryLinux();
        }

        protected Object createWindowsPolicy() {
            return new PPAgentRegistryWindows();
        }

        PPAgentRegistryCommon getPolicy() {
            return (PPAgentRegistryCommon)this.getPlatformPolicy();
        }

        abstract class PPAgentRegistryCommon {
            protected static final String LOCATION = "location";
            protected static final String INTERNAL_VERSION = "internalVersion";
            protected static final String IS64BIT = "is64bit";
            protected static final String VERSION = "version";
            protected static final String APP_DATA_LOCATION = "appDataLocation";
            private static final String CONFIGURATION = "configuration";
            private static final String CONFIG_INI = "config.ini";
            private static final String REGISTRY_FILE_VERSION = "registryVersion";

            PPAgentRegistryCommon() {
            }

            protected File getLocation(String value) {
                if (value == null) {
                    return null;
                }
                File loc = new File(value, AgentRegistry.REQUIRED_INSTALL_LOCATION_NAME);
                File configLoc = new File(loc, CONFIGURATION);
                if (!configLoc.isDirectory()) {
                    return null;
                }
                return loc;
            }

            protected File getAppDataLocation(String value) {
                if (value != null) {
                    return new File(value);
                }
                File loc = AgentRegistry.this.getInstalledAgentLocation();
                if (loc == null) {
                    return null;
                }
                File configLoc = new File(loc, CONFIGURATION);
                File configIniLoc = new File(configLoc, CONFIG_INI);
                try {
                    Properties props = FileUtil.readProperties((File)configIniLoc);
                    value = props.getProperty("cic.appDataLocation");
                    return new File(value);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    return null;
                }
            }

            void getInstalledAgentValues(String fileLocation) {
                AgentRegistry.this.registryLocation = fileLocation;
                AgentRegistry.this.registryFile = new File(fileLocation);
                if (!AgentRegistry.this.registryFile.isFile()) {
                    return;
                }
                Properties props = this.readProperties();
                if (props == null) {
                    return;
                }
                File loc = this.getLocation(props.getProperty(LOCATION));
                if (loc != null) {
                    AgentRegistry.this.installedAgentLocation = loc;
                    AgentRegistry.this.installedAgentVersion = AgentRegistry.getVersion(props.getProperty(VERSION));
                    AgentRegistry.this.installedAgentInternalVersion = AgentRegistry.getVersion(props.getProperty(INTERNAL_VERSION));
                    AgentRegistry.this.installedAgentAppDataLocation = this.getAppDataLocation(props.getProperty(APP_DATA_LOCATION));
                    AgentRegistry.this.is64bit = Boolean.parseBoolean(props.getProperty(IS64BIT));
                }
            }

            private Properties readProperties() {
                Properties props;
                try {
                    props = FileUtil.readProperties((File)AgentRegistry.this.registryFile);
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                    return null;
                }
                String ver = props.getProperty(REGISTRY_FILE_VERSION);
                if (ver != null) {
                    return props;
                }
                props.clear();
                BufferedReader bufReader = null;
                try {
                    try {
                        String line;
                        bufReader = new BufferedReader(Encodings.DEFAULT.reader(AgentRegistry.this.registryFile));
                        while ((line = bufReader.readLine()) != null) {
                            int i = line.indexOf(61);
                            if (i < 0) continue;
                            props.setProperty(line.substring(0, i), line.substring(i + 1));
                        }
                    }
                    catch (IOException e) {
                        log.error((Throwable)e);
                        FileUtil.close(bufReader);
                        return null;
                    }
                }
                catch (Throwable throwable) {
                    FileUtil.close(bufReader);
                    throw throwable;
                }
                FileUtil.close((Reader)bufReader);
                return props;
            }

            abstract void getInstalledAgentValues();
        }

        class PPAgentRegistryLinux
        extends PPAgentRegistryCommon {
            private final String relativeFileLocation = "/etc/.ibm/registry/InstallationManager" + CicCommonSettings.getBetaProperty() + ".dat";
            private final String os400AdminRelativeFileLocation = "/QIBM/InstallationManager/.ibm/registry/InstallationManager" + CicCommonSettings.getBetaProperty() + ".dat";
            private final String fileLocation = CicCommonSettings.isOS400() ? (CicCommonSettings.getAccessRightsMode().isAdminMode() ? this.os400AdminRelativeFileLocation : new CicFileLocation(System.getProperty("user.home")).append(this.relativeFileLocation).toString()) : (CicCommonSettings.getAccessRightsMode().isAdminMode() ? this.relativeFileLocation : (CicCommonSettings.getAccessRightsMode().isGroupMode() ? String.valueOf(CicCommonSettings.getApplicationDataLocation()) + this.relativeFileLocation : new CicFileLocation(System.getProperty("user.home")).append(this.relativeFileLocation).toString()));

            PPAgentRegistryLinux() {
            }

            @Override
            void getInstalledAgentValues() {
                this.getInstalledAgentValues(this.fileLocation);
            }
        }

        class PPAgentRegistryWindows
        extends PPAgentRegistryCommon {
            private final String betaProperty = CicCommonSettings.isBeta() ? " " + CicCommonSettings.getBetaProperty() : "";
            private final String registryBase = CicCommonSettings.getAccessRightsMode().isAdminMode() ? "HKLM\\SOFTWARE\\IBM\\Installation Manager" + this.betaProperty : "HKCU\\SOFTWARE\\IBM\\Installation Manager" + this.betaProperty;

            PPAgentRegistryWindows() {
            }

            private String getWin32InstalledAgentValue(String name) {
                String value;
                block3: {
                    try {
                        value = VariableSubstitution.getInstance().performVariableSubstitutions("${registry:" + this.registryBase + '\\' + name + '}', false);
                        if (value != null && value.charAt(0) != '$') break block3;
                        return null;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                return value;
            }

            @Override
            void getInstalledAgentValues() {
                AgentRegistry.this.registryLocation = this.registryBase;
                AgentRegistry.this.registryFile = null;
                File loc = this.getLocation(this.getWin32InstalledAgentValue("location"));
                if (loc != null) {
                    AgentRegistry.this.installedAgentLocation = loc;
                    AgentRegistry.this.installedAgentVersion = AgentRegistry.getVersion(this.getWin32InstalledAgentValue("version"));
                    AgentRegistry.this.installedAgentInternalVersion = AgentRegistry.getVersion(this.getWin32InstalledAgentValue("internalVersion"));
                    AgentRegistry.this.installedAgentAppDataLocation = this.getAppDataLocation(this.getWin32InstalledAgentValue("appDataLocation"));
                    AgentRegistry.this.is64bit = Boolean.parseBoolean(this.getWin32InstalledAgentValue("is64bit"));
                }
            }
        }
    }
}

