/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.CacheManager;
import com.ibm.cic.agent.core.IAgentEventManager;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;

public class AgentEventManager
implements IAgentEventManager {
    private static final Logger logger = Logger.getLogger(AgentEventManager.class);
    protected ListenerList installSessionListeners = new ListenerList();
    protected ListenerList installOfferingOrFixListeners = new ListenerList();
    protected ListenerList uninstallSessionListeners = new ListenerList();
    protected ListenerList uninstallOfferingOrFixListeners = new ListenerList();
    protected ListenerList beginFetchListeners = new ListenerList();
    protected ListenerList fetchCompleteListeners = new ListenerList();

    @Override
    public void addInstallSessionListener(IAgentEventManager.AgentSessionListener listener) {
        if (listener != null) {
            this.installSessionListeners.add((Object)listener);
        }
    }

    @Override
    public void removeInstallSessionListener(IAgentEventManager.AgentSessionListener listener) {
        if (listener != null) {
            this.installSessionListeners.remove((Object)listener);
        }
    }

    @Override
    public void addInstallOfferingOrFixListener(IAgentEventManager.AgentJobListener listener) {
        if (listener != null) {
            this.installOfferingOrFixListeners.add((Object)listener);
        }
    }

    @Override
    public void removeInstallOfferingOrFixListener(IAgentEventManager.AgentJobListener listener) {
        if (listener != null) {
            this.installOfferingOrFixListeners.remove((Object)listener);
        }
    }

    @Override
    public void fireBeforeInstallSession(AgentJob[] job) {
        IAgentEventManager.AgentSessionEvent ev = new IAgentEventManager.AgentSessionEvent(job);
        this.fireBeforeInstallSession(ev);
    }

    protected void fireBeforeInstallSession(IAgentEventManager.AgentSessionEvent ev) {
        Object[] listeners;
        Object[] objectArray = listeners = this.installSessionListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener2 = objectArray[n2];
            IAgentEventManager.AgentSessionListener listener = (IAgentEventManager.AgentSessionListener)listener2;
            try {
                listener.beforeInstallSession(ev);
            }
            catch (RuntimeException ex) {
                logger.error("Error in beforeInstallSession callback of install session listener: " + listener.getClass().getName());
                logger.error((Throwable)ex);
            }
            ++n2;
        }
    }

    @Override
    public void fireBeforeInstallOfferingOrFix(AgentJob job) {
        IAgentEventManager.AgentJobEvent ev = new IAgentEventManager.AgentJobEvent(job);
        this.fireBeforeInstallOfferingOrFix(ev);
    }

    protected void fireBeforeInstallOfferingOrFix(IAgentEventManager.AgentJobEvent ev) {
        Object[] listeners;
        Object[] objectArray = listeners = this.installOfferingOrFixListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener2 = objectArray[n2];
            IAgentEventManager.AgentJobListener listener = (IAgentEventManager.AgentJobListener)listener2;
            try {
                listener.beforeInstallOfferingOrFix(ev);
            }
            catch (RuntimeException ex) {
                logger.error("Error in beforeInstallOffering callback of install offering listener: " + listener.getClass().getName());
                logger.error((Throwable)ex);
            }
            ++n2;
        }
    }

    @Override
    public void fireAfterInstallOfferingOrFix(AgentJob job, IStatus status) {
        IAgentEventManager.AgentJobEvent ev = new IAgentEventManager.AgentJobEvent(job, status);
        this.fireAfterInstallOfferingOrFix(ev);
    }

    protected void fireAfterInstallOfferingOrFix(IAgentEventManager.AgentJobEvent ev) {
        Object[] listeners;
        Object[] objectArray = listeners = this.installOfferingOrFixListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener2 = objectArray[n2];
            IAgentEventManager.AgentJobListener listener = (IAgentEventManager.AgentJobListener)listener2;
            try {
                listener.afterInstallOfferingOrFix(ev);
            }
            catch (RuntimeException ex) {
                logger.error("Error in afterInstallOffering callback of install offering listener: " + listener.getClass().getName());
                logger.error((Throwable)ex);
            }
            ++n2;
        }
    }

    @Override
    public void fireAfterInstallSession(AgentJob[] jobs, IStatus status) {
        IAgentEventManager.AgentSessionEvent ev = new IAgentEventManager.AgentSessionEvent(jobs, status);
        this.fireAfterInstallSession(ev);
    }

    protected void fireAfterInstallSession(IAgentEventManager.AgentSessionEvent ev) {
        Object[] listeners;
        Object[] objectArray = listeners = this.installSessionListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener2 = objectArray[n2];
            IAgentEventManager.AgentSessionListener listener = (IAgentEventManager.AgentSessionListener)listener2;
            try {
                listener.afterInstallSession(ev);
            }
            catch (RuntimeException ex) {
                logger.error("Error in afterInstallSession callback of install session listener: " + listener.getClass().getName());
                logger.error((Throwable)ex);
            }
            ++n2;
        }
    }

    @Override
    public void addUninstallOfferingOrFixListener(IAgentEventManager.AgentJobListener listener) {
        if (listener != null) {
            this.uninstallOfferingOrFixListeners.add((Object)listener);
        }
    }

    @Override
    public void addUninstallSessionListener(IAgentEventManager.AgentSessionListener listener) {
        if (listener != null) {
            this.uninstallSessionListeners.add((Object)listener);
        }
    }

    @Override
    public void removeUninstallSessionListener(IAgentEventManager.AgentSessionListener listener) {
        if (listener != null) {
            this.uninstallSessionListeners.remove((Object)listener);
        }
    }

    @Override
    public void removeUnistallOfferingOrFixListener(IAgentEventManager.AgentJobListener listener) {
        if (listener != null) {
            this.uninstallOfferingOrFixListeners.remove((Object)listener);
        }
    }

    @Override
    public void fireAfterUninstallOfferingOrFix(AgentJob job, IStatus status) {
        IAgentEventManager.AgentJobEvent ev = new IAgentEventManager.AgentJobEvent(job, status);
        this.fireAfterUninstallOfferingOrFix(ev);
    }

    protected void fireAfterUninstallOfferingOrFix(IAgentEventManager.AgentJobEvent ev) {
        Object[] listeners;
        Object[] objectArray = listeners = this.uninstallOfferingOrFixListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener2 = objectArray[n2];
            IAgentEventManager.AgentJobListener listener = (IAgentEventManager.AgentJobListener)listener2;
            try {
                listener.afterUninstallOfferingOrFix(ev);
            }
            catch (RuntimeException ex) {
                logger.error("Error in afterUninstallSession callback of uninstall offering listener: " + listener.getClass().getName());
                logger.error((Throwable)ex);
            }
            ++n2;
        }
    }

    @Override
    public void fireAfterUninstallSession(AgentJob[] jobs, IStatus status) {
        IAgentEventManager.AgentSessionEvent ev = new IAgentEventManager.AgentSessionEvent(jobs, status);
        this.fireAfterUninstallSession(ev);
    }

    protected void fireAfterUninstallSession(IAgentEventManager.AgentSessionEvent ev) {
        Object[] listeners;
        Object[] objectArray = listeners = this.uninstallSessionListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener2 = objectArray[n2];
            IAgentEventManager.AgentSessionListener listener = (IAgentEventManager.AgentSessionListener)listener2;
            try {
                listener.afterUninstallSession(ev);
            }
            catch (RuntimeException ex) {
                logger.error("Error in afterUninstallSession callback of uninstall session listener: " + listener.getClass().getName());
                logger.error((Throwable)ex);
            }
            ++n2;
        }
    }

    @Override
    public void fireBeforeUninstallOfferingOrFix(AgentJob job) {
        IAgentEventManager.AgentJobEvent ev = new IAgentEventManager.AgentJobEvent(job);
        this.fireBeforeUninstallOfferingOrFix(ev);
    }

    protected void fireBeforeUninstallOfferingOrFix(IAgentEventManager.AgentJobEvent ev) {
        Object[] listeners;
        Object[] objectArray = listeners = this.uninstallOfferingOrFixListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener2 = objectArray[n2];
            IAgentEventManager.AgentJobListener listener = (IAgentEventManager.AgentJobListener)listener2;
            try {
                listener.beforeUninstallOfferingOrFix(ev);
            }
            catch (RuntimeException ex) {
                logger.error("Error in beforeUninstallOffering callback of uninstall offering listener: " + listener.getClass().getName());
                logger.error((Throwable)ex);
            }
            ++n2;
        }
    }

    @Override
    public void fireBeforeUninstallSession(AgentJob[] job) {
        IAgentEventManager.AgentSessionEvent ev = new IAgentEventManager.AgentSessionEvent(job);
        this.fireBeforeUninstallSession(ev);
    }

    protected void fireBeforeUninstallSession(IAgentEventManager.AgentSessionEvent ev) {
        Object[] listeners;
        Object[] objectArray = listeners = this.uninstallSessionListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener2 = objectArray[n2];
            IAgentEventManager.AgentSessionListener listener = (IAgentEventManager.AgentSessionListener)listener2;
            try {
                listener.beforeUninstallSession(ev);
            }
            catch (RuntimeException ex) {
                logger.error("Error in beforeUninstallSession callback of uninstall session listener: " + listener.getClass().getName());
                logger.error((Throwable)ex);
            }
            ++n2;
        }
    }

    @Override
    public void fireBeginFetch(Object source, IOfferingOrFix offeringOrFix, CicMultiStatus status) {
        Object[] listeners;
        Object[] objectArray = listeners = this.beginFetchListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener2 = objectArray[n2];
            IAgentEventManager.BeginFetchListener listener = (IAgentEventManager.BeginFetchListener)listener2;
            try {
                listener.beginFetch(new IAgentEventManager.AgentPhaseEvent(source, offeringOrFix, "Download artifacts", (IStatus)status));
            }
            catch (RuntimeException ex) {
                logger.error("Error in phaseCompleted callback of begin fetch session listener: " + listener.getClass().getName());
                logger.error((Throwable)ex);
            }
            ++n2;
        }
    }

    @Override
    public void fireFetchCompleted(Object source, IOfferingOrFix offeringOrFix, CicMultiStatus status, CacheManager.ArtifactsToDownload downloaded) {
        Object[] listeners;
        Object[] objectArray = listeners = this.fetchCompleteListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener2 = objectArray[n2];
            IAgentEventManager.FetchCompletedListener listener = (IAgentEventManager.FetchCompletedListener)listener2;
            try {
                listener.fetchCompleted(new IAgentEventManager.AgentFetchCompletePhaseEvent(source, offeringOrFix, (IStatus)status, downloaded));
            }
            catch (RuntimeException ex) {
                logger.error("Error in phaseCompleted callback of fetch completed session listener: " + listener.getClass().getName());
                logger.error((Throwable)ex);
            }
            ++n2;
        }
    }

    @Override
    public void addBeginFetchOfferingOrFixListener(IAgentEventManager.BeginFetchListener listener) {
        if (listener != null) {
            this.beginFetchListeners.add((Object)listener);
        }
    }

    @Override
    public void removeBeginFetchOfferingOrFixListener(IAgentEventManager.BeginFetchListener listener) {
        if (listener != null) {
            this.beginFetchListeners.remove((Object)listener);
        }
    }

    @Override
    public void addFetchCompletedOfferingOrFixListener(IAgentEventManager.FetchCompletedListener listener) {
        if (listener != null) {
            this.fetchCompleteListeners.add((Object)listener);
        }
    }

    @Override
    public void removeFetchCompletedOfferingOrFixListener(IAgentEventManager.FetchCompletedListener listener) {
        if (listener != null) {
            this.fetchCompleteListeners.remove((Object)listener);
        }
    }
}

