/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.PreparedAgentBundles;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.api.IDependencyValidationContext;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.internal.core.DependencyExtenderManager;
import com.ibm.cic.agent.internal.core.Messages;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class AgentDependencyCheckerUtil {
    private static final String[] DEPENDENCY_HANDLER_SELECTOR_IDS = new String[]{"InstallDependencyHandler"};
    public static final DependencyCheckerFlags FLAGS_SILENT_INSTALL = new DependencyCheckerFlags(false, false, true);
    public static final DependencyCheckerFlags FLAGS_FAKE_PROFILE = new DependencyCheckerFlags(true, true, false);

    private AgentDependencyCheckerUtil() {
    }

    public static synchronized IStatus checkOfferingFixDependenciesMultipleProfiles(AgentJob[] jobs, IProgressMonitor monitor) {
        return AgentDependencyCheckerUtil.checkOfferingFixDependenciesMultipleProfiles(FLAGS_SILENT_INSTALL, jobs, monitor);
    }

    public static synchronized IStatus checkOfferingFixDependenciesMultipleProfiles(DependencyCheckerFlags checkFlags, AgentJob[] jobs, IProgressMonitor monitor) {
        Collection profileJobsList = AgentUtil.groupByProfile(jobs, false);
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, profileJobsList.size());
        CicMultiStatus ret = Statuses.ST.createMultiStatus(Messages.Agent_unsatisfiedDependencies, new Object[0]);
        for (AgentJob[] profileJobs : profileJobsList) {
            try {
                IStatus status = AgentDependencyCheckerUtil.checkOfferingFixDependenciesProfilePrepareUnprepare(checkFlags, profileJobs, pm.next());
                if (status.isOK()) continue;
                ret.add(status);
            }
            catch (CoreException e) {
                ret.add(e.getStatus());
            }
        }
        return ret;
    }

    public static synchronized IStatus checkOfferingFixDependenciesProfilePrepareUnprepare(DependencyCheckerFlags checkFlags, AgentJob[] profileJobs, IProgressMonitor monitor) throws CoreException {
        Profile profile;
        Profile profile2 = checkFlags.isProfileFake() ? null : (profile = profileJobs.length > 0 ? profileJobs[0].getProfile() : null);
        if (profile != null) {
            profileJobs = AgentUtil.addUninstallFixJobs(profileJobs, checkFlags.adjustJobs());
        }
        ArrayList listPackages = new ArrayList();
        ArrayList listRemoved = new ArrayList();
        AgentUtil.getResultingOfferingsAndFixesAndChanges(profile, profileJobs, checkFlags.adjustJobs(), listPackages, listRemoved);
        DependencyExtenderManager.DependencyValidationContext dependencyContext = new DependencyExtenderManager.DependencyValidationContext(checkFlags.isProfilePreliminary(), profile, profileJobs, listPackages.toArray(new IOfferingOrFix[listPackages.size()]), listRemoved.toArray(new IOfferingOrFix[listRemoved.size()]));
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, 2);
        PreparedAgentBundles prepared = new PreparedAgentBundles(Agent.getInstance());
        IStatus status = null;
        try {
            status = AgentDependencyCheckerUtil.prepareDependencyBundles(prepared, dependencyContext, pm.next());
            if (status.matches(12)) {
                IStatus iStatus = status;
                return iStatus;
            }
            IStatus iStatus = AgentDependencyCheckerUtil.checkOfferingFixDependenciesProfile(checkFlags, profileJobs, pm.next());
            return iStatus;
        }
        catch (CoreException e) {
            throw e;
        }
        finally {
            Agent.getLogger().statusNotOK(prepared.unload());
        }
    }

    private static IStatus prepareDependencyBundles(PreparedAgentBundles prepared, IDependencyValidationContext dependencyContext, IProgressMonitor monitor) {
        IOfferingOrFix[] resulting = dependencyContext.getResultingOfferingsOrFixes();
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, resulting.length);
        IOfferingOrFix[] iOfferingOrFixArray = resulting;
        int n = resulting.length;
        int n2 = 0;
        while (n2 < n) {
            IOfferingOrFix oof = iOfferingOrFixArray[n2];
            IStatus status = AgentDependencyCheckerUtil.prepareDependencyBundles(prepared, oof, pm.next());
            if (status.matches(12)) {
                return status;
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    private static IStatus prepareDependencyBundles(PreparedAgentBundles prepared, IOfferingOrFix oof, IProgressMonitor monitor) {
        OfferingUtil.IBundleIdAndClassName[] bundles = OfferingUtil.getDependenciesBundles((IOfferingOrFix)oof);
        String[] bundleIds = OfferingUtil.getUniqueBundleIds((OfferingUtil.IBundleIdAndClassName[])bundles);
        IStatus status = prepared.prepare(oof, bundleIds, DEPENDENCY_HANDLER_SELECTOR_IDS, monitor);
        return status;
    }

    public static synchronized IStatus checkOfferingFixDependenciesProfile(DependencyCheckerFlags checkFlags, AgentJob[] profileJobs, IProgressMonitor monitor) throws CoreException {
        Profile installProfile;
        if (profileJobs.length == 0) {
            return Status.OK_STATUS;
        }
        Profile profile = installProfile = checkFlags.isProfileFake() ? null : profileJobs[0].getProfile();
        assert (checkFlags.isProfileFake() || installProfile != null);
        boolean effectiveProfileIsPreliminary = checkFlags.isProfilePreliminary();
        if (effectiveProfileIsPreliminary && !AgentDependencyCheckerUtil.isAnyProductInstalled()) {
            effectiveProfileIsPreliminary = false;
        }
        if (installProfile != null && !AgentDependencyCheckerUtil.isProductOrEclipseProfile(installProfile)) {
            return Status.OK_STATUS;
        }
        ArrayList listPackages = new ArrayList();
        ArrayList listRemoved = new ArrayList();
        AgentUtil.getResultingOfferingsAndFixesAndChanges(installProfile, profileJobs, checkFlags.adjustJobs(), listPackages, listRemoved);
        ArrayList<OfferingUtil.IBundleIdAndClassName> allBundles = new ArrayList<OfferingUtil.IBundleIdAndClassName>(listPackages.size() * 2);
        for (IOfferingOrFix oof : listPackages) {
            OfferingUtil.IBundleIdAndClassName[] bundles = OfferingUtil.getDependenciesBundles((IOfferingOrFix)oof);
            allBundles.addAll(Arrays.asList(bundles));
        }
        OfferingUtil.IBundleIdAndClassName[] arrBundles = allBundles.toArray(new OfferingUtil.IBundleIdAndClassName[allBundles.size()]);
        OfferingUtil.IBundleIdAndClassName[] uniqueBundles = OfferingUtil.getUniqueBundles((OfferingUtil.IBundleIdAndClassName[])arrBundles);
        ArrayList<IStatus> errors = new ArrayList<IStatus>(uniqueBundles.length);
        ArrayList<IStatus> warnings = new ArrayList<IStatus>(uniqueBundles.length);
        DependencyExtenderManager.DependencyValidationContext dependencyContext = new DependencyExtenderManager.DependencyValidationContext(effectiveProfileIsPreliminary, installProfile, profileJobs, listPackages.toArray(new IOfferingOrFix[listPackages.size()]), listRemoved.toArray(new IOfferingOrFix[listRemoved.size()]));
        OfferingUtil.IBundleIdAndClassName[] iBundleIdAndClassNameArray = uniqueBundles;
        int n = uniqueBundles.length;
        int n2 = 0;
        while (n2 < n) {
            OfferingUtil.IBundleIdAndClassName bundle = iBundleIdAndClassNameArray[n2];
            IStatus status = DependencyExtenderManager.check(dependencyContext, bundle.getBundleId(), bundle.getClassName());
            if (status.matches(4)) {
                errors.add(status);
            }
            if (status.matches(2)) {
                warnings.add(status);
            }
            ++n2;
        }
        if (!errors.isEmpty()) {
            return AgentDependencyCheckerUtil.combineStatusList(installProfile, errors);
        }
        if (!warnings.isEmpty()) {
            return AgentDependencyCheckerUtil.combineStatusList(installProfile, warnings);
        }
        return Status.OK_STATUS;
    }

    private static boolean isProductOrEclipseProfile(IProfile profile) {
        if (profile.getProfileKind().equals("product")) {
            return true;
        }
        return profile.getProfileKind().equals("existingEclipse");
    }

    private static boolean isAnyProductInstalled() {
        IProfile[] allProfiles;
        IProfile[] iProfileArray = allProfiles = Agent.getInstance().getAllProfiles();
        int n = allProfiles.length;
        int n2 = 0;
        while (n2 < n) {
            IProfile profile = iProfileArray[n2];
            if (AgentDependencyCheckerUtil.isProductOrEclipseProfile(profile)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static IStatus combineStatusList(IProfile profile, List stati) {
        LinkedList fixed = new LinkedList();
        for (IStatus status : stati) {
            AgentDependencyCheckerUtil.fixStatus(fixed, status);
        }
        CicMultiStatus ms = Statuses.ST.createMultiStatus(profile != null ? NLS.bind((String)Messages.Agent_unsatisfiedDependenciesInProfile, (Object)profile.getProfileId()) : Messages.Agent_unsatisfiedDependenciesInNullProfile, new Object[0]);
        ms.addAll(fixed);
        return ms;
    }

    private static boolean isMissingMessage(IStatus status) {
        String msg = status.getMessage();
        return msg == null || msg.trim().length() == 0;
    }

    private static void fixStatus(Collection list, IStatus status) {
        IStatus[] children;
        if (!status.isMultiStatus()) {
            list.add(status);
            return;
        }
        if (!AgentDependencyCheckerUtil.isMissingMessage(status)) {
            list.add(status);
            return;
        }
        IStatus[] iStatusArray = children = status.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            AgentDependencyCheckerUtil.fixStatus(list, child);
            ++n2;
        }
    }

    public static class DependencyCheckerFlags {
        private final boolean profileIsPreliminary;
        private final boolean profileIsFake;
        private final boolean adjustJobs;

        public DependencyCheckerFlags(boolean profileIsPreliminary, boolean profileIsFake, boolean adjustJobs) {
            this.profileIsPreliminary = profileIsPreliminary;
            this.profileIsFake = profileIsFake;
            this.adjustJobs = adjustJobs;
            assert (!profileIsFake || profileIsPreliminary);
            assert (!profileIsFake || !adjustJobs);
        }

        public String toString() {
            return "preliminary=" + this.profileIsPreliminary + " fake=" + this.profileIsFake + " adjustJobs=" + this.adjustJobs;
        }

        public boolean isProfilePreliminary() {
            return this.profileIsPreliminary;
        }

        public boolean isProfileFake() {
            return this.profileIsFake;
        }

        public boolean adjustJobs() {
            return this.adjustJobs;
        }
    }
}

