/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.core;

import com.ibm.cic.agent.core.AgentActivator;
import com.ibm.cic.agent.core.AgentEventManager;
import com.ibm.cic.agent.core.AgentInstall;
import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentRegistry;
import com.ibm.cic.agent.core.AgentRelaunch;
import com.ibm.cic.agent.core.AgentSettings;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.CacheLocationManager;
import com.ibm.cic.agent.core.CacheManager;
import com.ibm.cic.agent.core.CommandRecorder;
import com.ibm.cic.agent.core.IAgentEventManager;
import com.ibm.cic.agent.core.IInstallAdaptor;
import com.ibm.cic.agent.core.LocationCheckManager;
import com.ibm.cic.agent.core.LoggerInstallOperationDebug;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.SortUtil;
import com.ibm.cic.agent.core.SpaceInfoUtils;
import com.ibm.cic.agent.core.UndoProgress;
import com.ibm.cic.agent.core.UpdateOfferingJob;
import com.ibm.cic.agent.core.UserFeedback;
import com.ibm.cic.agent.core.api.IAgent;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.core.cmd.CmdLine;
import com.ibm.cic.agent.core.internal.commands.SilentInstallPreferenceHandler;
import com.ibm.cic.agent.core.internal.expander.ExpansionResult;
import com.ibm.cic.agent.core.internal.expander.FeatureDependencyChecker;
import com.ibm.cic.agent.core.internal.expander.RecommendedProfiles;
import com.ibm.cic.agent.core.internal.headless.AgentInput;
import com.ibm.cic.agent.core.internal.headless.IInput;
import com.ibm.cic.agent.core.internal.headless.InstallFixesAction;
import com.ibm.cic.agent.core.userdata.parser.CommonUserDataExtParser;
import com.ibm.cic.agent.core.userdata.parser.OfferingUserDataExtParser;
import com.ibm.cic.agent.core.utils.AgentUserOptions;
import com.ibm.cic.agent.core.utils.InstallJobTracker;
import com.ibm.cic.agent.internal.core.AdaptorManager;
import com.ibm.cic.agent.internal.core.Director;
import com.ibm.cic.agent.internal.core.FeatureDependencies;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.agent.internal.core.MemoryCleanup;
import com.ibm.cic.agent.internal.core.debug.InstallOperationDebug;
import com.ibm.cic.agent.internal.core.history.HistoryStore;
import com.ibm.cic.agent.publish.InstallPublication;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.auth.PasswordManager;
import com.ibm.cic.common.core.console.PrompterUtils;
import com.ibm.cic.common.core.definitions.CommonDef;
import com.ibm.cic.common.core.definitions.IAgentDef;
import com.ibm.cic.common.core.definitions.ProfileLanguageUtils;
import com.ibm.cic.common.core.downloads.RememberDownloadUserPrompts;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.internal.preferences.UserContext;
import com.ibm.cic.common.core.internal.repository.RepositoryRef;
import com.ibm.cic.common.core.model.ExtensionCategory;
import com.ibm.cic.common.core.model.FixUtil;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IFeatureBase;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.ISelectionExpression;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.expander.ExpanderUtils;
import com.ibm.cic.common.core.model.expander.IContextState;
import com.ibm.cic.common.core.model.utils.FixProperty;
import com.ibm.cic.common.core.model.utils.LicenseUtils;
import com.ibm.cic.common.core.model.utils.MaxInstallSizeInfo;
import com.ibm.cic.common.core.model.utils.OfferingOrFixProperty;
import com.ibm.cic.common.core.model.utils.OfferingProperty;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.preferences.ICicPreferenceHandler;
import com.ibm.cic.common.core.preferences.PPSettings;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryGroup;
import com.ibm.cic.common.core.repository.IRepositoryIdentity;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryStatus;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.repository.ServiceRepositoryUtils;
import com.ibm.cic.common.core.repository.SliceUtils;
import com.ibm.cic.common.core.repository.UnavailableUtils;
import com.ibm.cic.common.core.repository.UpdateOfferingUtils;
import com.ibm.cic.common.core.utils.Check;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.Comparators;
import com.ibm.cic.common.core.utils.EclipseUtil;
import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.core.utils.FileName;
import com.ibm.cic.common.core.utils.FileReplicator;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.NativeUtils;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.PathUtil;
import com.ibm.cic.common.core.utils.PlatformUtils;
import com.ibm.cic.common.core.utils.RebootRequest;
import com.ibm.cic.common.core.utils.SharedFileLock;
import com.ibm.cic.common.core.utils.SplitIdVersionUtil;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StandardInputDetector;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.TempUtil;
import com.ibm.cic.common.core.utils.UserFeedbackProvider;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.downloads.DownloadInProgressManager;
import com.ibm.cic.common.downloads.FileCacheManager;
import com.ibm.cic.common.downloads.HttpUserAgent;
import com.ibm.cic.common.downloads.NonsecureConnectionSessionState;
import com.ibm.cic.common.downloads.PreferencesHolder;
import com.ibm.cic.common.downloads.SizeInfo;
import com.ibm.cic.common.downloads.TransferSessionManager;
import com.ibm.cic.common.logging.ConsoleLog;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.Level;
import com.ibm.cic.common.logging.LogManager;
import com.ibm.cic.common.logging.LogUtil;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.licensing.common.util.LicUserUtils;
import com.ibm.cic.licensing.common.util.LicensePolicyData;
import com.ibm.cic.licensing.common.util.LicensePolicyDataParser;
import com.ibm.cic.licensing.common.util.LicensePolicyDataWriter;
import com.ibm.cic.licensing.common.util.PolicyManager;
import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.dgc.VMID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class Agent
implements IAgent,
IAgentDef {
    public static final String PI_AGENT = Agent.getBundleId();
    public static final String VAR_AGENT_LAUNCH_COMMAND = "agent.launch.command";
    public static final String VAR_AGENT_INSTALL_LOCATION = "agent.install.location";
    public static final String VAR_AGENT_APPDATA_LOCATION = "cic.appDataLocation";
    public static final String FILENAME_INSTALL_REGISTRY = "installRegistry.xml";
    public static final String FILENAME_INSTALL_PUBLICATION = "installed.xml";
    public static final String FILENAME_INSTALL_PUBLICATION_SCHEMA = "installed.xsd";
    protected static final String FILENAME_ADAPTERS = "adapters";
    private static final String FILENAME_LOGS = "logs";
    private static final String FILENAME_INPUT_LOGS = "inputs";
    protected static final String FILENAME_HISTORIES = "histories";
    private static final String FILENAME_LICENSE = "license";
    protected static final String FILENAME_BUNDLES = "bundles";
    private static final String FILENAME_PREFERENCES = ".settings";
    private static final String FILENAME_UNINSTALL = "macosx".equals(Platform.getOS()) ? "Uninstall.app/Contents/MacOS" : "uninstall";
    private static final String AGENT_LOCK_FILE = ".imlock";
    private static final String AGENT_JAVA_HOME = "agent.java.home";
    private static final String FILENAME_TEMP = "temp";
    private static final String[] requiredInstallAdaptors = new String[]{"native", "eclipse"};
    private FileReplicator javaFileReplicator = null;
    private static final Logger log = Logger.getLogger(Agent.class, (Plugin)AgentActivator.getDefault());
    private static final String GENERIC_AGENT_LAUNCHER_NAME = "launcher";
    private static final String SWT_AGENT_LAUNCHER_NAME = "IBMIM";
    private static Agent instance = null;
    private RepositoryGroup agentRepositoryGroup = null;
    private IStatus agentRepositoryGroupStatus = null;
    private IRepositoryGroup externalRepositoryGroup = null;
    private Director director;
    private SharedFileLock lock;
    private IEclipsePreferences currentUserPreferences;
    private Properties previousPrefs = null;
    private boolean updatingAgent = false;
    private boolean uninstallingAgent = false;
    private CacheManager agentSelfCache;
    private static final String SELF_CACHE_NAME = "agent self cache";
    private static final String SELF_CACHE_DESCRIPTION = "Agent Self Repository";
    private static final String SELF_CACHE_CLEAN_PROPERTY = "cleanSelfCache";
    private CacheManager agentBundleCache;
    private static final String BUNDLE_CACHE_NAME = "agent_bundle_cache";
    private static final String BUNDLE_CACHE_DESCRIPTION = "Agent Bundle Repository";
    private IAgentEventManager eventManager = null;
    private HistoryStore historyStore;
    private CommandRecorder commandRecorder = null;
    private String recordFilePath = null;
    private boolean isSilentMode = false;
    private boolean isCleanMode = false;
    private boolean isTemporaryMode = false;
    private ServiceRegistration service = null;
    private String previousUniqueifier;
    private final String uniqueInstanceId;
    private boolean isSkipInstall = false;
    private OutputFormatter stdoutBuffer = new OutputFormatter();
    private Map totalSizeMap = null;
    private Map<Profile, String> profileLanguageMap = new HashMap<Profile, String>();
    private int prevDefaultConsoleLogLevel;
    private IEclipsePreferences currentProxyPrefs = null;
    private IEclipsePreferences defaultProxyPrefs = null;
    public static final String[] DEPENDENCY_HANDLER_SELECTOR_IDS = new String[]{"InstallDependencyHandler"};
    private boolean checkingPrerequisites = false;
    private boolean agentVersionsLogged = false;
    private static final String IBMIM_TMP_PREFIX = ".IBMIM_TMP_";
    private static final String ECLIPSE_DLL_DIR_PREFIX = "org.eclipse.equinox.launcher.win32.win32.x86_";
    private static final String ECLIPSE_DLL_PREFIX = "eclipse_";
    private static final String PLUGINS_DIR = "plugins";

    public static Agent getInstance() {
        if (instance == null) {
            instance = new Agent();
        }
        return instance;
    }

    public static Logger getLogger() {
        return log;
    }

    private Agent() {
        this.uniqueInstanceId = new VMID().toString();
    }

    public boolean isReady() {
        return this.service != null;
    }

    public static String getBundleId() {
        return AgentActivator.getPluginId();
    }

    public IStatus restart(Profile profile) {
        return this.director.restart(profile);
    }

    public IStatus start() {
        return this.start(true);
    }

    private IStatus start(boolean locking) {
        IStatus status;
        this.initializeAgentPreferences();
        IStatus iStatus = status = locking ? this.acquireLock() : Status.OK_STATUS;
        if (status.isOK()) {
            String cmdLineArgs;
            StandardInputDetector.INSTANCE.detect();
            AgentSettings.reset();
            AgentRelaunch.getInstance().setNeedsRelaunch(false);
            this.previousUniqueifier = TempUtil.getUniqueifier();
            TempUtil.setUniqueifier((String)"");
            this.setLogDirectory();
            log.info(com.ibm.cic.agent.internal.core.Messages.Agent_Starting);
            log.info(com.ibm.cic.agent.internal.core.Messages.Agent_EnvInfo, new Object[]{Platform.getOS(), Platform.getOSArch(), CicCommonSettings.is64BitOs() ? "64" : "32"});
            log.info(com.ibm.cic.agent.internal.core.Messages.Agent_EnvInfo2, new Object[]{System.getProperty("os.name"), Platform.getNL(), System.getProperty("java.version")});
            log.info(com.ibm.cic.agent.internal.core.Messages.Agent_EnvInfo3, new Object[]{System.getProperty("user.name"), CicCommonSettings.isNativeAdministrator() ? com.ibm.cic.agent.internal.core.Messages.Agent_User_Admin : com.ibm.cic.agent.internal.core.Messages.Agent_User_NonAdmin});
            log.info(com.ibm.cic.agent.internal.core.Messages.Agent_Default_Encoding, new Object[]{Encodings.DEFAULT.getName()});
            String launcher = this.getAgentLauncher();
            if (launcher != null) {
                log.info(com.ibm.cic.agent.internal.core.Messages.Agent_Launcher, new Object[]{launcher});
            }
            File configuration = EclipseUtil.getCurrentEclipseConfiguration();
            if (launcher == null || !FileUtil.directoriesAreRelated((File)configuration.getParentFile(), (File)new File(launcher).getParentFile())) {
                log.info(com.ibm.cic.agent.internal.core.Messages.Agent_Configuration, new Object[]{configuration});
            }
            if (!(cmdLineArgs = CmdLine.CL.getMaskedString()).equals("")) {
                log.info(com.ibm.cic.agent.internal.core.Messages.Cmd_log_args, new Object[]{cmdLineArgs});
            }
            if ((status = this.restoreState()).isOK() && CicCommonSettings.getAccessRightsMode().isGroupMode() && !CacheLocationManager.getInstance().isCacheLocationChangeable()) {
                status = AgentUtil.validateCommonDirectoryPermissions(CacheLocationManager.getInstance().getCacheLocation());
            }
            log.info(com.ibm.cic.agent.internal.core.Messages.Agent_Mode, new Object[]{CicCommonSettings.getAccessRightsMode().toString()});
            this.director.start();
            this.setLicenseSettings();
            this.service = AgentActivator.getDefault().getContext().registerService(Agent.class.getName(), (Object)this, null);
            this.getJavaFileReplicator().cleanAllReplicas();
            if (status.isOK()) {
                status = InstallOperationDebug.INSTANCE.start();
            }
            LoggerInstallOperationDebug.INSTANCE.start();
        }
        return status;
    }

    public void logInputFile(IInput input) {
        File inputFile = input.getInputFile();
        if (inputFile == null) {
            return;
        }
        File inputLogDir = new File(this.getLogDirectory(), FILENAME_INPUT_LOGS);
        String inputFileName = inputFile.getName();
        int lastIndex = inputFileName.endsWith(".xml") ? inputFileName.lastIndexOf(".") : inputFileName.length();
        File inputLogFile = LogUtil.createLogFile((File)inputLogDir, (String)(String.valueOf(inputFileName.substring(0, lastIndex)) + "_"), (long)System.currentTimeMillis(), (String)".xml");
        try {
            input.save(inputLogFile, true);
            log.info(NLS.bind((String)com.ibm.cic.agent.internal.core.Messages.Log_Input_File, (Object)inputLogFile.getAbsolutePath()));
        }
        catch (FileNotFoundException fnfe) {
            log.warning(NLS.bind((String)com.ibm.cic.agent.internal.core.Messages.Log_Input_File_Failed, (Object)fnfe.getLocalizedMessage()));
        }
    }

    private IStatus acquireLock() {
        if (this.lock != null) {
            return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.Agent_Unbalanced_Acquire_Release_Lock, new Object[0]);
        }
        this.lock = new SharedFileLock(this.getAgentData(AGENT_LOCK_FILE));
        Object status = this.lock.acquire();
        if (!status.isOK()) {
            status = this.getAgentData(AGENT_LOCK_FILE).exists() ? Statuses.ERROR.getMultiStatus(new IStatus[]{status}, com.ibm.cic.agent.internal.core.Messages.Agent_Unable_To_Acquire_Lock, new Object[0]) : Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.Agent_Unable_To_Write_Data, new Object[]{CicCommonSettings.getApplicationDataLocation()});
            this.lock = null;
        }
        return status;
    }

    private IStatus restoreState() {
        CicMultiStatus status;
        block4: {
            log.info(com.ibm.cic.agent.internal.core.Messages.Agent_Restoring_State);
            status = Statuses.ST.createMultiStatus();
            this.createDirector();
            try {
                if (!InstallRegistry.getInstance().isOpen()) {
                    InstallRegistry.getInstance().open();
                }
            }
            catch (CoreException e) {
                status.add((IStatus)Statuses.ERROR.get(e.getMessage(), new Object[0]));
                if (status.isOK()) break block4;
                status.setMessage(com.ibm.cic.agent.internal.core.Messages.Agent_Error_Restoring_Installation_Manager_State);
                return status;
            }
        }
        this.logAgentVersions();
        status.add(this.setAgentLocation());
        this.restoreHistory();
        IStatus initProfileStatus = this.initializeAgentProfile();
        status.add(AdaptorManager.getInstance().validateInstallAdaptors(requiredInstallAdaptors));
        if (!status.isOK()) {
            status.setMessage(com.ibm.cic.agent.internal.core.Messages.Agent_Error_Restoring_Installation_Manager_State);
            return status;
        }
        return initProfileStatus;
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(boolean noPersist) {
        block24: {
            log.info(com.ibm.cic.agent.internal.core.Messages.Agent_Stopping);
            LoggerInstallOperationDebug.INSTANCE.stop();
            InstallOperationDebug.INSTANCE.stop();
            this.isSkipInstall = false;
            this.javaFileReplicator = null;
            if (this.commandRecorder != null) {
                try {
                    IStatus rc;
                    this.commandRecorder.updateServerCommand();
                    if (RebootRequest.isSet() && !RebootRequest.shouldRebootNow()) {
                        this.commandRecorder.setRebootLater(true);
                    }
                    if (!(rc = this.commandRecorder.saveToFile(new File(this.recordFilePath))).isOK()) {
                        log.status(rc);
                    }
                    this.commandRecorder = null;
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
            if (this.service != null) {
                this.service.unregister();
                this.service = null;
            }
            try {
                try {
                    this.resetRepositoryGroup();
                    if (InstallRegistry.getInstance().isOpen()) {
                        InstallRegistry.getInstance().close();
                    }
                    CacheManager.clearDefaultInstance();
                    TransferSessionManager.INSTANCE.closeDefaultSession();
                    FileCacheManager.getInstance().reset();
                    if (this.director != null) {
                        this.director.stop();
                    }
                    UserFeedback.setProvider(null);
                    UndoProgress.setProvider(null);
                    Util.deleteEmptyDirs((File)this.getAgentData(FILENAME_ADAPTERS));
                    ICicPreferenceHandler prefHandler = CicPreferenceManager.getInstance().getCurrentPreferenceHandler();
                    if (prefHandler != null) {
                        if (this.isTemporaryMode()) {
                            try {
                                prefHandler.removeTemporaryValues();
                                prefHandler.getPreferences().clear();
                            }
                            catch (BackingStoreException e) {
                                e.printStackTrace();
                            }
                            CicPreferenceManager.getInstance().setRemotePreferenceHandler();
                        } else {
                            CicPreferenceManager.getInstance().removeBackup();
                            prefHandler.removeTemporaryValues();
                            prefHandler.save();
                        }
                    }
                    NonsecureConnectionSessionState.INSTANCE.clear();
                    this.removeProxyPreferences();
                }
                catch (IOException iOException) {
                    Location location = Platform.getInstanceLocation();
                    if (location != null) {
                        location.release();
                    }
                    if (this.lock != null) {
                        TempUtil.setUniqueifier((String)this.previousUniqueifier);
                        this.lock.release();
                        this.lock = null;
                    }
                    this.previousPrefs = null;
                    this.updatingAgent = false;
                    this.uninstallingAgent = false;
                    this.isSilentMode = false;
                    this.isCleanMode = false;
                    this.isSkipInstall = false;
                    this.totalSizeMap = null;
                    this.profileLanguageMap = new HashMap<Profile, String>();
                    PasswordManager.INSTANCE.reset();
                    break block24;
                }
            }
            catch (Throwable throwable) {
                Location location = Platform.getInstanceLocation();
                if (location != null) {
                    location.release();
                }
                if (this.lock != null) {
                    TempUtil.setUniqueifier((String)this.previousUniqueifier);
                    this.lock.release();
                    this.lock = null;
                }
                this.previousPrefs = null;
                this.updatingAgent = false;
                this.uninstallingAgent = false;
                this.isSilentMode = false;
                this.isCleanMode = false;
                this.isSkipInstall = false;
                this.totalSizeMap = null;
                this.profileLanguageMap = new HashMap<Profile, String>();
                PasswordManager.INSTANCE.reset();
                throw throwable;
            }
            Location location = Platform.getInstanceLocation();
            if (location != null) {
                location.release();
            }
            if (this.lock != null) {
                TempUtil.setUniqueifier((String)this.previousUniqueifier);
                this.lock.release();
                this.lock = null;
            }
            this.previousPrefs = null;
            this.updatingAgent = false;
            this.uninstallingAgent = false;
            this.isSilentMode = false;
            this.isCleanMode = false;
            this.isSkipInstall = false;
            this.totalSizeMap = null;
            this.profileLanguageMap = new HashMap<Profile, String>();
            PasswordManager.INSTANCE.reset();
        }
        LogManager.setDefaultLevel((String)ConsoleLog.class.getName(), (int)this.prevDefaultConsoleLogLevel);
    }

    private String getLogDirectory() {
        return CicPreferenceManager.getInstance().getString(ICicPreferenceConstants.LOG_LOCATION.key(), this.getAgentData(FILENAME_LOGS).toString());
    }

    private void setLogDirectory() {
        this.prevDefaultConsoleLogLevel = LogManager.setDefaultLevel((String)ConsoleLog.class.getName(), (int)Level.getLevel((String)AgentUserOptions.getAgentDefaultConsoleLogLevel()));
        LogManager.setDirectory((String)this.getLogDirectory());
        UserOptions.logNonDefaultUserOptions((boolean)true);
    }

    private void setProxyPreferences() {
        this.currentProxyPrefs = CicPreferenceManager.getInstance().getCurrentPreferenceHandler().getPreferences();
        PreferencesHolder.INSTANCE.add(this.currentProxyPrefs);
        this.defaultProxyPrefs = CicPreferenceManager.getInstance().getDefaultsPreferenceHandler().getPreferences();
        PreferencesHolder.INSTANCE.add(this.defaultProxyPrefs);
    }

    private void removeProxyPreferences() {
        if (this.currentProxyPrefs != null) {
            PreferencesHolder.INSTANCE.remove(this.currentProxyPrefs);
            this.currentProxyPrefs = null;
        }
        if (this.defaultProxyPrefs != null) {
            PreferencesHolder.INSTANCE.remove(this.defaultProxyPrefs);
            this.defaultProxyPrefs = null;
        }
    }

    public File getLicensePolicyFile() {
        File policyFileDir = this.getAgentDataLicenseLocation();
        policyFileDir.mkdirs();
        Path agentDataLicensePath = new Path(policyFileDir.getAbsolutePath());
        File policyFile = LicUserUtils.getInstallTimeLicensePolicyFile((IPath)agentDataLicensePath).toFile();
        return policyFile;
    }

    public void setLicenseSettings(LicensePolicyData policyData) throws IOException {
        File policyFile = this.getLicensePolicyFile();
        LicensePolicyDataWriter.write((File)policyFile, (LicensePolicyData)policyData);
        if (this.commandRecorder != null) {
            this.commandRecorder.setLicenseSettings(policyData);
        }
        PolicyManager.reload((String)this.getLicensePolicyFile().getAbsolutePath());
        InstallRegistry ir = InstallRegistry.getInstance();
        new InstallPublication(ir, ir.getProfileRegistry()).publish();
    }

    public IStatus setLicenseSettingsFromFile(String fileLocation) {
        return this.setLicenseSettingsFromFile(fileLocation, false);
    }

    public IStatus setLicenseSettingsFromFile(String fileLocation, boolean isMerge) {
        IStatus status = Status.OK_STATUS;
        if (fileLocation != null) {
            LicensePolicyDataParser parser = new LicensePolicyDataParser();
            try {
                URL rlfUrl = new URL(fileLocation);
                parser.parse(rlfUrl);
            }
            catch (MalformedURLException malformedURLException) {
                parser.parse(fileLocation);
            }
            try {
                LicensePolicyData data = parser.getLicensePolicyData();
                File existingFile = this.getLicensePolicyFile();
                if (isMerge && existingFile.exists()) {
                    LicensePolicyDataParser parserForExistingFile = new LicensePolicyDataParser();
                    parserForExistingFile.parse(existingFile.getAbsolutePath());
                    LicensePolicyData existingData = parserForExistingFile.getLicensePolicyData();
                    existingData.merge(data);
                    this.setLicenseSettings(existingData);
                } else {
                    this.setLicenseSettings(data);
                }
            }
            catch (IOException e) {
                return Statuses.ERROR.get((Throwable)e, e.getMessage(), new Object[0]);
            }
        }
        return status;
    }

    private void setLicenseSettings() {
        String remoteLicenseFile = CicPreferenceManager.getInstance().getString(ICicPreferenceConstants.PREF_LICENSE_POLICY_LOCATION.key(), null);
        this.setLicenseSettingsFromFile(remoteLicenseFile);
    }

    private String getAgentLauncher() {
        return AgentRelaunch.getInstance().getArgument("-launcher");
    }

    private IStatus setAgentLocation() {
        String launcherCommand = this.getAgentLauncher();
        String agentInstallLocation = null;
        if (launcherCommand != null) {
            String launcherLocation;
            agentInstallLocation = launcherLocation = PathUtil.removeSimpleName((String)launcherCommand);
        } else if (System.getProperty("jnlpx.jvm") != null) {
            try {
                Class<?> appFinderClass = Class.forName("com.ibm.cic.agent.internal.appfinder.AppFinder");
                Method m = appFinderClass.getMethod("getBase", new Class[0]);
                String baseApp = (String)m.invoke(appFinderClass, null);
                launcherCommand = "JNLP\n" + System.getProperty("jnlpx.home") + '\n' + baseApp + "/agentUI.jnlp";
            }
            catch (ClassNotFoundException e) {
                ExceptionUtil.debugLogToReview((Throwable)e);
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                ExceptionUtil.debugLogToReview((Throwable)e);
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                ExceptionUtil.debugLogToReview((Throwable)e);
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                ExceptionUtil.debugLogToReview((Throwable)e);
                e.printStackTrace();
            }
        } else {
            String jarName = System.getProperty("java.class.path");
            String javaHome = System.getProperty("java.home");
            launcherCommand = "JAVA\n" + javaHome + '\n' + jarName;
            File jarFile = new File(jarName);
            agentInstallLocation = jarFile.getParent();
        }
        if (launcherCommand == null) {
            launcherCommand = "NOT FOUND";
        }
        InstallRegistry.getInstance().setProperty(VAR_AGENT_LAUNCH_COMMAND, LogUtil.fixNewlines((String)launcherCommand));
        IStatus return_value = Status.OK_STATUS;
        if (agentInstallLocation == null) {
            agentInstallLocation = "NOT INSTALLED";
        }
        InstallRegistry.getInstance().setProperty(VAR_AGENT_INSTALL_LOCATION, agentInstallLocation);
        InstallRegistry.getInstance().setProperty(VAR_AGENT_APPDATA_LOCATION, CicCommonSettings.getApplicationDataLocation());
        return return_value;
    }

    private void createDirector() {
        if (this.director == null) {
            this.director = new Director(this);
        }
    }

    private IStatus initializeAgentProfile() {
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        Profile selfProfile = this.getAgentProfile();
        if (selfProfile == null) {
            return result;
        }
        IOffering agentOffering = this.getAgentOffering();
        if (agentOffering != null) {
            boolean doPurgeSelfProfile = false;
            File installLocation = new File(selfProfile.getInstallLocation());
            if (CmdLine.CL.reinstallIM()) {
                IStatus status = AgentInstall.getInstance().backupOriginalIM(installLocation, InstallRegistry.getInstance().getLocations());
                if (!status.isOK()) {
                    return status;
                }
                doPurgeSelfProfile = true;
            } else if (!installLocation.isDirectory()) {
                File parent = installLocation.getParentFile();
                boolean bl = doPurgeSelfProfile = !CicCommonSettings.getAccessRightsMode().isGroupMode() || parent == null || FileUtil.directoryIsWriteable((String)FileUtil.getCanonicalPath((File)parent));
            }
            if (doPurgeSelfProfile) {
                InstallRegistry.ProfileInstallRegistry registry = selfProfile.getInstallRegistry();
                this.purgeSelfProfile(selfProfile, registry);
                InstallRegistry.getInstance().removeProfile(selfProfile);
                try {
                    registry.commit(null);
                }
                catch (CoreException e) {
                    log.error((Throwable)e, com.ibm.cic.agent.internal.core.Messages.Profile_Error_Saving_Install_Registry, new Object[]{e.getMessage()});
                }
                return result;
            }
        }
        InstallRegistry.getInstance().setProperty(VAR_AGENT_INSTALL_LOCATION, selfProfile.getInstallLocation());
        if (selfProfile.getRootContext().getSubcontexts().length == 0) {
            File agentSelfLocation = new File(selfProfile.getInstallLocation());
            this.addSelfSubcontexts(selfProfile, agentSelfLocation);
        } else if (selfProfile.getData(SELF_CACHE_CLEAN_PROPERTY) != null && !AgentInstall.getInstance().isAgentInstallerRunning()) {
            this.checkIfRunningWithOldJRE(result);
            if (!result.isOK()) {
                return result;
            }
            if (Platform.getOS().equals("win32")) {
                this.findAndRemoveEclipseDll();
            }
            this.cleanAgentSelfCache(selfProfile);
            this.removeCleanOptionFromAllConfigIniFiles(this.getAgentSelfLocation());
            this.removeOldAgentJREs();
            this.updateOldAgentLauncherStuff();
            this.setRunAsAdminFlagsOnVista(selfProfile);
        }
        this.removeOldAgentLauncher();
        return result;
    }

    private void setRunAsAdminFlagsOnVista(Profile selfProfile) {
        if (CicCommonSettings.getAccessRightsMode().isAdminMode() && CicCommonSettings.isWindowsVistaOrSimilar()) {
            String execLocation = String.valueOf(selfProfile.getInstallLocation()) + "\\" + SWT_AGENT_LAUNCHER_NAME + ".exe";
            NativeUtils.regWrite((String)"HKLM\\Software\\Microsoft\\Windows NT\\CurrentVersion\\AppCompatFlags\\Layers", (String)execLocation, (String)"RUNASADMIN", null, (int)256);
        }
    }

    private void restoreHistory() {
        if (this.historyStore == null) {
            this.historyStore = new HistoryStore(this);
        }
    }

    public IStatus purgeAll(boolean preservePreferences) {
        IStatus status = this.acquireLock();
        if (status.isOK()) {
            try {
                status = this.start(false);
                if (status.isOK()) {
                    this.purgeCache();
                    this.purgeAllProfiles();
                    this.doAgentDataPurge();
                    this.deleteAllProfiles();
                    if (!preservePreferences) {
                        this.purgeCurrentUserPreferences();
                    }
                }
            }
            finally {
                this.stop(true);
            }
        }
        return status;
    }

    public File getInstallRegistryLocation() {
        return this.getAgentData(FILENAME_INSTALL_REGISTRY);
    }

    public File getAgentDataLicenseLocation() {
        String adpath = this.getAgentData(FILENAME_LICENSE).getParent();
        if (FileName.validateLumFileName((String)adpath)) {
            return this.getAgentData(FILENAME_LICENSE);
        }
        return new File(PPSettings.getPolicy().getNonDbcsLumPath(adpath), FILENAME_LICENSE);
    }

    public File getAgentBundleLocation() {
        return this.getAgentData(FILENAME_BUNDLES);
    }

    public CacheManager getAgentBundleCacheManager() {
        if (this.agentBundleCache == null) {
            this.agentBundleCache = new CacheManager(this.getAgentBundleLocation().getAbsolutePath(), BUNDLE_CACHE_NAME, BUNDLE_CACHE_DESCRIPTION);
        }
        return this.agentBundleCache;
    }

    public File getAgentSelfLocation() {
        File configLocation = EclipseUtil.getCurrentEclipseConfiguration();
        if (CmdLine.CL.isServerMode()) {
            configLocation = configLocation.getParentFile();
        }
        String agentSelfLocation = System.getProperty("AGENT_SELF_LOCATION", configLocation.getParent());
        File file = new File(agentSelfLocation);
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file;
        }
    }

    public File getAgentInstanceLocation() {
        File file = new File(EclipseUtil.getCurrentEclipseConfiguration().getParent());
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file;
        }
    }

    public boolean isAgentUpdatingItself() {
        return this.updatingAgent;
    }

    public boolean isAgentUninstallingItself() {
        return this.uninstallingAgent;
    }

    public void setAgentUninstallingItself(boolean uninstallingAgent) {
        this.uninstallingAgent = uninstallingAgent;
    }

    public CacheManager newAgentSelfCacheManager(String agentSelfLocation) {
        return new CacheManager(agentSelfLocation, SELF_CACHE_NAME, SELF_CACHE_DESCRIPTION){

            @Override
            public boolean preserveDownloadedArtifacts() {
                return false;
            }

            @Override
            public boolean keepDownloadedArtifacts(IStatus status, int downloadedCount, long downloadedSize, boolean defaultResponse) {
                return false;
            }

            @Override
            public IStatus purge(IProgressMonitor monitor) {
                if (Agent.this.updatingAgent || Agent.this.uninstallingAgent) {
                    return Status.OK_STATUS;
                }
                return super.purge(monitor);
            }

            @Override
            protected InstallRegistry.ProfileInstallRegistry[] getProfileInstallRegistries() {
                Profile selfProfile = Agent.this.getAgentProfile();
                return new InstallRegistry.ProfileInstallRegistry[]{selfProfile.getInstallRegistry()};
            }
        };
    }

    private CacheManager getAgentSelfCacheManager() {
        if (this.agentSelfCache == null) {
            this.agentSelfCache = this.newAgentSelfCacheManager(this.getAgentSelfLocation().getPath());
        }
        return this.agentSelfCache;
    }

    private void purgeCache() {
        Agent.purge(new File(CacheLocationManager.getInstance().getCacheLocation()));
    }

    private void purgeAllProfiles() {
        Profile[] profiles = InstallRegistry.getInstance().getProfiles();
        int i = 0;
        while (i < profiles.length) {
            String installLocation;
            if (!profiles[i].isAgentProfile() && (installLocation = profiles[i].getInstallLocation()) != null) {
                Agent.purge(new File(installLocation));
            }
            ++i;
        }
    }

    public void deleteProfile(Profile profile) {
        InstallRegistry.getInstance().removeProfile(profile);
    }

    public void deleteAllProfiles() {
        Profile[] profiles = InstallRegistry.getInstance().getProfiles();
        int i = 0;
        while (i < profiles.length) {
            if (!profiles[i].isAgentProfile()) {
                InstallRegistry.getInstance().removeProfile(profiles[i]);
            }
            ++i;
        }
    }

    public IStatus purgeAgentData() {
        IStatus status = this.acquireLock();
        if (status.isOK()) {
            try {
                IStatus startStatus = this.start(false);
                log.statusNotOK(startStatus);
                this.doAgentDataPurge();
            }
            finally {
                this.stop(true);
            }
        }
        return status;
    }

    private void doAgentDataPurge() {
        this.purgeAgentBundles();
        this.purgeAdaptorStorage();
        InstallRegistry.getInstance().purge();
        this.purgeProfileRegistry();
        this.purgeLogs();
        this.purgeTempDownloadInProgressArea();
        this.purgeHistories();
        this.purgeLicenses();
        this.purgeJavaTemp();
        Agent.purge(this.getAgentData("p2"));
    }

    private void purgeAdaptorStorage() {
        Agent.purge(this.getAgentData(FILENAME_ADAPTERS));
    }

    private void purgeAgentBundles() {
        Agent.purge(this.getAgentData(FILENAME_BUNDLES));
    }

    private void purgeProfileRegistry() {
        Profile[] profiles;
        Profile[] profileArray = profiles = InstallRegistry.getInstance().getProfiles();
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile profile = profileArray[n2];
            InstallRegistry.getInstance().removeProfile(profile);
            ++n2;
        }
    }

    private void purgeLogs() {
        Agent.purge(this.getAgentData(FILENAME_LOGS));
    }

    private void purgeTempDownloadInProgressArea() {
        TempUtil.UniqueTempDir utd = DownloadInProgressManager.getUniqueDownloadInProgressRoot(null, (int)8);
        Agent.purge(utd.getUniqueTempDir());
    }

    private void purgeCurrentUserPreferences() {
        Agent.purge(this.getAgentData(FILENAME_PREFERENCES));
        if (this.currentUserPreferences != null) {
            try {
                this.currentUserPreferences.clear();
            }
            catch (BackingStoreException bse) {
                log.error(com.ibm.cic.agent.internal.core.Messages.Agent_Error_Removing_Preference_Node, new Object[]{this.currentUserPreferences, bse});
            }
            this.currentUserPreferences = null;
        }
    }

    private void purgeHistories() {
        Agent.purge(this.getAgentData(FILENAME_HISTORIES));
        this.historyStore = null;
    }

    @Deprecated
    public void removeHistoryStore() {
        this.historyStore = null;
    }

    private void purgeLicenses() {
        Agent.purge(this.getAgentData(FILENAME_LICENSE));
        if (System.getProperty("PURGE_LIC") != null) {
            try {
                Agent.purge(this.getAgentDataLicenseLocation());
            }
            catch (Exception exception) {}
        }
    }

    private static boolean purge(File dirOrFile) {
        return FileUtil.rm_r((File)dirOrFile, (boolean)true);
    }

    public BundleContext getAgentBundleContext() {
        return AgentActivator.getDefault().getContext();
    }

    public IStatus resolve(IOfferingOrFix offeringOrFix, IProgressMonitor monitor) {
        return this.doResolve(offeringOrFix, SubMonitor.convert((IProgressMonitor)monitor, (int)1), 1);
    }

    private IStatus doResolve(IOfferingOrFix offeringOrFix, SubMonitor sm, int ticks) {
        if (offeringOrFix.isResolved()) {
            return Status.OK_STATUS;
        }
        sm.setTaskName(NLS.bind((String)com.ibm.cic.agent.internal.core.Messages.Agent_Resolving_References_In, (Object)offeringOrFix.getName()));
        IStatus status = RepositoryUtils.resolve((IOfferingOrFix)offeringOrFix, (IProgressMonitor)sm.newChild(ticks, 6));
        if (status.isOK() && offeringOrFix.getAssembly() == null) {
            status = Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.Agent_Failed_To_Resolve_Root_Asm, new Object[]{offeringOrFix.getName()});
        }
        log.statusNotOK(status);
        return status;
    }

    public static IOffering[] sort(IOffering[] offerings) {
        if (offerings == null || offerings.length < 2) {
            return offerings;
        }
        IOffering[] sorted = new IOffering[offerings.length];
        System.arraycopy(offerings, 0, sorted, 0, offerings.length);
        Arrays.sort(sorted, new OfferingComparator());
        return sorted;
    }

    public static boolean isSelfContainedOffering(IOffering offering) {
        String profileId = OfferingProperty.getDefaultProfile((IOfferingOrFix)offering);
        return profileId != null && profileId.trim().length() > 0;
    }

    public static boolean isExtensionOffering(IOfferingOrFix offeringOrFix) {
        return OfferingProperty.isExtension((IOfferingOrFix)offeringOrFix);
    }

    public Profile[] getRecommendedProfiles(IOffering[] offerings, Map profileStatusMap, IProgressMonitor monitor) throws CoreException {
        return new RecommendedProfiles(this, offerings, profileStatusMap).getRecommendedProfiles(monitor);
    }

    public IFeature[] getDefaultFeatures(UpdateOfferingJob job) {
        IOffering base = job.getUpdatedOffering();
        IOffering update = job.getOffering();
        Set newFeatures = OfferingUtil.toFeatures((IFeature[])OfferingUtil.getDefaultFeatures((ISelectionExpression.EvaluationContext)job, (IOffering)update));
        newFeatures.removeAll(OfferingUtil.toFeatures((IFeature[])OfferingUtil.getAllFeatures((IOffering)base)));
        Set features = this.getInstalledFeatures(job.getProfile(), base);
        features.retainAll(OfferingUtil.toFeatures((IFeature[])OfferingUtil.getAllFeatures((IOffering)update)));
        features.addAll(newFeatures);
        return OfferingUtil.toFeaturesAsArray((IOffering)update, (Set)OfferingUtil.toFeatureIdsFromFeatures((Collection)features));
    }

    public IStatus checkOfferingFeatureInterdependencies(Collection<AgentJob> jobs, IProgressMonitor monitor) {
        return new FeatureDependencyChecker(jobs).perform(monitor);
    }

    public IStatus checkPrerequisite(IFeatureBase featureBase, AgentJob job) {
        try {
            this.checkingPrerequisites = true;
            IStatus iStatus = featureBase.evaluateApplicability((ISelectionExpression.EvaluationContext)job);
            return iStatus;
        }
        finally {
            this.checkingPrerequisites = false;
        }
    }

    private boolean checkIfLibraryExistOnLinux(AgentJob a_job, String a_libName) {
        boolean return_value = true;
        String ldconfig = "ldconfig";
        if (new File("/sbin/ldconfig").exists()) {
            ldconfig = "/sbin/ldconfig";
        } else if (new File("/bin/ldconfig").exists()) {
            ldconfig = "/bin/ldconfig";
        }
        String[] cmdArray = new String[]{ldconfig, "-p"};
        StringWriter out = new StringWriter(4096);
        if (PlatformUtils.runProcess((String[])cmdArray, null, null, (Writer)out, (Writer)out) == 0) {
            String output = out.toString();
            if (output.contains("/" + a_libName)) {
                return true;
            }
        } else {
            File usrlib = a_job.getProfile().is64bit() ? new File("/usr/lib64") : new File("/usr/lib");
            return_value = new File(usrlib, a_libName).exists();
        }
        return return_value;
    }

    public ICicStatus checkLumRequiredLibs(AgentJob job) {
        IOffering offering = job.getOffering();
        if (CicCommonSettings.isLinux() && offering != null && LicenseUtils.isOfferingLumApplicable((IOffering)offering) && !this.checkIfLibraryExistOnLinux(job, "libstdc++.so.5")) {
            Version ofLumVersion = LicenseUtils.getOfferingLumVersion((IOffering)offering);
            if (ofLumVersion.compareTo(LicenseUtils.LICENSE_LUM_VERSION_DEFAULT) > 0) {
                if (!this.checkIfLibraryExistOnLinux(job, "libstdc++.so.6")) {
                    return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.Agent_Lum468_libs_Check_Failed_5or6, new Object[]{offering.getName()});
                }
            } else {
                return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.Agent_Lum468_libs_Check_Failed, new Object[]{offering.getName()});
            }
        }
        return ICicStatus.OK_STATUS;
    }

    private boolean suppressWebUISupportChecks() {
        return AgentUserOptions.CIC_SUPPRESS_WEB_UI_CHECKS.isSet();
    }

    public IStatus checkWebUISupported(IOfferingOrFix offering) {
        if (AgentInput.getInstance().getMode() != 3) {
            return Status.OK_STATUS;
        }
        if (offering == null || this.suppressWebUISupportChecks()) {
            return Status.OK_STATUS;
        }
        if (!OfferingOrFixProperty.supportsWebUI((IOfferingOrFix)offering)) {
            return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.Agent_WebUI_CheckFailed, new Object[]{offering.getName()});
        }
        return Status.OK_STATUS;
    }

    @Override
    public boolean isCheckingPrerequisites() {
        return this.checkingPrerequisites;
    }

    public IStatus computeAllFeaturesInterdependencies(Profile profile, IOffering offering, IProgressMonitor monitor) {
        SubMonitor sm;
        IStatus status = OfferingUtil.checkUniqueFeatureIds((IOffering)offering);
        if (status.isOK() && (status = this.doResolve((IOfferingOrFix)offering, sm = SubMonitor.convert((IProgressMonitor)monitor, (int)3), 2)).isOK()) {
            sm.setWorkRemaining(1);
            sm.setTaskName(NLS.bind((String)com.ibm.cic.agent.internal.core.Messages.Agent_Computing_InterFeature_Dependencies, (Object)offering.getName()));
            new FeatureDependencies(profile, offering).compute((IProgressMonitor)sm.newChild(1));
        }
        log.statusNotOK(status);
        return status;
    }

    public IStatus validate(IOffering offering, IProgressMonitor monitor) {
        return this.director.validate((IOfferingOrFix)offering, monitor);
    }

    public synchronized IStatus prepare(IOfferingOrFix toPrepare, String[] selectorIds, IProgressMonitor monitor) {
        return this.prepare(toPrepare, selectorIds, monitor, true);
    }

    public synchronized IStatus prepare(IOfferingOrFix toPrepare, String[] selectorIds, IProgressMonitor monitor, boolean showInternalVersions) {
        this.createDirector();
        return this.director.prepare(toPrepare, selectorIds, this.getNonNullAgentProfile(), monitor);
    }

    public synchronized IStatus prepareAgentBundles(IOfferingOrFix toPrepare, String[] agentBundleIds, String[] selectorIds, IProgressMonitor monitor) {
        return this.director.prepareAgentBundles(toPrepare, agentBundleIds, selectorIds, this.getNonNullAgentProfile(), monitor);
    }

    public synchronized IStatus prepareAgentBundles(IOfferingOrFix toPrepare, ISelectionExpression.ISelectedByBundle[] selectedBundles, IProgressMonitor monitor) {
        if (selectedBundles == null) {
            throw new IllegalArgumentException("selectedBundles cannot be null");
        }
        String[] bundleIds = new String[selectedBundles.length];
        int i = 0;
        while (i < selectedBundles.length) {
            bundleIds[i] = selectedBundles[i].getBundleId();
            ++i;
        }
        String[] selectorIds = null;
        return this.director.prepareAgentBundles(toPrepare, bundleIds, selectorIds, this.getNonNullAgentProfile(), monitor);
    }

    public IStatus unprepare(AgentJob[] jobs, IProgressMonitor monitor) {
        log.statusNotOK(this.restoreOriginalIM());
        if (jobs != null) {
            this.removeEmptyProfiles(jobs);
        }
        AgentInstall.getInstance().removeInstallerArtifactRepository();
        return this.director.completeSession(jobs, monitor);
    }

    public IStatus restoreOriginalIM() {
        IStatus status;
        block4: {
            if (!AgentInstall.getInstance().reinstallIM()) {
                return Status.OK_STATUS;
            }
            status = AgentInstall.getInstance().restoreOriginalIM();
            if (InstallRegistry.getInstance().isOpen()) {
                try {
                    InstallRegistry.getInstance().reload();
                }
                catch (CoreException e) {
                    if (!status.isOK()) break block4;
                    status = e.getStatus();
                }
            }
        }
        return status;
    }

    public IStatus unloadAgentBundles(IProgressMonitor monitor) {
        return this.director.completeSession(AgentJob.NO_JOBS, monitor);
    }

    public synchronized IStatus unloadAgentBundles(IOfferingOrFix toUnload, IProgressMonitor monitor) {
        return this.unloadAgentBundles(toUnload, null, null, monitor);
    }

    public synchronized IStatus unloadAgentBundles(IOfferingOrFix toUnload, String[] agentBundleIds, String[] selectorIds, IProgressMonitor monitor) {
        return this.director.unloadAgentBundles(toUnload, this.getNonNullAgentProfile(), agentBundleIds, selectorIds, monitor);
    }

    public IAssignedArtifacts collect(CicMultiStatus[] status, AgentJob[] jobs, IProgressMonitor monitor) {
        return this.director.collect(status, jobs, monitor);
    }

    public IStatus install(AgentJob job, IProgressMonitor monitor) {
        return this.install(new AgentJob[]{job}, null, null, monitor);
    }

    public IStatus install(AgentJob[] jobs, IProgressMonitor monitor) {
        return this.install(jobs, null, null, monitor);
    }

    public IStatus install(AgentJob[] jobs, IAssignedArtifacts collected, IProgressMonitor monitor) {
        return this.install(jobs, collected, null, monitor);
    }

    public IStatus install(AgentJob[] jobs, IAssignedArtifacts collected, IDisableCancel disableCancel, IProgressMonitor monitor) {
        if (jobs.length == 0) {
            return Status.OK_STATUS;
        }
        try {
            AgentUtil.setOnlyInstallingAgent(jobs);
            InstallJobTracker.INSTANCE.start(jobs);
            CicMultiStatus ms = Statuses.OK.getMultiStatus();
            CicMultiStatus validateStatus = AgentUtil.validateJobs(jobs, false);
            if (validateStatus.isErrorOrCancel()) {
                CicMultiStatus cicMultiStatus = Director.fixErrorMessage(validateStatus, jobs);
                return cicMultiStatus;
            }
            ms.add((IStatus)validateStatus);
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            IStatus locChecksStatus = LocationCheckManager.getInstance().initializeAndPerform(jobs, (IProgressMonitor)sm.newChild(5));
            if (StatusUtil.isErrorOrCancel((IStatus)locChecksStatus)) {
                IStatus iStatus = locChecksStatus;
                return iStatus;
            }
            ms.add(locChecksStatus);
            CicMultiStatus userDataStatus = AgentUtil.validateUserData(jobs, (IProgressMonitor)sm.newChild(1));
            if (StatusUtil.isErrorOrCancel((IStatus)userDataStatus)) {
                CicMultiStatus cicMultiStatus = Director.fixErrorMessage(userDataStatus, jobs);
                return cicMultiStatus;
            }
            ms.add((IStatus)userDataStatus);
            log.statusNotOK((IStatus)ms);
            if (this.commandRecorder != null) {
                this.commandRecorder.recordJobs(jobs, true);
            }
            this.logPreferences();
            this.removeEmptyProfileAdapterStorage(jobs);
            ms.add(this.director.install(jobs, collected, disableCancel, (IProgressMonitor)sm.newChild(99)));
            CicMultiStatus cicMultiStatus = ms;
            return cicMultiStatus;
        }
        finally {
            this.removeEmptyProfiles(jobs);
            AgentJob.unresolve(jobs);
            this.getJavaFileReplicator().cleanAllReplicas();
            InstallJobTracker.INSTANCE.end(jobs);
        }
    }

    public IStatus uninstall(AgentJob[] jobs, IAssignedArtifacts collected, IDisableCancel disableCancel, boolean record, IProgressMonitor monitor) {
        try {
            CicMultiStatus userDataStatus;
            InstallJobTracker.INSTANCE.start(jobs);
            CicMultiStatus validateStatus = AgentUtil.validateJobs(jobs, true);
            if (validateStatus.isErrorOrCancel()) {
                CicMultiStatus cicMultiStatus = validateStatus = Director.fixErrorMessage(validateStatus, jobs);
                return cicMultiStatus;
            }
            if (validateStatus.isWarning()) {
                log.status((IStatus)validateStatus);
            }
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            IStatus locChecksStatus = LocationCheckManager.getInstance().initializeAndPerform(jobs, (IProgressMonitor)sm.newChild(5));
            if (StatusUtil.isErrorOrCancel((IStatus)locChecksStatus)) {
                IStatus iStatus = locChecksStatus;
                return iStatus;
            }
            if (StatusUtil.isWarning((IStatus)locChecksStatus)) {
                log.status(locChecksStatus);
            }
            if (StatusUtil.isErrorOrCancel((IStatus)(userDataStatus = AgentUtil.validateUserData(jobs, (IProgressMonitor)sm.newChild(1))))) {
                CicMultiStatus cicMultiStatus = userDataStatus = Director.fixErrorMessage(userDataStatus, jobs);
                return cicMultiStatus;
            }
            if (userDataStatus.isWarning()) {
                log.status((IStatus)userDataStatus);
            }
            if (record && this.commandRecorder != null) {
                this.commandRecorder.recordJobs(jobs, false);
            }
            this.logPreferences();
            IStatus iStatus = this.director.uninstall(jobs, collected, disableCancel, (IProgressMonitor)sm.newChild(99));
            return iStatus;
        }
        finally {
            this.removeEmptyProfiles(jobs);
            AgentJob.unresolve(jobs);
            this.getJavaFileReplicator().cleanAllReplicas();
            InstallJobTracker.INSTANCE.end(jobs);
        }
    }

    public IStatus uninstall(AgentJob[] jobs, IProgressMonitor monitor) {
        return this.uninstall(jobs, null, null, true, monitor);
    }

    public IStatus uninstall(AgentJob[] jobs, boolean record, IProgressMonitor monitor) {
        return this.uninstall(jobs, null, null, record, monitor);
    }

    public IStatus uninstall(AgentJob[] jobs, IAssignedArtifacts collected, IDisableCancel disableCancel, IProgressMonitor monitor) {
        return this.uninstall(jobs, collected, disableCancel, true, monitor);
    }

    public IStatus uninstall(AgentJob[] jobs, IAssignedArtifacts collected, IProgressMonitor monitor) {
        return this.uninstall(jobs, collected, null, true, monitor);
    }

    public IStatus checkInstall(AgentJob[] jobs, IProgressMonitor monitor) {
        return this.director.checkJobs(true, jobs, monitor);
    }

    public IStatus checkUninstall(AgentJob[] jobs, IProgressMonitor monitor) {
        return this.director.checkJobs(false, jobs, monitor);
    }

    public IPurgeableFiles determinePurgeableFiles(IProgressMonitor monitor) throws CoreException {
        if (!CacheManager.hasDefaultCache()) {
            return new IPurgeableFiles(){

                @Override
                public int getFileCount() {
                    return 0;
                }

                @Override
                public long getTotalSize() {
                    return 0L;
                }

                @Override
                public IStatus purgeFiles(IProgressMonitor aMonitor) {
                    return Status.OK_STATUS;
                }
            };
        }
        IStatus status = CacheManager.setDefaultInstance();
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        try {
            IPurgeableFiles iPurgeableFiles = CacheManager.getDefaultInstance().determinePurgeableFiles(monitor);
            return iPurgeableFiles;
        }
        finally {
            CacheManager.clearDefaultInstance();
            InstallRegistry.getInstance().cleanup();
            MemoryCleanup.start();
        }
    }

    public void addProfile(Profile toAdd) {
        InstallRegistry.getInstance().addProfile(toAdd);
    }

    public IStatus qualifyNewProfile(Profile profile) {
        IInstallAdaptor[] allAdaptors;
        IInstallAdaptor[] iInstallAdaptorArray = allAdaptors = AdaptorManager.getInstance().getAllAdaptors();
        int n = allAdaptors.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallAdaptor adaptor = iInstallAdaptorArray[n2];
            IStatus status = adaptor.qualifyNewProfile(profile);
            if (!status.isOK()) {
                return status;
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    public IStatus initializeNewProfile(Profile profile) {
        IInstallAdaptor[] allAdaptors;
        IInstallAdaptor[] iInstallAdaptorArray = allAdaptors = AdaptorManager.getInstance().getAllAdaptors();
        int n = allAdaptors.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallAdaptor adaptor = iInstallAdaptorArray[n2];
            IStatus status = adaptor.initializeNewProfile(profile);
            if (!status.isOK()) {
                return status;
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    public IStatus qualifyNewOffering(Profile profile, IOffering offering) {
        IInstallAdaptor[] allAdaptors;
        IStatus result = Status.OK_STATUS;
        ICicStatus status = this.checkOfferingLocaleSetApplicability(profile, offering);
        if (status.matches(12)) {
            return status;
        }
        if (status.matches(2)) {
            result = status;
        }
        IInstallAdaptor[] iInstallAdaptorArray = allAdaptors = AdaptorManager.getInstance().getAllAdaptors();
        int n = allAdaptors.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallAdaptor adaptor = iInstallAdaptorArray[n2];
            status = adaptor.qualifyNewOffering(profile, offering);
            if (status.matches(12)) {
                return status;
            }
            ++n2;
        }
        return result;
    }

    private ICicStatus checkOfferingLocaleSetApplicability(Profile profile, IOffering offering) {
        if (this.isAgentOffering((IOfferingOrFix)offering)) {
            return ICicStatus.OK_STATUS;
        }
        Set supportedLocales = OfferingProperty.getSupportedLocales((IOffering)offering);
        Set profileLocales = ProfileLanguageUtils.convertCodeStringToSet((String)profile.getData("cic.selector.nl"));
        profileLocales.removeAll(supportedLocales);
        if (profileLocales.isEmpty()) {
            return ICicStatus.OK_STATUS;
        }
        String profileName = profile.getProfileId();
        String offeringName = offering.getName();
        return Statuses.WARNING.get(com.ibm.cic.agent.internal.core.Messages.Agent_unsupportedLanguageInProfile, new Object[]{offeringName, profileName});
    }

    private void removeEmptyProfiles(AgentJob[] jobs) {
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            Profile profile = job.getProfile();
            if (this.canRemoveProfile(profile)) {
                IStatus status = this.removeProfile(profile);
                log.statusNotOK(status);
                status = profile.cleanDataLocation();
                log.statusNotOK(status);
            }
            ++n2;
        }
    }

    private void removeEmptyProfileAdapterStorage(AgentJob[] jobs) {
        AgentJob[] agentJobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            AgentJob job = agentJobArray[n2];
            Profile profile = job.getProfile();
            if (this.canRemoveProfile(profile)) {
                IStatus status = this.removeProfileAdapterStorageWithStatus(profile);
                log.statusNotOK(status);
            }
            ++n2;
        }
    }

    public boolean canRemoveProfile(Profile profile) {
        return profile.getInstallRegistry().isEmpty() && !Agent.getInstance().isAgentUninstallingItself();
    }

    private boolean removeProfileAdapterStorage(Profile profile) {
        IInstallAdaptor[] allAdaptors;
        boolean deletedAll = true;
        IInstallAdaptor[] iInstallAdaptorArray = allAdaptors = AdaptorManager.getInstance().getAllAdaptors();
        int n = allAdaptors.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallAdaptor adaptor = iInstallAdaptorArray[n2];
            File adapterProfileData = profile.getAdapterStorage(adaptor.getId());
            deletedAll &= Agent.purge(adapterProfileData);
            ++n2;
        }
        return deletedAll;
    }

    private IStatus removeProfileAdapterStorageWithStatus(Profile profile) {
        if (this.removeProfileAdapterStorage(profile)) {
            return Status.OK_STATUS;
        }
        return Statuses.WARNING.get(com.ibm.cic.agent.internal.core.Messages.Agent_Did_Not_Clean_Profile_Directory, new Object[]{profile.getDataLocation(), profile.getProfileId()});
    }

    public IStatus removeProfile(Profile profile) {
        if (this.canRemoveProfile(profile)) {
            InstallRegistry.getInstance().removeProfile(profile);
            return this.removeProfileAdapterStorageWithStatus(profile);
        }
        return Statuses.ST.createMultiStatus(NLS.bind((String)com.ibm.cic.agent.internal.core.Messages.Agent_Profile_Not_Empty, (Object)profile, (Object)profile.getInstallRegistry().contentsToString()), new Object[0]);
    }

    public Collection findAllOfferings(boolean resolveAll, IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)(resolveAll ? 2 : 1));
        List offerings = UpdateOfferingUtils.getAllOfferingsAndTheirUpdates((IRepository)this.getRepositoryGroup(), (boolean)true, (IProgressMonitor)sm.newChild(1));
        if (resolveAll) {
            SubMonitor sm2 = SubMonitor.convert((IProgressMonitor)sm.newChild(1), (int)offerings.size());
            for (IOffering offering : offerings) {
                log.statusNotOK(RepositoryUtils.resolve((IOfferingOrFix)offering, (IProgressMonitor)sm2.newChild(1)));
            }
        }
        return offerings;
    }

    public List<IFix> findAllFixes(boolean includeUnavailable, IProgressMonitor pm) {
        return OfferingUtil.filterAllButLatest((Collection)this.getRepositoryGroup().getAllFixes(includeUnavailable, pm));
    }

    public IOffering findOffering(IIdentity id, Version version) {
        return this.getRepositoryGroup().findOffering(id, version, null);
    }

    public IOfferingOrFix findOfferingOrFix(IIdentity id, Version version, IProgressMonitor progressMonitor) {
        return this.findOfferingOrFix(false, id, version, progressMonitor);
    }

    public IOfferingOrFix findOfferingOrFix(boolean includeUnavailable, IIdentity id, Version version, IProgressMonitor progressMonitor) {
        return UpdateOfferingUtils.findOfferingOrUpdateOrFix((boolean)includeUnavailable, (IRepository)this.getRepositoryGroup(), (IIdentity)id, (Version)version, (IProgressMonitor)progressMonitor);
    }

    public IOffering findLatestOfferingOrUpdate(IIdentity offeringId, VersionRange tolerance, IProgressMonitor monitor) {
        if (offeringId == null) {
            throw new NullPointerException("offeringId must not be null");
        }
        if (offeringId.getId() == null) {
            throw new NullPointerException("offeringId.getId() must not be null");
        }
        if (tolerance == null) {
            tolerance = VersionRange.emptyRange;
        }
        Collection allOfferings = this.findAllOfferings(false, monitor);
        IOffering latestOffering = null;
        for (IOffering offering : allOfferings) {
            if (!offering.getIdentity().equals(offeringId) || !tolerance.isIncluded(offering.getVersion()) || latestOffering != null && offering.compareVersion((IContent)latestOffering) <= 0) continue;
            latestOffering = offering;
        }
        return latestOffering;
    }

    public List findLatestOfferingOrUpdateFix(String offeringOrFixId, IProgressMonitor progressMonitor) {
        return this.findLatestOfferingOrUpdateFix(offeringOrFixId, progressMonitor, InstallFixesAction.ALL);
    }

    public List findLatestOfferingOrUpdateFix(String offeringOrFixId, IProgressMonitor progressMonitor, InstallFixesAction installFixes) {
        List offerings = this.getRepositoryGroup().getAllOfferings(true, progressMonitor);
        IOffering latestOfferingOrFix = null;
        IOffering latestUnavailable = null;
        for (IOffering offering : offerings) {
            if (!offeringOrFixId.equals(offering.getIdentity().getId())) continue;
            if (UnavailableUtils.isUnavailable((IContent)offering)) {
                if (latestUnavailable != null && offering.compareVersion((IContent)latestUnavailable) <= 0) continue;
                latestUnavailable = offering;
                continue;
            }
            if (latestOfferingOrFix != null && offering.compareVersion((IContent)latestOfferingOrFix) <= 0) continue;
            latestOfferingOrFix = offering;
        }
        List updateOfferings = this.getRepositoryGroup().getAllUpdates(true, null, null, progressMonitor);
        for (IOffering updateOffering : updateOfferings) {
            if (!offeringOrFixId.equals(updateOffering.getIdentity().getId()) || AgentUtil.isSyncOffering(updateOffering)) continue;
            if (UnavailableUtils.isUnavailable((IContent)updateOffering)) {
                if (latestUnavailable != null && updateOffering.compareVersion((IContent)latestUnavailable) <= 0) continue;
                latestUnavailable = updateOffering;
                continue;
            }
            if (latestOfferingOrFix != null && updateOffering.compareVersion((IContent)latestOfferingOrFix) <= 0) continue;
            latestOfferingOrFix = updateOffering;
        }
        if (latestOfferingOrFix == null) {
            List fixes = this.getRepositoryGroup().getAllFixes(progressMonitor);
            for (IFix fix : fixes) {
                if (!offeringOrFixId.equals(fix.getIdentity().getId())) continue;
                if (UnavailableUtils.isUnavailable((IContent)fix)) {
                    if (latestUnavailable != null && fix.compareVersion((IContent)latestUnavailable) <= 0) continue;
                    latestUnavailable = fix;
                    continue;
                }
                if (latestOfferingOrFix != null && fix.compareVersion((IContent)latestOfferingOrFix) <= 0) continue;
                latestOfferingOrFix = fix;
            }
        }
        ArrayList<Object> returnValue = new ArrayList<Object>();
        if (latestOfferingOrFix == null) {
            if (latestUnavailable != null) {
                latestOfferingOrFix = latestUnavailable;
            }
        } else if (latestUnavailable != null && latestUnavailable.compareVersion((IContent)latestOfferingOrFix) > 0) {
            returnValue.add(latestUnavailable);
        }
        if (latestOfferingOrFix != null) {
            returnValue.add(latestOfferingOrFix);
            if (latestOfferingOrFix instanceof IOffering) {
                returnValue.addAll(this.addApplicableFixes(latestOfferingOrFix, progressMonitor, installFixes));
            }
        }
        return returnValue;
    }

    public List<IFix> addApplicableFixes(IOffering offering, IProgressMonitor progressMonitor, InstallFixesAction installFixes) {
        if (InstallFixesAction.ALL.equals(installFixes)) {
            return this.findFixes(offering, progressMonitor);
        }
        if (InstallFixesAction.RECOMMENDED.equals(installFixes)) {
            CicMultiStatus status = Statuses.ST.createMultiStatus();
            return this.getRecommendedFixes(offering, status, progressMonitor);
        }
        return Collections.emptyList();
    }

    public List<IFix> addAllApplicableFixes(IProgressMonitor progressMonitor, InstallFixesAction installFixes, IProfile profile) {
        if (InstallFixesAction.NONE.equals(installFixes)) {
            return Collections.emptyList();
        }
        List<IFix> fixes = this.findAllFixes(false, progressMonitor);
        List<IFix> applicableFixesBySupportedPlatforms = this.filterSupportedPlatformFixes(fixes, profile);
        if (InstallFixesAction.RECOMMENDED.equals(installFixes)) {
            CicMultiStatus status = Statuses.ST.createMultiStatus();
            return this.filterRecommendedFixes(applicableFixesBySupportedPlatforms, status, progressMonitor);
        }
        return applicableFixesBySupportedPlatforms;
    }

    private List<IFix> filterSupportedPlatformFixes(Collection<IFix> fixes, IProfile profile) {
        ArrayList<IFix> applicableFixesBySupportedPlatforms = new ArrayList<IFix>(fixes.size());
        for (IFix fix : fixes) {
            if (!BitModeUtils.checkSupportedPlatformsAgainstProfile((IOfferingOrFix)fix, profile).isOK()) continue;
            applicableFixesBySupportedPlatforms.add(fix);
        }
        return applicableFixesBySupportedPlatforms;
    }

    private Profile[] getNormalProfiles(boolean checkVisible) {
        Profile[] profiles = null;
        profiles = checkVisible ? this.getVisibleProfiles() : this.getProfiles();
        ArrayList<Profile> result = new ArrayList<Profile>(profiles.length);
        Profile[] profileArray = profiles;
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile profile = profileArray[n2];
            String profileKind = profile.getProfileKind();
            if (!profileKind.equals("self") && !profileKind.equals(FILENAME_LICENSE)) {
                result.add(profile);
            }
            ++n2;
        }
        return result.toArray(new Profile[result.size()]);
    }

    public Profile[] getNormalProfiles() {
        return this.getNormalProfiles(false);
    }

    public Profile[] getSortedProductProfiles(boolean uninstall) {
        return Agent.sortProfiles(this.getNormalProfiles(true), uninstall);
    }

    public Profile[] getSortedProfiles(boolean uninstall) {
        return Agent.sortProfiles(this.getProfiles(), uninstall);
    }

    private static Profile[] sortProfiles(Profile[] profiles, boolean uninstall) {
        SortUtil.ProfileSorter sorter = new SortUtil.ProfileSorter();
        Profile[] profileArray = profiles;
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile profile = profileArray[n2];
            IOffering[] iOfferingArray = profile.getInstallRegistry().getInstalledOfferings();
            int n3 = iOfferingArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IOffering offering = iOfferingArray[n4];
                sorter.add(profile, (IOfferingOrFix)offering);
                ++n4;
            }
            ++n2;
        }
        List<Profile> result = sorter.getSortedProfiles(uninstall);
        return result.toArray(new Profile[result.size()]);
    }

    public Profile[] getProfiles() {
        return InstallRegistry.getInstance().getProfiles();
    }

    @Override
    public IProfile[] getAllProfiles() {
        return this.getProfiles();
    }

    public Profile[] getVisibleProfiles() {
        Profile[] allProfiles;
        ArrayList<Profile> result = new ArrayList<Profile>();
        Profile[] profileArray = allProfiles = this.getProfiles();
        int n = allProfiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile profile = profileArray[n2];
            if (profile.shouldBeVisible()) {
                result.add(profile);
            }
            ++n2;
        }
        return result.toArray(new Profile[result.size()]);
    }

    public Profile getProfile(String id) {
        Profile profile = InstallRegistry.getInstance().getProfile(id);
        return profile;
    }

    public Profile getProfileByInstallLocation(String installLocation) {
        return InstallRegistry.getInstance().getProfileRegistry().getProfileByInstallLocation(installLocation);
    }

    public List getProfilesByOfferingOrFixId(String offeringId) {
        return InstallRegistry.getInstance().getProfileRegistry().getProfilesByOfferingOrFixId(offeringId);
    }

    @Override
    public IProfile findProfile(String id) {
        return this.getProfile(id);
    }

    public Profile getAgentProfile() {
        Profile[] profiles;
        Profile[] profileArray = profiles = this.getProfiles();
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile profile = profileArray[n2];
            if (profile.isAgentProfile()) {
                return profile;
            }
            ++n2;
        }
        return null;
    }

    public Profile getNonNullAgentProfile() {
        Profile selfProfile = this.getAgentProfile();
        if (selfProfile == null) {
            selfProfile = InstallRegistry.getInstance().getPhantomAgentProfile();
        }
        return selfProfile;
    }

    private void addSelfSubcontexts(Profile selfProfile, File agentSelfLocation) {
        File configurationLocation = new File(agentSelfLocation, "configuration");
        selfProfile.getRootContext().addAdaptorType("eclipse");
        selfProfile.getRootContext().setLocalProperty("configLocation", configurationLocation.getPath());
    }

    public IOffering getAgentOffering() {
        Profile agentProfile = this.getAgentProfile();
        IOffering installedAgentOffering = null;
        if (agentProfile != null) {
            installedAgentOffering = this.getInstalledOffering(agentProfile, (IIdentity)new SimpleIdentity("com.ibm.cic.agent"));
        }
        return installedAgentOffering;
    }

    private void logAgentVersions() {
        if (!this.agentVersionsLogged) {
            log.info(NLS.bind((String)com.ibm.cic.agent.internal.core.Messages.Agent_runningAgentDetails, (Object)AgentSettings.getRunningAgentInternalVersionStr(), (Object)AgentSettings.getRunningAgentVersionStr()));
            this.agentVersionsLogged = true;
            String userAgent = NLS.bind((String)"IBM Installation Manager/{1}({0})", (Object)AgentSettings.getRunningAgentInternalVersionStr(), (Object)AgentSettings.getRunningAgentVersionStr());
            HttpUserAgent.INSTANCE.setUserAgent(userAgent);
        }
    }

    public boolean addRepository(String serializeRepositoryInfo) {
        StringTokenizer st = new StringTokenizer(serializeRepositoryInfo, ";");
        while (st.hasMoreTokens()) {
            String serializedRepInfo = st.nextToken();
            if (this.getRepositoryGroup().addExistingRepository(serializedRepInfo, false) != null) continue;
            return false;
        }
        return true;
    }

    private File getAgentData(String key) {
        this.initializeAgentPreferences();
        return new File(CicCommonSettings.getApplicationDataLocation(), key);
    }

    public IFix[] getInstalledFixes(Profile profile) {
        return profile.getInstallRegistry().getInstalledFixes();
    }

    public IFix[] getInstalledFixes(Profile profile, IOffering offering) {
        return profile.getInstallRegistry().getInstalledFixes(offering);
    }

    public IOffering[] getInstalledOfferingsForFix(Profile profile, IFix fix) {
        IOffering[] offerings = profile.getInstallRegistry().getInstalledOfferings();
        ArrayList<IOffering> list = new ArrayList<IOffering>(offerings.length);
        IOffering[] iOfferingArray = offerings;
        int n = offerings.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering offering = iOfferingArray[n2];
            if (FixUtil.isFixApplicable((IFix)fix, (IOffering)offering)) {
                list.add(offering);
            }
            ++n2;
        }
        return list.toArray(new IOffering[list.size()]);
    }

    public IOffering getInstalledOffering(Profile profile, IIdentity id) {
        return profile.getInstallRegistry().getInstalledOffering(id);
    }

    @Override
    public IOffering findInstalledOffering(IProfile profile, IIdentity id) {
        return this.getInstalledOffering((Profile)profile, id);
    }

    public IOffering[] getInstalledOfferings(Profile profile, IIdentity id) {
        return profile.getInstallRegistry().getInstalledOfferings(id);
    }

    public IOffering[] getInstalledOfferings(Profile profile) {
        return InstallRegistry.getInstance().hasProfile(profile) ? profile.getInstallRegistry().getInstalledOfferings() : new IOffering[]{};
    }

    public Set getInstalledFeatures(Profile profile, IOffering offering) {
        return profile.getInstallRegistry().getInstalledFeatures(offering);
    }

    @Override
    public IFeature[] getInstalledFeatures(IProfile profile, IOffering offering) {
        return OfferingUtil.toFeaturesAsArray((Collection)this.getInstalledFeatures((Profile)profile, offering));
    }

    public boolean isRollbackAllowed(Profile profile, IOffering toOffering) {
        if (!profile.getInstallRegistry().isInstalled(toOffering)) {
            throw new IllegalArgumentException(toOffering.toString());
        }
        if (profile.isAgentProfile()) {
            return false;
        }
        IOffering fromOffering = this.getInstalledOffering(profile, toOffering.getIdentity());
        return OfferingProperty.isRollbackAllowed((IOffering)fromOffering, (Version)toOffering.getVersion());
    }

    public boolean isAgentOffering(IOfferingOrFix offeringOrFix) {
        if (!(offeringOrFix instanceof IOffering)) {
            return false;
        }
        IOffering offering = (IOffering)offeringOrFix;
        return "com.ibm.cic.agent".equals(offering.getIdentity().getId());
    }

    public boolean isAgentOfferingHidden() {
        String agentHiddenStr = System.getProperty("com.ibm.cic.agent.hidden");
        boolean agentHidden = agentHiddenStr == null ? true : Boolean.valueOf(agentHiddenStr);
        return agentHidden;
    }

    public IShareableEntity[] getInstalledShareableEntities(Profile profile) {
        ExpansionResult expansionResult = ExpansionResult.expand(profile, null);
        List ses = ExpanderUtils.getAllShareableEntities((IContextState)expansionResult.getRootContext());
        return ses.toArray(new IShareableEntity[ses.size()]);
    }

    public MaxInstallSizeInfo getSizeInfo(AgentJob[] jobs, IProgressMonitor monitor) {
        SizeInfo profileSize = new SizeInfo();
        MaxInstallSizeInfo cacheSize = new MaxInstallSizeInfo();
        this.getSizeInfo(jobs, profileSize, cacheSize, monitor);
        MaxInstallSizeInfo totalSize = new MaxInstallSizeInfo(profileSize);
        totalSize.add(cacheSize);
        return totalSize;
    }

    public void getSizeInfo(AgentJob[] jobs, SizeInfo profileSize, MaxInstallSizeInfo cacheSize, IProgressMonitor monitor) {
        this.director.getSizeInfo(jobs, profileSize, cacheSize, monitor);
    }

    public IOffering[] findUpdates(Profile profile, IOffering offering, IProgressMonitor monitor) {
        return this.findUpdates(false, profile, offering, monitor);
    }

    public IOffering[] findUpdates(boolean includeUnavailable, Profile profile, IOffering offering, IProgressMonitor monitor) {
        Check.notNull((Object)offering);
        if (!profile.getInstallRegistry().isInstalled(offering)) {
            return new IOffering[0];
        }
        List offeringsOfSameId = UpdateOfferingUtils.findAllOfferingsAndTheirUpdates((boolean)includeUnavailable, (IRepository)this.getRepositoryGroup(), (IIdentity)offering.getIdentity(), (Version)offering.getVersion(), (boolean)true, (IProgressMonitor)monitor);
        TreeSet<IOffering> result = new TreeSet<IOffering>(new Comparator(){

            public int compare(Object o1, Object o2) {
                IOffering of1 = (IOffering)o1;
                IOffering of2 = (IOffering)o2;
                return of1.compareVersion((IContent)of2);
            }
        });
        for (IOffering off : offeringsOfSameId) {
            if (off.compareVersion((IContent)offering) <= 0) continue;
            result.add(off);
        }
        return OfferingUtil.toOfferingArray(result);
    }

    public List<IFix> getRecommendedFixes(IOffering offering, CicMultiStatus returnStatus, IProgressMonitor monitor) {
        List<IFix> fixes = this.findFixes(offering, monitor);
        return this.filterRecommendedFixes(fixes, returnStatus, monitor);
    }

    private List<IFix> filterRecommendedFixes(List<IFix> unfilteredFixes, CicMultiStatus returnStatus, IProgressMonitor monitor) {
        ArrayList<IFix> result = new ArrayList<IFix>(unfilteredFixes.size());
        for (IFix fix : unfilteredFixes) {
            IStatus betaStatus = this.checkBetaRequirement((IOfferingOrFix)fix);
            if (betaStatus.isOK()) {
                if (!FixProperty.isRecommended((IFix)fix)) continue;
                result.add(fix);
                continue;
            }
            returnStatus.add(betaStatus);
        }
        return result;
    }

    public Map getRecommendedUpdates(Profile profile, CicMultiStatus returnStatus, IProgressMonitor monitor) {
        IOffering[] installed = this.getInstalledOfferings(profile);
        HashMap<IIdentity, IOffering> result = new HashMap<IIdentity, IOffering>(installed.length);
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, installed.length);
        IOffering[] iOfferingArray = installed;
        int n = installed.length;
        int n2 = 0;
        while (n2 < n) {
            IOffering element = iOfferingArray[n2];
            IOffering[] updates = this.findUpdates(profile, element, spm.next());
            int j = updates.length - 1;
            while (j >= 0) {
                ICicStatus privilegeStatus;
                IOffering update = updates[j];
                if (OfferingProperty.hasUnacceptableRequirementForUserRights((IOffering)update)) {
                    privilegeStatus = Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.OfferingsRequireAdminRights, new Object[]{OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)update)});
                    returnStatus.add((IStatus)privilegeStatus);
                } else if (OfferingProperty.hasUnacceptableRequirementForGroupMode((IOfferingOrFix)update)) {
                    privilegeStatus = Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.OfferingsDoNotSupportGroupMode, new Object[]{OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)update)});
                    returnStatus.add((IStatus)privilegeStatus);
                } else {
                    IStatus betaStatus = this.checkBetaRequirement((IOfferingOrFix)update);
                    if (!betaStatus.isOK()) {
                        returnStatus.add(betaStatus);
                    } else if (!OfferingProperty.isSupportedOS((IOffering)update)) {
                        String supportedOSList = OfferingProperty.getSupportedOS((IOffering)update);
                        ICicStatus nonSupportedOSStatus = Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.OfferingNotSupportOSMsg, new Object[]{OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)update), Platform.getOS(), supportedOSList});
                        returnStatus.add((IStatus)nonSupportedOSStatus);
                    } else {
                        IStatus platformsStatus = BitModeUtils.checkSupportedPlatforms((IOfferingOrFix)update);
                        if (!platformsStatus.isOK()) {
                            returnStatus.add(platformsStatus);
                        } else {
                            IStatus archStatus = SliceUtils.checkPlatform((IOfferingOrFix)update, (String)profile.getOS(), (String)profile.getArch());
                            if (!archStatus.isOK()) {
                                returnStatus.add(archStatus);
                            } else if (!UnavailableUtils.isUnavailable((IContent)update)) {
                                result.put(update.getIdentity(), update);
                                break;
                            }
                        }
                    }
                }
                --j;
            }
            ++n2;
        }
        spm.done();
        return result;
    }

    public List<IFix> findFixes(IOffering offering, IProgressMonitor monitor) {
        return this.findFixes(false, offering, monitor);
    }

    public List<IFix> findFixes(boolean includeUnavailable, IOffering offering, IProgressMonitor monitor) {
        ArrayList<IFix> result = new ArrayList<IFix>();
        for (IFix fix : this.findAllFixes(includeUnavailable, monitor)) {
            if (!FixUtil.isFixApplicable((IFix)fix, (IOffering)offering)) continue;
            result.add(fix);
        }
        return result;
    }

    public List<IFix> findFixesForCurrentPlatform(IOffering offering, IProgressMonitor monitor) {
        ArrayList<IFix> result = new ArrayList<IFix>();
        for (IFix fix : this.findAllFixes(false, monitor)) {
            if (!FixUtil.isFixApplicable((IFix)fix, (IOffering)offering) || !BitModeUtils.checkFixSupportedPlatforms(fix, offering)) continue;
            result.add(fix);
        }
        return result;
    }

    public List<IFix> findFixesForProfile(IOffering offering, IProgressMonitor monitor, IProfile profile) {
        return this.findFixesForProfile(false, offering, monitor, profile);
    }

    public List<IFix> findFixesForProfile(boolean includeUnavailable, IOffering offering, IProgressMonitor monitor, IProfile profile) {
        ArrayList<IFix> result = new ArrayList<IFix>();
        for (IFix fix : this.findAllFixes(includeUnavailable, monitor)) {
            if (!FixUtil.isFixApplicable((IFix)fix, (IOffering)offering) || !AgentUserOptions.CIC_SUPPRESS_PLATFORM_CHECKS.isSet() && !BitModeUtils.checkSupportedPlatformsAgainstProfile((IOfferingOrFix)fix, profile).isOK()) continue;
            result.add(fix);
        }
        return result;
    }

    public IRepositoryGroup getRepositoryGroup() {
        return this.getRepositoryGroupAndStatus(false, (IProgressMonitor)new NullProgressMonitor()).getRepositoryGroup();
    }

    private IRepositoryGroup getAgentRepositoryGroup() {
        return this.getAgentRepositoryGroupAndStatus(false, (IProgressMonitor)new NullProgressMonitor()).getRepositoryGroup();
    }

    public boolean isRepositoryGroupSet() {
        return this.agentRepositoryGroup != null;
    }

    public void resetRepositoryGroup() {
        if (this.isRepositoryGroupSet()) {
            this.agentRepositoryGroup.removeAllRepositories();
            this.agentRepositoryGroup = null;
            this.agentRepositoryGroupStatus = null;
        }
    }

    public IStatus getRepositoryGroupStatus(boolean doConfigureRepGroup, IProgressMonitor monitor) {
        return this.getRepositoryGroupAndStatus(doConfigureRepGroup, monitor).getStatus();
    }

    public IStatus validateAgentGroupRepo(IRepository repoToValidate, IProgressMonitor monitor) {
        if (this.externalRepositoryGroup != null) {
            return Status.OK_STATUS;
        }
        if (!this.isRepositoryGroupSet()) {
            this.configureRepositoryGroup(monitor);
        }
        RememberDownloadUserPrompts rememberPrompts = new RememberDownloadUserPrompts();
        try {
            SplitProgressMonitor spm = new SplitProgressMonitor(monitor, this.agentRepositoryGroup.size());
            IRepositoryIdentity repoToValidateId = (IRepositoryIdentity)repoToValidate.getAdapter(IRepositoryIdentity.class);
            for (IRepository repo : this.agentRepositoryGroup) {
                IRepositoryIdentity repoId = (IRepositoryIdentity)repo.getAdapter(IRepositoryIdentity.class);
                if (repoId.equals((Object)repoToValidateId)) {
                    IStatus status = repo.getStatus(true, spm.next());
                    if (!status.isOK()) {
                        this.agentRepositoryGroup.removeRepository(repo);
                        String msg = NLS.bind((String)com.ibm.cic.agent.internal.core.Messages.Agent_temporarilyRemoveInaccessiblePreferenceRepo, (Object)repo.getLocation());
                        status = RepositoryStatus.getDisplayStatusForCanAddExisting((String)msg, (IStatus)status);
                    } else if (repo.isOpen()) {
                        repo.setOpen(true);
                    }
                    IStatus iStatus = status;
                    return iStatus;
                }
                spm.next();
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            rememberPrompts.forget();
        }
    }

    private IRepositoryGroup.GroupAndStatus getRepositoryGroupAndStatus(boolean doConfigureRepGroup, IProgressMonitor monitor) {
        if (this.externalRepositoryGroup != null) {
            return this.getExternalRepositoryGroupAndStatus();
        }
        return this.getAgentRepositoryGroupAndStatus(doConfigureRepGroup, monitor);
    }

    private IRepositoryGroup.GroupAndStatus getExternalRepositoryGroupAndStatus() {
        return new IRepositoryGroup.GroupAndStatus(){

            public IRepositoryGroup getRepositoryGroup() {
                return Agent.this.externalRepositoryGroup;
            }

            public IStatus getStatus() {
                return Status.OK_STATUS;
            }
        };
    }

    public IRepositoryGroup.GroupAndStatus getAgentRepositoryGroupAndStatus(boolean doConfigureRepGroup, IProgressMonitor monitor) {
        if (!this.isRepositoryGroupSet() || doConfigureRepGroup) {
            this.configureRepositoryGroup(monitor);
        }
        return new IRepositoryGroup.GroupAndStatus(){

            public IRepositoryGroup getRepositoryGroup() {
                return Agent.this.agentRepositoryGroup;
            }

            public IStatus getStatus() {
                return Agent.this.agentRepositoryGroupStatus;
            }
        };
    }

    public IStatus configureRepositoryGroup(IProgressMonitor monitor) {
        PrompterUtils.ConsoleCredentialPrompter credentialPrompts = CmdLine.CL.getConsoleCredentialPrompter();
        RememberDownloadUserPrompts rememberPrompts = new RememberDownloadUserPrompts();
        try {
            if (this.externalRepositoryGroup != null) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            RepositoryGroup tmpGroup = new RepositoryGroup("tmp");
            if (this.agentRepositoryGroup == null) {
                this.agentRepositoryGroup = RepositoryGroup.getDefault();
            } else {
                for (IRepository repo : this.agentRepositoryGroup) {
                    tmpGroup.addExistingRepository(repo, false);
                    this.agentRepositoryGroup.removeRepository(repo);
                }
            }
            this.agentRepositoryGroupStatus = this.loadAgentGroup((IRepositoryGroup)this.agentRepositoryGroup, monitor);
            tmpGroup.removeAllRepositories();
            IStatus iStatus = this.agentRepositoryGroupStatus;
            return iStatus;
        }
        finally {
            rememberPrompts.forget();
            credentialPrompts.restore();
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IStatus loadAgentGroup(IRepositoryGroup agentGroup, IProgressMonitor monitor) {
        CicMultiStatus return_value = Statuses.OK.getMultiStatus();
        this.initializeAgentPreferences();
        ICicPreferenceConstants.ComposedPreferenceTag repoSpecialSettingsTag = new ICicPreferenceConstants.ComposedPreferenceTag(ICicPreferenceConstants.REPOSITORY_LOCATIONS, "", ICicPreferenceConstants.REPOSITORY_SPECIAL_SETTINGS);
        ICicPreferenceConstants.ComposedPreferenceTag repoIsOpenTag = new ICicPreferenceConstants.ComposedPreferenceTag(ICicPreferenceConstants.REPOSITORY_LOCATIONS, "", ICicPreferenceConstants.REPOSITORY_IS_OPEN);
        CicPreferenceManager pm = CicPreferenceManager.getInstance();
        String[] locations = pm.getStringArray(ICicPreferenceConstants.REPOSITORY_LOCATIONS.key());
        boolean paEnabled = pm.getBoolean(ICicPreferenceConstants.PASSPORT_ADVANTAGE_ENABLED.key());
        int length = paEnabled ? locations.length + 1 : locations.length;
        monitor.beginTask(com.ibm.cic.agent.internal.core.Messages.Agent_Load_Repositories, length);
        try {
            block11: {
                int i;
                boolean isCanceled;
                block10: {
                    this.resetPassportAdvantageRepository();
                    this.addPassportAdvantageRepositoryToGroup(paEnabled, agentGroup, monitor);
                    isCanceled = monitor.isCanceled();
                    i = 0;
                    if (!true) break block10;
                    if (isCanceled) return return_value;
                    if (i >= locations.length) break block11;
                }
                do {
                    String location = locations[i];
                    String msg = NLS.bind((String)com.ibm.cic.agent.internal.core.Messages.Agent_Read_Repository, (Object)location);
                    SubProgressMonitor partMonitor = new SubProgressMonitor(monitor, 1);
                    partMonitor.beginTask(msg, 1);
                    partMonitor.setTaskName(msg);
                    try {
                        boolean isOpen = pm.getBoolean(repoIsOpenTag.replaceKey(1, location).key());
                        if (isOpen) {
                            String settings = pm.getString(repoSpecialSettingsTag.replaceKey(1, location).key()).trim();
                            this.addRepositoryToGroup(return_value, agentGroup, location, null, null, settings, (IProgressMonitor)partMonitor);
                        }
                    }
                    finally {
                        partMonitor.done();
                        isCanceled = monitor.isCanceled();
                    }
                    ++i;
                    if (isCanceled) return return_value;
                } while (i < locations.length);
            }
            return return_value;
        }
        finally {
            monitor.done();
        }
    }

    private void addPassportAdvantageRepositoryToGroup(boolean paEnabled, IRepositoryGroup agentGroup, IProgressMonitor monitor) {
        SubProgressMonitor partMonitor = new SubProgressMonitor(monitor, 1);
        String location = CommonDef.Urls.EntitledRepositoryUrl;
        String msg = NLS.bind((String)com.ibm.cic.agent.internal.core.Messages.Agent_Read_Repository, (Object)location);
        partMonitor.beginTask(msg, 1);
        partMonitor.setTaskName(msg);
        try {
            if (paEnabled) {
                this.addRepositoryToGroup(null, agentGroup, location, "CompositeRepository", "0.0.0.1", "", (IProgressMonitor)partMonitor);
            }
            return;
        }
        finally {
            partMonitor.done();
        }
    }

    private void addRepositoryToGroup(CicMultiStatus return_status, IRepositoryGroup group, String location, String type, String version, String settings, IProgressMonitor monitor) {
        IRepositoryInfo repInfo = RepositoryUtils.createRepInfoForExistingRepository((IRepositoryGroup)group, (String)location, (String)type, (String)version, (String)location, (String)settings);
        AgentInstall.getInstance().checkAndSetInstallerContext(repInfo);
        IStatus canAdd = group.canAddExistingRepository(repInfo, monitor);
        try {
            IRepository rep;
            if (canAdd.isOK() && (rep = group.addExistingRepository(repInfo, false)) != null) {
                boolean forceRefresh = !(rep instanceof RepositoryRef) || ((RepositoryRef)rep).getReferenceCount() > 1;
                canAdd = rep.getStatus(forceRefresh, monitor);
                if (!canAdd.isOK()) {
                    group.removeRepository(rep);
                } else if (rep.isOpen()) {
                    rep.setOpen(true);
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        RepositoryStatus.addRepositroyAccessStatus((CicMultiStatus)return_status, (IStatus)canAdd, (String)repInfo.getLocationStr());
    }

    public void initializeAgentPreferences() {
        if (this.currentUserPreferences == null) {
            NonsecureConnectionSessionState.INSTANCE.clear();
            this.currentUserPreferences = new UserContext().getNode(Agent.getBundleId());
            IEclipsePreferences defaultUserPreferences = DefaultScope.INSTANCE.getNode(Agent.getBundleId());
            IEclipsePreferences[] nodes = new IEclipsePreferences[]{this.currentUserPreferences, defaultUserPreferences};
            Platform.getPreferencesService().get(VAR_AGENT_APPDATA_LOCATION, null, (Preferences[])nodes);
            this.currentUserPreferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)ServiceRepositoryUtils.INSTANCE);
        }
        if (this.currentUserPreferences != null && this.previousPrefs == null) {
            try {
                String[] keys;
                this.previousPrefs = new Properties();
                String[] stringArray = keys = this.currentUserPreferences.keys();
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    this.previousPrefs.setProperty(key, this.currentUserPreferences.get(key, null));
                    ++n2;
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
            this.setProxyPreferences();
        }
    }

    private void logPreferences() {
        Object[] keys;
        try {
            keys = this.currentUserPreferences.keys();
        }
        catch (BackingStoreException e) {
            log.error("Error logging preferences: {0}", new Object[]{e.getMessage()});
            return;
        }
        Arrays.sort(keys);
        StringBuffer sb = new StringBuffer(100 * keys.length);
        sb.append(com.ibm.cic.agent.internal.core.Messages.Agent_preferences);
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            sb.append("\n  ").append((String)key);
            sb.append('=').append(this.currentUserPreferences.get((String)key, null));
            ++n2;
        }
        log.info(sb.toString());
    }

    public void setValidating(boolean value) {
        if (this.director != null) {
            this.director.setValidating(value);
        }
    }

    public UserFeedbackProvider setUserFeedbackProvider(UserFeedbackProvider provider) {
        return UserFeedback.setProvider(provider);
    }

    public UndoProgress.Provider setUndoProgressProvider(UndoProgress.Provider provider) {
        return UndoProgress.setProvider(provider);
    }

    public File getHistoryStorage() {
        return this.getAgentData(FILENAME_HISTORIES);
    }

    public HistoryStore getHistoryStore() {
        return this.historyStore;
    }

    public IAgentEventManager getEventManager() {
        if (this.eventManager == null) {
            this.eventManager = new AgentEventManager();
        }
        return this.eventManager;
    }

    public void setEventManager(IAgentEventManager eventManager) {
        this.eventManager = eventManager;
    }

    public IStatus setRecordMode(String recordFilePath) {
        this.commandRecorder = new CommandRecorder();
        this.recordFilePath = recordFilePath;
        return Status.OK_STATUS;
    }

    public void recordImport(String type, Profile profile, Properties dataProps) {
        if (this.commandRecorder != null) {
            this.commandRecorder.recordImport(type, profile, dataProps);
        }
    }

    public boolean isCleanMode() {
        return this.isCleanMode;
    }

    public void setCleanTemporaryMode(boolean isCleanMode, boolean isTemporary) {
        this.isCleanMode = isCleanMode;
        this.isTemporaryMode = isTemporary;
        SilentInstallPreferenceHandler handlerForCleanMode = null;
        if (this.isCleanMode()) {
            handlerForCleanMode = new SilentInstallPreferenceHandler();
        }
        CicPreferenceManager prefMan = CicPreferenceManager.getInstance();
        prefMan.setTemporaryRemotePreferenceHandler((ICicPreferenceHandler)handlerForCleanMode, isTemporary);
        if (isCleanMode) {
            this.resetRepositoryGroup();
        }
    }

    @Override
    public boolean isSilentMode() {
        return this.isSilentMode;
    }

    public void setSilentMode(boolean isSilentMode) {
        this.isSilentMode = isSilentMode;
    }

    private void purgeSelfProfile(Profile selfProfile, InstallRegistry.ProfileInstallRegistry selfRegistry) {
        Check.isTrue((selfRegistry.getInstalledFixes().length == 0 ? 1 : 0) != 0, (Object)"can't purge fixes in self profile");
        selfRegistry.clear();
        if (!AgentInstall.getInstance().reinstallIM()) {
            this.removeProfileAdapterStorage(selfProfile);
        }
    }

    public boolean searchForAgentUpdate() {
        return CicPreferenceManager.getInstance().getBoolean(ICicPreferenceConstants.SEARCH_FOR_UPDATES.key());
    }

    public IOffering checkForAgentUpdate(CicMultiStatus status, IProgressMonitor monitor) {
        IOffering agentOffering = this.getAgentOffering();
        if (agentOffering == null || AgentInstall.getInstance().isAgentInstallerRunning() || !this.isAgentOfferingHidden()) {
            return null;
        }
        IOffering offering = this.findAgentUpdate(monitor);
        if (offering == null) {
            return null;
        }
        if (status != null) {
            status.add((IStatus)Statuses.WARNING.get(com.ibm.cic.agent.internal.core.Messages.Agent_runningAgentDetails, new Object[]{AgentSettings.getRunningAgentInternalVersionStr(), AgentSettings.getRunningAgentVersionStr()}));
            status.add((IStatus)Statuses.WARNING.get(com.ibm.cic.agent.internal.core.Messages.Agent_foundAgentDetails, new Object[]{offering.getVersion(), OfferingUtil.getDisplayableVersion((IOfferingOrFix)offering)}));
        }
        return offering;
    }

    public IOffering getUpdateForSelectedAgent(IOffering selectedAgent, IProgressMonitor monitor, CicMultiStatus status) {
        IOffering agentUpdate = selectedAgent;
        List agentOfferings = this.findLatestOfferingOrUpdateFix(selectedAgent.getIdentity().getId(), monitor);
        int i = 0;
        while (i < agentOfferings.size()) {
            IOffering offering;
            Object object = agentOfferings.get(i);
            if (object instanceof IOffering && (offering = (IOffering)object).getVersion().compareTo(agentUpdate.getVersion()) > 0) {
                agentUpdate = offering;
            }
            ++i;
        }
        if (agentUpdate == selectedAgent) {
            return null;
        }
        status.add((IStatus)Statuses.WARNING.get(com.ibm.cic.agent.internal.core.Messages.Agent_selectedAgentDetails, new Object[]{selectedAgent.getVersion(), OfferingUtil.getDisplayableVersion((IOfferingOrFix)selectedAgent)}));
        status.add((IStatus)Statuses.WARNING.get(com.ibm.cic.agent.internal.core.Messages.Agent_foundAgentDetails, new Object[]{agentUpdate.getVersion(), OfferingUtil.getDisplayableVersion((IOfferingOrFix)agentUpdate)}));
        return agentUpdate;
    }

    public boolean isAgentUpdate(IOffering offering, CicMultiStatus status) {
        if (offering == null) {
            return false;
        }
        IOffering agentOffering = this.getAgentOffering();
        if (agentOffering == null) {
            return false;
        }
        Version installedAgentVersion = agentOffering.getVersion();
        Version runningInternalAgentVersion = AgentSettings.getRunningAgentInternalVersion();
        VersionRange offeringVersionTolerance = new VersionRange(this.getAgentTolerance((IOfferingOrFix)offering));
        Version offeringVersion = offering.getVersion();
        if (offeringVersion.compareTo(installedAgentVersion) > 0 && offeringVersionTolerance.isIncluded(runningInternalAgentVersion)) {
            status.add((IStatus)Statuses.WARNING.get(com.ibm.cic.agent.internal.core.Messages.Agent_runningAgentDetails, new Object[]{AgentSettings.getRunningAgentInternalVersionStr(), AgentSettings.getRunningAgentVersionStr()}));
            status.add((IStatus)Statuses.WARNING.get(com.ibm.cic.agent.internal.core.Messages.Agent_foundAgentDetails, new Object[]{offering.getVersion(), OfferingUtil.getDisplayableVersion((IOfferingOrFix)offering)}));
            return true;
        }
        return false;
    }

    public UpdateOfferingJob createAgentUpdateOfferingJob(IOffering offering) {
        Profile selfProfile = (Profile)Check.notNull((Object)this.getAgentProfile());
        IOffering oldOffering = (IOffering)Check.notNull((Object)this.getAgentOffering());
        UpdateOfferingJob job = new UpdateOfferingJob(selfProfile, offering, oldOffering);
        List features = offering.getFeatureGroup().getFeatures();
        job.setFeatures(features);
        return job;
    }

    public IStatus prepareAgentUpdate(UpdateOfferingJob job, IProgressMonitor monitor) {
        return this.prepareAgentUpdate(job.getOffering(), job.getUpdatedOffering(), monitor);
    }

    public IStatus prepareAgentUpdate(IOffering installedOffering, IOffering updateOffering, IProgressMonitor monitor) {
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, 2);
        try {
            IStatus status = this.prepare((IOfferingOrFix)installedOffering, ExtensionCategory.ALL, pm.next());
            if (!status.isOK()) {
                log.status(status);
                IStatus iStatus = status;
                return iStatus;
            }
            status = this.prepare((IOfferingOrFix)updateOffering, ExtensionCategory.ALL, pm.next());
            if (!status.isOK()) {
                log.status(status);
                IStatus iStatus = status;
                return iStatus;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            pm.done();
            monitor.done();
        }
    }

    public IStatus updateAgent(UpdateOfferingJob job, IProgressMonitor monitor) {
        IOffering oldOffering = job.getUpdatedOffering();
        IOffering offering = job.getOffering();
        Profile selfProfile = job.getProfile();
        selfProfile.setData("cic.selector.nl", ProfileLanguageUtils.convertCodeSetToString((Set)OfferingProperty.getSupportedLocales((IOffering)offering)));
        CicMultiStatus status = Statuses.ST.createMultiStatus();
        try {
            this.updatingAgent = true;
            status.add(this.install(job, monitor));
        }
        finally {
            this.updatingAgent = false;
        }
        if (!status.isErrorOrCancel()) {
            selfProfile.setData(SELF_CACHE_CLEAN_PROPERTY, oldOffering.getVersion().toString());
            try {
                selfProfile.getInstallRegistry().commit(null);
            }
            catch (CoreException e) {
                status.add((IStatus)Statuses.ERROR.get((Throwable)e, com.ibm.cic.agent.internal.core.Messages.Profile_Error_Saving_Install_Registry, new Object[]{e.getMessage()}));
            }
            this.cleanAgentSelfConfiguration();
        }
        log.statusNotOK((IStatus)status);
        return StatusUtil.toSingleStatus((IStatus)status);
    }

    private void cleanAgentSelfConfiguration() {
        File splashBmp = new File(this.getAgentSelfLocation(), "configuration/org.eclipse.osgi/splash.bmp");
        splashBmp.delete();
    }

    private void cleanAgentSelfCache(Profile selfProfile) {
        IStatus status = CacheManager.setDefaultInstance(this.getAgentSelfCacheManager());
        if (status.isOK()) {
            try {
                log.statusNotOK(CacheManager.getDefaultInstance().purge(null));
            }
            catch (Throwable throwable) {
                selfProfile.removeData(SELF_CACHE_CLEAN_PROPERTY);
                this.fixupWindowSystem(selfProfile);
                try {
                    selfProfile.refactorAgentProfileId();
                    selfProfile.getInstallRegistry().commit(null);
                }
                catch (IOException e) {
                    log.error((Throwable)e, com.ibm.cic.agent.internal.core.Messages.Profile_Error_Saving_Install_Registry, new Object[]{e.toString()});
                }
                catch (CoreException e) {
                    log.error((Throwable)e, com.ibm.cic.agent.internal.core.Messages.Profile_Error_Saving_Install_Registry, new Object[]{e.getMessage()});
                }
                throw throwable;
            }
            selfProfile.removeData(SELF_CACHE_CLEAN_PROPERTY);
            this.fixupWindowSystem(selfProfile);
            try {
                selfProfile.refactorAgentProfileId();
                selfProfile.getInstallRegistry().commit(null);
            }
            catch (IOException e) {
                log.error((Throwable)e, com.ibm.cic.agent.internal.core.Messages.Profile_Error_Saving_Install_Registry, new Object[]{e.toString()});
            }
            catch (CoreException e) {
                log.error((Throwable)e, com.ibm.cic.agent.internal.core.Messages.Profile_Error_Saving_Install_Registry, new Object[]{e.getMessage()});
            }
        }
        CacheManager.clearDefaultInstance();
    }

    private void fixupWindowSystem(Profile selfProfile) {
        String arch;
        String os = Platform.getOS();
        if (!this.isAixPpc(os, arch = Platform.getOSArch()) && !this.isHpuxIa64(os, arch)) {
            return;
        }
        String ws = selfProfile.getData("cic.selector.ws");
        if ("gtk".equals(ws)) {
            return;
        }
        selfProfile.setData("cic.selector.ws", "gtk");
    }

    private boolean isAixPpc(String os, String arch) {
        return "aix".equals(os) && ("ppc".equals(arch) || "ppc64".equals(arch));
    }

    private boolean isHpuxIa64(String os, String arch) {
        return "hpux".equals(os) && ("ia64_32".equals(arch) || "ia64".equals(arch));
    }

    private void checkIfRunningWithOldJRE(CicMultiStatus result) {
        File agentDir = this.getAgentSelfLocation();
        String javaHome = System.getProperty("java.home");
        if (javaHome == null) {
            return;
        }
        File javaHomeDir = new File(javaHome);
        File oldJreDir = new File(agentDir, "jre");
        if (!FileUtil.filesAreSame((File)javaHomeDir, (File)oldJreDir)) {
            return;
        }
        if (!AgentRelaunch.getInstance().setRelaunchWithLauncherIniArguments()) {
            return;
        }
        result.add((IStatus)Statuses.WARNING.get(com.ibm.cic.agent.internal.core.Messages.Agent_mustRelaunchDetails, new Object[0]));
        result.setMessage(com.ibm.cic.agent.internal.core.Messages.Agent_mustRelaunch);
        AgentRelaunch.getInstance().setNeedsRelaunch(true);
    }

    private void removeCleanOptionFromAllConfigIniFiles(File agentDir) {
        this.removeCleanOptionFromConfigIni(agentDir);
        this.removeCleanOptionFromConfigIni(new File(agentDir, "web"));
    }

    private void removeCleanOptionFromConfigIni(File agentDir) {
        block27: {
            File configLocation = new File(agentDir, "configuration");
            File configIniFile = new File(configLocation, "config.ini");
            if (!configLocation.exists() || !configIniFile.exists()) {
                return;
            }
            Properties props = new Properties();
            FileInputStream inStream = null;
            try {
                try {
                    inStream = new FileInputStream(configIniFile);
                    props.load(inStream);
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException e2) {
                            log.error((Throwable)e2);
                        }
                    }
                    return;
                }
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException e) {
                        log.error((Throwable)e);
                    }
                }
            }
            props.remove("osgi.clean");
            FileOutputStream outStream = null;
            try {
                try {
                    outStream = new FileOutputStream(configIniFile);
                    props.store(outStream, null);
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                    if (outStream == null) break block27;
                    try {
                        outStream.close();
                    }
                    catch (IOException e3) {
                        log.error((Throwable)e3);
                    }
                }
            }
            finally {
                if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (IOException e) {
                        log.error((Throwable)e);
                    }
                }
            }
        }
    }

    private void removeOldAgentJREs() {
        File agentDir = this.getAgentSelfLocation();
        String javaHome = System.getProperty("java.home");
        if (javaHome == null) {
            return;
        }
        File javaHomeDir = new File(javaHome);
        this.removeOldAgentJREs(agentDir, javaHomeDir);
    }

    private File getMacosxJreVersionDir(File agentDir, File javaHomeDir) {
        File jreVersionDir = javaHomeDir;
        while (jreVersionDir != null && !jreVersionDir.getName().equals("eclipse")) {
            if (FileUtil.filesAreSame((File)agentDir, (File)jreVersionDir.getParentFile()) && jreVersionDir.getName().startsWith("jre_")) {
                return jreVersionDir;
            }
            jreVersionDir = jreVersionDir.getParentFile();
        }
        return null;
    }

    private void removeOldAgentJREs(File agentDir, File javaHomeDir) {
        File javaHomeParentDir;
        File file = javaHomeParentDir = "macosx".equals(Platform.getOS()) ? this.getMacosxJreVersionDir(agentDir, javaHomeDir) : javaHomeDir.getParentFile();
        if (javaHomeParentDir == null) {
            return;
        }
        File javaHomeGrandParentDir = javaHomeParentDir.getParentFile();
        if (javaHomeGrandParentDir == null) {
            return;
        }
        if (!FileUtil.filesAreSame((File)agentDir, (File)javaHomeGrandParentDir)) {
            return;
        }
        String currJreName = javaHomeParentDir.getName();
        this.removeOldAgentJREs(agentDir, currJreName);
    }

    private void removeOldAgentJREs(File agentDir, final String currJreName) {
        File[] jreStuffToDelete = agentDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (!file.isDirectory()) {
                    return file.isFile() && file.getName().equalsIgnoreCase("copyright");
                }
                String name = file.getName();
                if (name.equals("docs")) {
                    File commonDir = new File(file, "common");
                    return commonDir.isDirectory();
                }
                if (!name.equals("jre") && !name.startsWith("jre_")) {
                    return false;
                }
                if (name.equals(currJreName)) {
                    return false;
                }
                File jreDir = name.equals("jre") ? file : new File(file, "jre");
                File binDir = "macosx".equals(Platform.getOS()) ? new File(new File(new File(jreDir, "Contents"), "Home"), "bin") : new File(jreDir, "bin");
                return binDir.isDirectory();
            }
        });
        if (jreStuffToDelete != null) {
            File[] fileArray = jreStuffToDelete;
            int n = jreStuffToDelete.length;
            int n2 = 0;
            while (n2 < n) {
                File jreStuff = fileArray[n2];
                FileUtil.rm_r((File)jreStuff, (boolean)true);
                ++n2;
            }
        }
    }

    private void updateOldAgentLauncherStuff() {
        File agentDir = this.getAgentSelfLocation();
        this.updateOldAgentLauncherStuff(agentDir);
    }

    private void updateOldAgentLauncherStuff(File agentDir) {
        String[] fileNames;
        String[] stringArray = fileNames = new String[]{"startup.jar", "launcher.bat", "launcher.sh"};
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            File file = new File(agentDir, fileName);
            if (file.isFile()) {
                file.delete();
            }
            ++n2;
        }
        String oldLauncherName = GENERIC_AGENT_LAUNCHER_NAME;
        String newLauncherName = SWT_AGENT_LAUNCHER_NAME;
        this.updateLauncherFile(agentDir, this.getLauncher(newLauncherName), this.getLauncher(oldLauncherName), this.getLauncherPerm());
        this.updateLauncherFile(agentDir, this.getLauncherIni(newLauncherName), this.getLauncherIni(oldLauncherName), null);
    }

    private void removeOldAgentLauncher() {
        File agentDir = this.getAgentSelfLocation();
        this.removeOldAgentLauncher(agentDir);
    }

    private void removeOldAgentLauncher(File agentDir) {
        File[] launcherToDelete = agentDir.listFiles();
        if (launcherToDelete != null) {
            File[] fileArray = launcherToDelete;
            int n = launcherToDelete.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    this.removeOldAgentLauncher(f);
                } else if (f.isFile() && f.getName().startsWith(IBMIM_TMP_PREFIX)) {
                    f.delete();
                }
                ++n2;
            }
        }
    }

    private String getLauncher(String name) {
        if ("win32".equals(Platform.getOS())) {
            return String.valueOf(name) + ".exe";
        }
        return name;
    }

    private String getLauncherPerm() {
        if ("win32".equals(Platform.getOS())) {
            return null;
        }
        return "a+rx";
    }

    private String getLauncherIni(String name) {
        return String.valueOf(name) + ".ini";
    }

    private void findAndRemoveEclipseDll() {
        File agentDir = this.getAgentSelfLocation();
        File pluginsDir = new File(agentDir, PLUGINS_DIR);
        File[] possibleDllDirs = pluginsDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && file.getName().startsWith(Agent.ECLIPSE_DLL_DIR_PREFIX);
            }
        });
        if (possibleDllDirs != null && possibleDllDirs.length > 1) {
            Version minVersion = null;
            File oldDir = null;
            File[] fileArray = possibleDllDirs;
            int n = possibleDllDirs.length;
            int n2 = 0;
            while (n2 < n) {
                File tempDir = fileArray[n2];
                Object[] idAndVersion = SplitIdVersionUtil.splitIdUnderscoreVersion((String)tempDir.getName());
                Version version = (Version)idAndVersion[1];
                if (minVersion == null || version != null && version.compareTo(minVersion) < 0) {
                    minVersion = version;
                    oldDir = tempDir;
                }
                ++n2;
            }
            File[] oldDirFiles = oldDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().startsWith(Agent.ECLIPSE_DLL_PREFIX) && file.getName().endsWith(".dll");
                }
            });
            if (oldDirFiles != null) {
                File[] fileArray2 = oldDirFiles;
                int n3 = oldDirFiles.length;
                n = 0;
                while (n < n3) {
                    File oldDirFile = fileArray2[n];
                    this.renameFileToTmpFile(agentDir, oldDirFile);
                    ++n;
                }
            }
        }
    }

    private boolean renameFileToTmpFile(File agentDir, File destFile) {
        File tmpFile = this.getLauncherTempFile(agentDir);
        if (!destFile.renameTo(tmpFile)) {
            log.error(com.ibm.cic.agent.internal.core.Messages.CacheManager_Failed_To_DeleteError, new Object[]{destFile.getPath()});
            return false;
        }
        return true;
    }

    private void updateLauncherFile(File agentDir, String src, String dest, String perm) {
        File srcFile = new File(PlatformUtils.getLauncherLocation((File)agentDir), src);
        File destFile = new File(agentDir, dest);
        if (destFile.isFile() && !destFile.delete() && !this.renameFileToTmpFile(agentDir, destFile)) {
            return;
        }
        try {
            FileUtil.copyFile((File)srcFile, (File)destFile);
        }
        catch (IOException e) {
            log.error((Throwable)e);
            return;
        }
        if (perm != null && !FileUtil.chmod((String)perm, (boolean)false, (String[])new String[]{destFile.getPath()})) {
            log.error("cannot change permissions: " + destFile.getPath());
        }
        destFile.setLastModified(srcFile.lastModified());
    }

    private File getLauncherTempFile(File agentDir) {
        int i = 1;
        File tmpFile;
        while ((tmpFile = new File(agentDir, IBMIM_TMP_PREFIX + String.valueOf(i))).exists()) {
            ++i;
        }
        return tmpFile;
    }

    public void cleanupAfterAgentInstall(Profile profile) {
        if (!profile.isAgentProfile()) {
            return;
        }
        AgentInstall agentInstall = AgentInstall.getInstance();
        if (!agentInstall.isAgentInstallerRunning()) {
            return;
        }
        try {
            profile.refactorAgentProfileId();
        }
        catch (IOException e) {
            log.status((IStatus)Statuses.ERROR.get((Throwable)e, com.ibm.cic.agent.internal.core.Messages.Profile_Error_Saving_Install_Registry, new Object[]{e.toString()}));
        }
        File agentDir = new File(profile.getInstallLocation());
        this.removeCleanOptionFromAllConfigIniFiles(agentDir);
        String agentJavaHome = profile.getData(AGENT_JAVA_HOME);
        if (agentJavaHome == null) {
            log.error(com.ibm.cic.agent.internal.core.Messages.InstallRegistry_Error_In_Property, new Object[]{profile.getProfileId(), AGENT_JAVA_HOME, null});
        } else {
            File agentJavaHomeDir = new File(agentJavaHome);
            this.removeOldAgentJREs(agentDir, agentJavaHomeDir);
        }
        this.updateOldAgentLauncherStuff(agentDir);
        this.removeOldAgentLauncher(agentDir);
    }

    public IStatus checkAgentRequirement(IOfferingOrFix offeringOrFix) {
        return this.checkAgentRequirement(offeringOrFix, true);
    }

    public IStatus checkAgentRequirement(IOfferingOrFix offeringOrFix, boolean displayInternalVersion) {
        IStatus returnStatus = Status.OK_STATUS;
        VersionRange agentTolerance = new VersionRange(this.getAgentTolerance(offeringOrFix));
        Version runningAgentVersion = AgentSettings.getRunningAgentInternalVersion();
        if (!Version.emptyVersion.equals((Object)runningAgentVersion) && !agentTolerance.isIncluded(runningAgentVersion)) {
            String offeringLabel = OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offeringOrFix);
            String displayableAgentTolerance = this.getDisplayableAgentTolerance(offeringOrFix);
            Version displayableRunningAgentVersion = AgentSettings.getRunningAgentVersion();
            String displayableAgentMinTolerance = OfferingUtil.getDisplayableAgentMinTolerance((IOfferingOrFix)offeringOrFix);
            returnStatus = displayInternalVersion ? (displayableRunningAgentVersion.compareTo(agentTolerance.getMinimum()) < 0 ? Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.Agent_agentNotToleratedTooLowInternal, new Object[]{offeringLabel, agentTolerance, AgentSettings.getRunningAgentInternalVersionStr(), displayableAgentMinTolerance, displayableRunningAgentVersion}) : Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.Agent_agentNotToleratedInternal, new Object[]{offeringLabel, agentTolerance, AgentSettings.getRunningAgentInternalVersionStr(), displayableAgentTolerance, displayableRunningAgentVersion})) : (displayableRunningAgentVersion.compareTo(agentTolerance.getMinimum()) < 0 ? Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.Agent_agentNotToleratedTooLow, new Object[]{offeringLabel, displayableAgentMinTolerance, displayableRunningAgentVersion}) : Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.Agent_agentNotTolerated, new Object[]{offeringLabel, displayableAgentTolerance, displayableRunningAgentVersion}));
            log.statusNotOK(returnStatus);
        }
        return returnStatus;
    }

    private String getAgentTolerance(IOfferingOrFix offeringOrFix) {
        return OfferingUtil.getAgentTolerance((IOfferingOrFix)offeringOrFix);
    }

    private String getDisplayableAgentTolerance(IOfferingOrFix offeringOrFix) {
        LinkedProperties properties = offeringOrFix.getProperties();
        String tolerance = properties.getProperty("displayable.im.tolerance");
        if (tolerance == null && (tolerance = properties.getProperty("displayable.agent.tolerance")) == null && (tolerance = this.getAgentTolerance(offeringOrFix)) != null) {
            VersionRange range = new VersionRange(tolerance);
            Version externalMin = Agent.toExternalAgentVersion(range.getMinimum());
            Version externalMax = Agent.toExternalAgentVersion(range.getRight());
            tolerance = new VersionRange(externalMin, range.getIncludeMinimum(), externalMax, range.getIncludeMaximum()).toString();
        }
        return tolerance;
    }

    public static Version toExternalAgentVersion(Version internal) {
        return OfferingUtil.toExternalAgentVersion((Version)internal);
    }

    public IStatus checkBetaRequirement(IOfferingOrFix offeringOrFix) {
        IStatus status = Status.OK_STATUS;
        if (LicenseUtils.isPEKOffering((IOfferingOrFix)offeringOrFix)) {
            return status;
        }
        if (!CicCommonSettings.isBetaOverride()) {
            if (CicCommonSettings.isBeta()) {
                if (!OfferingProperty.isBetaCompatible((IOfferingOrFix)offeringOrFix) && !OfferingProperty.isBetaInstallationOnly((IOfferingOrFix)offeringOrFix)) {
                    status = Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.Agent_OfferingNotBetaCompatible, new Object[]{OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offeringOrFix)});
                }
            } else if (OfferingProperty.isBetaInstallationOnly((IOfferingOrFix)offeringOrFix)) {
                status = Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.Agent_OfferingBetaIMRequired, new Object[]{OfferingUtil.getOfferingOrFixLabel((IOfferingOrFix)offeringOrFix)});
            }
        }
        return status;
    }

    private IOffering findAgentUpdate(IProgressMonitor monitor) {
        Profile agentProfile = this.getAgentProfile();
        IOffering agentOffering = this.getAgentOffering();
        if (agentProfile == null || agentOffering == null) {
            return null;
        }
        IOffering[] offerings = this.findUpdates(agentProfile, agentOffering, monitor);
        if (offerings.length == 0) {
            return null;
        }
        Version runningAgentVersion = agentOffering.getVersion();
        int i = offerings.length - 1;
        while (i >= 0) {
            IOffering offering = offerings[i];
            VersionRange agentTolerance = new VersionRange(this.getAgentTolerance((IOfferingOrFix)offering));
            if (agentTolerance.isIncluded(runningAgentVersion)) {
                return offering;
            }
            --i;
        }
        return null;
    }

    public String getInstalledOfferingRepInfo(Profile profile, IOfferingOrFix offeringOrFix) {
        return profile.getInstallRegistry().getInstalledRepositoryInfo(offeringOrFix);
    }

    public boolean isTemporaryMode() {
        return this.isTemporaryMode;
    }

    public String getUniqueInstanceId() {
        return this.uniqueInstanceId;
    }

    public void resetPassportAdvantageRepository() {
        IRepositoryInfo info;
        IRepositoryGroup group;
        IRepository repository;
        CicFileLocation location = new CicFileLocation(CommonDef.Urls.EntitledRepositoryUrl);
        FileCacheManager.getInstance().resetPathTree((ICicLocation)location);
        if (this.isRepositoryGroupSet() && (repository = (group = this.getAgentRepositoryGroup()).findRepository(info = this.getPassportAdvantageRepositoryInfo(group))) != null) {
            group.removeRepository(repository);
        }
    }

    private IRepositoryInfo getPassportAdvantageRepositoryInfo(IRepositoryGroup group) {
        String siteUrl = CommonDef.Urls.EntitledRepositoryUrl;
        return RepositoryUtils.createRepInfoForExistingRepository((IRepositoryGroup)group, (String)siteUrl);
    }

    private static IStatus isAgentPrefWriteable() {
        IStatus status = Status.OK_STATUS;
        File agentPrefsDir = CicCommonSettings.getApplicationPreferenceLocation().toFile();
        File agentPrefs = CicCommonSettings.getApplicationPreferenceLocation().append(String.valueOf(Agent.getBundleId()) + ".prefs").toFile();
        try {
            if (agentPrefsDir.exists() && !FileUtil.directoryIsWriteable((String)agentPrefsDir.getCanonicalPath())) {
                status = Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.Agent_Unable_To_Write_Data, new Object[]{agentPrefsDir.getCanonicalPath()});
            }
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
        if (agentPrefs.exists() && !FileUtil.canWrite((File)agentPrefs)) {
            status = Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.Agent_Unable_To_Write_File, new Object[]{agentPrefs});
        }
        return status;
    }

    public static IStatus getAccessRightsStatus() {
        if (CicCommonSettings.getAccessRightsMode().isAdminMode()) {
            if (!CicCommonSettings.isNativeAdministrator()) {
                return Statuses.ERROR.get(Messages.CommonSettings_Error_NoAdministratorPrivileges, new Object[0]);
            }
        } else {
            String appdataLocation = CicCommonSettings.getApplicationDataLocation();
            File appdataFile = new File(appdataLocation);
            if (appdataFile.exists()) {
                if (!FileUtil.canRead((File)appdataFile) || !FileUtil.canWrite((String)appdataLocation)) {
                    return Statuses.ERROR.get(Messages.GroupMode_enterAReadableAndWritableApplicationDataLocation, new Object[]{appdataLocation});
                }
                if (CicCommonSettings.getAccessRightsMode().isGroupMode()) {
                    IStatus checkStatus = Agent.isAgentPrefWriteable();
                    if (!checkStatus.isOK()) {
                        return checkStatus;
                    }
                    File instRegFile = Agent.getInstance().getInstallRegistryLocation();
                    if (instRegFile.exists()) {
                        checkStatus = AgentUtil.checkGroupId(instRegFile.getPath());
                    }
                    if (!checkStatus.isOK()) {
                        return checkStatus;
                    }
                }
            } else if (!FileUtil.directoryIsWriteable((String)appdataLocation)) {
                return Statuses.ERROR.get(Messages.Enter_ApplicationDataLocation_Not_Writable, new Object[]{appdataLocation});
            }
            if (!CicCommonSettings.getAccessRightsMode().isGroupMode()) {
                AgentRegistry reg = AgentRegistry.getInstance();
                if (!(Boolean.TRUE.toString().equals(System.getProperty("JUnitTest")) || AgentInstall.getInstance().isAgentInstallerRunning() || reg.runningInstanceOfIMMatches())) {
                    return Statuses.ERROR.get(Messages.CommonSettings_Error_OnlyInstallingNonAdminCanRunIM, new Object[0]);
                }
            } else {
                if (CicCommonSettings.isWindows()) {
                    return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.Agent_GroupMode_UnsupportedPlatform_Windows, new Object[0]);
                }
                if (CicCommonSettings.isOS400()) {
                    return Statuses.ERROR.get(com.ibm.cic.agent.internal.core.Messages.Agent_GroupMode_UnsupportedPlatform_iSeries, new Object[0]);
                }
            }
        }
        return Status.OK_STATUS;
    }

    public IRepositoryGroup getExternalRepositoryGroup() {
        return this.externalRepositoryGroup;
    }

    public void setExternalRepositoryGroup(IRepositoryGroup repoGroup) {
        this.externalRepositoryGroup = repoGroup;
    }

    public FileReplicator getJavaFileReplicator() {
        if (this.javaFileReplicator == null) {
            this.javaFileReplicator = new FileReplicator(this.getAgentData(FILENAME_TEMP));
        }
        return this.javaFileReplicator;
    }

    private void purgeJavaTemp() {
        Agent.purge(this.getAgentData(FILENAME_TEMP));
    }

    @Override
    public boolean isSkipInstall() {
        return this.isSkipInstall;
    }

    public void setSkipInstall(boolean skipInstall) {
        this.isSkipInstall = skipInstall;
    }

    public void clearUserPreferences() {
        if (this.currentUserPreferences != null) {
            try {
                this.currentUserPreferences.clear();
            }
            catch (BackingStoreException bse) {
                log.error(com.ibm.cic.agent.internal.core.Messages.Agent_Error_Removing_Preference_Node, new Object[]{this.currentUserPreferences, bse});
            }
            this.currentUserPreferences = null;
        }
    }

    public ISelectionExpression.ISelectedByBundle[] getPrecheckBundles(IOfferingOrFix offeringOrFix) {
        return OfferingUtil.getPrecheckBundles((IOfferingOrFix)offeringOrFix, (Version)AgentSettings.getRunningAgentInternalVersion());
    }

    public IStatus evaluatePrecheckBundles(IOfferingOrFix offeringOrFix, AgentJob job) {
        return this.evaluateOfferingBundles((ISelectionExpression[])this.getPrecheckBundles(offeringOrFix), job, false);
    }

    public IStatus evaluatePrereqBundles(IOfferingOrFix offeringOrFix, AgentJob job) {
        return this.evaluateOfferingBundles((ISelectionExpression[])OfferingUtil.getPrereqBundles((IOfferingOrFix)offeringOrFix), job, true);
    }

    public IStatus evaluateOfferingBundles(ISelectionExpression[] bundles, AgentJob job, boolean isCheckingPrerequisites) {
        try {
            this.checkingPrerequisites = isCheckingPrerequisites;
            CicMultiStatus ret = Statuses.ST.createMultiStatus();
            ISelectionExpression[] iSelectionExpressionArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                ISelectionExpression bundle = iSelectionExpressionArray[n2];
                IStatus status = bundle.evaluate((ISelectionExpression.EvaluationContext)job);
                ret.add(status);
                if (StatusUtil.isErrorOrCancel((IStatus)status)) break;
                ++n2;
            }
            CicMultiStatus cicMultiStatus = ret;
            return cicMultiStatus;
        }
        finally {
            this.checkingPrerequisites = false;
        }
    }

    @Override
    public Version getInternalVersion() {
        return AgentSettings.getRunningAgentInternalVersion();
    }

    @Override
    public String getDisplayableVersion() {
        return AgentSettings.getRunningAgentVersion().toString();
    }

    public void addOrRemovePPA(boolean enablePPA) {
        String url = CommonDef.Urls.EntitledRepositoryUrl;
        CicFileLocation location = new CicFileLocation(url);
        FileCacheManager.getInstance().resetPathTree((ICicLocation)location);
        if (this.isRepositoryGroupSet()) {
            IRepositoryGroup group = this.getAgentRepositoryGroup();
            IRepositoryInfo info = RepositoryUtils.createRepInfoForExistingRepository((IRepositoryGroup)group, (String)url);
            IRepository repository = group.findRepository(info);
            if (!enablePPA && repository != null) {
                group.removeRepository(repository);
            }
        }
    }

    public String[] getCommonDataKeys() {
        return CommonUserDataExtParser.getInstance().getCommonUserDataKeys();
    }

    @Override
    public String getCommonDataDefaultValue(String dataKey) {
        return CommonUserDataExtParser.getInstance().getCommonUserDataDefaultValue(dataKey);
    }

    @Override
    public String getCommonDataDescription(String dataKey) {
        return CommonUserDataExtParser.getInstance().getCommonUserDataDescription(dataKey);
    }

    @Override
    public IStatus validateCommonData(Map keyValueMap) {
        return CommonUserDataExtParser.getInstance().getCommonUserDataValidationStatus(keyValueMap);
    }

    public String[] getOfferingDataKeys(IOfferingOrFix offeringOrFix) {
        return OfferingUserDataExtParser.getInstance().getOfferingUserDataKeys(offeringOrFix);
    }

    @Override
    public String getOfferingDataDefaultValue(IOfferingOrFix offeringOrFix, String dataKey) {
        return OfferingUserDataExtParser.getInstance().getOfferingUserDataDefaultValue(offeringOrFix, dataKey);
    }

    @Override
    public String getOfferingDataDescription(IOfferingOrFix offeringOrFix, String dataKey) {
        return OfferingUserDataExtParser.getInstance().getOfferingUserDataDescription(offeringOrFix, dataKey);
    }

    @Override
    public IStatus validateOfferingUserData(IOfferingOrFix offeringOrFix, Map keyValueMap) {
        return OfferingUserDataExtParser.getInstance().getOfferingUserDataValidationStatus(offeringOrFix, keyValueMap);
    }

    public CommandRecorder getCommandRecorder() {
        return this.commandRecorder;
    }

    public void setCommandRecorder(CommandRecorder commandRecorder) {
        this.commandRecorder = commandRecorder;
    }

    public boolean isRecordMode() {
        return this.commandRecorder != null;
    }

    public OutputFormatter getStdoutBuffer() {
        return this.stdoutBuffer;
    }

    public void flushStdoutBuffer() {
        if (this.stdoutBuffer.toString().length() > 0) {
            System.out.print(this.stdoutBuffer);
            this.stdoutBuffer = new OutputFormatter();
        }
    }

    public void setTotalSizeMap(Map sizeMap) {
        this.totalSizeMap = sizeMap;
    }

    @Override
    public Map getTotalSizeMap() {
        if (this.totalSizeMap != null) {
            return new HashMap(this.totalSizeMap);
        }
        return null;
    }

    public void clearProfileLanguageMap() {
        this.profileLanguageMap.clear();
    }

    public Map<Profile, String> getProfileLanguageMap() {
        return this.profileLanguageMap;
    }

    private void swapProfileLocaleSettings() {
        Map<Profile, String> plm = this.getProfileLanguageMap();
        HashSet<Profile> pSet = new HashSet<Profile>(plm.keySet());
        for (Profile p : pSet) {
            if (p == null) continue;
            String inProfile = p.getData("cic.selector.nl");
            inProfile = inProfile == null ? "" : inProfile;
            String inMap = plm.get(p);
            plm.put(p, inProfile);
            if (inMap == null) continue;
            p.setData("cic.selector.nl", inMap);
        }
    }

    public IStatus checkDiskSpaceInfo(List selectedJobs, IProgressMonitor monitor) {
        if (Agent.getInstance().isSkipInstall()) {
            return Status.OK_STATUS;
        }
        SplitProgressMonitor sm = new SplitProgressMonitor(monitor, new int[]{1, 1});
        this.swapProfileLocaleSettings();
        List<Long> eclipseCacheLocationSizeList = SpaceInfoUtils.getEclipseCacheLocationSizeListMap(selectedJobs, sm.next());
        this.swapProfileLocaleSettings();
        if (eclipseCacheLocationSizeList == null) {
            return Status.OK_STATUS;
        }
        Map<String, List<Long>> installLocationSizeMap = SpaceInfoUtils.getInstallLocationDriveSizeListMap(selectedJobs, sm.next());
        if (installLocationSizeMap == null) {
            return Status.OK_STATUS;
        }
        HashMap<String, Long> resultMap = new HashMap<String, Long>();
        IStatus spaceValidationStatus = SpaceInfoUtils.verifySpaceInfo(eclipseCacheLocationSizeList, installLocationSizeMap, resultMap);
        this.setTotalSizeMap(resultMap);
        return spaceValidationStatus;
    }

    @Override
    public boolean isAdminMode() {
        return CicCommonSettings.getAccessRightsMode().isAdminMode();
    }

    @Override
    public boolean isGroupMode() {
        return CicCommonSettings.getAccessRightsMode().isGroupMode();
    }

    @Override
    public boolean isUserMode() {
        return CicCommonSettings.getAccessRightsMode().isNonAdminMode();
    }

    @Override
    public boolean isPortable() {
        return CicCommonSettings.isPortable();
    }

    public List<IOffering> getRollbackOfferings(Profile profile, IOffering offering) {
        IOffering[] installedOfferings = this.getInstalledOfferings(profile, offering.getIdentity());
        ArrayList<IOffering> rollbackOfferings = new ArrayList<IOffering>();
        if (installedOfferings.length > 1) {
            IOffering[] iOfferingArray = installedOfferings;
            int n = installedOfferings.length;
            int n2 = 0;
            while (n2 < n) {
                IOffering installedOffering = iOfferingArray[n2];
                if (!offering.equals(installedOffering) && this.isRollbackAllowed(profile, installedOffering) && !OfferingProperty.hasUnacceptableRequirementForUserRights((IOffering)installedOffering) && !OfferingProperty.hasUnacceptableRequirementForGroupMode((IOfferingOrFix)installedOffering)) {
                    rollbackOfferings.add(installedOffering);
                }
                ++n2;
            }
        }
        return rollbackOfferings;
    }

    @Override
    public boolean isConsoleMode() {
        return CmdLine.CL.isConsoleMode();
    }

    @Override
    public boolean isServerMode() {
        return CmdLine.CL.isServerMode();
    }

    @Override
    public boolean isGuiMode() {
        return !this.isServerMode() && !this.isSilentMode() && !this.isConsoleMode();
    }

    public File getUninstallLocation() {
        return this.getAgentData(FILENAME_UNINSTALL);
    }

    public static interface IAssignedArtifacts {
        public boolean hasArtifactsForProfile(Profile var1);

        public Collection<IRepository> getRepositories();

        public Collection<IArtifact> getAssignedArtifacts(IRepository var1);

        public void validate(CicMultiStatus var1, IArtifactSession var2, IProgressMonitor var3);
    }

    public static interface IDisableCancel {
        public Object disableCancel();

        public void restoreCancel(Object var1);
    }

    public static interface IPurgeableFiles {
        public long getTotalSize();

        public int getFileCount();

        public IStatus purgeFiles(IProgressMonitor var1);
    }

    static class OfferingComparator
    implements Comparator {
        OfferingComparator() {
        }

        public int compare(Object arg1, Object arg2) {
            boolean isSelfContained1 = Agent.isSelfContainedOffering((IOffering)arg1);
            boolean isSelfContained2 = Agent.isSelfContainedOffering((IOffering)arg2);
            return Comparators.compare((boolean)isSelfContained2, (boolean)isSelfContained1);
        }
    }

    public static class SetRestoreExternalAgentGroup {
        private final Agent agent;
        private final IRepositoryGroup previousExternalGroup;

        public SetRestoreExternalAgentGroup(Agent agent, IRepositoryGroup group) {
            this.agent = agent;
            this.previousExternalGroup = agent.getExternalRepositoryGroup();
            this.agent.setExternalRepositoryGroup(group);
        }

        public void restorePreviousAgentGroup() {
            this.agent.setExternalRepositoryGroup(this.previousExternalGroup);
        }
    }
}

