/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.commonNativeAdapterData;

import com.ibm.cic.common.commonNativeAdapterData.internal.Messages;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.AbstractArtifact;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.model.adapterdata.impl.ArtifactKey;
import java.util.Locale;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public class NativeFileArtifact
extends AbstractArtifact {
    public static final String QUALIFIER = "file";
    public static final String NAMESPACE = "native";
    private final IArtifactKey key;

    public NativeFileArtifact(IInstallableUnit iu, String extension) {
        this(iu.getIdentity(), iu.getVersion(), extension);
    }

    public NativeFileArtifact(IIdentity id, Version version, String extension) {
        assert (extension != null);
        assert (extension.trim().equals(extension));
        assert (extension.equals(extension.toLowerCase(Locale.ENGLISH)));
        assert (extension.length() > 0);
        Path path = new Path(extension);
        assert (!path.isAbsolute());
        assert (path.segmentCount() == 1);
        this.key = new ArtifactKey((IPath)path, NAMESPACE, QUALIFIER, id, version);
    }

    public IArtifactKey getKey() {
        return this.key;
    }

    public static String toUserString(IArtifactKey key, int options) {
        String result;
        String ext;
        if (key == null) {
            return null;
        }
        String string = ext = key.getPath().equals((Object)Path.EMPTY) ? QUALIFIER : key.getPath().toString();
        if (options == 2) {
            result = ext.equals(QUALIFIER) ? NLS.bind((String)Messages.NativeFileArtifact_file_id_only, (Object)key.getId()) : NLS.bind((String)Messages.NativeFileArtifact_file_ext_id_only, (Object)ext, (Object)key.getId());
        } else {
            assert (options == 1);
            result = ext.equals(QUALIFIER) ? NLS.bind((String)Messages.NativeFileArtifact_file, (Object[])new Object[]{key.getId(), key.getVersion()}) : NLS.bind((String)Messages.NativeFileArtifact_file_ext, (Object[])new Object[]{ext, key.getId(), key.getVersion()});
        }
        return result;
    }

    public String toUserString() {
        return NativeFileArtifact.toUserString(this.key, 1);
    }
}

