/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.commonNativeAdapterData;

import com.ibm.cic.common.core.model.Phases;

public class DuringPhases {
    private final long phases;
    private int firstPhase = -1;
    private int lastPhase = -1;
    private static final long INSTALL_MASK = DuringPhases.createMask(Phases.getAllInstallPhases());
    private static final long UNINSTALL_MASK = DuringPhases.createMask(Phases.getAllUninstallPhases());

    public DuringPhases(long phases) {
        this.phases = phases;
    }

    public String toString() {
        return this.getPhases();
    }

    public boolean equals(long otherPhases) {
        return this.phases == otherPhases;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DuringPhases) {
            DuringPhases rhs = (DuringPhases)obj;
            return this.phases == rhs.phases;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.phases ^ this.phases >>> 32);
    }

    public boolean isPhaseSet(int phase) {
        if (phase < 0 || phase > 63) {
            return false;
        }
        return (this.phases & 1L << phase) != 0L;
    }

    public static boolean isFirstPhase(long phases, int phase) {
        if (phase < 0 || phase > 63) {
            return false;
        }
        return phases << 63 - phase == Long.MIN_VALUE;
    }

    public boolean isFirstPhase(int phase) {
        return DuringPhases.isFirstPhase(this.phases, phase);
    }

    public boolean isFirstUninstallPhase(int phase) {
        return DuringPhases.isFirstPhase(this.getUninstallPhases(), phase);
    }

    public static boolean isLastPhase(long phases, int phase) {
        if (phase < 0 || phase > 63) {
            return false;
        }
        return phases >>> phase == 1L;
    }

    public boolean isLastPhase(int phase) {
        return DuringPhases.isLastPhase(this.phases, phase);
    }

    public boolean isLastInstallPhase(int phase) {
        return DuringPhases.isLastPhase(this.getInstallPhases(), phase);
    }

    public int getFirstPhase() {
        if (this.firstPhase == -1) {
            int[] allPhases;
            int[] nArray = allPhases = Phases.getAllPhases();
            int n = allPhases.length;
            int n2 = 0;
            while (n2 < n) {
                int currPhase = nArray[n2];
                if (this.isFirstPhase(currPhase)) {
                    this.firstPhase = currPhase;
                }
                ++n2;
            }
        }
        return this.firstPhase;
    }

    public int getLastPhase() {
        if (this.lastPhase == -1) {
            int[] allPhases;
            int[] nArray = allPhases = Phases.getAllPhases();
            int n = allPhases.length;
            int n2 = 0;
            while (n2 < n) {
                int currPhase = nArray[n2];
                if (this.isLastPhase(currPhase)) {
                    this.lastPhase = currPhase;
                }
                ++n2;
            }
        }
        return this.lastPhase;
    }

    public String getPhases() {
        int[] allPhases = Phases.getAllPhases();
        StringBuffer result = new StringBuffer();
        int[] nArray = allPhases;
        int n = allPhases.length;
        int n2 = 0;
        while (n2 < n) {
            int phase = nArray[n2];
            if (this.isPhaseSet(phase)) {
                if (result.length() > 0) {
                    result.append(',');
                }
                result.append(Phases.phaseToName((int)phase));
            }
            ++n2;
        }
        return result.toString();
    }

    private static long createMask(int[] phases) {
        long mask = 0L;
        int[] nArray = phases;
        int n = phases.length;
        int n2 = 0;
        while (n2 < n) {
            int phase = nArray[n2];
            mask |= 1L << phase;
            ++n2;
        }
        return mask;
    }

    public long getInstallPhases() {
        return this.phases & INSTALL_MASK;
    }

    public long getUninstallPhases() {
        return this.phases & UNINSTALL_MASK;
    }
}

