/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.commonNativeAdapterData;

import com.ibm.cic.common.commonNativeAdapterData.CommonNativeAdapterUtils;
import com.ibm.cic.common.commonNativeAdapterData.DuringPhases;
import com.ibm.cic.common.commonNativeAdapterData.ICommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.IDuringPhasesCommonNativeData;
import com.ibm.cic.common.core.model.Phases;

public abstract class AbstractDuringPhasesCommonNativeData
extends ICommonNativeData
implements IDuringPhasesCommonNativeData {
    private IDuringPhasesCommonNativeData parent;
    private final DuringPhases explicitPhases;
    private static final String DEFAULT_PHASES_STR = String.valueOf(Phases.phaseToName((int)21)) + "," + Phases.phaseToName((int)51);
    protected static final long DEFAULT_PHASES = CommonNativeAdapterUtils.parsePhases(DEFAULT_PHASES_STR);

    public AbstractDuringPhasesCommonNativeData(IDuringPhasesCommonNativeData parent, DuringPhases explicitPhases) {
        this.parent = parent;
        this.explicitPhases = explicitPhases;
    }

    @Override
    public void setDuringPhasesParent(IDuringPhasesCommonNativeData parent) {
        this.parent = parent;
    }

    @Override
    public IDuringPhasesCommonNativeData getDuringPhasesParent() {
        return this.parent;
    }

    @Override
    public DuringPhases getContextDuringPhases() {
        DuringPhases duringPhases = null;
        if (this.parent != null) {
            duringPhases = this.parent.getDuringPhases();
        }
        if (duringPhases != null) {
            return duringPhases;
        }
        return new DuringPhases(DEFAULT_PHASES);
    }

    @Override
    public boolean isDuringPhasesExplicit() {
        return this.explicitPhases != null;
    }

    @Override
    public boolean isContextDuringPhases() {
        if (this.explicitPhases == null) {
            return true;
        }
        return this.explicitPhases.equals(this.getContextDuringPhases());
    }

    @Override
    public DuringPhases getDuringPhases() {
        if (this.explicitPhases != null) {
            return this.explicitPhases;
        }
        return this.getContextDuringPhases();
    }

    @Override
    public String getPhases() {
        return this.getDuringPhases().getPhases();
    }

    private long getInstallPhases() {
        return this.getDuringPhases().getInstallPhases();
    }

    private long getUninstallPhases() {
        return this.getDuringPhases().getUninstallPhases();
    }

    @Override
    public boolean isFirstUninstallPhase(int phase) {
        return DuringPhases.isFirstPhase(this.getUninstallPhases(), phase);
    }

    @Override
    public boolean isLastInstallPhase(int phase) {
        return DuringPhases.isLastPhase(this.getInstallPhases(), phase);
    }

    protected int getFirstPhaseToInstall() {
        int first = this.getDuringPhases().getFirstPhase();
        int phaseToInstall = Phases.isInstallationPhase((int)first) ? first : 21;
        return phaseToInstall;
    }

    @Override
    public boolean canInstallArtifact(int currPhase) {
        int firstToInstall = this.getFirstPhaseToInstall();
        return currPhase == firstToInstall;
    }

    @Override
    public boolean canUninstallArtifact(int currPhase) {
        int last = this.getDuringPhases().getLastPhase();
        return last != -1 && currPhase == last;
    }

    @Override
    public boolean shouldBeInstalled(int currPhase) {
        int firstToInstall = this.getFirstPhaseToInstall();
        int last = this.getDuringPhases().getLastPhase();
        if (firstToInstall == -1 || last == -1) {
            return false;
        }
        return firstToInstall <= currPhase && currPhase <= last;
    }
}

