/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core.p2;

import com.ibm.cic.agent.core.BitModeUtils;
import com.ibm.cic.agent.core.api.IProfile;
import com.ibm.cic.agent.internal.core.p2.Activator;
import com.ibm.cic.agent.internal.core.p2.Messages;
import com.ibm.cic.agent.internal.core.p2.P2VersionUtil;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.IAdapterData;
import com.ibm.cic.common.core.model.utils.SupportedPlatforms;
import com.ibm.cic.common.eclipseAdapterData.EclipseAdapterData;
import com.ibm.cic.common.eclipseAdapterData.EclipseBundleData;
import com.ibm.cic.common.eclipseAdapterData.EclipseFeatureData;
import com.ibm.cic.common.eclipseAdapterData.IEclipseData;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.p2EclipseAdapterData.IP2EclipseAdapterData;
import com.ibm.cic.common.p2EclipseAdapterData.IP2ReferenceData;
import com.ibm.cic.common.p2EclipseAdapterData.P2ReferenceData;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.osgi.framework.Version;

public class Utils {
    public static List<IP2ReferenceData> getP2ReferencesList(IInstallableUnit unit) {
        List references;
        String adapterId = unit.getAdapterId();
        if (!adapterId.equals("p2Eclipse")) {
            return null;
        }
        IAdapterData adapterData = unit.getAdapterData();
        if (adapterData instanceof EclipseAdapterData) {
            EclipseAdapterData data = (EclipseAdapterData)adapterData;
            references = Utils.getP2ReferencesList(data);
        } else {
            IP2EclipseAdapterData data = (IP2EclipseAdapterData)adapterData;
            references = data.getP2ReferencesList();
        }
        return references;
    }

    public static String getOS(IProfile profile) {
        String os = Utils.getData(profile.getOS());
        if (os == null) {
            os = Platform.getOS();
        }
        return os;
    }

    public static String getWS(IProfile profile) {
        String ws = Utils.getData(profile.getWS());
        if (ws == null) {
            ws = SupportedPlatforms.getInstance().getLegacyWs(Utils.getOS(profile), Utils.getOSArch(profile));
        }
        return ws;
    }

    public static String getOSArch(IProfile profile) {
        String arch = Utils.getData(profile.getArch());
        if (arch == null) {
            return BitModeUtils.get32bitArch();
        }
        return arch;
    }

    private static String getData(String data) {
        if (data != null && (data.indexOf(44) >= 0 || data.equals("*"))) {
            return null;
        }
        return data;
    }

    private static List getP2ReferencesList(EclipseAdapterData data) {
        Collection dataElements = data.getDataElements();
        for (IEclipseData elem : dataElements) {
            P2ReferenceData reference = null;
            if (elem instanceof EclipseFeatureData) {
                EclipseFeatureData feature = (EclipseFeatureData)elem;
                reference = new P2ReferenceData(Utils.getFeatureId(feature), feature.getVersion().toString());
                reference.setForceInstall(IP2ReferenceData.ForceInstall.YES);
            } else if (elem instanceof EclipseBundleData) {
                EclipseBundleData bundle = (EclipseBundleData)elem;
                reference = new P2ReferenceData(bundle.getId(), bundle.getVersion().toString());
                reference.setForceInstall(IP2ReferenceData.ForceInstall.NO);
            }
            if (reference == null) continue;
            return Collections.singletonList(reference);
        }
        return Collections.EMPTY_LIST;
    }

    private static String getFeatureId(EclipseFeatureData feature) {
        String id = String.valueOf(feature.getId()) + ".feature.group";
        return id;
    }

    public static org.eclipse.equinox.p2.metadata.IInstallableUnit findP2Unit(Logger log, IQueryable<org.eclipse.equinox.p2.metadata.IInstallableUnit> metadata, String id, org.eclipse.equinox.p2.metadata.Version version) {
        VersionRange range = new VersionRange(version, true, version, true);
        IQuery query = QueryUtil.createIUQuery((String)id, (VersionRange)range);
        IQueryResult queryResult = metadata.query(query, null);
        if (queryResult.isEmpty()) {
            if (log != null) {
                log.error(Messages.P2EngineOperation_p2UnitNotFound, new Object[]{id, version.toString()});
            }
            return null;
        }
        org.eclipse.equinox.p2.metadata.IInstallableUnit p2unit = (org.eclipse.equinox.p2.metadata.IInstallableUnit)queryResult.iterator().next();
        return p2unit;
    }

    public static org.eclipse.equinox.p2.metadata.IInstallableUnit findP2Unit(Logger log, IQueryable<org.eclipse.equinox.p2.metadata.IInstallableUnit> metadata, IP2ReferenceData ref) {
        org.eclipse.equinox.p2.metadata.Version version = org.eclipse.equinox.p2.metadata.Version.parseVersion((String)ref.getVersionStr());
        return Utils.findP2Unit(log, metadata, ref.getId(), version);
    }

    public static boolean isBundleUnit(org.eclipse.equinox.p2.metadata.IInstallableUnit unit) {
        for (IProvidedCapability capability : unit.getProvidedCapabilities()) {
            if (!capability.getNamespace().equals("osgi.bundle")) continue;
            return true;
        }
        return false;
    }

    public static boolean isFeatureUnit(org.eclipse.equinox.p2.metadata.IInstallableUnit p2unit) {
        return p2unit.getId().endsWith(".feature.group");
    }

    public static IRequiredCapability determineInstallRequirement(IP2ReferenceData.ForceInstall forceInstall, org.eclipse.equinox.p2.metadata.IInstallableUnit unit, Version osgiVersion, boolean useTightTolerance) {
        assert (forceInstall != null);
        assert (unit != null);
        assert (osgiVersion != null);
        VersionRange range = null;
        switch (forceInstall) {
            case YES: {
                range = Utils.forceInstallRequirementRange(unit, osgiVersion, useTightTolerance);
                break;
            }
            case NO: {
                break;
            }
            case DEFAULT: {
                if (Utils.isBundleUnit(unit)) break;
                range = Utils.forceInstallRequirementRange(unit, osgiVersion, useTightTolerance);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        IRequiredCapability installReq = null;
        if (range != null) {
            installReq = Utils.createRequiredCapability(unit.getId(), range);
        }
        return installReq;
    }

    private static VersionRange forceInstallRequirementRange(org.eclipse.equinox.p2.metadata.IInstallableUnit unit, Version osgiVersion, boolean useTightTolerance) {
        VersionRange range = Utils.isFeatureUnit(unit) ? Utils.forceInstallFeatureGroupRequirementRange(osgiVersion, useTightTolerance) : Utils.forceInstallNonFeatureRequirementRange(osgiVersion, useTightTolerance);
        return range;
    }

    private static VersionRange forceInstallFeatureGroupRequirementRange(Version osgiVersion, boolean useTightTolerance) {
        VersionRange range = useTightTolerance ? P2VersionUtil.createExactP2Tolerance(osgiVersion) : P2VersionUtil.createCompatibleP2Tolerance(osgiVersion);
        return range;
    }

    private static VersionRange forceInstallNonFeatureRequirementRange(Version osgiVersion, boolean useTightTolerance) {
        VersionRange range = useTightTolerance ? P2VersionUtil.createEquivalentP2Tolerance(osgiVersion) : VersionRange.emptyRange;
        return range;
    }

    private static IRequiredCapability createRequiredCapability(String id, VersionRange tolerance) {
        return (IRequiredCapability)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)tolerance, null, (int)1, (int)1, (boolean)true);
    }

    public static void removeAllRepositories(IMetadataRepositoryManager repoMgr) {
        URI[] repos;
        URI[] uRIArray = repos = repoMgr.getKnownRepositories(0);
        int n = repos.length;
        int n2 = 0;
        while (n2 < n) {
            URI repo = uRIArray[n2];
            repoMgr.removeRepository(repo);
            ++n2;
        }
    }

    public static IStatus readPropertiesFile(File propertiesFile, Properties properties) {
        block17: {
            BufferedInputStream inputStream = null;
            try {
                inputStream = new BufferedInputStream(new FileInputStream(propertiesFile));
                properties.load(inputStream);
            }
            catch (FileNotFoundException fnfe) {
                String msg = Messages.bind((String)Messages.P2EngineOperation_fileNotFound, (Object)propertiesFile);
                Status status = new Status(4, Activator.getPluginId(), msg, (Throwable)fnfe);
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                return status;
            }
            catch (IOException ioe) {
                Status status;
                block16: {
                    try {
                        String msg = Messages.bind((String)Messages.P2EngineOperation_errorReadingFile, (Object)propertiesFile);
                        status = new Status(4, Activator.getPluginId(), msg, (Throwable)ioe);
                        if (inputStream == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                return status;
            }
            if (inputStream == null) break block17;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return Status.OK_STATUS;
    }
}

