/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core.p2;

import com.ibm.cic.common.core.utils.MapSet;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.p2.model.internal.P2MatchQuery;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.Version;

public class P2FilterQuery
extends P2MatchQuery {
    private static final Logger log = Logger.getLogger(P2FilterQuery.class);
    private final MapSet<String, Version> p2Units;

    public P2FilterQuery(MapSet<String, Version> p2Units) {
        this.p2Units = p2Units;
    }

    public boolean isMatch(Object candidate) {
        if (!(candidate instanceof IInstallableUnit)) {
            return false;
        }
        IInstallableUnit iu = (IInstallableUnit)candidate;
        if (iu instanceof IInstallableUnitFragment) {
            return false;
        }
        String id = iu.getId();
        Version version = iu.getVersion();
        if ("tooling.osgi.bundle.default".equals(id) || "tooling.org.eclipse.update.feature.default".equals(id) || "tooling.source.default".equals(id) || "a.jre".equals(id) || "a.jre.javase".equals(id) || this.p2Units.contains((Object)id, (Object)version)) {
            return false;
        }
        log.debug("Filter out IU {0} {1}", new Object[]{id, version});
        return true;
    }
}

