/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core.p2;

import com.ibm.cic.agent.core.AgentJob;
import com.ibm.cic.agent.core.AgentUtil;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.InstallTransaction;
import com.ibm.cic.agent.core.Profile;
import com.ibm.cic.agent.core.utils.AgentUserOptions;
import com.ibm.cic.agent.internal.core.InstallRegistry;
import com.ibm.cic.agent.internal.core.p2.Activator;
import com.ibm.cic.agent.internal.core.p2.FragmentQuery;
import com.ibm.cic.agent.internal.core.p2.Messages;
import com.ibm.cic.agent.internal.core.p2.P2ArtifactsXmlWriter;
import com.ibm.cic.agent.internal.core.p2.P2Configuration;
import com.ibm.cic.agent.internal.core.p2.P2Constants;
import com.ibm.cic.agent.internal.core.p2.P2EclipseQualificationHistory;
import com.ibm.cic.agent.internal.core.p2.P2Engine;
import com.ibm.cic.agent.internal.core.p2.P2FilterQuery;
import com.ibm.cic.agent.internal.core.p2.P2PlatformXmlFixup;
import com.ibm.cic.agent.internal.core.p2.P2Services;
import com.ibm.cic.agent.internal.core.p2.Utils;
import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IFix;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.InstallableUnitPair;
import com.ibm.cic.common.core.repository.IContentRepository;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.MapSet;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.UnsupportedOperationException;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.logging.Level;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.p2EclipseAdapterData.IP2EclipseAdapterData;
import com.ibm.cic.common.p2EclipseAdapterData.IP2ReferenceData;
import com.ibm.cic.p2.model.CicP2Model;
import com.ibm.icu.util.GregorianCalendar;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.director.PlanExecutionHelper;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.util.NLS;

public class P2EngineOperation {
    private static final Logger log = Logger.getLogger(P2EngineOperation.class);
    private static final Util.Formatter MULTI_LINE_FORMATTER = new Util.Formatter("\n");
    private static final String LAUNCHER_PLUGIN_ID = "org.eclipse.equinox.launcher";
    private P2Services p2Services;
    private final InstallTransaction directorTransaction;
    private final InstallableUnitPair[] ius;
    private final InstallContext context;
    private final AgentJob[] jobs;
    private final boolean profileMustExist;
    private String profileId;
    private boolean isFinalUninstall;
    private URI[] artifactRepositories = null;
    private URI[] metadataRepositories = null;
    private IProvisioningPlan plan = null;
    private Version planVersion = Version.emptyVersion;
    private File p2DataArea = null;
    private boolean cacheWasAdded = false;
    private List<IP2ReferenceData> installData = null;
    private IP2ReferenceData launcherStartupPlugin = null;
    private IP2ReferenceData launcherLibraryPlugin = null;
    private ArrayList<IInstallableUnit> bundleData = null;
    private File launcherPath = null;
    private static final String[] configDirsToDelete = new String[]{"org.eclipse.osgi", "org.eclipse.core.runtime", "org.eclipse.equinox.app", "org.eclipse.equinox.launcher", "org.eclipse.equinox.source", "org.eclipse.ui.intro.universal", "org.eclipse.equinox.simpleconfigurator", ".settings"};
    private static final String[] configFilesToDelete = new String[]{"config.ini"};

    public P2EngineOperation(InstallTransaction directorTransaction, InstallableUnitPair[] ius, InstallContext context, AgentJob[] jobs, boolean profileMustExist) {
        this.directorTransaction = directorTransaction;
        this.ius = ius;
        this.context = context;
        this.jobs = jobs;
        this.profileMustExist = profileMustExist;
        this.isFinalUninstall = AgentUtil.isFinalUninstall((Profile)context.getEnclosingProfile(), (AgentJob[])jobs);
    }

    public IStatus perform(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, new int[]{1, 1, 9, 44, 1});
        try {
            if (!AgentUserOptions.CIC_AGENT_P2_ENABLED.isSet()) {
                throw new UnsupportedOperationException();
            }
            status = this.initialize();
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                IStatus iStatus = status;
                return iStatus;
            }
            status = this.addCache(spm.next());
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                IStatus iStatus = status;
                return iStatus;
            }
            status = this.installLauncherPlugins(spm.next());
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                IStatus iStatus = status;
                return iStatus;
            }
            status = this.computePlan(spm.next());
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                IStatus iStatus = status;
                return iStatus;
            }
            status = PlanExecutionHelper.executePlan((IProvisioningPlan)this.plan, (IEngine)this.p2Services.getEngine(), null, (IProgressMonitor)spm.next());
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                IStatus iStatus = status;
                return iStatus;
            }
            try {
                this.saveProfileProperties();
                if (this.isFinalUninstall()) {
                    log.statusNotOK(this.removeCache());
                    if (!this.context.getEnclosingProfile().isExistingEclipseProfile()) {
                        this.cleanupAfterFinalUninstall();
                    } else {
                        status = this.fixupPlatformXml(spm.next());
                    }
                } else {
                    status = this.fixupPlatformXml(spm.next());
                }
                P2Engine.getInstance().saveQualificationHistory();
            }
            catch (Exception e) {
                status = new Status(4, Activator.getPluginId(), e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if (this.cacheWasAdded && StatusUtil.isErrorOrCancel((IStatus)status)) {
                log.statusNotOK(this.removeCache());
            }
            spm.done();
            monitor.done();
        }
        return status;
    }

    public IStatus getAdditionsAndRemovals(Map additions, Map removals, IProgressMonitor monitor) {
        IStatus status = this.initialize();
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            return status;
        }
        P2EclipseQualificationHistory qualificationHistory = new P2EclipseQualificationHistory(this.context.getEnclosingProfile());
        qualificationHistory.load();
        P2Engine.getInstance().setQualificationHistory(qualificationHistory);
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, new int[]{90, 1, 1, 1});
        try {
            IInstallableUnit[] added;
            IInstallableUnit[] removed;
            status = this.computePlan(spm.next());
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                IStatus iStatus = status;
                return iStatus;
            }
            IQueryResult remQuery = this.plan.getRemovals().query(QueryUtil.ALL_UNITS, spm.next());
            IInstallableUnit[] iInstallableUnitArray = removed = (IInstallableUnit[])remQuery.toArray(IInstallableUnit.class);
            int n = removed.length;
            int n2 = 0;
            while (n2 < n) {
                IInstallableUnit iuToRemove = iInstallableUnitArray[n2];
                removals.put(this.getVersionedUnitId(iuToRemove), iuToRemove);
                qualificationHistory.remove(iuToRemove);
                ++n2;
            }
            IQueryResult addQuery = this.plan.getAdditions().query(QueryUtil.ALL_UNITS, spm.next());
            IInstallableUnit[] iInstallableUnitArray2 = added = (IInstallableUnit[])addQuery.toArray(IInstallableUnit.class);
            int n3 = added.length;
            int n4 = 0;
            while (n4 < n3) {
                IInstallableUnit iuToAdd = iInstallableUnitArray2[n4];
                additions.put(this.getVersionedUnitId(iuToAdd), iuToAdd);
                qualificationHistory.add(iuToAdd);
                ++n4;
            }
            status = this.checkPatches(qualificationHistory, spm.next());
            if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                IStatus iStatus = status;
                return iStatus;
            }
        }
        finally {
            spm.done();
            monitor.done();
        }
        return status;
    }

    public void dispose() {
        this.unloadMetadataRepositories();
        this.unloadArtifactRepositories();
        if (this.p2Services != null) {
            this.p2Services.dispose();
            this.p2Services = null;
        }
    }

    public P2Services getP2Services() {
        return this.p2Services;
    }

    protected InstallTransaction getDirectorTransaction() {
        return this.directorTransaction;
    }

    private IStatus computePlan(IProgressMonitor monitor) {
        Status status;
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, new int[]{1, 1, 2, 2, 40});
        try {
            try {
                this.loadMetadataRepositories(spm.next());
                this.loadArtifactRepositories(spm.next());
                IProfile p = this.getOrCreateProfile();
                ProfileChangeRequest request = new ProfileChangeRequest(p);
                IInstallableUnit selectionContext = this.createSelectionContext(p);
                IInstallableUnit[] toInstall = this.computeUnitsToInstall(selectionContext, spm.next());
                IInstallableUnit[] toUninstall = this.computeUnitsToUninstall(spm.next());
                this.logUnits("installing", toInstall);
                this.logUnits("uninstalling", toUninstall);
                request.removeInstallableUnits(toUninstall);
                request.addInstallableUnits(toInstall);
                if (toInstall.length == 0) {
                    this.planVersion = Version.emptyVersion;
                    this.isFinalUninstall = true;
                } else {
                    IInstallableUnit groupUnit = toInstall[0];
                    this.planVersion = groupUnit.getVersion();
                }
                IInstallableUnit[] iInstallableUnitArray = toInstall;
                int n = toInstall.length;
                int n2 = 0;
                while (n2 < n) {
                    IInstallableUnit element = iInstallableUnitArray[n2];
                    request.setInstallableUnitProfileProperty(element, "org.eclipse.equinox.p2.type.root", Boolean.toString(true));
                    ++n2;
                }
                this.plan = this.p2Services.getPlanner().getProvisioningPlan((IProfileChangeRequest)request, null, spm.next());
                status = this.plan.getStatus();
            }
            catch (Exception e) {
                status = new Status(4, Activator.getPluginId(), e.getMessage(), (Throwable)e);
                spm.done();
                monitor.done();
            }
        }
        finally {
            spm.done();
            monitor.done();
        }
        return status;
    }

    private IStatus initialize() {
        try {
            P2Configuration p2Configuration = new P2Configuration(this.context);
            this.profileId = p2Configuration.getP2ProfileId();
            this.p2DataArea = p2Configuration.getP2DataArea();
            this.p2Services = new P2Services(this.p2DataArea);
            this.launcherPath = this.readLauncherPath();
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (Exception e) {
            return new Status(4, Activator.getPluginId(), e.getMessage(), (Throwable)e);
        }
    }

    private String getProfileId() {
        return this.profileId;
    }

    private Version getProfileVersion() {
        String versionString = this.context.getLocalProperty("P2_PROFILE_VERSION");
        return versionString != null ? Version.parseVersion((String)versionString) : null;
    }

    private void saveProfileProperties() {
        this.context.setLocalProperty("P2_PROFILE_ID", (Object)this.getProfileId());
        this.context.setLocalProperty("P2_PROFILE_VERSION", (Object)this.planVersion.toString());
        this.context.setLocalProperty("P2_DATA_AREA", (Object)this.p2DataArea.toString());
    }

    public boolean isFinalUninstall() {
        return this.isFinalUninstall;
    }

    private IProfile getProfile() {
        String id;
        IProfileRegistry profileRegistry = this.p2Services.getProfileRegistry();
        IProfile profile = profileRegistry.getProfile(id = this.getProfileId());
        if (profile != null && !profileRegistry.isCurrent(profile)) {
            profile = profileRegistry.getProfile(id);
        }
        return profile;
    }

    private IProfile createProfile() throws ProvisionException {
        IProfile profile = this.getProfile();
        if (profile == null) {
            HashMap<String, String> properties = new HashMap<String, String>();
            String installLocation = this.context.getInstallLocation();
            properties.put("org.eclipse.equinox.p2.installFolder", installLocation);
            properties.put("org.eclipse.equinox.p2.configurationFolder", this.context.getLocation("configLocation"));
            Profile cicProfile = this.context.getEnclosingProfile();
            String env = "osgi.os=" + Utils.getOS((com.ibm.cic.agent.core.api.IProfile)cicProfile) + ",osgi.ws=" + Utils.getWS((com.ibm.cic.agent.core.api.IProfile)cicProfile) + ",osgi.arch=" + Utils.getOSArch((com.ibm.cic.agent.core.api.IProfile)cicProfile);
            properties.put("org.eclipse.equinox.p2.environments", env);
            properties.put("org.eclipse.equinox.p2.name", this.getProfileId());
            properties.put("org.eclipse.equinox.p2.cache", installLocation);
            properties.put("org.eclipse.update.install.features", Boolean.TRUE.toString());
            profile = this.p2Services.getProfileRegistry().addProfile(this.getProfileId(), properties);
        }
        return profile;
    }

    private IProfile getOrCreateProfile() throws ProvisionException {
        IProfile p = this.getProfile();
        if (p == null) {
            if (this.profileMustExist) {
                throw new IllegalStateException(NLS.bind((String)Messages.P2EngineOperation_p2ProfileNotFound, (Object)this.getProfileId()));
            }
            p = this.createProfile();
        }
        return p;
    }

    private void loadMetadataRepositories(IProgressMonitor monitor) throws CoreException {
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, 2);
        try {
            IMetadataRepositoryManager repoMgr = this.p2Services.getMetadataRepoMan();
            Utils.removeAllRepositories(repoMgr);
            URI[] repos = this.getMetadataRepositories(spm.next());
            SplitProgressMonitor spm2 = new SplitProgressMonitor(spm.next(), repos.length + 1);
            try {
                this.loadMetadataCacheRepository(spm2.next());
                URI[] uRIArray = repos;
                int n = repos.length;
                int n2 = 0;
                while (n2 < n) {
                    URI repo = uRIArray[n2];
                    repoMgr.loadRepository(repo, spm2.next());
                    ++n2;
                }
            }
            finally {
                spm2.done();
            }
        }
        finally {
            spm.done();
            monitor.done();
        }
    }

    private void loadArtifactRepositories(IProgressMonitor monitor) throws ProvisionException {
        URI[] repos = this.getArtifactRepositories();
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, repos.length);
        try {
            URI[] uRIArray = repos;
            int n = repos.length;
            int n2 = 0;
            while (n2 < n) {
                URI repo = uRIArray[n2];
                this.p2Services.getArtifactRepoMan().loadRepository(repo, spm.next());
                ++n2;
            }
        }
        finally {
            spm.done();
            monitor.done();
        }
    }

    private void unloadMetadataRepositories() {
        if (this.metadataRepositories != null) {
            URI[] repos;
            URI[] uRIArray = repos = this.metadataRepositories;
            int n = repos.length;
            int n2 = 0;
            while (n2 < n) {
                URI repo = uRIArray[n2];
                this.p2Services.getMetadataRepoMan().removeRepository(repo);
                FileUtil.rm_r((File)new File(repo), (boolean)true);
                ++n2;
            }
            this.metadataRepositories = null;
        }
    }

    private void unloadArtifactRepositories() {
        if (this.artifactRepositories != null) {
            URI[] repos;
            URI[] uRIArray = repos = this.artifactRepositories;
            int n = repos.length;
            int n2 = 0;
            while (n2 < n) {
                URI repo = uRIArray[n2];
                this.p2Services.getArtifactRepoMan().removeRepository(repo);
                ++n2;
            }
            this.artifactRepositories = null;
        }
    }

    private IInstallableUnit[] computeUnitsToInstall(IInstallableUnit selectionContext, IProgressMonitor monitor) {
        ArrayList<IRequirement> result;
        block4: {
            result = new ArrayList<IRequirement>();
            SplitProgressMonitor spm = new SplitProgressMonitor(monitor, new int[]{1, 3, 7});
            try {
                List<IP2ReferenceData> data = this.getInstallData(spm.next());
                this.addUnits(result, data, spm.next());
                if (result.size() != 0) {
                    this.addCuFragments(result, selectionContext, spm.next());
                    break block4;
                }
                spm.next().done();
                IInstallableUnit[] iInstallableUnitArray = new IInstallableUnit[]{};
                return iInstallableUnitArray;
            }
            finally {
                spm.done();
                monitor.done();
            }
        }
        this.addDefaultBundles(result);
        return new IInstallableUnit[]{this.createGroup(result)};
    }

    private String getGroupId() {
        return this.context.getUniqueId();
    }

    private IInstallableUnit[] computeUnitsToUninstall(IProgressMonitor monitor) {
        try {
            IInstallableUnit[] iInstallableUnitArray;
            Version version = this.getProfileVersion();
            if (version == null) {
                IInstallableUnit[] iInstallableUnitArray2 = new IInstallableUnit[]{};
                return iInstallableUnitArray2;
            }
            IProfile profile = this.getProfile();
            IInstallableUnit oldUnit = Utils.findP2Unit(log, (IQueryable<IInstallableUnit>)profile, this.getGroupId(), version);
            if (oldUnit == null) {
                oldUnit = Utils.findP2Unit(log, (IQueryable<IInstallableUnit>)profile, this.getProfileId(), version);
            }
            if (oldUnit == null) {
                iInstallableUnitArray = new IInstallableUnit[]{};
            } else {
                IInstallableUnit[] iInstallableUnitArray3 = new IInstallableUnit[1];
                iInstallableUnitArray = iInstallableUnitArray3;
                iInstallableUnitArray3[0] = oldUnit;
            }
            IInstallableUnit[] iInstallableUnitArray4 = iInstallableUnitArray;
            return iInstallableUnitArray4;
        }
        finally {
            monitor.done();
        }
    }

    private void loadMetadataCacheRepository(IProgressMonitor monitor) throws ProvisionException {
        block6: {
            try {
                URI uri = this.getMetadataRepositoryURI(this.p2Services.getAgentLocation());
                if (uri == null) break block6;
                try {
                    this.p2Services.getMetadataRepoMan().loadRepository(uri, monitor);
                }
                catch (ProvisionException e) {
                    if (e.getStatus().getCode() != 1000) {
                        throw e;
                    }
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private URI getMetadataRepositoryURI(IAgentLocation loc) {
        return URIUtil.append((URI)loc.getDataArea("org.eclipse.equinox.p2.core"), (String)"cache/");
    }

    private void addDefaultBundles(ArrayList<IRequirement> result) {
        this.addDefaultBundle(result, "tooling.osgi.bundle.default", P2Constants.TOOLING_OSGI_BUNDLE_DEFAULT_VERSION);
        this.addDefaultBundle(result, "tooling.org.eclipse.update.feature.default", P2Constants.TOOLING_UPDATE_FEATURE_DEFAULT_VERSION);
        this.addDefaultBundle(result, "tooling.source.default", P2Constants.TOOLING_SOURCE_DEFAULT_VERSION);
    }

    private void addDefaultBundle(ArrayList<IRequirement> result, String id, Version version) {
        IInstallableUnit p2unit = this.findP2Unit(id, version);
        if (p2unit != null) {
            result.add((IRequirement)this.createInstallRequirement(p2unit));
        }
    }

    private IStatus getSessionP2Repositories(ArrayList repositories, IProgressMonitor monitor) {
        Profile profile = this.context.getEnclosingProfile();
        HashSet<String> seenBefore = new HashSet<String>();
        InstallRegistry.ProfileInstallRegistry registry = profile.getInstallRegistry();
        IOffering[] installedOfferings = registry.getInstalledOfferings();
        IFix[] installedFixes = registry.getInstalledFixes();
        MapSet<String, Version> p2Units = this.createP2UnitIdToVersionsMap();
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, this.jobs.length + installedOfferings.length + installedFixes.length);
        try {
            try {
                AgentJob[] agentJobArray = this.jobs;
                int n = this.jobs.length;
                int n2 = 0;
                while (n2 < n) {
                    AgentJob job = agentJobArray[n2];
                    IProgressMonitor nextMonitor = spm.next();
                    if (profile.equals(job.getProfile())) {
                        IOfferingOrFix oof = job.getOfferingOrFix();
                        this.addRepository(repositories, seenBefore, p2Units, oof, nextMonitor);
                    }
                    ++n2;
                }
                agentJobArray = installedOfferings;
                n = installedOfferings.length;
                n2 = 0;
                while (n2 < n) {
                    AgentJob offering = agentJobArray[n2];
                    this.addRepository(repositories, seenBefore, p2Units, (IOfferingOrFix)offering, spm.next());
                    ++n2;
                }
                agentJobArray = installedFixes;
                n = installedFixes.length;
                n2 = 0;
                while (n2 < n) {
                    AgentJob fix = agentJobArray[n2];
                    this.addRepository(repositories, seenBefore, p2Units, (IOfferingOrFix)fix, spm.next());
                    ++n2;
                }
            }
            catch (IOException e) {
                Status status = new Status(4, Activator.getPluginId(), e.getMessage(), (Throwable)e);
                spm.done();
                monitor.done();
                return status;
            }
            catch (CoreException e) {
                IStatus iStatus = e.getStatus();
                spm.done();
                monitor.done();
                return iStatus;
            }
        }
        finally {
            spm.done();
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private void addRepository(ArrayList repositories, HashSet<String> seenBefore, MapSet<String, Version> p2Units, IOfferingOrFix oof, IProgressMonitor monitor) throws CoreException, IOException {
        File tempDir;
        if (seenBefore.add(oof.getIdentity().getId()) && (tempDir = this.getFilteredP2Repository(oof, p2Units, monitor)) != null) {
            repositories.add(tempDir.toURI());
        }
    }

    private File getFilteredP2Repository(IOfferingOrFix oof, MapSet<String, Version> p2Units, IProgressMonitor monitor) throws CoreException, IOException {
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, 4);
        IContentRepository contentRepo = RepositoryUtils.getContentRepository((IContent)oof);
        if (contentRepo == null || !contentRepo.containsP2Repository(spm.next())) {
            return null;
        }
        File tempDir = FileUtil.createTempDir((String)oof.getIdentity().getId(), null, null);
        File destFile = new File(tempDir, "content.xml");
        StatusUtil.throwIfError((IStatus)contentRepo.exportP2Repository(destFile, spm.next()));
        IMetadataRepositoryManager metadataRepoMan = this.p2Services.getMetadataRepoMan();
        IMetadataRepository p2Repo = metadataRepoMan.loadRepository(tempDir.toURI(), 0, spm.next());
        try {
            P2FilterQuery query = new P2FilterQuery(p2Units);
            IQueryResult result = p2Repo.query((IQuery)query, spm.next());
            p2Repo.removeInstallableUnits((Collection)result.toUnmodifiableSet());
        }
        finally {
            metadataRepoMan.removeRepository(p2Repo.getLocation());
        }
        return tempDir;
    }

    private MapSet<String, Version> createP2UnitIdToVersionsMap() {
        MapSet.MapHashSet p2Units = new MapSet.MapHashSet(new HashMap(this.ius.length));
        InstallableUnitPair[] installableUnitPairArray = this.ius;
        int n = this.ius.length;
        int n2 = 0;
        while (n2 < n) {
            InstallableUnitPair iu2 = installableUnitPairArray[n2];
            com.ibm.cic.common.core.model.IInstallableUnit iu = iu2.getTo();
            if (iu != null && iu.getAdapterData() instanceof IP2EclipseAdapterData) {
                IP2EclipseAdapterData p2ad = (IP2EclipseAdapterData)iu.getAdapterData();
                for (IP2ReferenceData p2AdapterData : p2ad.getP2ReferencesList()) {
                    p2Units.add((Object)p2AdapterData.getId(), (Object)CicP2Model.fromOSGiVersion((org.osgi.framework.Version)p2AdapterData.getVersion()));
                }
            }
            ++n2;
        }
        return p2Units;
    }

    private URI[] getMetadataRepositories(IProgressMonitor monitor) throws CoreException {
        if (this.metadataRepositories == null) {
            ArrayList repositories = new ArrayList();
            IStatus status = this.getSessionP2Repositories(repositories, monitor);
            if (!status.isOK()) {
                throw new CoreException(status);
            }
            this.metadataRepositories = repositories.toArray(new URI[repositories.size()]);
        } else {
            monitor.done();
        }
        return this.metadataRepositories;
    }

    private URI[] getArtifactRepositories() {
        if (this.artifactRepositories == null) {
            this.artifactRepositories = new URI[0];
        }
        return this.artifactRepositories;
    }

    private IInstallableUnit findP2Unit(IP2ReferenceData ref) {
        String id = ref.getId();
        Version version = Version.parseVersion((String)ref.getVersionStr());
        return this.findP2Unit(id, version);
    }

    private IInstallableUnit findP2Unit(String id, Version version) {
        return Utils.findP2Unit(log, (IQueryable<IInstallableUnit>)this.p2Services.getMetadataRepoMan(), id, version);
    }

    private void addCuFragments(ArrayList<IRequirement> list, IInstallableUnit selectionContext, IProgressMonitor monitor) {
        FragmentQuery query = new FragmentQuery(selectionContext, this.bundleData);
        IQueryResult result = this.p2Services.getMetadataRepoMan().query((IQuery)query, monitor);
        Set units = result.toUnmodifiableSet();
        ArrayList<IRequiredCapability> cuInstallReqs = new ArrayList<IRequiredCapability>(units.size());
        for (IInstallableUnit unit : units) {
            IRequiredCapability installReq = this.createInstallRequirement(unit);
            cuInstallReqs.add(installReq);
        }
        list.addAll(cuInstallReqs);
    }

    private IRequiredCapability createInstallRequirement(IInstallableUnit unit) {
        org.osgi.framework.Version osgiVersion = CicP2Model.toOSGiVersion((Version)unit.getVersion());
        IRequiredCapability installReq = Utils.determineInstallRequirement(IP2ReferenceData.ForceInstall.YES, unit, osgiVersion, this.useTightTolerance(unit));
        assert (installReq != null);
        return installReq;
    }

    private void addUnits(ArrayList<IRequirement> list, List data, IProgressMonitor monitor) {
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, data.size());
        this.bundleData = new ArrayList(data.size());
        try {
            for (IP2ReferenceData ref : data) {
                IInstallableUnit p2Unit = this.findP2Unit(ref);
                if (p2Unit != null) {
                    IRequiredCapability installRequirement = Utils.determineInstallRequirement(ref.getForceInstall(), p2Unit, ref.getVersion(), this.useTightTolerance(p2Unit));
                    if (installRequirement != null) {
                        list.add((IRequirement)installRequirement);
                    }
                    if (Utils.isBundleUnit(p2Unit)) {
                        this.bundleData.add(p2Unit);
                    }
                }
                spm.next().done();
            }
        }
        finally {
            spm.done();
            monitor.done();
        }
    }

    private List<IP2ReferenceData> getInstallData(IProgressMonitor monitor) {
        if (this.installData != null) {
            monitor.done();
            return this.installData;
        }
        ArrayList<IP2ReferenceData> result = new ArrayList<IP2ReferenceData>();
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, this.ius.length);
        String launcherLibraryPluginId = this.getLauncherLibraryPluginId();
        try {
            InstallableUnitPair[] installableUnitPairArray = this.ius;
            int n = this.ius.length;
            int n2 = 0;
            while (n2 < n) {
                String adapterId;
                InstallableUnitPair pair = installableUnitPairArray[n2];
                com.ibm.cic.common.core.model.IInstallableUnit unit = pair.getTo();
                if (unit != null && (adapterId = unit.getAdapterId()).equals("p2Eclipse")) {
                    List<IP2ReferenceData> dataList = Utils.getP2ReferencesList(unit);
                    if (dataList.isEmpty()) {
                        log.error(Messages.P2EngineOperation_missingBundleOrFeatureData, new Object[]{unit.getIdentity().getId(), unit.getVersion().toString()});
                    }
                    for (IP2ReferenceData data : dataList) {
                        result.add(data);
                        if (LAUNCHER_PLUGIN_ID.equals(data.getId())) {
                            this.launcherStartupPlugin = data;
                            continue;
                        }
                        if (!launcherLibraryPluginId.equals(data.getId())) continue;
                        this.launcherLibraryPlugin = data;
                    }
                }
                spm.next().done();
                ++n2;
            }
        }
        finally {
            spm.done();
            monitor.done();
        }
        this.installData = result;
        return result;
    }

    private IInstallableUnit createGroup(Collection<IRequirement> installRequirements) {
        MetadataFactory.InstallableUnitDescription description = new MetadataFactory.InstallableUnitDescription();
        String id = this.getGroupId();
        String name = this.context.getEnclosingProfile().getProfileId();
        Version version = this.createProfileVersion();
        description.setId(id);
        description.setVersion(version);
        description.setUpdateDescriptor(this.createUpdateDescriptor(id, version));
        description.setProperty("org.eclipse.equinox.p2.type.group", Boolean.TRUE.toString());
        description.setProperty("org.eclipse.equinox.p2.name", name);
        description.setProperty("org.eclipse.equinox.p2.description", name);
        description.setProperty("org.eclipse.equinox.p2.provider", "IBM");
        description.addProvidedCapabilities(this.createProvidedCapabilities(id, version));
        description.addRequirements(installRequirements);
        IInstallableUnit unit = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)description);
        if (log.isDebugLoggable()) {
            this.logGroupUnit(unit);
        }
        return unit;
    }

    private void logGroupUnit(IInstallableUnit unit) {
        try {
            File tempP2Repo = FileUtil.createTempFile((String)"p2Repo", null);
            tempP2Repo = tempP2Repo.getCanonicalFile();
            FileUtil.rm((File)tempP2Repo);
            FileUtil.makeDirectories((File)tempP2Repo);
            URI uri = tempP2Repo.toURI();
            IMetadataRepositoryManager metadataRepoMan = this.p2Services.getMetadataRepoMan();
            IMetadataRepository repository = metadataRepoMan.createRepository(uri, uri.toString(), "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null);
            repository.addInstallableUnits(Collections.singleton(unit));
            metadataRepoMan.removeRepository(uri);
            File contentXml = new File(tempP2Repo, "content.xml");
            String path = tempP2Repo.getPath();
            File tempContentXml = new File(String.valueOf(path.substring(0, path.length() - 3)) + "xml");
            FileUtil.renameTo((File)contentXml, (File)tempContentXml, (boolean)true);
            FileUtil.rm_r((File)tempP2Repo, (boolean)true);
            String name = unit.getProperty("org.eclipse.equinox.p2.name");
            log.log(Level.DEBUG, tempContentXml.toURI().toURL().toString(), "See P2 root unit for \"{0}\" profile", new Object[]{name});
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private IUpdateDescriptor createUpdateDescriptor(String id, Version version) {
        return MetadataFactory.createUpdateDescriptor((String)id, (VersionRange)new VersionRange(Version.createOSGi((int)0, (int)0, (int)0), true, version, false), (int)0, null);
    }

    private Collection createProvidedCapabilities(String id, Version version) {
        ArrayList<IProvidedCapability> result = new ArrayList<IProvidedCapability>();
        IProvidedCapability providedCapability = MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)id, (Version)version);
        result.add(providedCapability);
        return result;
    }

    private boolean useTightTolerance() {
        return !this.context.getEnclosingProfile().isExistingEclipseProfile();
    }

    private boolean useTightTolerance(IInstallableUnit unit) {
        if (this.useTightTolerance()) {
            return true;
        }
        P2EclipseQualificationHistory qualificationHistory = P2Engine.getInstance().getQualificationHistory();
        if (qualificationHistory == null) {
            return false;
        }
        return qualificationHistory.isInstalled(unit);
    }

    public static VersionRange createExactTolerance(Version version) {
        return new VersionRange(version, true, version, true);
    }

    public static VersionRange createEquivalentTolerance(Version version) {
        org.osgi.framework.Version osgiVersion = CicP2Model.toOSGiVersion((Version)version);
        Version minVersion = Version.createOSGi((int)osgiVersion.getMajor(), (int)osgiVersion.getMinor(), (int)osgiVersion.getMicro());
        Version maxVersion = Version.createOSGi((int)osgiVersion.getMajor(), (int)(osgiVersion.getMinor() + 1), (int)0);
        return new VersionRange(minVersion, true, maxVersion, false);
    }

    public static VersionRange createCompatibleTolerance(Version version) {
        org.osgi.framework.Version osgiVersion = CicP2Model.toOSGiVersion((Version)version);
        Version maxVersion = Version.createOSGi((int)(osgiVersion.getMajor() + 1), (int)0, (int)0);
        return new VersionRange(version, true, maxVersion, false);
    }

    private Version createProfileVersion() {
        long millis = System.currentTimeMillis();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(millis);
        StringBuffer sb = new StringBuffer();
        this.appendInt2(sb, calendar.get(11));
        this.appendInt2(sb, calendar.get(12));
        this.appendInt2(sb, calendar.get(13));
        int major = calendar.get(1);
        int minor = calendar.get(2) + 1;
        int micro = calendar.get(5);
        Version version = Version.createOSGi((int)major, (int)minor, (int)micro, (String)sb.toString());
        if (version.equals(this.getProfileVersion())) {
            this.appendInt2(sb, calendar.get(14) / 10);
            version = Version.createOSGi((int)major, (int)minor, (int)micro, (String)sb.toString());
        }
        return version;
    }

    private StringBuffer appendInt2(StringBuffer sb, int i) {
        if (i < 10) {
            sb.append('0');
        }
        sb.append(i);
        return sb;
    }

    private void logUnits(String action, IInstallableUnit[] units) {
        if (units.length != 0 && log.isDebugLoggable()) {
            log.debug("{0} {1} units:\n{2}", new Object[]{action, String.valueOf(units.length), Util.toString((Object[])units, (Util.Formatter)MULTI_LINE_FORMATTER)});
        }
    }

    private void cleanupAfterFinalUninstall() {
        this.p2Services.getProfileRegistry().removeProfile(this.getProfileId());
        String installLocation = this.context.getInstallLocation();
        File installDir = new File(installLocation);
        File artifactsXml = new File(installDir, "artifacts.xml");
        FileUtil.rm((File)artifactsXml);
        String configLocation = this.context.getLocation("configLocation");
        File cfgDir = new File(configLocation);
        boolean removedConfigurator = FileUtil.rm_r((File)new File(cfgDir, "org.eclipse.update"), (boolean)true);
        boolean createdConfigLocation = this.context.createdDirectory(cfgDir);
        if (removedConfigurator && createdConfigLocation) {
            String[] stringArray = configDirsToDelete;
            int n = configDirsToDelete.length;
            int n2 = 0;
            while (n2 < n) {
                String dir = stringArray[n2];
                FileUtil.rm_r((File)new File(cfgDir, dir), (boolean)true);
                ++n2;
            }
            stringArray = configFilesToDelete;
            n = configFilesToDelete.length;
            n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                FileUtil.delete((File)new File(cfgDir, file));
                ++n2;
            }
            File[] logFiles = cfgDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".log");
                }
            });
            if (logFiles != null) {
                File[] fileArray = logFiles;
                int n3 = logFiles.length;
                n = 0;
                while (n < n3) {
                    File file = fileArray[n];
                    FileUtil.delete((File)file);
                    ++n;
                }
            }
            FileUtil.deleteEmptyDirsLogIOE((File)cfgDir);
            this.removeMacosxLauncherAppDir();
        }
    }

    private File readLauncherPath() {
        String configLocation = this.context.getLocation("configLocation");
        File cfgDir = new File(configLocation);
        File configIni = new File(cfgDir, "config.ini");
        Properties configProperties = new Properties();
        Utils.readPropertiesFile(configIni, configProperties);
        String propertyLauncherPath = configProperties.getProperty("osgi.launcherPath", null);
        if (propertyLauncherPath == null) {
            return null;
        }
        return new File(propertyLauncherPath);
    }

    private void removeMacosxLauncherAppDir() {
        if (!"macosx".equals(Platform.getOS())) {
            return;
        }
        if (this.launcherPath == null || !this.launcherPath.exists()) {
            return;
        }
        FileUtil.removeEmptyDirs((File)this.launcherPath.getParentFile().getParentFile(), (boolean)true, (String[])new String[0]);
    }

    private String getVersionedUnitId(IInstallableUnit unit) {
        return String.valueOf(unit.getId()) + '_' + unit.getVersion().toString();
    }

    private String getFeatureVersionedUnitId(IInstallableUnit unit) {
        String featureId = unit.getId();
        if (featureId.endsWith(".feature.group")) {
            featureId = featureId.substring(0, featureId.length() - ".feature.group".length());
        }
        return String.valueOf(featureId) + '_' + unit.getVersion().toString();
    }

    private IStatus addCache(IProgressMonitor monitor) {
        LinkedHashSet<String> set;
        IProfile profile;
        File cicCache = new File(this.context.getLocation("cacheLocation"));
        String uri = cicCache.toURI().toString();
        P2ArtifactsXmlWriter writer = new P2ArtifactsXmlWriter(cicCache, this.p2Services);
        IStatus status = writer.store(true, monitor);
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            return status;
        }
        P2Engine.getInstance().removeP2Index(cicCache);
        try {
            profile = this.getOrCreateProfile();
        }
        catch (ProvisionException e) {
            return new Status(4, Activator.getPluginId(), e.getMessage(), (Throwable)e);
        }
        String extensions = profile.getProperty("org.eclipse.equinox.p2.cache.extensions");
        if (extensions == null || extensions.trim().length() == 0) {
            extensions = "";
        }
        if ((set = Util.toOrderedSet((String)extensions, (char)'|')).contains(uri)) {
            return Status.OK_STATUS;
        }
        String installLocation = this.context.getInstallLocation();
        File installDir = new File(installLocation);
        if (FileUtil.filesAreSame((File)cicCache, (File)installDir)) {
            return Status.OK_STATUS;
        }
        set = new LinkedHashSet<String>(set);
        set.add(uri);
        extensions = Util.toString(set, (char)'|');
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.setProfileProperty("org.eclipse.equinox.p2.cache.extensions", extensions);
        String p2Cache = profile.getProperty("org.eclipse.equinox.p2.cache");
        if (FileUtil.filesAreSame((File)cicCache, (File)new File(p2Cache))) {
            request.setProfileProperty("org.eclipse.equinox.p2.cache", installLocation);
        }
        if (!StatusUtil.isErrorOrCancel((IStatus)(status = this.p2Services.getDirector().provision((IProfileChangeRequest)request, null, null)))) {
            this.cacheWasAdded = true;
        }
        return status;
    }

    private IStatus removeCache() {
        File cicCache = new File(this.context.getLocation("cacheLocation"));
        String uri = cicCache.toURI().toString();
        IProfile profile = this.getProfile();
        String extensions = profile.getProperty("org.eclipse.equinox.p2.cache.extensions");
        if (extensions == null || extensions.trim().length() == 0) {
            return Status.OK_STATUS;
        }
        LinkedHashSet set = Util.toOrderedSet((String)extensions, (char)'|');
        if (!set.contains(uri)) {
            return Status.OK_STATUS;
        }
        set = new LinkedHashSet(set);
        set.remove(uri);
        extensions = Util.toString(set, (char)'|');
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.setProfileProperty("org.eclipse.equinox.p2.cache.extensions", extensions);
        IStatus status = this.p2Services.getDirector().provision((IProfileChangeRequest)request, null, null);
        if (!StatusUtil.isErrorOrCancel((IStatus)status)) {
            this.cacheWasAdded = false;
        }
        return status;
    }

    private IInstallableUnit createSelectionContext(IProfile p) {
        String value;
        String key;
        Map properties = p.getProperties();
        HashMap<String, String> map = new HashMap<String, String>(properties);
        String environments = (String)properties.get("org.eclipse.equinox.p2.environments");
        if (environments != null) {
            StringTokenizer tokenizer = new StringTokenizer(environments, ",");
            while (tokenizer.hasMoreElements()) {
                String entry = tokenizer.nextToken();
                int i = entry.indexOf(61);
                key = entry.substring(0, i).trim();
                value = entry.substring(i + 1).trim();
                map.put(key, value);
            }
        }
        MetadataFactory.InstallableUnitDescription description = new MetadataFactory.InstallableUnitDescription();
        description.setId("com.ibm.cic.agent.core.p2.context.iu");
        for (Map.Entry entry : map.entrySet()) {
            key = (String)entry.getKey();
            value = (String)entry.getValue();
            description.setProperty(key, value);
        }
        IInstallableUnit result = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)description);
        return result;
    }

    public boolean isInstallLocation(File dir) {
        String installLocation = this.context.getInstallLocation();
        File installDir = new File(installLocation);
        return FileUtil.filesAreSame((File)dir, (File)installDir);
    }

    private String getLauncherLibraryPluginId() {
        Profile profile = this.context.getEnclosingProfile();
        String launcherLibraryPluginId = "org.eclipse.equinox.launcher." + Utils.getWS((com.ibm.cic.agent.core.api.IProfile)profile) + '.' + Utils.getOS((com.ibm.cic.agent.core.api.IProfile)profile) + '.' + Utils.getOSArch((com.ibm.cic.agent.core.api.IProfile)profile);
        return launcherLibraryPluginId;
    }

    private IStatus installLauncherPlugins(IProgressMonitor monitor) {
        File installLocation;
        if (this.context.getEnclosingProfile().isExistingEclipseProfile()) {
            monitor.done();
            return Status.OK_STATUS;
        }
        File cacheLocation = new File(this.context.getLocation("cacheLocation"));
        if (FileUtil.filesAreSame((File)cacheLocation, (File)(installLocation = new File(this.context.getInstallLocation())))) {
            monitor.done();
            return Status.OK_STATUS;
        }
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, 2);
        this.getInstallData(spm.next());
        File installedPluginsDir = new File(installLocation, "plugins");
        File cachedPluginsDir = new File(cacheLocation, "plugins");
        this.uninstallOldLauncherPlugin(installedPluginsDir, LAUNCHER_PLUGIN_ID);
        this.uninstallOldLauncherPlugin(installedPluginsDir, this.getLauncherLibraryPluginId());
        CicMultiStatus result = Statuses.OK.getMultiStatus();
        result.add(this.installNewLauncherPlugin(cachedPluginsDir, installedPluginsDir, this.launcherStartupPlugin));
        result.add(this.installNewLauncherPlugin(cachedPluginsDir, installedPluginsDir, this.launcherLibraryPlugin));
        P2ArtifactsXmlWriter writer = new P2ArtifactsXmlWriter(installLocation, this.p2Services);
        result.add(writer.store(false, spm.next()));
        spm.done();
        monitor.done();
        return result;
    }

    private void uninstallOldLauncherPlugin(File installedPluginsDir, String launcherPlugin) {
        final String prefix = String.valueOf(launcherPlugin) + '_';
        File[] files = installedPluginsDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().startsWith(prefix);
            }
        });
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                FileUtil.rm_r((File)file, (boolean)true);
                ++n2;
            }
            FileUtil.deleteEmptyDirsLogIOE((File)installedPluginsDir);
        }
    }

    private IStatus installNewLauncherPlugin(File cachedPluginsDir, File installedPluginsDir, IP2ReferenceData launcherPlugin) {
        if (launcherPlugin == null) {
            return Status.OK_STATUS;
        }
        String name = String.valueOf(launcherPlugin.getId()) + '_' + launcherPlugin.getVersionStr();
        File src = new File(cachedPluginsDir, name);
        if (src.isDirectory()) {
            try {
                File dest = new File(installedPluginsDir, name);
                FileUtil.copyDir((File)src, (File)dest, null);
            }
            catch (IOException e) {
                return Statuses.ERROR.get((Throwable)e, e.getMessage(), new Object[0]);
            }
        }
        String jarExt = CicConstants.getJarFileDotExt();
        src = new File(cachedPluginsDir, String.valueOf(name) + jarExt);
        if (src.isFile()) {
            try {
                File dest = new File(installedPluginsDir, String.valueOf(name) + jarExt);
                installedPluginsDir.mkdirs();
                FileUtil.copyFile((File)src, (File)dest);
            }
            catch (IOException e) {
                return Statuses.ERROR.get((Throwable)e, e.getMessage(), new Object[0]);
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus fixupPlatformXml(IProgressMonitor monitor) {
        File cacheLocation = new File(this.context.getLocation("cacheLocation"));
        File configLocation = new File(this.context.getLocation("configLocation"));
        File installLocation = new File(this.context.getInstallLocation());
        IQueryResult result = this.plan.getProfile().query(QueryUtil.ALL_UNITS, monitor);
        IInstallableUnit[] units = (IInstallableUnit[])result.toArray(IInstallableUnit.class);
        P2PlatformXmlFixup fixup = new P2PlatformXmlFixup(installLocation, configLocation, cacheLocation, units, this.isFinalUninstall());
        return fixup.perform();
    }

    private IStatus checkPatches(P2EclipseQualificationHistory qualificationHistory, IProgressMonitor monitor) {
        IInstallableUnit[] addedPatch;
        CicMultiStatus patchStatus = Statuses.ERROR.getMultiStatus(Messages.P2EngineOperation_patchesRequired, new Object[0]);
        IQueryResult addPatchQuery = this.plan.getAdditions().query(QueryUtil.createIUPatchQuery(), monitor);
        IInstallableUnit[] iInstallableUnitArray = addedPatch = (IInstallableUnit[])addPatchQuery.toArray(IInstallableUnit.class);
        int n = addedPatch.length;
        int n2 = 0;
        while (n2 < n) {
            IRequiredCapability capability;
            String patchedFeatureGroupId;
            IInstallableUnitPatch patchIuToAdd;
            IRequirement lifeCycle;
            IInstallableUnit element = iInstallableUnitArray[n2];
            IInstallableUnit iuToAdd = element.unresolved();
            if (iuToAdd instanceof IInstallableUnitPatch && (lifeCycle = (patchIuToAdd = (IInstallableUnitPatch)iuToAdd).getLifeCycle()) instanceof IRequiredCapability && !qualificationHistory.isInstalled(patchedFeatureGroupId = (capability = (IRequiredCapability)lifeCycle).getName())) {
                patchStatus.add((IStatus)Statuses.ERROR.get(Messages.P2EngineOperation_missingPatch, new Object[]{this.getFeatureVersionedUnitId(iuToAdd)}));
            }
            ++n2;
        }
        return patchStatus.hasChildren() ? patchStatus : Status.OK_STATUS;
    }
}

