/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core.p2;

import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.internal.core.p2.Activator;
import com.ibm.cic.agent.internal.core.p2.Messages;
import com.ibm.cic.agent.internal.core.p2.Utils;
import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.StatusUtil;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class P2Configuration {
    private final InstallContext context;
    private File p2DataArea;
    private String p2ProfileId;
    private File configDir;
    private File configIni;
    private Properties configProperties;

    public P2Configuration(InstallContext context) throws CoreException {
        this.context = context;
        IStatus status = this.initialize();
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    public File getP2DataArea() {
        return this.p2DataArea;
    }

    public String getP2ProfileId() {
        return this.p2ProfileId;
    }

    private IStatus initialize() {
        String p2DataAreaValue = this.context.getLocalProperty("P2_DATA_AREA");
        String p2ProfileIdValue = this.context.getLocalProperty("P2_PROFILE_ID");
        if (p2DataAreaValue != null && p2ProfileIdValue != null) {
            this.p2DataArea = new File(p2DataAreaValue);
            this.p2ProfileId = p2ProfileIdValue;
            return Status.OK_STATUS;
        }
        if (!this.context.getEnclosingProfile().isExistingEclipseProfile()) {
            return this.determineDefaultP2DataAreaAndP2Profile();
        }
        IStatus status = this.loadConfigurationProperties();
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            return status;
        }
        status = this.determineP2DataArea();
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            return status;
        }
        status = this.determineP2Profile();
        if (StatusUtil.isErrorOrCancel((IStatus)status)) {
            return status;
        }
        return Status.OK_STATUS;
    }

    private IStatus determineDefaultP2DataAreaAndP2Profile() {
        if (this.context.getLocalProperty("P2_PROFILE_VERSION") != null) {
            String appDataLocation = CicCommonSettings.getApplicationDataLocation();
            this.p2DataArea = new File(appDataLocation, "p2");
        } else {
            String installLocation = this.context.getInstallLocation();
            this.p2DataArea = new File(installLocation, "p2");
        }
        this.p2ProfileId = this.context.getUniqueId();
        return Status.OK_STATUS;
    }

    private IStatus loadConfigurationProperties() {
        String configLocation = this.context.getLocation("configLocation");
        this.configDir = new File(configLocation);
        this.configIni = new File(this.configDir, "config.ini");
        this.configProperties = new Properties();
        return Utils.readPropertiesFile(this.configIni, this.configProperties);
    }

    private IStatus determineP2DataArea() {
        File dir;
        String p2DataAreaProp = this.configProperties.getProperty("eclipse.p2.data.area");
        if (p2DataAreaProp == null) {
            String msg = Messages.bind((String)Messages.P2EngineOperation_propertyNotFound, (Object)"eclipse.p2.data.area", (Object)this.configIni);
            return new Status(4, Activator.getPluginId(), msg);
        }
        if (p2DataAreaProp.startsWith("@config.dir")) {
            p2DataAreaProp = this.configDir + p2DataAreaProp.substring("@config.dir".length());
        }
        if (!(dir = new File(p2DataAreaProp)).isDirectory()) {
            String msg = Messages.bind((String)Messages.P2EngineOperation_dirNotFound, (Object)dir);
            return new Status(4, Activator.getPluginId(), msg);
        }
        try {
            this.p2DataArea = dir.getCanonicalFile();
        }
        catch (IOException iOException) {
            this.p2DataArea = dir;
        }
        return Status.OK_STATUS;
    }

    private IStatus determineP2Profile() {
        this.p2ProfileId = this.configProperties.getProperty("eclipse.p2.profile");
        if (this.p2ProfileId == null) {
            String msg = Messages.bind((String)Messages.P2EngineOperation_propertyNotFound, (Object)"eclipse.p2.profile", (Object)this.configIni);
            return new Status(4, Activator.getPluginId(), msg);
        }
        return Status.OK_STATUS;
    }
}

