/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.core.p2;

import com.ibm.cic.agent.internal.core.p2.Activator;
import com.ibm.cic.agent.internal.core.p2.P2Services;
import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.SplitIdVersionUtil;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.p2.model.CicP2Model;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactDescriptor;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.repository.IRunnableWithProgress;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.osgi.framework.Version;

public class P2ArtifactsXmlWriter {
    private static final String[][] CIC_MAPPING_RULES = new String[][]{{"(& (classifier=osgi.bundle))", "${repoUrl}/plugins/${id}_${version}.jar"}, {"(& (classifier=binary))", "${repoUrl}/native/${id}_${version}.zip"}, {"(& (classifier=org.eclipse.update.feature))", "${repoUrl}/features/${id}_${version}.jar"}};
    private static final String ARTIFACT_FOLDER = "artifact.folder";
    private final File repositoryLocation;
    private final P2Services p2Services;

    public P2ArtifactsXmlWriter(File repositoryLocation, P2Services p2Services) {
        this.repositoryLocation = repositoryLocation;
        this.p2Services = p2Services;
    }

    public IStatus store(final boolean useCicMappingRules, IProgressMonitor monitor) {
        IArtifactRepositoryManager manager = this.p2Services.getArtifactRepoMan();
        try {
            File artifactsXml = new File(this.repositoryLocation, "artifacts.xml");
            if (artifactsXml.isFile()) {
                FileUtil.rm((File)artifactsXml);
            }
            final IArtifactRepository repository = manager.createRepository(this.repositoryLocation.toURI(), this.repositoryLocation.getAbsolutePath(), "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
            if (useCicMappingRules) {
                SimpleArtifactRepository sar = (SimpleArtifactRepository)repository;
                sar.setRules(CIC_MAPPING_RULES);
            }
            repository.executeBatch(new IRunnableWithProgress(){

                public void run(IProgressMonitor mon) throws OperationCanceledException {
                    String binExt;
                    String binDirName;
                    SplitProgressMonitor spm = new SplitProgressMonitor(mon, new int[]{2, 8, 2});
                    String jarExt = CicConstants.getJarFileDotExt();
                    P2ArtifactsXmlWriter.this.addArtifactFiles(repository, P2ArtifactsXmlWriter.this.repositoryLocation, "org.eclipse.update.feature", "features", jarExt, spm.next());
                    P2ArtifactsXmlWriter.this.addArtifactFiles(repository, P2ArtifactsXmlWriter.this.repositoryLocation, "osgi.bundle", "plugins", jarExt, spm.next());
                    if (useCicMappingRules) {
                        binDirName = "native";
                        binExt = CicConstants.getZipFileDotExt();
                    } else {
                        binDirName = "binary";
                        binExt = null;
                    }
                    P2ArtifactsXmlWriter.this.addArtifactFiles(repository, P2ArtifactsXmlWriter.this.repositoryLocation, "binary", binDirName, binExt, spm.next());
                    spm.done();
                }
            }, monitor);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (OperationCanceledException operationCanceledException) {
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            Status status = new Status(4, Activator.getPluginId(), e.getMessage(), (Throwable)e);
            return status;
        }
        finally {
            manager.removeRepository(this.repositoryLocation.toURI());
            monitor.done();
        }
    }

    private void addArtifactFiles(IArtifactRepository repository, File parentDir, String classifier, String subDirName, String dotExt, IProgressMonitor monitor) {
        File subDir = new File(parentDir, subDirName);
        File[] files = subDir.listFiles();
        if (files == null) {
            return;
        }
        monitor.beginTask("", files.length);
        ArrayList<File> dirs = new ArrayList<File>(files.length);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (file.isDirectory()) {
                dirs.add(file);
            } else {
                String name = file.getName();
                if (dotExt == null || name.endsWith(dotExt)) {
                    String idAndVersionString = dotExt != null ? name.substring(0, name.length() - dotExt.length()) : name;
                    Object[] idAndVersion = SplitIdVersionUtil.splitIdUnderscoreVersion((String)idAndVersionString);
                    String id = (String)idAndVersion[0];
                    Version version = (Version)idAndVersion[1];
                    if (version != null) {
                        this.addDescriptor(repository, classifier, id, version, file, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                }
            }
            ++n2;
        }
        for (File dir : dirs) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            String name = dir.getName();
            Object[] idAndVersion = SplitIdVersionUtil.splitIdUnderscoreVersion((String)name);
            String id = (String)idAndVersion[0];
            Version version = (Version)idAndVersion[1];
            if (version == null) continue;
            this.addDescriptor(repository, classifier, id, version, dir, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
    }

    private void addDescriptor(IArtifactRepository repository, String classifier, String id, Version version, File f, IProgressMonitor monitor) {
        IArtifactKey key = repository.createArtifactKey(classifier, id, CicP2Model.fromOSGiVersion((Version)version));
        IArtifactDescriptor descriptor = repository.createArtifactDescriptor(key);
        SimpleArtifactDescriptor sad = (SimpleArtifactDescriptor)descriptor;
        long size = f.isDirectory() ? 4096L : f.length();
        sad.setProperty("download.size", String.valueOf(size));
        if (f.isDirectory()) {
            sad.setRepositoryProperty(ARTIFACT_FOLDER, Boolean.TRUE.toString());
        }
        repository.addDescriptor(descriptor, monitor);
    }
}

