/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert.deploy;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.cert.deploy.CertId;
import com.ibm.security.util.Debug;
import com.ibm.security.util.DerOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

class OCSPRequest {
    private static final Debug debug = Debug.getInstance((String)"certpath");
    private static final boolean dump = Debug.isOn((String)"ocsp");
    private final List<CertId> certIds;

    OCSPRequest(CertId certId) {
        this.certIds = Collections.singletonList(certId);
    }

    OCSPRequest(List<CertId> certIds) {
        this.certIds = certIds;
    }

    byte[] encodeBytes() throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        DerOutputStream requestsOut = new DerOutputStream();
        for (CertId certId : this.certIds) {
            DerOutputStream certIdOut = new DerOutputStream();
            certId.encode(certIdOut);
            requestsOut.write((byte)48, certIdOut);
        }
        tmp.write((byte)48, requestsOut);
        DerOutputStream tbsRequest = new DerOutputStream();
        tbsRequest.write((byte)48, tmp);
        DerOutputStream ocspRequest = new DerOutputStream();
        ocspRequest.write((byte)48, tbsRequest);
        byte[] bytes = ocspRequest.toByteArray();
        if (dump) {
            HexDumpEncoder hexEnc = new HexDumpEncoder();
            debug.println("\nOCSPRequest bytes... ");
            debug.println(hexEnc.encode(bytes) + "\n");
        }
        return bytes;
    }

    List<CertId> getCertIds() {
        return this.certIds;
    }
}

