/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.Debug;
import com.ibm.security.cert.CertPathImpl;
import com.ibm.security.cert.CertPathUtil;
import com.ibm.security.cert.PKIXCertPathValidatorImpl;
import com.ibm.security.cert.URICertStore;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AccessDescription;
import com.ibm.security.x509.AuthorityKeyIdentifierExtension;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.KeyIdentifier;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.PrivilegedAction;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.LDAPCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class PKIXCertPathBuilderImpl
extends CertPathBuilderSpi {
    private static final Debug debug = Debug.getInstance((String)"certpath");
    private static final String x509String = "X.509";

    @Override
    public CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        X509Certificate targetCert;
        if (debug != null) {
            System.out.println("CERTPATH: to build a certpath with parameters " + params + ")");
        }
        PKIXBuilderParameters parms = null;
        PKIXCertPathBuilderResult myPKIXCertPathBuilderResult = null;
        PKIXCertPathValidatorResult cpvr = null;
        CertPath certPath = null;
        LinkedList<Object> eeCerts = new LinkedList<Object>();
        Collection<Object> eeCertsTemp = new ArrayList();
        X509Certificate eeCert = null;
        LinkedList<X509Certificate> list_of_certs = new LinkedList<X509Certificate>();
        boolean caNameAndPublicKeySet = false;
        X509CertSelector eeSelector = null;
        Object[] cpbr = new Object[]{null, null};
        ArrayList<CertStore> certStores = null;
        int maxPathLength = -1;
        Object publicKey = null;
        Object caName = null;
        CertSelector certSelector = null;
        Date date = null;
        boolean done = false;
        if (!(params instanceof PKIXBuilderParameters)) {
            throw new InvalidAlgorithmParameterException("Parameters are not an instance of PKIXBuilderParameters");
        }
        parms = (PKIXBuilderParameters)params;
        List<CertStore> certStores2 = null;
        certStores2 = parms.getCertStores();
        certStores = new ArrayList<CertStore>(certStores2);
        if (debug != null) {
            System.out.println("===============================================");
            System.out.println("PKIXCertPathBuilderImpl.java:  engineBuild():  The input CertStores prior to sorting are:");
            for (CertStore store : certStores) {
                System.out.println(store.toString());
            }
            System.out.println("===============================================");
        }
        Collections.sort(certStores, new CertStoreComparator());
        if (debug != null) {
            System.out.println("===============================================");
            System.out.println("PKIXCertPathBuilderImpl.java:  engineBuild():  The input CertStores after sorting are:");
            for (CertStore store : certStores) {
                System.out.println(store.toString());
            }
            System.out.println("===============================================");
        }
        maxPathLength = parms.getMaxPathLength();
        String[] taNames = this.getTaNames(parms.getTrustAnchors());
        certSelector = parms.getTargetCertConstraints();
        if (certSelector == null) {
            throw new InvalidAlgorithmParameterException("TargetCertConstraints is not set in the CertPathParameters");
        }
        if (!(certSelector instanceof X509CertSelector)) {
            throw new InvalidAlgorithmParameterException("TargetCertConstrants is not an instance of X509CertSelector");
        }
        date = parms.getDate();
        if (date == null) {
            date = new Date();
        }
        if ((eeSelector = (X509CertSelector)certSelector).getSubject() == null && (targetCert = eeSelector.getCertificate()) != null) {
            X500Principal subjectDN = targetCert.getSubjectX500Principal();
            eeSelector.setSubject(subjectDN);
        }
        if (eeSelector.getSubject() == null) {
            throw new InvalidAlgorithmParameterException("TargetSubject must be set");
        }
        for (CertStore store : certStores) {
            try {
                eeCertsTemp = store.getCertificates(eeSelector);
            }
            catch (CertStoreException certStoreException) {
                throw new CertPathBuilderException("Exception caught: " + certStoreException);
            }
            if (eeCertsTemp.isEmpty()) continue;
            eeCerts.addAll(eeCertsTemp);
        }
        if (eeCerts.isEmpty()) {
            throw new CertPathBuilderException("No end-entity certificate matching the selection criteria could be found.");
        }
        if (eeCerts.size() > 1 && eeSelector.getSubject() == null) {
            throw new InvalidAlgorithmParameterException("TargetSubject must be set, target constraints do not uniquely identify a certificate");
        }
        X509CertSelector selector = new X509CertSelector();
        Iterator iterator = eeCerts.iterator();
        while (iterator.hasNext() && !done) {
            eeCert = (X509Certificate)iterator.next();
            list_of_certs.add(eeCert);
            if (this.checkAIAEXTEnabled()) {
                List<CertStore> AIAExtensionCertStoresList;
                if (debug != null) {
                    System.out.println("PKIXCertPathBuilderImpl.java:  engineBuild():  Processing the eeCert");
                }
                if ((AIAExtensionCertStoresList = this.getAIAExtensionCertStores(eeCert)) != null) {
                    if (debug != null) {
                        System.out.println("\n\nPKIXCertPathBuilderImpl.java:  engineBuild():  The eeCert has an AIA extension");
                        System.out.println("                               " + AIAExtensionCertStoresList.size() + " CertStores were built from that AIA extension.\n");
                    }
                    for (CertStore store : AIAExtensionCertStoresList) {
                        if (debug != null) {
                            System.out.println("\nPKIXCertPathBuilderImpl.java:  engineBuild():  Processing the following CertStore from the AIA extension.  Can it be added to certStores or is it a duplicate?");
                            System.out.println(store.toString() + "\n");
                        }
                        CertStoreParameters myCertStoreParameters = store.getCertStoreParameters();
                        boolean alreadyPresent = false;
                        for (CertStore storeFromCertStores : certStores) {
                            String storeFromCertStoresType = storeFromCertStores.getType();
                            if (!storeFromCertStoresType.equals("LDAP")) continue;
                            CertStoreParameters storeFromCertStoresParameters = storeFromCertStores.getCertStoreParameters();
                            String accessDescriptionServerName = ((LDAPCertStoreParameters)myCertStoreParameters).getServerName();
                            int accessDescriptionPort = ((LDAPCertStoreParameters)myCertStoreParameters).getPort();
                            String storeFromCertStoresServerName = ((LDAPCertStoreParameters)storeFromCertStoresParameters).getServerName();
                            int storeFromCertStoresPort = ((LDAPCertStoreParameters)storeFromCertStoresParameters).getPort();
                            if (!storeFromCertStoresServerName.equals(accessDescriptionServerName) || storeFromCertStoresPort != accessDescriptionPort) continue;
                            alreadyPresent = true;
                            break;
                        }
                        if (!alreadyPresent) {
                            if (debug != null) {
                                System.out.println("PKIXCertPathBuilderImpl.java:  engineBuild():  Adding the following AIA CertStore to certStores:");
                                System.out.println();
                                System.out.println(store.getCertStoreParameters().toString());
                            }
                            certStores.add(store);
                            continue;
                        }
                        if (debug == null) continue;
                        System.out.println("PKIXCertPathBuilderImpl.java:  engineBuild():  The following AIA CertStore is already contained within certStores.  Skipping it.");
                        System.out.println(store.toString());
                        System.out.println(store.getCertStoreParameters().toString());
                    }
                    if (debug != null) {
                        System.out.println("\nPKIXCertPathBuilderImpl.java:  engineBuild():  The List of CertStores with the AIA Extension CertStores added is:");
                        for (CertStore store : certStores) {
                            System.out.println(store.toString());
                        }
                        System.out.println(" ");
                    }
                } else if (debug != null) {
                    System.out.println("\nPKIXCertPathBuilderImpl.java:  engineBuild():  Either the eeCert DOES NOT have an AIA extension, or");
                    System.out.println("                                               its AIA extension contains no AccessDescription elements.");
                    System.out.println("                                               Nothing has been added to the list of CertStores.");
                }
            }
            if ((cpbr = this.buildCertPath(selector = this.createCASelector(eeCert, selector), certStores, list_of_certs, parms, maxPathLength, taNames))[1] != null) {
                done = true;
                continue;
            }
            list_of_certs.clear();
        }
        certPath = (CertPath)cpbr[0];
        if (!(cpbr[1] instanceof Exception)) {
            cpvr = (PKIXCertPathValidatorResult)cpbr[1];
            try {
                myPKIXCertPathBuilderResult = new PKIXCertPathBuilderResult(certPath, cpvr.getTrustAnchor(), cpvr.getPolicyTree(), cpvr.getPublicKey());
            }
            catch (NullPointerException ex) {
                if (debug != null) {
                    System.out.println("CERTPATH: exception thrown while constructing builder result");
                    ex.printStackTrace();
                }
                throw (CertPathBuilderException)new CertPathBuilderException().initCause(ex);
            }
        } else {
            for (X509Certificate x509Certificate : eeCerts) {
                if (!CertPathUtil.isTrustedCert(x509Certificate, parms.getTrustAnchors())) continue;
                CertPathImpl spCertpath = new CertPathImpl(x509String, new ArrayList(0));
                return new PKIXCertPathBuilderResult(spCertpath, new TrustAnchor(x509Certificate, null), null, x509Certificate.getPublicKey());
            }
            if (debug != null) {
                System.out.println("CERTPATH: PKIXCertPathBuilderImpl.engineBuild() exception thrown");
                ((Exception)cpbr[1]).printStackTrace();
            }
            throw new CertPathBuilderException("PKIXCertPathBuilderImpl could not build a valid CertPath.", (Exception)cpbr[1]);
        }
        return myPKIXCertPathBuilderResult;
    }

    private Object[] buildCertPath(X509CertSelector selector, List certStores, LinkedList list_of_certs, PKIXBuilderParameters parms, int maxPathLength, String[] taNames) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        CertPathImpl certPath = null;
        Collection<Object> certs = new ArrayList();
        LinkedList<Object> col = new LinkedList<Object>();
        X509Certificate cert = null;
        X509Certificate lastCert = null;
        Object[] cpbr = new Object[]{null, null};
        boolean done = false;
        Iterator j = certStores.iterator();
        while (j.hasNext()) {
            try {
                CertStore store = (CertStore)j.next();
                certs = store.getCertificates(selector);
                if (certs.isEmpty()) continue;
                col.addAll(certs);
            }
            catch (CertStoreException cse) {
                throw new CertPathBuilderException("Exception caught: " + cse);
            }
        }
        if (list_of_certs.size() <= maxPathLength || maxPathLength == -1) {
            Iterator k = col.iterator();
            while (k.hasNext() && !done) {
                cert = (X509Certificate)k.next();
                if (list_of_certs.contains(cert)) continue;
                if (this.isEndOfCertPath(cert, taNames)) {
                    if (maxPathLength != -1 && list_of_certs.size() > maxPathLength) {
                        throw new CertPathBuilderException("length of cert chain exceeds max path length");
                    }
                    certPath = new CertPathImpl(x509String, list_of_certs);
                    cpbr = this.myValidator(certPath, parms);
                    if (cpbr[1] == null) continue;
                    done = true;
                    continue;
                }
                list_of_certs.add(cert);
                if (this.checkAIAEXTEnabled()) {
                    List<CertStore> AIAExtensionCertStoresList;
                    if (debug != null) {
                        System.out.println("PKIXCertPathBuilderImpl.java:  engineBuild():  Processing the cert");
                    }
                    if ((AIAExtensionCertStoresList = this.getAIAExtensionCertStores(cert)) != null) {
                        if (debug != null) {
                            System.out.println("\n\nPKIXCertPathBuilderImpl.java:  engineBuild():  The cert has an AIA extension");
                            System.out.println("                               " + AIAExtensionCertStoresList.size() + " CertStores were built from that AIA extension.");
                        }
                        for (CertStore store : AIAExtensionCertStoresList) {
                            if (debug != null) {
                                System.out.println("\nPKIXCertPathBuilderImpl.java:  engineBuild():  Processing the following CertStore from the AIA extension.  Can it be added to certStores or is it a duplicate?");
                                System.out.println(store.toString() + "\n");
                            }
                            CertStoreParameters myCertStoreParameters = store.getCertStoreParameters();
                            boolean alreadyPresent = false;
                            for (CertStore storeFromCertStores : certStores) {
                                String storeFromCertStoresType = storeFromCertStores.getType();
                                if (!storeFromCertStoresType.equals("LDAP")) continue;
                                CertStoreParameters storeFromCertStoresParameters = storeFromCertStores.getCertStoreParameters();
                                String accessDescriptionServerName = ((LDAPCertStoreParameters)myCertStoreParameters).getServerName();
                                int accessDescriptionPort = ((LDAPCertStoreParameters)myCertStoreParameters).getPort();
                                String storeFromCertStoresServerName = ((LDAPCertStoreParameters)storeFromCertStoresParameters).getServerName();
                                int storeFromCertStoresPort = ((LDAPCertStoreParameters)storeFromCertStoresParameters).getPort();
                                if (!storeFromCertStoresServerName.equals(accessDescriptionServerName) || storeFromCertStoresPort != accessDescriptionPort) continue;
                                alreadyPresent = true;
                                break;
                            }
                            if (!alreadyPresent) {
                                if (debug != null) {
                                    System.out.println("PKIXCertPathBuilderImpl.java:  engineBuild():  Adding the following AIA CertStore to certStores:");
                                    System.out.println(store.toString());
                                }
                                certStores.add(store);
                                continue;
                            }
                            if (debug == null) continue;
                            System.out.println("PKIXCertPathBuilderImpl.java:  engineBuild():  The following AIA CertStore is already contained within certStores.  Skipping it.");
                            System.out.println(store.toString());
                        }
                        if (debug != null) {
                            System.out.println("\nPKIXCertPathBuilderImpl.java:  engineBuild():  The List of CertStores with the AIA Extension CertStores added is:");
                            for (CertStore store : certStores) {
                                System.out.println(store.toString());
                            }
                        }
                    } else if (debug != null) {
                        System.out.println("\nPKIXCertPathBuilderImpl.java:  engineBuild():  Either the cert DOES NOT have an AIA extension, or");
                        System.out.println("                                               its AIA extension contains no AccessDescription elements.");
                        System.out.println("                                               Nothing has been added to the list of CertStores.");
                    }
                }
                if ((cpbr = this.buildCertPath(selector = this.createCASelector(cert, selector), certStores, list_of_certs, parms, maxPathLength, taNames))[1] != null) {
                    done = true;
                    continue;
                }
                lastCert = (X509Certificate)list_of_certs.removeLast();
            }
        }
        if (cpbr[1] == null) {
            lastCert = (X509Certificate)list_of_certs.getLast();
            TrustAnchor temp = null;
            if (this.isSelfSigned(lastCert)) {
                list_of_certs.removeLast();
                if (list_of_certs.size() == 0) {
                    boolean found;
                    block30: {
                        Set<TrustAnchor> anchors = parms.getTrustAnchors();
                        found = false;
                        try {
                            temp = CertPathUtil.findIssuer(lastCert, anchors, parms.getSigProvider());
                            if (temp != null) {
                                found = true;
                            }
                        }
                        catch (CertPathValidatorException ex) {
                            if (debug == null) break block30;
                            System.out.println("CERTPATH: failed to validate the certpath " + ex.toString());
                        }
                    }
                    if (!found) {
                        throw new CertPathBuilderException("unable to find valid certification path to requested target");
                    }
                }
            }
            if (!((cpbr = this.myValidator(certPath = new CertPathImpl(x509String, list_of_certs), parms))[1] instanceof Exception)) {
                cpbr[0] = certPath;
                if (((CertPath)cpbr[0]).getCertificates().size() == 0) {
                    cpbr[1] = new PKIXCertPathValidatorResult(temp, ((PKIXCertPathValidatorResult)cpbr[1]).getPolicyTree(), ((PKIXCertPathValidatorResult)cpbr[1]).getPublicKey());
                }
            }
        }
        return cpbr;
    }

    private boolean isSelfSigned(X509Certificate cert) {
        return cert.getIssuerX500Principal().equals(cert.getSubjectX500Principal());
    }

    private X509CertSelector createCASelector(X509Certificate cert, X509CertSelector caSelector) throws CertPathBuilderException {
        try {
            caSelector.setSubject("");
            caSelector.setSubjectKeyIdentifier(null);
            X500Principal tempP = cert.getIssuerX500Principal();
            caSelector.setSubject(tempP);
            Object[] extObj = CertPathUtil.getExtension("x509.info.extensions.AuthorityKeyIdentifier", cert);
            if (extObj[1] != null) {
                AuthorityKeyIdentifierExtension temp = new AuthorityKeyIdentifierExtension((Boolean)extObj[0], extObj[1]);
                KeyIdentifier id = (KeyIdentifier)temp.get("key_id");
                if (id != null) {
                    caSelector.setSubjectKeyIdentifier(new DerValue(4, id.getIdentifier()).toByteArray());
                } else if (debug != null) {
                    System.out.println("CERTPATH: no AuthorityKeyIdentifier");
                }
            }
        }
        catch (IOException e) {
        }
        catch (CertPathValidatorException certPathValidatorException) {
            // empty catch block
        }
        if (debug != null) {
            System.out.println("CERTPATH: created CA selector ");
            System.out.println(caSelector.toString());
        }
        return caSelector;
    }

    private Object[] myValidator(CertPath certPath, PKIXBuilderParameters parms) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        PKIXCertPathValidatorImpl cpv = new PKIXCertPathValidatorImpl();
        Object[] cpbr = new Object[]{null, null};
        PKIXCertPathValidatorResult cpvr = null;
        try {
            cpvr = (PKIXCertPathValidatorResult)cpv.engineValidate(certPath, parms);
        }
        catch (CertPathValidatorException cpve) {
            if (debug != null) {
                System.out.println("CERTPATH: myValidator failed on validation");
                cpve.printStackTrace();
            }
            cpbr[1] = cpve;
        }
        catch (InvalidAlgorithmParameterException iape) {
            if (debug != null) {
                System.out.println("CERTPATH: myValidator has invalid parameter");
                iape.printStackTrace();
            }
            cpbr[1] = iape;
        }
        if (cpvr != null) {
            cpbr[0] = certPath;
            cpbr[1] = cpvr;
        }
        return cpbr;
    }

    private String[] getTaNames(Set trustAnchors) {
        int count = 0;
        String[] names = new String[trustAnchors.size()];
        for (TrustAnchor ta : trustAnchors) {
            String temp = ta.getCAName();
            names[count] = temp == null ? ta.getTrustedCert().getSubjectDN().getName() : temp;
            ++count;
        }
        return names;
    }

    private boolean isEndOfCertPath(X509Certificate cert, String[] names) {
        String subjectName = cert.getSubjectDN().getName();
        for (int i = 0; i < names.length; ++i) {
            if (!subjectName.equalsIgnoreCase(names[i])) continue;
            return true;
        }
        return false;
    }

    private List<CertStore> getAIAExtensionCertStores(X509Certificate cert) {
        if (debug != null) {
            System.out.println("PKIXCertPathBuilderImpl.getAIAExtensionCertStores:  METHOD ENTRY.  ");
        }
        try {
            Set adSet;
            X509CertImpl certImpl = X509CertImpl.toImpl((X509Certificate)cert);
            if (debug != null) {
                System.out.println("PKIXCertPathBuilderImpl.getAIAExtensionCertStores:  ");
                System.out.println("   The input cert is: " + certImpl.toString());
            }
            if ((adSet = certImpl.getAuthorityInformationAccess()) == null || adSet.isEmpty()) {
                if (debug != null) {
                    System.out.println("PKIXCertPathBuilderImpl.getAIAExtensionCertStores:  Either this cert does not contain an AIA extension, or");
                    System.out.println("                                                    its AIA extension contains no AccessDescription elements.");
                    System.out.println("                                                    Returning null to the caller.");
                    System.out.println("PKIXCertPathBuilderImpl.getAIAExtensionCertStores:  METHOD EXIT.  ");
                }
                return null;
            }
            if (debug != null) {
                System.out.println("PKIXCertPathBuilderImpl.getAIAExtensionCertStores: ");
                System.out.println("   There are " + adSet.size() + " AccessDescription elements within this cert's AIA extension.");
                System.out.println("   They are:");
                for (AccessDescription ad : adSet) {
                    System.out.println(ad.toString());
                }
            }
            ArrayList<CertStore> certStores = new ArrayList<CertStore>();
            for (AccessDescription ad : adSet) {
                if (debug != null) {
                    System.out.println("\nProcessing AccessDescription = " + ad.toString());
                }
                if (!ad.getAccessMethod().equals(AccessDescription.Ad_CAISSUERS_Id)) {
                    if (debug == null) continue;
                    System.out.println("Ignore this AccessDescription.  NO Ad_CAISSUERS_Id ACCESS METHOD.");
                    System.out.println("No  CertStore created for this AccessDescription object.");
                    continue;
                }
                GeneralNameInterface gn = ad.getAccessLocation().getName();
                CertStore cs = URICertStore.getInstance(ad);
                if (cs == null) continue;
                if (debug != null) {
                    System.out.println("adding AIAext CertStore");
                }
                certStores.add(cs);
            }
            if (debug != null) {
                System.out.println("\nPKIXCertPathBuilderImpl.getAIAExtensionCertStores(AIA):  ");
                System.out.println("   The collection of certStores returned is:             ");
                for (CertStore store : certStores) {
                    System.out.println(store.toString());
                }
                System.out.println("PKIXCertPathBuilderImpl.getAIAExtensionCertStores:  METHOD EXIT.  ");
            }
            return certStores;
        }
        catch (Exception e) {
            if (debug != null) {
                System.out.println("PKIXCertPathBuilderImpl.getAIAExtensionCertStores(): Exception while obtaining CertStores: " + e.getMessage());
                System.out.println("                                                     Returning null.");
                System.out.println("PKIXCertPathBuilderImpl.getAIAExtensionCertStores:  METHOD EXIT.  ");
            }
            return null;
        }
    }

    private boolean checkAIAEXTEnabled() {
        String enabled = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("com.ibm.security.enableAIAEXT");
            }
        });
        return new Boolean(enabled);
    }

    static class CertStoreComparator
    implements Comparator<CertStore> {
        CertStoreComparator() {
        }

        @Override
        public int compare(CertStore store1, CertStore store2) {
            if (store1.getType().equals(store2.getType())) {
                return 0;
            }
            if (store1.getType().equals("Collection")) {
                return -1;
            }
            return 1;
        }
    }
}

