/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.securerandom.provider;

import com.ibm.securerandom.provider.SecureRandom;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandomSpi;

public final class SHA1PRNG
extends SecureRandomSpi
implements Serializable {
    static final long serialVersionUID = -3888978670357092251L;
    private transient MessageDigest sha1;
    private SecureRandom seedGenerator;
    private BigInteger P64;
    private int[] syms = new int[16];
    private byte[] sbuf = new byte[256];
    private byte[] rngTestBuf = null;
    private long accu = 0L;
    private boolean firstTrng = true;
    private boolean extSeeded = false;
    private long rngTest = 0L;
    private int bits = 0;
    private int nsam = 64;
    private static final short[] logtab;
    byte[] state = new byte[85];
    boolean resetState = false;
    private static final String[] z;

    public SHA1PRNG() {
        this.a(null);
    }

    public SHA1PRNG(byte[] byArray) {
        this.a(byArray);
    }

    private void a(byte[] byArray) {
        byte[] byArray2 = new byte[9];
        try {
            this.sha1 = MessageDigest.getInstance(z[0], z[2]);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError(z[1]);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new InternalError(z[3]);
        }
        byArray2[0] = 1;
        byArray2[8] = 13;
        this.P64 = new BigInteger(1, byArray2);
        SHA1PRNG.a(128, this.state, 49);
        SHA1PRNG.a(30, this.state, 53);
        if (byArray != null) {
            this.engineSetSeed(byArray);
        }
    }

    public boolean isFipsApproved() {
        return true;
    }

    public synchronized void engineSetSeed(byte[] byArray) {
        this.b(byArray);
    }

    protected synchronized void b(byte[] byArray) {
        if (byArray != null) {
            int n = 0;
            int n2 = byArray.length;
            if (n2 > 40) {
                MessageDigest messageDigest = null;
                try {
                    messageDigest = MessageDigest.getInstance(z[0], z[2]);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new InternalError(z[1]);
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    throw new InternalError(z[3]);
                }
                byte[] byArray2 = new byte[20];
                messageDigest.update(byArray);
                byArray2 = messageDigest.digest();
                n2 = 20;
                byArray = this.state;
                n = 65;
                System.arraycopy(byArray2, 0, this.state, 65, n2);
            }
            while (--n2 >= 0) {
                int n3 = 25 + n2 % 20;
                this.state[n3] = (byte)(this.state[n3] ^ byArray[n + n2]);
            }
            if (this.state[0] == 0) {
                this.state[0] = 25;
            }
            this.extSeeded = true;
        }
    }

    public synchronized void engineNextBytes(byte[] byArray) {
        this.c(byArray);
    }

    protected synchronized void c(byte[] byArray) {
        this.b(byArray, 0, byArray.length);
    }

    public byte[] engineGenerateSeed(int n) {
        return this.a(n);
    }

    protected byte[] a(int n) {
        byte[] byArray = new byte[n];
        this.b(byArray, 0, byArray.length);
        return byArray;
    }

    private int a() {
        int n;
        while (this.bits == 0) {
            BigInteger bigInteger;
            long l;
            this.accu = 0L;
            int n2 = 0;
            do {
                this.syms[n2] = 0;
            } while (++n2 < 16);
            int n3 = this.sbuf.length - 1;
            int n4 = 0;
            n = 0;
            int n5 = 0;
            int n6 = 0;
            while (true) {
                int n7 = 0;
                do {
                    l = System.currentTimeMillis();
                    while (l == System.currentTimeMillis()) {
                        ++n7;
                    }
                } while (n7 == 0);
                this.sbuf[n3] = (byte)(this.sbuf[n3] << 4 | n7 % 16);
                n3 -= n4;
                n4 ^= 1;
                if ((n6 - n7) * (n6 - n7) != 1) {
                    n6 = n7;
                }
                int n8 = n6 % 16;
                this.syms[n8] = this.syms[n8] + n;
                n |= 1;
                if (n3 < 0) {
                    bigInteger = new BigInteger(1, this.sbuf);
                    this.accu ^= bigInteger.multiply(bigInteger).remainder(this.P64).longValue();
                    n3 += this.sbuf.length;
                    n = 0;
                }
                if (++n5 < this.nsam) continue;
                n2 = 0;
                int n9 = 0;
                int n10 = SHA1PRNG.b(n5);
                do {
                    n = this.syms[n2];
                    n9 += n * (n10 - SHA1PRNG.b(n));
                } while (++n2 < 16);
                this.nsam = 96000 * n5 / n9;
                if (this.nsam <= n5) break;
                this.nsam = n9 > n5 ? this.nsam + 3 : n5 + 32;
                n = 0;
            }
            bigInteger = new BigInteger(1, this.sbuf);
            this.accu ^= bigInteger.multiply(bigInteger).remainder(this.P64).longValue() ^ l;
            this.bits = 64;
            if (!this.firstTrng) continue;
            this.accu = 0L;
            this.bits = 0;
            this.firstTrng = false;
        }
        n = (int)(this.accu & 0xFFL);
        this.accu >>>= 8;
        this.bits -= 8;
        return n;
    }

    private void a(byte[] byArray, int n, int n2) {
        byte[] byArray2 = this.state;
        while (--n2 >= 0) {
            int n3 = 25 + n2 % 20;
            byArray2[n3] = (byte)(byArray2[n3] ^ this.a());
        }
        long l = (long)SHA1PRNG.a(byArray2, 53) * 1000L + System.currentTimeMillis();
        SHA1PRNG.a((int)(l >>> 32), byArray2, 57);
        SHA1PRNG.a((int)l, byArray2, 61);
        if (byArray2[0] == 0) {
            byArray2[0] = 25;
        }
        this.state = byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private synchronized void b(byte[] byArray, int n, int n2) {
        int n3;
        byte[] byArray2 = this.state;
        byte[] byArray3 = new byte[45];
        byte[] byArray4 = null;
        if (this.resetState) {
            this.state = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            this.resetState = false;
        }
        while ((n3 = byArray2[0]) == 0) {
            this.a(null, 0, 20);
            byArray2 = this.state;
        }
        while (true) {
            if (--n2 < 0) {
                byArray2[0] = (byte)n3;
                return;
            }
            while (n3 == 25 || this.rngTestBuf == null) {
                int n4 = SHA1PRNG.a(byArray2, 49);
                if (n4 > 0 && !this.extSeeded) {
                    long l = ((long)SHA1PRNG.a(byArray2, 57) << 32) + ((long)SHA1PRNG.a(byArray2, 61) & 0xFFFFFFFFL);
                    int n5 = SHA1PRNG.a(byArray2, 45);
                    int n6 = n5 + 20;
                    if (n6 < n5) {
                        n5 = 0;
                        n6 = 0 + 20;
                    }
                    SHA1PRNG.a(n6, byArray2, 45);
                    n5 += n4 - n5 % n4;
                    while (n5 < n6) {
                        if (n5 > 0x59999994 || n5 < -1503238548) {
                            this.resetState = true;
                        }
                        byte[] byArray5 = this.sbuf;
                        // MONITORENTER : this.sbuf
                        if (this.bits > 0 || System.currentTimeMillis() >= l) {
                            int n7 = 25 + n5 / n4 % 20;
                            byArray2[n7] = (byte)(byArray2[n7] ^ this.a());
                            l = (long)SHA1PRNG.a(byArray2, 53) * 1000L + System.currentTimeMillis();
                            SHA1PRNG.a((int)(l >>> 32), byArray2, 57);
                            SHA1PRNG.a((int)l, byArray2, 61);
                        }
                        // MONITOREXIT : byArray5
                        n5 += n4;
                    }
                }
                System.arraycopy(byArray2, 5, byArray3, 0, 45);
                this.sha1.update(byArray3, 0, byArray3.length);
                byArray4 = this.sha1.digest();
                System.arraycopy(byArray4, 0, byArray2, 5, 20);
                if (this.rngTestBuf != null) {
                    n3 = 5;
                    continue;
                }
                this.rngTestBuf = new byte[20];
                n3 = 25;
            }
            byArray[n++] = byArray2[n3++];
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.sha1 = MessageDigest.getInstance(z[0], z[2]);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError(z[1]);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new InternalError(z[3]);
        }
    }

    private static final int b(int n) {
        int n2 = 6;
        if (n == 0) {
            return 0;
        }
        while (n < 64) {
            n <<= 1;
            --n2;
        }
        while (n >= 128) {
            n >>= 1;
            ++n2;
        }
        return n2 * 1000 + logtab[n & 0x3F];
    }

    static final int a(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    static final void a(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >>> 24);
        byArray[n2 + 1] = (byte)(n >>> 16);
        byArray[n2 + 2] = (byte)(n >>> 8);
        byArray[n2 + 3] = (byte)n;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block39: {
            int n;
            int n2;
            block38: {
                char[] cArray2;
                Object var0;
                block37: {
                    int n3;
                    block36: {
                        char[] cArray3;
                        block35: {
                            int n4;
                            block34: {
                                char[] cArray4;
                                block33: {
                                    int n5;
                                    block32: {
                                        stringArray = new String[4];
                                        var0 = null;
                                        char[] cArray5 = "KgPg".toCharArray();
                                        cArray4 = cArray5;
                                        n5 = cArray5.length;
                                        n2 = 0;
                                        if (!true) break block32;
                                        n5 = n5;
                                        if (n5 <= n2) break block33;
                                    }
                                    do {
                                        int n6;
                                        cArray4 = cArray4;
                                        int n7 = n2;
                                        char c2 = cArray4[n7];
                                        switch (n2 % 5) {
                                            case 0: {
                                                n6 = 24;
                                                break;
                                            }
                                            case 1: {
                                                n6 = 47;
                                                break;
                                            }
                                            case 2: {
                                                n6 = 17;
                                                break;
                                            }
                                            case 3: {
                                                n6 = 86;
                                                break;
                                            }
                                            default: {
                                                n6 = 69;
                                            }
                                        }
                                        cArray4[n7] = (char)(c2 ^ n6);
                                        ++n2;
                                        n5 = n5;
                                    } while (n5 > n2);
                                }
                                stringArray[0] = new String(cArray4).intern();
                                var0 = null;
                                char[] cArray6 = "Qm\\\u0005 {Zc3\u0017yAu9(8|Y\u0017t8Fbv+w[173yF}7'tJ".toCharArray();
                                cArray3 = cArray6;
                                n4 = cArray6.length;
                                n2 = 0;
                                if (!true) break block34;
                                n4 = n4;
                                if (n4 <= n2) break block35;
                            }
                            do {
                                int n8;
                                cArray3 = cArray3;
                                int n9 = n2;
                                char c3 = cArray3[n9];
                                switch (n2 % 5) {
                                    case 0: {
                                        n8 = 24;
                                        break;
                                    }
                                    case 1: {
                                        n8 = 47;
                                        break;
                                    }
                                    case 2: {
                                        n8 = 17;
                                        break;
                                    }
                                    case 3: {
                                        n8 = 86;
                                        break;
                                    }
                                    default: {
                                        n8 = 69;
                                    }
                                }
                                cArray3[n9] = (char)(c3 ^ n8);
                                ++n2;
                                n4 = n4;
                            } while (n4 > n2);
                        }
                        stringArray[1] = new String(cArray3).intern();
                        var0 = null;
                        char[] cArray7 = "Qm\\\u0005 {Zc3\u0017yAu9(".toCharArray();
                        cArray2 = cArray7;
                        n3 = cArray7.length;
                        n2 = 0;
                        if (!true) break block36;
                        n3 = n3;
                        if (n3 <= n2) break block37;
                    }
                    do {
                        int n10;
                        cArray2 = cArray2;
                        int n11 = n2;
                        char c4 = cArray2[n11];
                        switch (n2 % 5) {
                            case 0: {
                                n10 = 24;
                                break;
                            }
                            case 1: {
                                n10 = 47;
                                break;
                            }
                            case 2: {
                                n10 = 17;
                                break;
                            }
                            case 3: {
                                n10 = 86;
                                break;
                            }
                            default: {
                                n10 = 69;
                            }
                        }
                        cArray2[n11] = (char)(c4 ^ n10);
                        ++n2;
                        n3 = n3;
                    } while (n3 > n2);
                }
                stringArray[2] = new String(cArray2).intern();
                var0 = null;
                char[] cArray8 = "Qm\\\u0005 {Zc3\u0017yAu9(8Fbv+w[173yF}7'tJ".toCharArray();
                cArray = cArray8;
                n = cArray8.length;
                n2 = 0;
                if (!true) break block38;
                n = n;
                if (n <= n2) break block39;
            }
            do {
                int n12;
                cArray = cArray;
                int n13 = n2;
                char c5 = cArray[n13];
                switch (n2 % 5) {
                    case 0: {
                        n12 = 24;
                        break;
                    }
                    case 1: {
                        n12 = 47;
                        break;
                    }
                    case 2: {
                        n12 = 17;
                        break;
                    }
                    case 3: {
                        n12 = 86;
                        break;
                    }
                    default: {
                        n12 = 69;
                    }
                }
                cArray[n13] = (char)(c5 ^ n12);
                ++n2;
                n = n;
            } while (n > n2);
        }
        stringArray[3] = new String(cArray).intern();
        z = stringArray;
        logtab = new short[]{0, 22, 44, 66, 87, 109, 129, 150, 170, 190, 209, 229, 248, 267, 285, 304, 322, 340, 358, 375, 392, 409, 426, 443, 459, 476, 492, 508, 524, 539, 555, 570, 585, 600, 615, 629, 644, 658, 672, 687, 700, 714, 728, 741, 755, 768, 781, 794, 807, 820, 833, 845, 858, 870, 883, 895, 907, 919, 931, 943, 954, 966, 977, 989};
    }
}

