/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.eclipseAdapterData;

import com.ibm.cic.common.core.model.adapterdata.CommonAdapterData;
import com.ibm.cic.common.eclipseAdapterData.EclipseIdVersionData;
import com.ibm.cic.common.eclipseAdapterData.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public class EclipseBundleData
extends EclipseIdVersionData {
    public static final int DEFAULT_BUNDLE_LEVEL = 5;
    public static final int DEFAULT_BUNDLE_STATE = 4;
    public static final boolean DEFAULT_BUNDLE_EXPLODE = false;
    public static final boolean DEFAULT_BUNDLE_SINGLETON = true;
    private final int startLevel;
    private final int expectedState;
    private final boolean explode;
    private boolean singleton;

    public EclipseBundleData(String id, Version version, int startLevel, int expectedState, boolean exploded) {
        this(id, version, startLevel, expectedState, exploded, true);
    }

    public EclipseBundleData(String id, Version version, int startLevel, int expectedState, boolean exploded, boolean singleton) {
        super(id, version);
        this.startLevel = startLevel;
        this.expectedState = expectedState;
        this.explode = exploded;
        this.singleton = singleton;
    }

    public static String getKind() {
        return "bundle";
    }

    protected EclipseBundleData(String id, Version version) {
        this(id, version, 5, 4, false, true);
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public int getExpectedState() {
        return this.expectedState;
    }

    public boolean getExploded() {
        return this.explode;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public String getElementName() {
        return EclipseBundleData.getKind();
    }

    protected CommonAdapterData.NameValuePairs getAttrNameValuePairs() {
        return new CommonAdapterData.NameValuePairs().add("id", (Object)this.id).add("version", (Object)this.version).add("level", (Object)Integer.toString(this.startLevel)).add("state", (Object)EclipseBundleData.convertState(this.expectedState)).addIfTrue("exploded", this.explode).addIfFalse("singleton", this.singleton);
    }

    public static int convertState(String stringState) throws IllegalArgumentException {
        if ("RESOLVED".equalsIgnoreCase(stringState)) {
            return 4;
        }
        if ("ACTIVE".equalsIgnoreCase(stringState)) {
            return 32;
        }
        if ("INSTALLED".equalsIgnoreCase(stringState)) {
            return 2;
        }
        if ("UNINSTALLED".equalsIgnoreCase(stringState)) {
            return 1;
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.EclipseData_invalid_bundle_state, (Object)stringState));
    }

    public static String convertState(int intState) {
        if (intState == 4) {
            return "RESOLVED";
        }
        if (intState == 32) {
            return "ACTIVE";
        }
        return "INSTALLED";
    }
}

