/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.adapters.nativeAdapter.linux;

import com.ibm.cic.agent.core.IInstallAdaptor;
import com.ibm.cic.agent.core.IInstallOperation;
import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.core.commonNativeInstallAdapter.ICommonNativeInstallAdapter;
import com.ibm.cic.agent.internal.adapters.nativeAdapter.linux.DesktopIconLinuxInstallOperation;
import com.ibm.cic.agent.internal.adapters.nativeAdapter.linux.Util;
import com.ibm.cic.common.commonNativeAdapterData.ICommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.PerformCommonNativeData;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.InstallableUnitPair;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.nativeAdapterData.linux.DesktopIconLinuxNativeData;
import java.io.IOException;
import java.io.Writer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class NativeLinuxInstallAdapter
extends ICommonNativeInstallAdapter
implements IInstallAdaptor {
    private static final String ID = "nativeLinux";
    private static Logger log = Logger.getLogger(NativeLinuxInstallAdapter.class);

    public String getId() {
        return ID;
    }

    public IStatus preInstallConfigure(InstallableUnitPair pair, InstallContext context, IProgressMonitor monitor) {
        return this.perform(10, 40, pair, context, monitor);
    }

    public IStatus install(InstallableUnitPair pair, InstallContext context, IProgressMonitor monitor) {
        return this.perform(21, 51, pair, context, monitor);
    }

    public IStatus postInstallConfigure(InstallableUnitPair pair, InstallContext context, IProgressMonitor monitor) {
        return this.perform(30, 60, pair, context, monitor);
    }

    protected Logger getLog() {
        return log;
    }

    protected void customOperation(int phase, IInstallableUnit unit, InstallContext context, ICommonNativeData data, PerformCommonNativeData performData, IProgressMonitor monitor) throws CoreException {
        this.processCommonPerformOperation(phase, unit, context, data, performData, monitor);
    }

    private void handleDesktopOperation(int phase, IInstallableUnit unit, InstallContext context, DesktopIconLinuxNativeData data, IProgressMonitor monitor) throws CoreException {
        ICommonNativeInstallAdapter.SupplementaryLogWriter writer = ICommonNativeInstallAdapter.SupplementaryLogWriter.create();
        try {
            DesktopIconLinuxInstallOperation op = new DesktopIconLinuxInstallOperation(phase, unit, context, data, (Writer)writer);
            context.performOperation((IInstallOperation)op, monitor);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                throw Util.coreException(e, null);
            }
        }
    }

    protected void dispatcher(int phase, IInstallableUnit unit, InstallContext context, ICommonNativeData data, IProgressMonitor monitor) throws CoreException {
        boolean processed = this.processCommonOperation(phase, unit, context, data, monitor);
        if (!processed && data instanceof DesktopIconLinuxNativeData) {
            this.handleDesktopOperation(phase, unit, context, (DesktopIconLinuxNativeData)data, monitor);
        }
    }
}

