/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.p2EclipseAdapterData.internal;

import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IShareableItem;
import com.ibm.cic.common.core.model.IShareableUnit;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.model.Walker;
import com.ibm.cic.common.core.model.adapterdata.CommonAdapterData;
import com.ibm.cic.common.core.model.adapterdata.IAdapterDataResolver;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.model.adapterdata.KeyBasedArtifact;
import com.ibm.cic.common.core.repository.IContentRepository;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.RepositoryUtils;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.downloads.ContentInfo;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IMessageDigests;
import com.ibm.cic.common.downloads.SimpleContentInfo;
import com.ibm.cic.common.downloads.SizeInfo;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.p2EclipseAdapterData.IP2ReferenceData;
import com.ibm.cic.common.p2EclipseAdapterData.P2EclipseAdapterData;
import com.ibm.cic.common.p2EclipseAdapterData.internal.Messages;
import com.ibm.cic.p2.model.CicP2Model;
import com.ibm.cic.p2.model.IP2ArtifactKey;
import com.ibm.cic.p2.model.IP2InstallUnit;
import com.ibm.cic.p2.model.IP2MetadataSource;
import com.ibm.cic.p2.model.IP2Session;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class P2ArtifactResolver
implements IAdapterDataResolver {
    private static final P2ArtifactResolver INSTANCE = new P2ArtifactResolver();

    public static P2ArtifactResolver getInstance() {
        return INSTANCE;
    }

    public IStatus resolveIUAdapterData(IContent root, IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)6);
        Collection ius = this.getIUs(root);
        sm.worked(1);
        IArtifactResolver resolver = null;
        try {
            resolver = this.prepareResolution(root, ius, (IProgressMonitor)sm.newChild(2));
            if (resolver == null) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            SubMonitor sm2 = sm.newChild(3);
            sm2.setWorkRemaining(ius.size());
            for (IInstallableUnit iu : ius) {
                IStatus status = resolver.resolve(iu);
                if (StatusUtil.isErrorOrCancel((IStatus)status)) {
                    IStatus iStatus = status;
                    return iStatus;
                }
                sm2.worked(1);
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (CoreException e) {
            IStatus iStatus = e.getStatus();
            return iStatus;
        }
        finally {
            if (resolver != null) {
                resolver.release();
            }
            sm.done();
        }
    }

    private IArtifactResolver prepareResolution(IContent root, Collection ius, IProgressMonitor monitor) throws CoreException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        if (ius.isEmpty()) {
            sm.done();
            return null;
        }
        IInstallableUnit anyIu = (IInstallableUnit)ius.iterator().next();
        P2EclipseAdapterData p2Data = (P2EclipseAdapterData)anyIu.getAdapterData();
        if (p2Data.isResolved()) {
            sm.done();
            return null;
        }
        IContentRepository repo = RepositoryUtils.getContentRepository((IContent)root);
        try {
            if (!(repo != null && repo.containsP2Repository((IProgressMonitor)sm.newChild(1)) || (repo = root.getRepository()) != null && repo.containsP2Repository(null))) {
                return null;
            }
            File tempDir = FileUtil.createTempDir((String)root.getIdentity().getId(), null, null);
            File destFile = new File(tempDir, "content.xml");
            IStatus status = repo.exportP2Repository(destFile, (IProgressMonitor)sm.newChild(1));
            if (!status.isOK()) {
                throw new CoreException(status);
            }
            IP2Session p2Session = CicP2Model.getDefault().getP2Session();
            IP2MetadataSource p2MetaSrc = p2Session.openExistingMetadataSource(tempDir.toURI(), (IProgressMonitor)sm.newChild(1));
            IUArtifactResolver iUArtifactResolver = new IUArtifactResolver(destFile, p2Session, p2MetaSrc, (IRepository)repo);
            return iUArtifactResolver;
        }
        catch (CoreException e) {
            String msg = NLS.bind((String)Messages.P2ArtifactResolver_resolvingP2ArtifactFailed, (Object)repo.getLocation());
            CicMultiStatus ms = Statuses.ST.createMultiStatus(msg, new Object[0]);
            ms.add(e.getStatus());
            throw new CoreException((IStatus)ms);
        }
        catch (IOException e) {
            String msg = NLS.bind((String)Messages.P2ArtifactResolver_resolvingP2ArtifactFailed, (Object)repo.getLocation());
            ICicStatus status = Statuses.ERROR.get((Throwable)e, msg, new Object[0]);
            throw new CoreException((IStatus)status);
        }
        finally {
            sm.done();
        }
    }

    private Collection getIUs(IContent root) {
        final LinkedList ius = new LinkedList();
        Walker walker = new Walker(){

            public void doShareableUnit(IShareableUnit su) throws Exception {
                this.addP2IUs(ius, (IShareableItem)su);
            }

            public void doSuFragment(ISuFragment suFragment) throws Exception {
                this.addP2IUs(ius, (IShareableItem)suFragment);
            }

            private void addP2IUs(Collection p2IUs, IShareableItem si) {
                for (IInstallableUnit iu : si.getChildren()) {
                    if (!iu.getAdapterId().equals("p2Eclipse")) continue;
                    p2IUs.add(iu);
                }
            }

            protected boolean canHaveUnresolvedIncludes() {
                return true;
            }
        };
        try {
            walker.walkIncludes(root);
        }
        catch (InvocationTargetException e) {
            Logger.getGlobalLogger().error((Throwable)e);
        }
        return ius;
    }

    static interface IArtifactResolver {
        public IStatus resolve(IInstallableUnit var1);

        public void release();
    }

    static class IUArtifactResolver
    implements IArtifactResolver {
        private final File fileContentXmlInTempDir;
        private final IP2Session session;
        private final IP2MetadataSource p2MetaSrc;
        private final IRepository repo;

        public IUArtifactResolver(File fileContentXmlInTempDir, IP2Session session, IP2MetadataSource p2MetaSrc, IRepository repo) {
            this.fileContentXmlInTempDir = fileContentXmlInTempDir;
            this.session = session;
            this.p2MetaSrc = p2MetaSrc;
            this.repo = repo;
        }

        @Override
        public void release() {
            this.session.dispose();
            this.fileContentXmlInTempDir.delete();
            FileUtil.deleteEmptyDirsLogIOE((File)this.fileContentXmlInTempDir.getParentFile());
        }

        @Override
        public IStatus resolve(IInstallableUnit iu) {
            CommonAdapterData[] children;
            P2EclipseAdapterData p2Data = (P2EclipseAdapterData)iu.getAdapterData();
            CommonAdapterData[] commonAdapterDataArray = children = p2Data.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IP2ReferenceData p2RefData;
                IStatus status;
                CommonAdapterData commonData = commonAdapterDataArray[n2];
                if (commonData instanceof IP2ReferenceData && StatusUtil.isErrorOrCancel((IStatus)(status = this.resolve(iu, p2Data, p2RefData = (IP2ReferenceData)commonData)))) {
                    return status;
                }
                ++n2;
            }
            p2Data.setResolved(true);
            return Status.OK_STATUS;
        }

        private IStatus resolve(IInstallableUnit iu, P2EclipseAdapterData data, IP2ReferenceData refData) {
            IP2InstallUnit p2IU = this.p2MetaSrc.findIU(refData.getId(), refData.getVersion());
            if (p2IU == null) {
                return Statuses.ERROR.get(Messages.P2ArtifactResolver_p2UnitNotFound, new Object[]{refData.getId(), refData.getVersion().toString(), this.repo.getLocationStr()});
            }
            IP2ArtifactKey[] p2Keys = p2IU.getArtifacts();
            if (p2Keys.length == 1) {
                IP2ArtifactKey p2Key = p2Keys[0];
                IArtifactKey key = p2Key.toCicKey();
                boolean exploded = p2IU.isZipped();
                boolean isActive = true;
                P2Artifact artifact = new P2Artifact(key, refData.getSizeInfo(), exploded);
                data.addArtifact((IArtifact)artifact, isActive);
            }
            return Status.OK_STATUS;
        }
    }

    static class P2Artifact
    extends KeyBasedArtifact {
        public P2Artifact(IArtifactKey key, SizeInfo sizeInfo, boolean exploded) {
            super(key, exploded);
            SimpleContentInfo sci = new SimpleContentInfo(sizeInfo, (IMessageDigests)ContentInfo.EMPTY_CONTENT_INFO);
            this.setContentInfo((IContentInfo)sci);
        }
    }
}

