/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Transformer;
import org.apache.xml.serializer.AttributesImplSerializer;
import org.apache.xml.serializer.DOMSerializer;
import org.apache.xml.serializer.ElemContext;
import org.apache.xml.serializer.Encodings;
import org.apache.xml.serializer.NamespaceMappings;
import org.apache.xml.serializer.SecuritySupport;
import org.apache.xml.serializer.SerializationHandler;
import org.apache.xml.serializer.SerializerConstants;
import org.apache.xml.serializer.SerializerTrace;
import org.apache.xml.serializer.WriterOptimized;
import org.apache.xml.serializer.dom3.DOM3SerializerImpl;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class SerializerBase
implements SerializationHandler,
SerializerConstants {
    public static final String PKG_NAME;
    public static final String PKG_PATH;
    protected static final char[] s_systemLineSep;
    private static final int ALL_BITS_ON = 65535;
    protected boolean m_needToCallStartDocument = true;
    protected boolean m_cdataTagOpen = false;
    protected boolean m_cdataTagEnd = false;
    protected final AttributesImplSerializer m_attributes;
    protected boolean m_inEntityRef = false;
    protected boolean m_inExternalDTD = false;
    protected String m_doctypeSystem = null;
    protected String m_doctypePublic = null;
    boolean m_needToOutputDocTypeDecl = true;
    protected boolean m_shouldNotWriteXMLHeader = false;
    String m_standalone = null;
    protected boolean m_standaloneWasSpecified = false;
    protected boolean m_doIndent = false;
    protected int m_indentAmount = 0;
    protected String m_version = null;
    private final boolean m_isXslt10 = true;
    protected boolean m_wasJustReset = false;
    protected String m_mediatype = null;
    private Transformer m_transformer = null;
    protected NamespaceMappings m_prefixMap = null;
    protected SerializerTrace m_tracer = null;
    protected SourceLocator m_sourceLocator = null;
    protected Writer m_writer = null;
    protected WriterOptimized m_writerOptimized = null;
    protected ElemContext m_elemContext;
    protected final int CHARSBUFF_MAX_SIZE = 65536;
    private char[] m_charsBuff = new char[60];
    protected char[] m_normalizedCharsBuff;
    protected String m_StringOfCDATASections = null;
    boolean m_docIsEmpty = true;
    protected Hashtable m_CdataElems = null;
    private HashMap m_OutputProps = null;
    HashMap m_OutputPropsDefault = null;
    protected char[] m_lineSep;
    protected int m_lineSepLen;
    private String m_attr_qName = null;
    private final StringBuffer m_attr_content_sb = new StringBuffer();
    private String m_attr_content_s = null;
    private boolean m_attr_appended = false;
    private int m_attr_content_flags = 65535;
    private String m_resultDocAbsoluteURI = null;
    boolean m_undeclareNamespaces = false;
    protected OutputStream m_OutputStream = null;
    public static final boolean XSLT2_DEV = true;

    SerializerBase() {
        this.m_attributes = new AttributesImplSerializer();
        this.m_elemContext = new ElemContext();
        this.m_lineSep = s_systemLineSep;
        this.m_lineSepLen = this.m_lineSep.length;
        this.m_normalizedCharsBuff = new char[60];
    }

    @Override
    public boolean reset() {
        this.m_attr_qName = null;
        this.m_attr_content_flags = 65535;
        this.m_attr_content_sb.setLength(0);
        this.m_attr_appended = false;
        this.m_attr_content_s = null;
        this.m_attributes.clear();
        this.m_CdataElems = null;
        this.m_cdataTagOpen = false;
        this.m_cdataTagEnd = false;
        this.m_docIsEmpty = true;
        this.m_doctypePublic = null;
        this.m_doctypeSystem = null;
        this.m_doIndent = false;
        while (this.m_elemContext.m_currentElemDepth > 0) {
            this.m_elemContext = this.m_elemContext.pop();
        }
        this.m_indentAmount = 0;
        this.m_inEntityRef = false;
        this.m_inExternalDTD = false;
        this.m_lineSep = s_systemLineSep;
        this.m_lineSepLen = this.m_lineSep.length;
        this.m_mediatype = null;
        this.m_needToCallStartDocument = true;
        this.m_needToOutputDocTypeDecl = true;
        this.m_OutputStream = null;
        if (this.m_prefixMap != null) {
            this.m_prefixMap.reset();
        }
        this.m_resultDocAbsoluteURI = null;
        this.m_shouldNotWriteXMLHeader = false;
        this.m_sourceLocator = null;
        this.m_standalone = null;
        this.m_standaloneWasSpecified = false;
        this.m_StringOfCDATASections = null;
        this.m_tracer = null;
        this.m_transformer = null;
        this.m_undeclareNamespaces = false;
        this.m_version = null;
        this.m_wasJustReset = true;
        return true;
    }

    protected void fireEndElem(String string) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(4, string, (Attributes)null);
        }
    }

    protected void fireCharEvent(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(5, cArray, n, n2);
        }
    }

    protected String patchName(String string) {
        int n = string.lastIndexOf(58);
        if (n > 0) {
            int n2 = string.indexOf(58);
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n + 1);
            String string4 = this.m_prefixMap.lookupNamespace(string2);
            if (string4 != null && string4.length() == 0) {
                return string3;
            }
            if (n2 != n) {
                return string2 + ':' + string3;
            }
        }
        return string;
    }

    protected static String getLocalName(String string) {
        int n = string.lastIndexOf(58);
        return n > 0 ? string.substring(n + 1) : string;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void addAttribute(String string, String string2, String string3, String string4, String string5, boolean bl) throws SAXException {
        if (this.m_elemContext.m_startTagOpen) {
            this.addAttributeAlways(string, string2, string3, string4, string5, bl, 0);
        }
    }

    public boolean addAttributeAlways(String string, String string2, String string3, String string4, String string5, boolean bl, int n) {
        boolean bl2;
        int n2 = string2 == null || string == null || string.length() == 0 ? this.m_attributes.getIndex(string3) : this.m_attributes.getIndex(string, string2);
        if (n2 >= 0) {
            this.m_attributes.setValue(n2, string5);
            bl2 = false;
        } else {
            this.m_attributes.addAttribute(string, string2, string3, string4, string5, n);
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public void addAttribute(String string, String string2) {
        if (this.m_elemContext.m_startTagOpen) {
            String string3 = this.patchName(string);
            String string4 = SerializerBase.getLocalName(string3);
            String string5 = this.getNamespaceURI(string3, false);
            this.addAttributeAlways(string5, string4, string3, "CDATA", string2, false, 0);
        }
    }

    @Override
    public void addUniqueAttribute(String string, String string2, int n) throws SAXException {
        String string3 = this.patchName(string);
        String string4 = SerializerBase.getLocalName(string3);
        String string5 = this.getNamespaceURI(string3, false);
        this.m_attributes.addAttribute(string5, string4, string3, "CDATA", string2, n);
    }

    @Override
    public void addXSLAttribute(String string, String string2, String string3) {
        if (this.m_elemContext.m_startTagOpen) {
            String string4 = this.patchName(string);
            String string5 = SerializerBase.getLocalName(string4);
            this.addAttributeAlways(string3, string5, string4, "CDATA", string2, true, 0);
        }
    }

    @Override
    public void addAttributes(Attributes attributes) throws SAXException {
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String string = attributes.getURI(i);
            if (null == string) {
                string = "";
            }
            this.addAttributeAlways(string, attributes.getLocalName(i), attributes.getQName(i), attributes.getType(i), attributes.getValue(i), false, 0);
        }
    }

    @Override
    public ContentHandler asContentHandler() throws IOException {
        return this;
    }

    @Override
    public void endEntity(String string) throws SAXException {
        if (string.equals("[dtd]")) {
            this.m_inExternalDTD = false;
        }
        this.m_inEntityRef = false;
        if (this.m_tracer != null) {
            this.fireEndEntity(string);
        }
    }

    @Override
    public void close() {
    }

    protected void initCDATA() {
    }

    @Override
    public String getEncoding() {
        return this.getOutputProperty("encoding");
    }

    @Override
    public void setEncoding(String string) {
        this.setOutputProperty("encoding", string);
    }

    @Override
    public void setOmitXMLDeclaration(boolean bl) {
        String string = bl ? "yes" : "no";
        this.setOutputProperty("omit-xml-declaration", string);
    }

    @Override
    public boolean getOmitXMLDeclaration() {
        return this.m_shouldNotWriteXMLHeader;
    }

    @Override
    public String getDoctypePublic() {
        return this.m_doctypePublic;
    }

    @Override
    public void setDoctypePublic(String string) {
        this.setOutputProperty("doctype-public", string);
    }

    @Override
    public String getDoctypeSystem() {
        return this.m_doctypeSystem;
    }

    @Override
    public void setDoctypeSystem(String string) {
        this.setOutputProperty("doctype-system", string);
    }

    @Override
    public void setDoctype(String string, String string2) {
        this.setOutputProperty("doctype-system", string);
        this.setOutputProperty("doctype-public", string2);
    }

    @Override
    public void setStandalone(String string) {
        this.setOutputProperty("standalone", string);
    }

    protected void setStandaloneInternal(String string) {
        this.m_standalone = "yes".equals(string) ? "yes" : "no";
    }

    @Override
    public String getStandalone() {
        return this.m_standalone;
    }

    @Override
    public boolean getIndent() {
        return this.m_doIndent;
    }

    @Override
    public String getMediaType() {
        return this.m_mediatype;
    }

    @Override
    public String getVersion() {
        return this.m_version;
    }

    final boolean isXSLT10() {
        return true;
    }

    @Override
    public void setVersion(String string) {
        this.setOutputProperty("version", string);
    }

    @Override
    public void setMediaType(String string) {
        this.setOutputProperty("media-type", string);
    }

    @Override
    public int getIndentAmount() {
        return this.m_indentAmount;
    }

    @Override
    public void setIndentAmount(int n) {
        this.m_indentAmount = n;
    }

    @Override
    public void setIndent(boolean bl) {
        String string = bl ? "yes" : "no";
        this.setOutputProperty("indent", string);
    }

    @Override
    public void namespaceAfterStartElement(String string, String string2) throws SAXException {
    }

    @Override
    public DOMSerializer asDOMSerializer() throws IOException {
        return this;
    }

    protected static final String getPrefixPart(String string) {
        int n = string.indexOf(58);
        return n > 0 ? string.substring(0, n) : null;
    }

    @Override
    public NamespaceMappings getNamespaceMappings() {
        return this.m_prefixMap;
    }

    @Override
    public String getPrefix(String string) {
        String string2 = this.m_prefixMap.lookupPrefix(string);
        return string2;
    }

    @Override
    public String getNamespaceURI(String string, boolean bl) {
        String string2;
        String string3 = "";
        int n = string.lastIndexOf(58);
        String string4 = string2 = n > 0 ? string.substring(0, n) : "";
        if ((!"".equals(string2) || bl) && this.m_prefixMap != null && (string3 = this.m_prefixMap.lookupNamespace(string2)) == null) {
            string3 = "";
        }
        return string3;
    }

    @Override
    public String getNamespaceURIFromPrefix(String string) {
        String string2 = null;
        if (this.m_prefixMap != null) {
            string2 = this.m_prefixMap.lookupNamespace(string);
        }
        return string2;
    }

    @Override
    public void entityReference(String string) throws SAXException {
        this.flushInternal();
        this.startEntity(string);
        this.endEntity(string);
        if (this.m_tracer != null) {
            this.fireEntityReference(string);
        }
    }

    @Override
    public void setTransformer(Transformer transformer) {
        this.m_transformer = transformer;
        this.m_tracer = this.m_transformer instanceof SerializerTrace && ((SerializerTrace)((Object)this.m_transformer)).hasTraceListeners() ? (SerializerTrace)((Object)this.m_transformer) : null;
    }

    @Override
    public Transformer getTransformer() {
        return this.m_transformer;
    }

    final char[] getCharsBuff() {
        return this.m_charsBuff;
    }

    int getChars(String string, int n, int n2) {
        int n3;
        int n4 = n2 - n;
        if (n4 <= 0) {
            n3 = 0;
        } else {
            char[] cArray = this.m_charsBuff;
            int n5 = cArray.length;
            if (n4 <= n5) {
                int n6 = n4 - 1;
                string.getChars(n, n2, cArray, 0);
                char c = cArray[n6];
                n3 = Encodings.isHighUTF16Surrogate(c) ? n6 : n4;
            } else {
                if (n5 != 65536) {
                    n5 = n4 * 2 + 1;
                    if (n5 > 65536) {
                        n5 = 65536;
                    }
                    this.m_charsBuff = cArray = new char[n5];
                }
                boolean bl = false;
                if (n5 < n4) {
                    n4 = n5;
                    n2 = n + n4;
                    bl = true;
                }
                int n7 = n4 - 1;
                string.getChars(n, n2, cArray, 0);
                char c = cArray[n7];
                n3 = Encodings.isHighUTF16Surrogate(c) ? n7 : n4;
                if (bl) {
                    int n8;
                    int n9 = 0;
                    for (n8 = n3; n8 > 2 && cArray[n8 - 1] == ']' && n9 < 4; --n8, ++n9) {
                        if (!Encodings.isHighUTF16Surrogate(cArray[n8 - 2])) continue;
                        --n8;
                    }
                    if (n3 != n8 && cArray[n8 - 1] != ']') {
                        n3 = n8;
                    }
                }
            }
        }
        return n3;
    }

    @Override
    public void characters(Node node) throws SAXException {
        this.flushInternal();
        String string = node.getNodeValue();
        if (string != null) {
            this.characters(string);
        }
    }

    @Override
    public void characters(String string) throws SAXException {
        int n = string.length();
        if (n > 0) {
            int n2;
            this.m_docIsEmpty = false;
            this.flushInternal();
            for (int i = 0; i < n; i += n2) {
                n2 = this.getChars(string, i, n);
                char[] cArray = this.getCharsBuff();
                this.characters(cArray, 0, n2);
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2, int n3) throws SAXException {
        this.characters(cArray, n, n2);
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.m_elemContext.m_startTagOpen = false;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    protected void fireStartEntity(String string) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(9, string);
        }
    }

    private void flushMyWriter() {
        if (this.m_writer != null) {
            try {
                this.m_writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void fireCDATAEvent(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(10, cArray, n, n2);
        }
    }

    protected void fireCommentEvent(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(8, new String(cArray, n, n2));
        }
    }

    public void fireEndEntity(String string) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
        }
    }

    protected void fireStartDoc() throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(1);
        }
    }

    protected void fireEndDoc() throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(2);
        }
    }

    protected void fireStartElem(String string) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(3, string, this.m_attributes);
        }
    }

    protected void fireEscapingEvent(String string, String string2) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(7, string, string2);
        }
    }

    protected void fireEntityReference(String string) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(9, string, (Attributes)null);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.startDocumentInternal();
        this.m_needToCallStartDocument = false;
    }

    protected void startDocumentInternal() throws SAXException {
        if (this.m_tracer != null) {
            this.fireStartDoc();
        }
    }

    @Override
    public void setSourceLocator(SourceLocator sourceLocator) {
        this.m_sourceLocator = sourceLocator;
    }

    @Override
    public void setNamespaceMappings(NamespaceMappings namespaceMappings) {
        this.m_prefixMap = namespaceMappings;
    }

    final boolean inTemporaryOutputState() {
        return this.getEncoding() == null;
    }

    @Override
    public void addAttribute(String string, String string2, String string3, String string4, String string5) {
        if (this.m_elemContext.m_startTagOpen) {
            this.addAttributeAlways(string, string2, string3, string4, string5, false, 0);
        }
    }

    @Override
    public void notationDecl(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
    }

    @Override
    public void setDTDEntityExpansion(boolean bl) {
    }

    void initCdataElems(String string) {
        if (string != null) {
            int n = string.length();
            boolean bl = false;
            boolean bl2 = false;
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = null;
            String string3 = null;
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (Character.isWhitespace(c)) {
                    if (!bl) {
                        if (stringBuffer.length() <= 0) continue;
                        string3 = stringBuffer.toString();
                        if (!bl2) {
                            string2 = "";
                        }
                        this.addCDATAElement(string2, string3);
                        stringBuffer.setLength(0);
                        bl2 = false;
                        continue;
                    }
                    stringBuffer.append(c);
                    continue;
                }
                if ('{' == c) {
                    bl = true;
                    continue;
                }
                if ('}' == c) {
                    bl2 = true;
                    string2 = stringBuffer.toString();
                    stringBuffer.setLength(0);
                    bl = false;
                    continue;
                }
                stringBuffer.append(c);
            }
            if (stringBuffer.length() > 0) {
                string3 = stringBuffer.toString();
                if (!bl2) {
                    string2 = "";
                }
                this.addCDATAElement(string2, string3);
            }
        }
    }

    private void addCDATAElement(String string, String string2) {
        Hashtable<String, String> hashtable;
        if (this.m_CdataElems == null) {
            this.m_CdataElems = new Hashtable();
        }
        if ((hashtable = (Hashtable<String, String>)this.m_CdataElems.get(string2)) == null) {
            hashtable = new Hashtable<String, String>();
            this.m_CdataElems.put(string2, hashtable);
        }
        hashtable.put(string, string);
    }

    @Override
    public boolean documentIsEmpty() {
        return this.m_docIsEmpty && this.m_elemContext.m_currentElemDepth == 0;
    }

    protected boolean isCdataSection() {
        boolean bl = false;
        if (null != this.m_StringOfCDATASections) {
            Object v;
            Object object;
            if (this.m_elemContext.m_elementLocalName == null) {
                object = SerializerBase.getLocalName(this.m_elemContext.m_elementName);
                this.m_elemContext.m_elementLocalName = object;
            }
            if (this.m_elemContext.m_elementURI == null) {
                this.m_elemContext.m_elementURI = this.getElementURI();
            } else if (this.m_elemContext.m_elementURI.length() == 0) {
                if (this.m_elemContext.m_elementName == null) {
                    this.m_elemContext.m_elementName = this.m_elemContext.m_elementLocalName;
                } else if (this.m_elemContext.m_elementLocalName.length() < this.m_elemContext.m_elementName.length()) {
                    this.m_elemContext.m_elementURI = this.getElementURI();
                }
            }
            object = (Hashtable)this.m_CdataElems.get(this.m_elemContext.m_elementLocalName);
            if (object != null && (v = ((Hashtable)object).get(this.m_elemContext.m_elementURI)) != null) {
                bl = true;
            }
        }
        return bl;
    }

    String getElementURI() {
        String string = null;
        String string2 = SerializerBase.getPrefixPart(this.m_elemContext.m_elementName);
        string = string2 == null ? this.m_prefixMap.lookupNamespace("") : this.m_prefixMap.lookupNamespace(string2);
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public String getOutputProperty(String string) {
        String string2 = this.getOutputPropertyNonDefault(string);
        if (string2 == null) {
            string2 = this.getOutputPropertyDefault(string);
        }
        return string2;
    }

    public String getOutputPropertyNonDefault(String string) {
        return this.getProp(string, false);
    }

    @Override
    public Object asDOM3Serializer() throws IOException {
        return new DOM3SerializerImpl(this);
    }

    @Override
    public String getOutputPropertyDefault(String string) {
        return this.getProp(string, true);
    }

    @Override
    public void setOutputProperty(String string, String string2) {
        this.setProp(string, string2, false);
    }

    @Override
    public void setOutputPropertyDefault(String string, String string2) {
        this.setProp(string, string2, true);
    }

    Set getOutputPropDefaultKeys() {
        return this.m_OutputPropsDefault.keySet();
    }

    Set getOutputPropKeys() {
        return this.m_OutputProps.keySet();
    }

    private String getProp(String string, boolean bl) {
        if (this.m_OutputProps == null) {
            this.m_OutputProps = new HashMap();
        }
        if (this.m_OutputPropsDefault == null) {
            this.m_OutputPropsDefault = new HashMap();
        }
        String string2 = bl ? (String)this.m_OutputPropsDefault.get(string) : (String)this.m_OutputProps.get(string);
        return string2;
    }

    void setProp(String string, String string2, boolean bl) {
        if (this.m_OutputProps == null) {
            this.m_OutputProps = new HashMap();
        }
        if (this.m_OutputPropsDefault == null) {
            this.m_OutputPropsDefault = new HashMap();
        }
        if (bl) {
            this.m_OutputPropsDefault.put(string, string2);
        } else if ("cdata-section-elements".equals(string) && string2 != null) {
            this.initCdataElems(string2);
            String string3 = (String)this.m_OutputProps.get(string);
            String string4 = string3 == null ? string3 + ' ' + string2 : string2;
            this.m_OutputProps.put(string, string4);
        } else {
            this.m_OutputProps.put(string, string2);
        }
    }

    static String getLocalNameFromExpanded(String string) {
        int n = string.indexOf(125);
        String string2 = n < 0 ? string : string.substring(n + 1);
        return string2;
    }

    void flushInternal() throws SAXException {
    }

    @Override
    public void startAttribute(String string) {
        this.m_attr_qName = string;
    }

    @Override
    public void startAttribute(String string, String string2) {
        this.m_attr_qName = string.length() > 0 ? string + ':' + string2 : string2;
    }

    @Override
    public void addAttributeContent(String string, int n) {
        if (this.m_attr_appended) {
            if (this.m_attr_content_s != null) {
                this.m_attr_content_sb.append(this.m_attr_content_s);
                this.m_attr_content_s = null;
            }
            this.m_attr_content_sb.append(string);
        } else {
            this.m_attr_content_s = string;
            this.m_attr_appended = true;
        }
        this.m_attr_content_flags &= n;
    }

    @Override
    public void endAttribute() {
        String string;
        if (this.m_attr_content_s != null) {
            string = this.m_attr_content_s;
        } else {
            string = this.m_attr_content_sb.toString();
            this.m_attr_content_sb.setLength(0);
        }
        this.m_attr_appended = false;
        String string2 = this.m_attr_qName;
        int n = this.m_attr_content_flags;
        if (this.m_elemContext.m_startTagOpen) {
            this.endAttribute(string2, string, n);
        }
        this.m_attr_content_flags = 65535;
    }

    @Override
    public void undeclareAllPrefixMappings() {
    }

    @Override
    public void setURI(String string) {
        this.m_resultDocAbsoluteURI = string;
    }

    @Override
    public String getURI() {
        return this.m_resultDocAbsoluteURI;
    }

    private void endAttribute(String string, String string2, int n) {
        int n2;
        String string3;
        String string4;
        int n3 = string.indexOf(58);
        if (n3 > 0) {
            String string5 = string.substring(0, n3);
            string4 = string.substring(n3 + 1);
            string3 = this.m_prefixMap.lookupNamespace(string5);
            if (string3 == null) {
                string3 = "";
                n2 = this.m_attributes.getIndex(string4);
                string = string4;
            } else if (string3.length() == 0) {
                n2 = this.m_attributes.getIndex(string4);
                string = string4;
            } else {
                n2 = this.m_attributes.getIndex(string3, string4);
            }
        } else {
            string4 = string;
            string3 = "";
            n2 = this.m_attributes.getIndex(string4);
        }
        if (n2 >= 0) {
            this.m_attributes.setValue(n2, string2);
        } else {
            this.m_attributes.addAttribute(string3, string4, string, "CDATA", string2, n);
        }
    }

    static {
        Object object = SerializerBase.class.getName();
        int n = ((String)object).lastIndexOf(46);
        PKG_NAME = n < 0 ? "" : ((String)object).substring(0, n);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < PKG_NAME.length(); ++i) {
            char c = PKG_NAME.charAt(i);
            if (c == '.') {
                stringBuffer.append('/');
                continue;
            }
            stringBuffer.append(c);
        }
        PKG_PATH = stringBuffer.toString();
        object = SecuritySupport.getInstance();
        s_systemLineSep = ((SecuritySupport)object).getSystemProperty("line.separator").toCharArray();
    }
}

