/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.translator.v1;

import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.FunctionCall;
import com.ibm.xtq.ast.nodes.Literal;
import com.ibm.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xtq.common.utils.Assert;
import com.ibm.xtq.common.utils.SecurityUtil;
import com.ibm.xtq.xslt.drivers.XPathCompiler;
import com.ibm.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xtq.xslt.res.ErrorMsg;
import com.ibm.xtq.xslt.runtime.BasisLibrary;
import com.ibm.xtq.xslt.runtime.RuntimeLibrary;
import com.ibm.xtq.xslt.runtime.extensions.JavaExtensionUtils;
import com.ibm.xtq.xslt.runtime.extensions.XSLTObjectType;
import com.ibm.xtq.xslt.runtime.res.RuntimeMsg;
import com.ibm.xtq.xslt.translator.ASTDecorator;
import com.ibm.xtq.xslt.translator.ASTDecorator1;
import com.ibm.xtq.xslt.translator.FunctionOperatorHelper;
import com.ibm.xtq.xslt.translator.StaticError;
import com.ibm.xtq.xslt.translator.TranslatorUtilities;
import com.ibm.xtq.xslt.translator.XSLTCHelper;
import com.ibm.xtq.xslt.translator.v1.XPathTranslator;
import com.ibm.xtq.xslt.translator.v1.XSLTTranslator;
import com.ibm.xtq.xslt.typechecker.v1.types.Type;
import com.ibm.xtq.xslt.xylem.instructions.CeilingInstruction;
import com.ibm.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xtq.xslt.xylem.instructions.ContainsInstruction;
import com.ibm.xtq.xslt.xylem.instructions.CountInstruction;
import com.ibm.xtq.xslt.xylem.instructions.Document2Instruction;
import com.ibm.xtq.xslt.xylem.instructions.DocumentInstruction;
import com.ibm.xtq.xslt.xylem.instructions.EmptyCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.EqualityInstruction;
import com.ibm.xtq.xslt.xylem.instructions.FloorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GenerateIDInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetNodeNameInstruction;
import com.ibm.xtq.xslt.xylem.instructions.IDInstruction;
import com.ibm.xtq.xslt.xylem.instructions.LangInstruction;
import com.ibm.xtq.xslt.xylem.instructions.LocalNameInstruction;
import com.ibm.xtq.xslt.xylem.instructions.NamespaceURIInstruction;
import com.ibm.xtq.xslt.xylem.instructions.NodeStreamCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.NodesetContainsNodeInstruction;
import com.ibm.xtq.xslt.xylem.instructions.NormalizeSpaceInstruction;
import com.ibm.xtq.xslt.xylem.instructions.QNameLocalNameInstruction;
import com.ibm.xtq.xslt.xylem.instructions.QNameNamespaceURIInstruction;
import com.ibm.xtq.xslt.xylem.instructions.StartsWithInstruction;
import com.ibm.xtq.xslt.xylem.instructions.SumInstruction;
import com.ibm.xtq.xslt.xylem.instructions.TerminateInstruction;
import com.ibm.xtq.xslt.xylem.instructions.TranslateStreamInstruction;
import com.ibm.xtq.xslt.xylem.instructions.UnionCursorInstruction;
import com.ibm.xtq.xslt.xylem.instructions.UnparsedEntityUriInstruction;
import com.ibm.xtq.xslt.xylem.instructions.XDMManagerFactoryInstruction;
import com.ibm.xtq.xslt.xylem.types.CursorType;
import com.ibm.xtq.xslt.xylem.types.SAXEventsLibrary;
import com.ibm.xylem.Binding;
import com.ibm.xylem.Function;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Module;
import com.ibm.xylem.builders.LetChainBuilder;
import com.ibm.xylem.instructions.BeginInstruction;
import com.ibm.xylem.instructions.CharStreamToJavaStringInstruction;
import com.ibm.xylem.instructions.ChooseInstruction;
import com.ibm.xylem.instructions.ForEachInstruction;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.JavaDowncastInstruction;
import com.ibm.xylem.instructions.JavaMethodInvocationInstruction;
import com.ibm.xylem.instructions.LambdaInstruction;
import com.ibm.xylem.instructions.LengthInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.LocalizeMessageInstruction;
import com.ibm.xylem.instructions.ModuleFunctionCallInstruction;
import com.ibm.xylem.instructions.NaNInstruction;
import com.ibm.xylem.instructions.NewJavaObjectInstruction;
import com.ibm.xylem.instructions.NotInstruction;
import com.ibm.xylem.instructions.OnceInstruction;
import com.ibm.xylem.instructions.PrimitiveEqualityInstruction;
import com.ibm.xylem.instructions.RoundInstruction;
import com.ibm.xylem.instructions.StaticMethodInvocationInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.instructions.SubstreamAfterInstruction;
import com.ibm.xylem.instructions.SubstreamBeforeInstruction;
import com.ibm.xylem.instructions.TestStreamInstruction;
import com.ibm.xylem.instructions.TryCatchInstruction;
import com.ibm.xylem.instructions.TupleInstruction;
import com.ibm.xylem.instructions.TupleMatchInstruction;
import com.ibm.xylem.instructions.TypeMatchInstruction;
import com.ibm.xylem.optimizers.OptimizerUtilities;
import com.ibm.xylem.types.BooleanType;
import com.ibm.xylem.types.ByteType;
import com.ibm.xylem.types.CharType;
import com.ibm.xylem.types.DoubleType;
import com.ibm.xylem.types.FloatType;
import com.ibm.xylem.types.IntType;
import com.ibm.xylem.types.JavaObjectType;
import com.ibm.xylem.types.LongType;
import com.ibm.xylem.types.NamedType;
import com.ibm.xylem.types.ShortType;
import com.ibm.xylem.types.StreamType;
import com.ibm.xylem.types.TupleType;
import com.ibm.xylem.types.UnitType;
import com.ibm.xylem.utils.SourceLocation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunction;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class FunctionTranslator {
    protected static final String EXT_XSLTC = "http://xml.apache.org/xalan/xsltc";
    protected XPathTranslator m_xpathTranslator;
    protected Module m_module;
    protected XPathCompiler m_compiler;
    private boolean builtInstrTable = true;
    private static final com.ibm.xylem.Type s_javaObjectType = new JavaObjectType("java.lang.Object");
    private static final com.ibm.xylem.Type s_hashmapType = new JavaObjectType("java.util.HashMap");
    private static final com.ibm.xylem.Type s_booleanType = new JavaObjectType("java.lang.Boolean");
    private static final String s_getBuiltInstrTableFunction = "get-build-instructions-table";
    public static final String XSLT_URI = "http://www.w3.org/1999/XSL/Transform";
    public static final String XSL = "xsl";
    public static final String REDIRECT_URI = "http://xml.apache.org/xalan/redirect";
    public static final String REDIRECT_PREFIX = "redirect";
    public static final String REDIRECT_OUTPUT_PREFIX = "xsltc";
    private static final String[] xsltInstructions = new String[]{"apply-templates", "call-template", "apply-imports", "for-each", "value-of", "copy-of", "number", "choose", "if", "text", "copy", "variable", "message", "fallback", "processing-instruction", "comment", "element", "attribute"};
    private boolean buildFuncTable = true;
    private static final String s_getFuncTableFunction = "get-build-functions-table";
    private static final String[] STANDARD_SYS_PROPS = new String[]{"version", "vendor", "vendor-url"};
    private static final String[] STANDARD_SYS_PROP_VALUES = new String[]{"1.0", "IBM Corporation", "http://www.ibm.com/"};
    private static HashMap javaTypeMap = new HashMap();

    public FunctionTranslator(Module module, XPathTranslator xPathTranslator, XPathCompiler xPathCompiler) {
        this.m_module = module;
        this.m_xpathTranslator = xPathTranslator;
        this.m_compiler = xPathCompiler;
    }

    public Module getModule() {
        return this.m_module;
    }

    public XPathCompiler getCompiler() {
        return this.m_compiler;
    }

    public XSLTParser getParser() {
        return this.m_compiler.getParser();
    }

    public void visitFunction(FunctionCall functionCall) {
        throw new UnsupportedOperationException();
    }

    private Instruction visitXPath(Expr expr, String string) {
        return this.m_xpathTranslator.visitRawExpression(expr, string, new IdentifierInstruction("__context__"));
    }

    protected Instruction visitRawFunction(FunctionCall functionCall, String string) {
        QName qName = functionCall.getFunctionQName();
        String string2 = qName.getLocalPart();
        String string3 = qName.getNamespaceURI();
        if (FunctionOperatorHelper.isNodesetExtensionCall(string3, string2)) {
            return this.nodesetCall(functionCall, string);
        }
        if (this.isJAXPFunctionCall(functionCall)) {
            return this.jaxpFunctionCall(functionCall, string);
        }
        if (FunctionOperatorHelper.isStandardFunctionNamespace(string3)) {
            if (string2.equals("boolean")) {
                return this.booleanCall(functionCall, string);
            }
            if (string2.equals("ceiling")) {
                return this.ceilingCall(functionCall, string);
            }
            if (string2.equals("compare")) {
                throw new UnsupportedOperationException();
            }
            if (string2.equals("concat")) {
                return this.concatCall(functionCall, string);
            }
            if (string2.equals("contains")) {
                return this.containsCall(functionCall, string);
            }
            if (string2.equals("count")) {
                return new CountInstruction(new CoerceInstruction(this.visitXPath(functionCall.getOperand(0), string), CursorType.s_cursorType));
            }
            if (string2.equals("current")) {
                return this.currentCall(functionCall);
            }
            if (string2.equals("document")) {
                return this.documentCall(functionCall, string);
            }
            if (string2.equals("element-available")) {
                return this.elementAvailableCall(functionCall, string);
            }
            if (string2.equals("false")) {
                return this.falseCall(functionCall);
            }
            if (string2.equals("floor")) {
                return this.floorCall(functionCall, string);
            }
            if (string2.equals("format-number")) {
                return this.formatNumberCall(functionCall, string);
            }
            if (string2.equals("function-available")) {
                return this.functionAvailableCall(functionCall, string);
            }
            if (string2.equals("generate-id")) {
                return this.generateIdCall(functionCall, string);
            }
            if (string2.equals("id")) {
                return this.idCall(functionCall, string);
            }
            if (string2.equals("key")) {
                return this.keyCall(functionCall, string, this.getModule().getName());
            }
            if (string2.equals("lang")) {
                return this.langCall(functionCall, string);
            }
            if (string2.equals("last")) {
                return this.lastCall(functionCall);
            }
            if (string2.equals("local-name")) {
                return this.localNameCall(functionCall, string);
            }
            if (string2.equals("name")) {
                return this.nameCall(functionCall, string);
            }
            if (string2.equals("namespace-uri")) {
                return this.namespaceUriCall(functionCall, string);
            }
            if (string2.equals("normalize-space")) {
                return this.normalizeSpaceCall(functionCall, string);
            }
            if (string2.equals("not")) {
                return this.notCall(functionCall, string);
            }
            if (string2.equals("number")) {
                return this.numberCall(functionCall, string);
            }
            if (string2.equals("position")) {
                return this.positionCall(functionCall);
            }
            if (string2.equals("round")) {
                return this.roundCall(functionCall, string);
            }
            if (string2.equals("sql")) {
                return this.sqlCall(functionCall, string);
            }
            if (string2.equals("starts-with")) {
                return this.startsWithCall(functionCall, string);
            }
            if (string2.equals("string")) {
                return this.stringCall(functionCall, string);
            }
            if (string2.equals("string-length")) {
                return this.stringLengthCall(functionCall, string);
            }
            if (string2.equals("substring")) {
                return this.substringCall(functionCall, string);
            }
            if (string2.equals("substring-after")) {
                return this.substringAfterCall(functionCall, string);
            }
            if (string2.equals("substring-before")) {
                return this.substringBeforeCall(functionCall, string);
            }
            if (string2.equals("sum")) {
                return new SumInstruction(new CoerceInstruction(this.visitXPath(functionCall.getOperand(0), string), CursorType.s_cursorType));
            }
            if (string2.equals("system-property")) {
                return this.systemPropertyCall(functionCall, string);
            }
            if (string2.equals("translate")) {
                return new TranslateStreamInstruction(this.coerceToString(functionCall.getOperand(0), string), this.coerceToString(functionCall.getOperand(1), string), this.coerceToString(functionCall.getOperand(2), string));
            }
            if (string2.equals("true")) {
                return this.trueCall(functionCall);
            }
            if (string2.equals("unparsed-entity-uri")) {
                return this.unparsedEntityUriCall(functionCall, string);
            }
        } else if (FunctionOperatorHelper.isExtensionNamespace(string3)) {
            return this.extensionFunctionCall(functionCall, string);
        }
        throw new StaticError("ERR_UNSUPPORTED_FUNC", qName);
    }

    protected Instruction booleanCall(FunctionCall functionCall, String string) {
        Expr expr = functionCall.getOperand(0);
        Instruction instruction = this.visitXPath(expr, string);
        return new CoerceInstruction(instruction, BooleanType.s_booleanType);
    }

    protected Instruction ceilingCall(FunctionCall functionCall, String string) {
        return new CeilingInstruction(this.visitXPath(functionCall.getOperand(0), string));
    }

    protected Instruction coerceToString(Expr expr, String string) {
        return new CoerceInstruction(this.visitXPath(expr, string), CharType.s_charType.getStreamType());
    }

    protected Instruction containsCall(FunctionCall functionCall, String string) {
        Expr expr = functionCall.getOperand(0);
        Expr expr2 = functionCall.getOperand(1);
        return new ContainsInstruction(this.coerceToString(expr, string), this.coerceToString(expr2, string));
    }

    protected Instruction startsWithCall(FunctionCall functionCall, String string) {
        Expr expr = functionCall.getOperand(0);
        Expr expr2 = functionCall.getOperand(1);
        return new StartsWithInstruction(this.coerceToString(expr, string), this.coerceToString(expr2, string));
    }

    protected Instruction substringBeforeCall(FunctionCall functionCall, String string) {
        Expr expr = functionCall.getOperand(0);
        Expr expr2 = functionCall.getOperand(1);
        return new SubstreamBeforeInstruction(this.coerceToString(expr, string), this.coerceToString(expr2, string));
    }

    protected Instruction substringAfterCall(FunctionCall functionCall, String string) {
        Expr expr = functionCall.getOperand(0);
        Expr expr2 = functionCall.getOperand(1);
        return new SubstreamAfterInstruction(this.coerceToString(expr, string), this.coerceToString(expr2, string));
    }

    protected Instruction concatCall(FunctionCall functionCall, String string) {
        int n = functionCall.getOperandCount();
        Instruction[] instructionArray = new Instruction[n];
        for (int i = 0; i < n; ++i) {
            instructionArray[i] = TranslatorUtilities.coerceToString(this.visitXPath(functionCall.getOperand(i), string));
        }
        return new StreamInstruction((com.ibm.xylem.Type)CharType.s_charType, instructionArray);
    }

    protected Instruction documentCall(FunctionCall functionCall, String string) {
        Instruction instruction;
        Object object;
        int n = functionCall.getOperandCount();
        Expr expr = functionCall.getOperand(0);
        if (n == 2) {
            object = functionCall.getOperand(1);
            Instruction instruction2 = this.m_xpathTranslator.visitRawExpression((Expr)object, string, new IdentifierInstruction("__context__"));
            instruction = new Document2Instruction(new IdentifierInstruction("value"), instruction2, XSLTCHelper.getStylesheet(functionCall).getSystemId());
        } else {
            instruction = new DocumentInstruction(new IdentifierInstruction("value"), XSLTCHelper.getStylesheet(functionCall).getSystemId());
        }
        object = this.getCompiler().createSourceLocation(functionCall);
        instruction.setSourceLocation((SourceLocation)object);
        instruction = this.nodeSetOrCharStreamArg(expr, instruction, "value", string);
        return instruction;
    }

    protected Instruction nodeSetOrCharStreamArg(Expr expr, Instruction instruction, String string, String string2) {
        Instruction instruction2 = this.m_xpathTranslator.visitRawExpression(expr, string2, new IdentifierInstruction("__context__"));
        StreamType streamType = CharType.s_charType.getStreamType();
        LambdaInstruction lambdaInstruction = new LambdaInstruction(instruction, new Binding[]{new Binding((Object)string, streamType)}, true);
        LambdaInstruction lambdaInstruction2 = new LambdaInstruction(instruction.cloneWithoutTypeInformation(), new Binding[]{new Binding((Object)string, CursorType.s_cursorType)}, true);
        TypeMatchInstruction.Match match = new TypeMatchInstruction.Match(new NamedType("parameterType"), string, new ModuleFunctionCallInstruction("xslt1", "apply-paramType-as-chars-or-node-set", new Instruction[]{new IdentifierInstruction("charStreamLambda"), new IdentifierInstruction("nodeSetLambda"), new IdentifierInstruction(string)}));
        TypeMatchInstruction.Match match2 = new TypeMatchInstruction.Match(XSLTObjectType.s_xsltObjectType, string, new ModuleFunctionCallInstruction("xslt1", "apply-xsltObj-as-chars-or-node-set", new Instruction[]{new IdentifierInstruction("charStreamLambda"), new IdentifierInstruction("nodeSetLambda"), new IdentifierInstruction(string)}));
        TypeMatchInstruction.Match match3 = new TypeMatchInstruction.Match(CursorType.s_cursorType, string, instruction.cloneWithoutTypeInformation());
        LetInstruction letInstruction = new LetInstruction(string, new CoerceInstruction(new IdentifierInstruction(string), streamType), instruction.cloneWithoutTypeInformation());
        TypeMatchInstruction typeMatchInstruction = new TypeMatchInstruction(new IdentifierInstruction(string), new TypeMatchInstruction.Match[]{match, match2, match3}, letInstruction);
        return new LetInstruction("charStreamLambda", lambdaInstruction, new LetInstruction("nodeSetLambda", lambdaInstruction2, new LetInstruction(string, instruction2, typeMatchInstruction)));
    }

    protected Instruction currentCall(FunctionCall functionCall) {
        return new IdentifierInstruction("__current__");
    }

    protected Instruction elementAvailableCall(FunctionCall functionCall, String string) {
        Expr expr = functionCall.getOperand(0);
        if (expr instanceof Literal) {
            boolean bl = XSLTCHelper.evaluateElementAvailableAtCompileTime(functionCall, this.getCompiler());
            return bl ? LiteralInstruction.booleanTrueLiteral() : LiteralInstruction.booleanFalseLiteral();
        }
        if (this.builtInstrTable) {
            this.getModule().addFunction(this.builtInstrTableFunction(this.getCompiler()), false);
            this.builtInstrTable = false;
        }
        String string2 = "__value__";
        LetChainBuilder letChainBuilder = new LetChainBuilder();
        StreamInstruction streamInstruction = new StreamInstruction((com.ibm.xylem.Type)CharType.s_charType, new CoerceInstruction(this.visitXPath(expr, string), CharType.s_charType.getStreamType()));
        Instruction instruction = this.compileExtractLocalName(new IdentifierInstruction(string2));
        LiteralInstruction literalInstruction = LiteralInstruction.booleanFalseLiteral();
        LiteralInstruction literalInstruction2 = LiteralInstruction.booleanTrueLiteral();
        Instruction instruction2 = this.m_xpathTranslator.getNamespaceHelper().getNamespaceTable(expr);
        ModuleFunctionCallInstruction moduleFunctionCallInstruction = new ModuleFunctionCallInstruction("xslt1", "getInScopeNamespaceURI", new Instruction[]{new IdentifierInstruction(string2), literalInstruction, literalInstruction2, instruction2});
        letChainBuilder.bind(string2, streamInstruction);
        StaticMethodInvocationInstruction staticMethodInvocationInstruction = new StaticMethodInvocationInstruction(BasisLibrary.class.getName(), "elementAvailableF", new Instruction[]{moduleFunctionCallInstruction, instruction, new FunctionCallInstruction(s_getBuiltInstrTableFunction, new Instruction[0])}, BooleanType.s_booleanType);
        return letChainBuilder.packageUp(staticMethodInvocationInstruction);
    }

    private Function builtInstrTableFunction(XPathCompiler xPathCompiler) {
        Instruction[] instructionArray;
        Object object;
        LetChainBuilder letChainBuilder = new LetChainBuilder();
        Instruction instruction = letChainBuilder.bind(new OnceInstruction(new NewJavaObjectInstruction(new Instruction[0], s_hashmapType)));
        ArrayList<Instruction> arrayList = new ArrayList<Instruction>();
        XSLTParser xSLTParser = xPathCompiler.getParser();
        Iterator iterator = xSLTParser.getInstructionItr();
        QName qName = null;
        String string = null;
        String string2 = null;
        for (int i = 0; i < xsltInstructions.length; ++i) {
            string2 = xsltInstructions[i];
            object = letChainBuilder.bind(StreamInstruction.charStreamLiteral("{http://www.w3.org/1999/XSL/Transform}" + string2));
            instructionArray = letChainBuilder.bind(new NewJavaObjectInstruction(new Instruction[]{LiteralInstruction.booleanTrueLiteral()}, s_booleanType));
            Instruction[] instructionArray2 = new Instruction[]{letChainBuilder.bind(new CharStreamToJavaStringInstruction((Instruction)object)), instructionArray};
            arrayList.add(new JavaMethodInvocationInstruction("put", instruction.cloneWithoutTypeInformation(), instructionArray2, s_javaObjectType));
        }
        while (iterator.hasNext()) {
            qName = (QName)iterator.next();
            string = qName.getNamespaceURI();
            if (string.equals(XSLT_URI)) continue;
            string2 = qName.getLocalPart();
            Instruction instruction2 = letChainBuilder.bind(StreamInstruction.charStreamLiteral("{" + string + "}" + string2));
            object = letChainBuilder.bind(new NewJavaObjectInstruction(new Instruction[]{LiteralInstruction.booleanTrueLiteral()}, s_booleanType));
            instructionArray = new Instruction[]{letChainBuilder.bind(new CharStreamToJavaStringInstruction(instruction2)), object};
            arrayList.add(new JavaMethodInvocationInstruction("put", instruction.cloneWithoutTypeInformation(), instructionArray, s_javaObjectType));
        }
        arrayList.add(instruction);
        Instruction instruction3 = letChainBuilder.packageUp(new BeginInstruction(arrayList));
        object = new Function(s_getBuiltInstrTableFunction, new Binding[0], instruction3);
        ((Function)object).setMemoizeResult(true);
        return object;
    }

    protected Instruction compileExtractLocalName(Instruction instruction) {
        return new ChooseInstruction(new ContainsInstruction(instruction.cloneWithoutTypeInformation(), StreamInstruction.charStreamLiteral(":")), (Instruction)new SubstreamAfterInstruction(instruction.cloneWithoutTypeInformation(), StreamInstruction.charStreamLiteral(":")), instruction.cloneWithoutTypeInformation());
    }

    protected Instruction floorCall(FunctionCall functionCall, String string) {
        return new FloorInstruction(this.visitXPath(functionCall.getOperand(0), string));
    }

    protected Instruction formatNumberCall(FunctionCall functionCall, String string) {
        Instruction instruction;
        int n = functionCall.getOperandCount();
        if (n != 2 && n != 3) {
            throw new StaticError("ERR_ARG_FORMAT_NUMBER");
        }
        Instruction instruction2 = this.visitXPath(functionCall.getOperand(0), string);
        Instruction instruction3 = this.visitXPath(functionCall.getOperand(1), string);
        if (n == 3) {
            Expr expr = functionCall.getOperand(2);
            QName qName = ASTDecorator.getResolvedQNameArgument(expr);
            if (qName == null) {
                String string2 = "__qnamevar__";
                Instruction instruction4 = this.visitXPath(expr, string);
                instruction4 = new CoerceInstruction(instruction4, CharType.s_charType.getStreamType());
                LiteralInstruction literalInstruction = LiteralInstruction.booleanFalseLiteral();
                LiteralInstruction literalInstruction2 = LiteralInstruction.booleanFalseLiteral();
                Instruction instruction5 = this.m_xpathTranslator.getNamespaceHelper().getNamespaceTable(functionCall);
                ModuleFunctionCallInstruction moduleFunctionCallInstruction = new ModuleFunctionCallInstruction("xslt1", "validate-lexical-qname", new Instruction[]{instruction4, literalInstruction, literalInstruction2, instruction5});
                instruction = new FunctionCallInstruction("$xsltc-decimal-format$get-for", new Instruction[]{new QNameNamespaceURIInstruction(new IdentifierInstruction(string2)), new QNameLocalNameInstruction(new IdentifierInstruction(string2))});
                instruction = new LetInstruction(string2, moduleFunctionCallInstruction, instruction);
            } else {
                StreamInstruction streamInstruction = StreamInstruction.charStreamLiteral(qName.getNamespaceURI() == null ? "" : qName.getNamespaceURI());
                StreamInstruction streamInstruction2 = StreamInstruction.charStreamLiteral(qName.getLocalPart());
                instruction = new FunctionCallInstruction("$xsltc-decimal-format$get-for", new Instruction[]{streamInstruction, streamInstruction2});
            }
        } else {
            instruction = new FunctionCallInstruction("$xsltc-decimal-format$get-default", new Instruction[0]);
        }
        return new FunctionCallInstruction("format-number", new Instruction[]{new CoerceInstruction(instruction2, DoubleType.s_doubleType), instruction3, instruction});
    }

    protected Instruction functionAvailableCall(FunctionCall functionCall, String string) {
        Expr expr = functionCall.getOperand(0);
        if (expr instanceof Literal) {
            boolean bl = ASTDecorator.isFunctionAvailable(functionCall);
            return bl ? LiteralInstruction.booleanTrueLiteral() : LiteralInstruction.booleanFalseLiteral();
        }
        if (this.buildFuncTable) {
            this.getModule().addFunction(this.buildFuncTableFunction(this.getCompiler()), false);
            this.buildFuncTable = false;
        }
        String string2 = "__value__";
        LetChainBuilder letChainBuilder = new LetChainBuilder();
        StreamInstruction streamInstruction = new StreamInstruction((com.ibm.xylem.Type)CharType.s_charType, new CoerceInstruction(this.visitXPath(expr, string), CharType.s_charType.getStreamType()));
        Instruction instruction = this.compileExtractLocalName(new IdentifierInstruction(string2));
        LiteralInstruction literalInstruction = LiteralInstruction.booleanFalseLiteral();
        LiteralInstruction literalInstruction2 = LiteralInstruction.booleanFalseLiteral();
        Instruction instruction2 = this.m_xpathTranslator.getNamespaceHelper().getNamespaceTable(expr);
        ModuleFunctionCallInstruction moduleFunctionCallInstruction = new ModuleFunctionCallInstruction("xslt1", "getInScopeNamespaceURI", new Instruction[]{new IdentifierInstruction(string2), literalInstruction, literalInstruction2, instruction2});
        letChainBuilder.bind(string2, streamInstruction);
        StaticMethodInvocationInstruction staticMethodInvocationInstruction = new StaticMethodInvocationInstruction(BasisLibrary.class.getName(), "functionAvailableF", new Instruction[]{moduleFunctionCallInstruction, instruction, new FunctionCallInstruction(s_getFuncTableFunction, new Instruction[0])}, BooleanType.s_booleanType);
        return letChainBuilder.packageUp(staticMethodInvocationInstruction);
    }

    private Function buildFuncTableFunction(XPathCompiler xPathCompiler) {
        Object object;
        Instruction instruction;
        LetChainBuilder letChainBuilder = new LetChainBuilder();
        Instruction instruction2 = letChainBuilder.bind(new OnceInstruction(new NewJavaObjectInstruction(new Instruction[0], s_hashmapType)));
        ArrayList<Instruction> arrayList = new ArrayList<Instruction>();
        Iterator iterator = xPathCompiler.getFOHelper().getFunctionItr();
        while (iterator.hasNext()) {
            instruction = letChainBuilder.bind(StreamInstruction.charStreamLiteral((String)iterator.next()));
            object = letChainBuilder.bind(new NewJavaObjectInstruction(new Instruction[]{LiteralInstruction.booleanTrueLiteral()}, s_booleanType));
            Instruction[] instructionArray = new Instruction[]{letChainBuilder.bind(new CharStreamToJavaStringInstruction(instruction)), object};
            arrayList.add(new JavaMethodInvocationInstruction("put", instruction2.cloneWithoutTypeInformation(), instructionArray, s_javaObjectType));
        }
        arrayList.add(instruction2);
        instruction = letChainBuilder.packageUp(new BeginInstruction(arrayList));
        object = new Function(s_getFuncTableFunction, new Binding[0], instruction);
        ((Function)object).setMemoizeResult(true);
        return object;
    }

    protected Instruction generateIdCall(FunctionCall functionCall, String string) {
        if (functionCall.getOperandCount() == 0) {
            return new GenerateIDInstruction(new IdentifierInstruction("__context__"));
        }
        return new GenerateIDInstruction(new CoerceInstruction(this.visitXPath(functionCall.getOperand(0), string), CursorType.s_cursorType));
    }

    protected Instruction idCall(FunctionCall functionCall, String string) {
        return new IDInstruction(this.visitXPath(functionCall.getOperand(0), string));
    }

    protected Instruction keyCall(FunctionCall functionCall, String string, String string2) {
        return this.translateKey(functionCall, string, string2);
    }

    protected Instruction translateKey(FunctionCall functionCall, String string, String string2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Expr expr;
        Expr expr2;
        switch (functionCall.getOperandCount()) {
            case 1: {
                expr2 = null;
                expr = functionCall.getOperand(0);
                break;
            }
            case 2: {
                expr2 = functionCall.getOperand(0);
                expr = functionCall.getOperand(1);
                break;
            }
            default: {
                expr = null;
                expr2 = null;
            }
        }
        Type type = ASTDecorator1.getType(expr);
        QName qName = null;
        if (expr2 != null && (qName = ASTDecorator.getResolvedQNameArgument(expr2)) != null) {
            object4 = qName.toString();
            object3 = this.m_xpathTranslator.getXSLTTranslator();
            if (object3 != null) {
                object2 = ((XSLTTranslator)object3).getKeyBuilders();
                boolean bl = false;
                if (object2 != null) {
                    Object object5;
                    object = ((ArrayList)object2).iterator();
                    while (object.hasNext()) {
                        object5 = (String)object.next();
                        if (!((String)object4).equals(object5)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        object5 = new ErrorMsg("KEY_NOT_DEFINED", object4, (Expr)functionCall);
                        throw new StaticError((ErrorMsg)object5);
                    }
                }
            }
        }
        if (expr2 == null) {
            object4 = StreamInstruction.charStreamLiteral("##id");
        } else if (qName != null) {
            object4 = StreamInstruction.charStreamLiteral(qName.toString());
        } else {
            object3 = this.m_xpathTranslator.getNamespaceHelper().getNamespaceTable(functionCall);
            object4 = new ModuleFunctionCallInstruction("xslt1", "validate-lexical-qname", new Instruction[]{this.coerceToString(expr2, string), LiteralInstruction.booleanFalseLiteral(), LiteralInstruction.booleanFalseLiteral(), object3});
            object4 = new JavaMethodInvocationInstruction("toString", (Instruction)object4, new Instruction[0], (com.ibm.xylem.Type)new JavaObjectType(String.class.getName()));
            object4 = new JavaMethodInvocationInstruction("toCharArray", (Instruction)object4, new Instruction[0], (com.ibm.xylem.Type)CharType.s_charType.getStreamType());
        }
        object3 = new FunctionCallInstruction("select_key_table", new Instruction[]{new IdentifierInstruction("__current__"), object4});
        Object object6 = object2 = new LetInstruction("result", new JavaDowncastInstruction(new JavaMethodInvocationInstruction("get", new IdentifierInstruction("keyMap"), new Instruction[]{new IdentifierInstruction("value")}, (com.ibm.xylem.Type)new JavaObjectType("java.lang.Object")), CursorType.s_cursorType.getStreamType()), new ChooseInstruction(new PrimitiveEqualityInstruction(LiteralInstruction.nullLiteral(CursorType.s_cursorType.getStreamType()), new IdentifierInstruction("result")), (Instruction)new StreamInstruction(new TupleType(new com.ibm.xylem.Type[]{CursorType.s_cursorType})), new StreamInstruction((com.ibm.xylem.Type)new TupleType(new com.ibm.xylem.Type[]{CursorType.s_cursorType}), new TupleInstruction(new Instruction[]{new NodeStreamCursorInstruction(new IdentifierInstruction("result"))}))));
        Object object7 = object = type == Type.Reference ? ((Instruction)object2).cloneWithoutTypeInformation() : object2;
        if (type == Type.NodeSet || type == Type.Reference) {
            object6 = new LetInstruction("value", new CharStreamToJavaStringInstruction(new IdentifierInstruction("value")), (Instruction)object6);
            object6 = new LetInstruction("value", new CoerceInstruction(new IdentifierInstruction("node"), CharType.s_charType.getStreamType()), (Instruction)object6);
            object6 = new ForEachInstruction((Instruction)new IdentifierInstruction("value"), (Object)"node", (Instruction)object6, CursorType.s_cursorType);
        }
        if (type != Type.NodeSet) {
            object = new LetInstruction("value", new CharStreamToJavaStringInstruction(new IdentifierInstruction("value")), (Instruction)object);
            object = new LetInstruction("value", new CoerceInstruction(new IdentifierInstruction("value"), CharType.s_charType.getStreamType()), (Instruction)object);
        }
        object2 = type == Type.Reference ? new TypeMatchInstruction(new IdentifierInstruction("value"), new TypeMatchInstruction.Match[]{new TypeMatchInstruction.Match(CursorType.s_cursorType, "value", (Instruction)object6)}, (Instruction)object) : (type == Type.NodeSet ? object6 : object);
        object2 = new LetInstruction("keyMap", (Instruction)object3, new LetInstruction("value", this.visitXPath(expr, string), (Instruction)object2));
        return new LetInstruction("cursorStream", (Instruction)object2, new TestStreamInstruction(new IdentifierInstruction("cursorStream"), new EmptyCursorInstruction(), "aCursor", "resultCursor", new LetInstruction("aCursor", new TupleMatchInstruction((Instruction)new IdentifierInstruction("aCursor"), new Object[]{"a"}, new IdentifierInstruction("a")), new ChooseInstruction(new JavaMethodInvocationInstruction("isEmpty", new IdentifierInstruction("resultCursor"), new Instruction[0], (com.ibm.xylem.Type)BooleanType.s_booleanType), (Instruction)new IdentifierInstruction("aCursor"), new UnionCursorInstruction(new IdentifierInstruction("resultCursor"), new IdentifierInstruction("aCursor"))))));
    }

    protected Instruction langCall(FunctionCall functionCall, String string) {
        Instruction instruction = this.m_xpathTranslator.visitRawExpression(functionCall.getOperand(0), string, new IdentifierInstruction("__context__"));
        return new LangInstruction(new CoerceInstruction(instruction, CharType.s_charType.getStreamType()), new IdentifierInstruction("__context__"));
    }

    protected Instruction lastCall(FunctionCall functionCall) {
        return new IdentifierInstruction("__contextlast__");
    }

    protected Instruction localNameCall(FunctionCall functionCall, String string) {
        if (functionCall.getOperandCount() == 0) {
            return new LocalNameInstruction(new IdentifierInstruction("__context__"));
        }
        Expr expr = functionCall.getOperand(0);
        Instruction instruction = this.visitXPath(expr, string);
        return new LocalNameInstruction(new CoerceInstruction(instruction, CursorType.s_cursorType));
    }

    protected Instruction nameCall(FunctionCall functionCall, String string) {
        if (functionCall.getOperandCount() == 0) {
            return new GetNodeNameInstruction(new IdentifierInstruction("__context__"));
        }
        return new GetNodeNameInstruction(new CoerceInstruction(this.visitXPath(functionCall.getOperand(0), string), CursorType.s_cursorType));
    }

    protected Instruction nodesetCall(FunctionCall functionCall, String string) {
        Instruction[] instructionArray;
        if (this.getParser().getSecureProcessing()) {
            return new ModuleFunctionCallInstruction("xslt1", "unallowed-extension-secure-true", new Instruction[]{StreamInstruction.charStreamLiteral("nodeset")});
        }
        Instruction instruction = this.visitXPath(functionCall.getOperand(0), string);
        XSLTLinkerSettings xSLTLinkerSettings = this.m_xpathTranslator.getLinkerSettings();
        String string2 = "y";
        if (xSLTLinkerSettings.isEnableNodeSetDeforester()) {
            Instruction[] instructionArray2 = new Instruction[1];
            instructionArray = instructionArray2;
            instructionArray2[0] = new IdentifierInstruction(string2);
        } else {
            Instruction[] instructionArray3 = new Instruction[1];
            instructionArray = instructionArray3;
            instructionArray3[0] = new ModuleFunctionCallInstruction("xslt1", "handle-rtf", new Instruction[]{new IdentifierInstruction(string2)});
        }
        FunctionCallInstruction functionCallInstruction = new FunctionCallInstruction("do-nodeset", instructionArray);
        ModuleFunctionCallInstruction moduleFunctionCallInstruction = new ModuleFunctionCallInstruction("xslt1", "get-nodeset-from-xsltobject", new Instruction[]{new IdentifierInstruction(string2)});
        FunctionCallInstruction functionCallInstruction2 = new FunctionCallInstruction("do-nodeset", new Instruction[]{new CoerceInstruction(instruction.cloneWithoutTypeInformation(), SAXEventsLibrary.getSAXEventStream())});
        TypeMatchInstruction typeMatchInstruction = new TypeMatchInstruction(instruction, new TypeMatchInstruction.Match[]{new TypeMatchInstruction.Match(SAXEventsLibrary.getSAXEventStream(), string2, functionCallInstruction), new TypeMatchInstruction.Match(XSLTObjectType.s_xsltObjectType, string2, moduleFunctionCallInstruction)}, functionCallInstruction2);
        return typeMatchInstruction;
    }

    protected Instruction namespaceUriCall(FunctionCall functionCall, String string) {
        if (functionCall.getOperandCount() == 0) {
            return new NamespaceURIInstruction(new IdentifierInstruction("__context__"));
        }
        Expr expr = functionCall.getOperand(0);
        Instruction instruction = this.visitXPath(expr, string);
        return new NamespaceURIInstruction(instruction);
    }

    protected Instruction normalizeSpaceCall(FunctionCall functionCall, String string) {
        return new NormalizeSpaceInstruction(functionCall.getOperandCount() == 0 ? new CoerceInstruction(new IdentifierInstruction("__context__"), CharType.s_charType.getStreamType()) : this.coerceToString(functionCall.getOperand(0), string));
    }

    protected Instruction notCall(FunctionCall functionCall, String string) {
        Expr expr = functionCall.getOperand(0);
        Instruction instruction = this.visitXPath(expr, string);
        return new NotInstruction(new CoerceInstruction(instruction, BooleanType.s_booleanType));
    }

    protected Instruction numberCall(FunctionCall functionCall, String string) {
        Instruction instruction;
        if (functionCall.getOperandCount() == 0) {
            instruction = new IdentifierInstruction("__context__");
        } else {
            Expr expr = functionCall.getOperand(0);
            instruction = this.visitXPath(expr, string);
        }
        return new CoerceInstruction(instruction, DoubleType.s_doubleType);
    }

    protected Instruction positionCall(FunctionCall functionCall) {
        return new IdentifierInstruction("__contextposition__");
    }

    protected Instruction roundCall(FunctionCall functionCall, String string) {
        Expr expr = functionCall.getOperand(0);
        Instruction instruction = this.visitXPath(expr, string);
        String string2 = OptimizerUtilities.generateIntermediateIdentifier();
        return new LetInstruction(string2, new CoerceInstruction(instruction, DoubleType.s_doubleType), new ChooseInstruction(new NaNInstruction(new IdentifierInstruction(string2)), (Instruction)new IdentifierInstruction(string2), new RoundInstruction(new IdentifierInstruction(string2))));
    }

    protected Instruction sqlCall(FunctionCall functionCall, String string) {
        int n = functionCall.getOperandCount();
        Instruction[] instructionArray = new Instruction[n - 4];
        for (int i = 4; i < n; ++i) {
            instructionArray[i - 4] = this.coerceToString(functionCall.getOperand(i), string);
        }
        return null;
    }

    protected Instruction stringCall(FunctionCall functionCall, String string) {
        Instruction instruction;
        if (functionCall.getOperandCount() == 0) {
            instruction = new IdentifierInstruction("__context__");
        } else {
            Expr expr = functionCall.getOperand(0);
            instruction = this.visitXPath(expr, string);
        }
        return new CoerceInstruction(instruction, CharType.s_charType.getStreamType());
    }

    protected Instruction stringLengthCall(FunctionCall functionCall, String string) {
        Instruction instruction = functionCall.getOperandCount() == 0 ? new CoerceInstruction(new IdentifierInstruction("__context__"), CharType.s_charType.getStreamType()) : this.coerceToString(functionCall.getOperand(0), string);
        return new LengthInstruction(instruction);
    }

    protected Instruction substringCall(FunctionCall functionCall, String string) {
        if (functionCall.getOperandCount() > 2) {
            return new ModuleFunctionCallInstruction("xslt1", "substring-xsl", new Instruction[]{this.coerceToString(functionCall.getOperand(0), string), new CoerceInstruction(this.visitXPath(functionCall.getOperand(1), string), DoubleType.s_doubleType), new CoerceInstruction(this.visitXPath(functionCall.getOperand(2), string), DoubleType.s_doubleType)});
        }
        return new ModuleFunctionCallInstruction("xslt1", "substring-xsl-1-arg", new Instruction[]{this.coerceToString(functionCall.getOperand(0), string), new CoerceInstruction(this.visitXPath(functionCall.getOperand(1), string), DoubleType.s_doubleType)});
    }

    protected Instruction systemPropertyCall(FunctionCall functionCall, String string) {
        Instruction instruction;
        Instruction instruction2;
        Instruction instruction3;
        Expr expr = functionCall.getOperand(0);
        QName qName = ASTDecorator.getResolvedQNameArgument(expr);
        if (qName != null) {
            String string2 = "";
            if (XSLT_URI.equals(qName.getNamespaceURI())) {
                String string3 = qName.getLocalPart();
                for (int i = 0; i < STANDARD_SYS_PROPS.length; ++i) {
                    if (!STANDARD_SYS_PROPS[i].equals(string3)) continue;
                    string2 = STANDARD_SYS_PROP_VALUES[i];
                    break;
                }
            }
            return StreamInstruction.charStreamLiteral(string2);
        }
        Instruction instruction4 = this.m_xpathTranslator.getNamespaceHelper().getNamespaceTable(functionCall);
        ModuleFunctionCallInstruction moduleFunctionCallInstruction = new ModuleFunctionCallInstruction("xslt1", "validate-lexical-qname", new Instruction[]{this.coerceToString(expr, string), LiteralInstruction.booleanFalseLiteral(), LiteralInstruction.booleanFalseLiteral(), instruction4});
        JavaMethodInvocationInstruction javaMethodInvocationInstruction = new JavaMethodInvocationInstruction("toCharArray", new JavaMethodInvocationInstruction("getLocalPart", new IdentifierInstruction("__prop__"), new Instruction[0], (com.ibm.xylem.Type)new JavaObjectType(String.class.getName())), new Instruction[0], (com.ibm.xylem.Type)CharType.s_charType.getStreamType());
        int n = STANDARD_SYS_PROPS.length;
        ChooseInstruction.Case[] caseArray = new ChooseInstruction.Case[n];
        for (int i = 0; i < n; ++i) {
            instruction3 = new IdentifierInstruction("__localpart__");
            instruction2 = StreamInstruction.charStreamLiteral(STANDARD_SYS_PROPS[i]);
            instruction = StreamInstruction.charStreamLiteral(STANDARD_SYS_PROP_VALUES[i]);
            caseArray[i] = new ChooseInstruction.Case(new EqualityInstruction(instruction2, instruction3, false), instruction);
        }
        StreamInstruction streamInstruction = StreamInstruction.charStreamLiteral("");
        instruction3 = new LetInstruction("__localpart__", javaMethodInvocationInstruction, new ChooseInstruction(caseArray, streamInstruction));
        instruction2 = new JavaMethodInvocationInstruction("toCharArray", new JavaMethodInvocationInstruction("getNamespaceURI", new IdentifierInstruction("__prop__"), new Instruction[0], (com.ibm.xylem.Type)new JavaObjectType(String.class.getName())), new Instruction[0], (com.ibm.xylem.Type)CharType.s_charType.getStreamType());
        instruction = new EqualityInstruction(instruction2, StreamInstruction.charStreamLiteral(XSLT_URI), false);
        ChooseInstruction chooseInstruction = new ChooseInstruction(instruction, instruction3, StreamInstruction.charStreamLiteral(""));
        return new LetInstruction("__prop__", moduleFunctionCallInstruction, chooseInstruction);
    }

    protected Instruction trueCall(FunctionCall functionCall) {
        return LiteralInstruction.booleanTrueLiteral();
    }

    protected Instruction falseCall(FunctionCall functionCall) {
        return LiteralInstruction.booleanFalseLiteral();
    }

    protected Instruction unparsedEntityUriCall(FunctionCall functionCall, String string) {
        Expr expr = functionCall.getOperand(0);
        CoerceInstruction coerceInstruction = new CoerceInstruction(this.visitXPath(expr, string), CharType.s_charType.getStreamType());
        return new UnparsedEntityUriInstruction(coerceInstruction);
    }

    protected Instruction extensionFunctionCall(FunctionCall functionCall, String string) {
        QName qName = functionCall.getFunctionQName();
        String string2 = qName.getLocalPart();
        String string3 = qName.getNamespaceURI();
        if (this.getParser().getSecureProcessing()) {
            return new ModuleFunctionCallInstruction("xslt1", "unallowed-extension-secure-true", new Instruction[]{StreamInstruction.charStreamLiteral(qName.toString())});
        }
        if (FunctionOperatorHelper.isObjectTypeExtensionCall(string3, string2)) {
            Instruction[] instructionArray = new Instruction[]{this.visitXPath(functionCall.getOperand(0), string)};
            return new FunctionCallInstruction("object-type$exslt-common$", instructionArray);
        }
        if (FunctionOperatorHelper.isNodeIsInSequenceCall(string3, string2)) {
            return new NodesetContainsNodeInstruction(this.visitXPath(functionCall.getOperand(0), string), this.visitXPath(functionCall.getOperand(1), string));
        }
        if (SecurityUtil.disableExtensionCalls()) {
            return new ModuleFunctionCallInstruction("xslt1", "unallowed-extension-java-secure-true", new Instruction[]{StreamInstruction.charStreamLiteral(qName.toString()), StreamInstruction.charStreamLiteral("com.ibm.xtq.processor.overrideSecureProcessing")});
        }
        return this.externalFunctionCall(functionCall, string);
    }

    protected Instruction externalFunctionCall(FunctionCall functionCall, String string) {
        Constructor constructor = this.getCompiler().getResolvedExtensionMap().getConstructor(functionCall);
        Method method = this.getCompiler().getResolvedExtensionMap().getMethod(functionCall);
        RuntimeMsg runtimeMsg = ASTDecorator.getFunctionCallErrorMessage(functionCall);
        String string2 = ASTDecorator.getMethodName(functionCall);
        String string3 = ASTDecorator.getClassName(functionCall);
        if (runtimeMsg != null) {
            String string4 = runtimeMsg.getErrorCode();
            Object[] objectArray = runtimeMsg.getParams();
            Instruction[] instructionArray = new Instruction[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                instructionArray[i] = StreamInstruction.charStreamLiteral(objectArray[i].toString());
            }
            Instruction instruction = new LocalizeMessageInstruction(StreamInstruction.charStreamLiteral("com.ibm.xtq.xslt.runtime.res.RuntimeMessages"), StreamInstruction.charStreamLiteral(string4), instructionArray);
            instruction = new TerminateInstruction(instruction, LiteralInstruction.booleanTrueLiteral(), CharType.s_charType.getStreamType());
            instruction.setSourceLocation(runtimeMsg.getSourceLocation());
            return instruction;
        }
        if (constructor != null) {
            LetChainBuilder letChainBuilder = new LetChainBuilder();
            Class[] classArray = constructor.getParameterTypes();
            Instruction[] instructionArray = this.convertArgsToJava(functionCall, classArray, 0, letChainBuilder, string);
            JavaObjectType javaObjectType = new JavaObjectType(constructor.getDeclaringClass().getName());
            Instruction instruction = new NewJavaObjectInstruction(instructionArray, (com.ibm.xylem.Type)javaObjectType);
            instruction = new CoerceInstruction(instruction, new JavaObjectType("java.lang.Object"));
            instruction = TranslatorUtilities.createXSLTObject(instruction, constructor.getDeclaringClass());
            if (constructor.getExceptionTypes().length > 0) {
                instruction = new TryCatchInstruction(instruction, StreamInstruction.charStreamLiteral(""));
            }
            instruction = letChainBuilder.packageUp(instruction);
            return instruction;
        }
        if (method != null) {
            Instruction instruction;
            boolean bl;
            Class[] classArray = method.getParameterTypes();
            Class<Object> clazz = method.getReturnType();
            boolean bl2 = bl = clazz == Void.TYPE;
            if (!clazz.isPrimitive()) {
                clazz = Object.class;
            }
            com.ibm.xylem.Type type = bl ? UnitType.s_unitType : new JavaObjectType(clazz.getName());
            int n = method.getModifiers();
            LetChainBuilder letChainBuilder = new LetChainBuilder();
            if (Modifier.isStatic(n)) {
                String string5 = method.getDeclaringClass().getName() + "." + method.getName();
                Instruction[] instructionArray = this.convertArgsToJava(functionCall, classArray, 0, letChainBuilder, string);
                instruction = new StaticMethodInvocationInstruction(string5, instructionArray, type);
                instruction = bl ? new BeginInstruction(new Instruction[]{instruction, TranslatorUtilities.createXSLTObject()}) : TranslatorUtilities.createXSLTObject(instruction, method.getReturnType());
            } else {
                Instruction[] instructionArray;
                Instruction instruction2;
                int n2 = 0;
                String string6 = method.getDeclaringClass().getName();
                JavaObjectType javaObjectType = new JavaObjectType(string6);
                if (ASTDecorator.getThisArgumentF(functionCall) != null) {
                    instruction2 = this.visitXPath(functionCall.getOperand(0), string);
                    instruction2 = new CoerceInstruction(instruction2, javaObjectType);
                    n2 = 1;
                } else {
                    instructionArray = new LambdaInstruction(new JavaDowncastInstruction(new NewJavaObjectInstruction(new Instruction[0], (com.ibm.xylem.Type)javaObjectType), new JavaObjectType("java.lang.Object")), new Binding[0], true);
                    instruction2 = new ModuleFunctionCallInstruction("xslt1", "get-default-java-object", new Instruction[]{StreamInstruction.charStreamLiteral(string6), instructionArray});
                    instruction2 = new JavaDowncastInstruction(instruction2, javaObjectType);
                }
                instruction2 = letChainBuilder.bind(instruction2);
                instructionArray = this.convertArgsToJava(functionCall, classArray, n2, letChainBuilder, string);
                instruction = new JavaMethodInvocationInstruction(method.getName(), instruction2, instructionArray, type);
                instruction = bl ? new BeginInstruction(new Instruction[]{instruction, TranslatorUtilities.createXSLTObject()}) : TranslatorUtilities.createXSLTObject(instruction, method.getReturnType());
            }
            if (method.getExceptionTypes().length > 0) {
                instruction = new TryCatchInstruction(instruction, StreamInstruction.charStreamLiteral(""));
            }
            instruction = letChainBuilder.packageUp(instruction);
            instruction = new OnceInstruction(instruction);
            return instruction;
        }
        if (string2 != null) {
            StaticMethodInvocationInstruction staticMethodInvocationInstruction;
            Instruction instruction = string3 != null ? CharStreamToJavaStringInstruction.literal(string3) : LiteralInstruction.nullLiteral(JavaObjectType.s_javaStringType);
            Instruction instruction3 = this.convertArgsToXSLTObjectStream(functionCall, string);
            XDMManagerFactoryInstruction xDMManagerFactoryInstruction = new XDMManagerFactoryInstruction();
            if (string2.equals("new")) {
                staticMethodInvocationInstruction = new StaticMethodInvocationInstruction(JavaExtensionUtils.class.getName(), "callJavaConstructor", new Instruction[]{instruction, instruction3, xDMManagerFactoryInstruction}, XSLTObjectType.s_xsltObjectType);
            } else {
                Instruction instruction4 = CharStreamToJavaStringInstruction.literal(string2);
                ModuleFunctionCallInstruction moduleFunctionCallInstruction = new ModuleFunctionCallInstruction("xslt1", "get-default-java-object-table", new Instruction[0]);
                staticMethodInvocationInstruction = new StaticMethodInvocationInstruction(JavaExtensionUtils.class.getName(), "callJavaMethod", new Instruction[]{instruction4, instruction, instruction3, xDMManagerFactoryInstruction, moduleFunctionCallInstruction}, XSLTObjectType.s_xsltObjectType);
            }
            return staticMethodInvocationInstruction;
        }
        Assert.assertNotImplemented();
        QName qName = functionCall.getFunctionQName();
        throw new StaticError("ERR_UNSUPPORTED_FUNC", qName);
    }

    private Instruction[] convertArgsToJava(FunctionCall functionCall, Class[] classArray, int n, LetChainBuilder letChainBuilder, String string) {
        int n2 = functionCall.getOperandCount();
        Instruction[] instructionArray = new Instruction[classArray.length];
        int n3 = n;
        int n4 = 0;
        while (n3 < n2) {
            Expr expr = functionCall.getOperand(n3);
            Class clazz = classArray[n4];
            Instruction instruction = this.visitXPath(expr, string);
            instruction = this.convertToJava(instruction, clazz);
            instructionArray[n4] = letChainBuilder.bind(instruction);
            ++n3;
            ++n4;
        }
        return instructionArray;
    }

    private Instruction convertToJava(Instruction instruction, Class clazz) {
        instruction = this.convertToXylem(instruction, clazz);
        com.ibm.xylem.Type type = (com.ibm.xylem.Type)javaTypeMap.get(clazz);
        if (type == null) {
            type = new JavaObjectType(clazz.getName());
        }
        instruction = new CoerceInstruction(instruction, type);
        return instruction;
    }

    private Instruction convertArgsToXSLTObjectStream(FunctionCall functionCall, String string) {
        int n = functionCall.getOperandCount();
        Instruction[] instructionArray = new Instruction[n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            Expr expr = functionCall.getOperand(n2);
            Instruction instruction = this.visitXPath(expr, string);
            instructionArray[n3] = new FunctionCallInstruction("create-xsltobject", new Instruction[]{instruction});
            ++n2;
            ++n3;
        }
        StreamInstruction streamInstruction = new StreamInstruction((com.ibm.xylem.Type)XSLTObjectType.s_xsltObjectType, instructionArray);
        return streamInstruction;
    }

    private Instruction convertToXylem(Instruction instruction, Class clazz) {
        if (NodeIterator.class.isAssignableFrom(clazz) || NodeList.class.isAssignableFrom(clazz) || Node.class.isAssignableFrom(clazz)) {
            return new CoerceInstruction(instruction, CursorType.s_cursorType);
        }
        if (String.class.isAssignableFrom(clazz)) {
            return new CoerceInstruction(instruction, CharType.s_charType.getStreamType());
        }
        if (Boolean.class.isAssignableFrom(clazz) || clazz == Boolean.TYPE) {
            return new CoerceInstruction(instruction, BooleanType.s_booleanType);
        }
        if (Character.class.isAssignableFrom(clazz) || clazz == Character.TYPE) {
            return instruction;
        }
        if (Number.class.isAssignableFrom(clazz) || clazz.isPrimitive()) {
            return new CoerceInstruction(instruction, DoubleType.s_doubleType);
        }
        if (DocumentFragment.class.isAssignableFrom(clazz)) {
            return new CoerceInstruction(instruction, CursorType.s_cursorType);
        }
        return instruction;
    }

    protected boolean isStylesheetFunctionCall(FunctionCall functionCall) {
        return XSLTCHelper.isStylesheetFunctionCall(functionCall, this.getCompiler());
    }

    protected boolean isJAXPFunctionCall(FunctionCall functionCall) {
        return XSLTCHelper.isJAXPFunctionCall(functionCall, this.getCompiler());
    }

    protected Instruction jaxpFunctionCall(FunctionCall functionCall, String string) {
        Instruction instruction;
        Object object;
        XPathFunction xPathFunction = XSLTCHelper.getJAXPFunctionCall(functionCall, this.getCompiler());
        int n = functionCall.getOperandCount();
        Instruction[] instructionArray = new Instruction[n];
        JavaObjectType javaObjectType = new JavaObjectType("java.lang.Object");
        for (int i = 0; i < n; ++i) {
            object = functionCall.getOperand(i);
            instruction = this.visitXPath((Expr)object, string);
            instructionArray[i] = instruction = new CoerceInstruction(instruction, javaObjectType);
        }
        LiteralInstruction literalInstruction = new LiteralInstruction(new JavaObjectType("javax.xml.xpath.XPathFunction"), xPathFunction);
        object = new StreamInstruction((com.ibm.xylem.Type)new JavaObjectType("java.lang.Object"), instructionArray);
        instruction = new StaticMethodInvocationInstruction(RuntimeLibrary.class.getName(), "evaluateXPathFunction10", new Instruction[]{literalInstruction, object}, new JavaObjectType("java.lang.Object"));
        return instruction;
    }

    static {
        javaTypeMap.put(Double.TYPE, DoubleType.s_doubleType);
        javaTypeMap.put(Float.TYPE, FloatType.s_floatType);
        javaTypeMap.put(Long.TYPE, LongType.s_longType);
        javaTypeMap.put(Integer.TYPE, IntType.s_intType);
        javaTypeMap.put(Short.TYPE, ShortType.s_shortType);
        javaTypeMap.put(Character.TYPE, CharType.s_charType);
        javaTypeMap.put(Byte.TYPE, ByteType.s_byteType);
        javaTypeMap.put(Boolean.TYPE, BooleanType.s_booleanType);
    }
}

