/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.jaxp;

import com.ibm.xtq.xml.res.XMLMessages;
import com.ibm.xtq.xml.xdm.ExpandedNameTable;
import com.ibm.xtq.xml.xdm.XDMCursor;
import com.ibm.xtq.xml.xdm.XDMCursor_SAXBuildable;
import com.ibm.xtq.xml.xdm.XDMManagerFactory;
import com.ibm.xtq.xslt.jaxp.ResultURIResolver;
import com.ibm.xtq.xslt.jaxp.TransformerImpl;
import com.ibm.xtq.xslt.res.ErrorMsg;
import com.ibm.xtq.xslt.runtime.AbstractTranslet;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.SerializationHandler;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.apache.xml.serializer.ToHTMLStream;
import org.apache.xml.serializer.ToStream;
import org.apache.xml.serializer.ToTextStream;
import org.apache.xml.serializer.ToUnknownStream;
import org.apache.xml.serializer.ToXMLStream;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class TransformerHandlerImpl
implements TransformerHandler,
DeclHandler {
    private final TransformerImpl _transformer;
    private AbstractTranslet _translet = null;
    private String _systemId;
    private XDMCursor _documentCursor = null;
    private ContentHandler _handler = null;
    private LexicalHandler _lexHandler = null;
    private DTDHandler _dtdHandler = null;
    private DeclHandler _declHandler = null;
    private Result _result = null;
    private Locator _locator = null;
    private boolean _done = false;
    private final boolean _isIdentity;

    public TransformerHandlerImpl(TransformerImpl transformerImpl) {
        this._transformer = transformerImpl;
        if (transformerImpl.isIdentity()) {
            this._handler = new DefaultHandler();
            this._isIdentity = true;
        } else {
            this._translet = this._transformer.getTranslet();
            this._isIdentity = false;
        }
    }

    @Override
    public String getSystemId() {
        return this._systemId;
    }

    @Override
    public void setSystemId(String string) {
        this._systemId = string;
    }

    @Override
    public Transformer getTransformer() {
        return this._transformer;
    }

    @Override
    public void setResult(Result result) throws IllegalArgumentException {
        if (result == null) {
            throw new IllegalArgumentException(XMLMessages.createXMLMessage("ERR_SET_NULL_RESULT", null));
        }
        this._result = result;
        if (this._isIdentity) {
            try {
                SerializationHandler serializationHandler;
                if (!(result instanceof StreamResult)) {
                    this._transformer.setStreamSerializerToReuse(null);
                }
                if ((serializationHandler = this._transformer.getOutputHandler(this._transformer.getStreamSerializerToReuse(), result)) == null) {
                    ErrorMsg errorMsg = new ErrorMsg("JAXP_NO_HANDLER_ERR");
                    throw new TransformerException(errorMsg.toString());
                }
                if (result instanceof StreamResult) {
                    this._transformer.transferOutputProperties(serializationHandler);
                    this._transformer.setStreamSerializerToReuse(serializationHandler);
                }
                this._handler = serializationHandler;
                this._lexHandler = serializationHandler;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
        }
        if (this._done) {
            this._done = false;
            try {
                this._transformer.setDOM(this._documentCursor);
                this._transformer.transform(null, this._result);
            }
            catch (TransformerException transformerException) {
                throw new IllegalArgumentException(transformerException.getMessage());
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this._handler.characters(cArray, n, n2);
    }

    @Override
    public void startDocument() throws SAXException {
        if (this._result == null) {
            ErrorMsg errorMsg = new ErrorMsg("JAXP_SET_RESULT_ERR");
            throw new SAXException(errorMsg.toString());
        }
        if (!this._isIdentity) {
            boolean bl = false;
            XDMManagerFactory xDMManagerFactory = this._transformer.getManagerFactory();
            this._documentCursor = (XDMCursor_SAXBuildable)xDMManagerFactory.getXDM(null, false, this._translet.preservesAllWhitespace() ? null : this._translet, true, false, bl, this._translet.getShouldTypeAnnotateTree(), this._translet.isSecureProcessing(), this._transformer.getTransformerFactory(), this._translet.getAllowedDTDProtocols());
            ExpandedNameTable expandedNameTable = xDMManagerFactory.getExpandedNameTable();
            boolean bl2 = expandedNameTable.assertTypeMappings(this._translet.getNamesArray(), this._translet.getUrisArray(), this._translet.getTypesArray());
            if (!bl2) {
                throw new RuntimeException(XMLMessages.createXMLMessage("ERR_SYSTEM", "Failed pre-asserting stylesheet Expanded Types into Document Manager."));
            }
            this._handler = ((XDMCursor_SAXBuildable)this._documentCursor).getContentHandler();
            this._lexHandler = ((XDMCursor_SAXBuildable)this._documentCursor).getLexicalHandler();
            this._dtdHandler = ((XDMCursor_SAXBuildable)this._documentCursor).getDTDHandler();
            this._declHandler = ((XDMCursor_SAXBuildable)this._documentCursor).getDeclHandler();
            this._documentCursor.setDocumentBaseURI(this._systemId);
            if (this._locator != null) {
                this._handler.setDocumentLocator(this._locator);
            }
        } else if (this._result instanceof StreamResult && (this._transformer.propertiesModified() || this._transformer.getStreamSerializerToReuse() != this._handler)) {
            boolean bl = this.swapStreamSerializer();
            this._transformer.setStreamSerializerToReuse((SerializationHandler)this._handler);
            this._transformer.transferOutputProperties((SerializationHandler)this._handler);
        }
        this._handler.startDocument();
    }

    private boolean swapStreamSerializer() {
        Object object;
        String string;
        Properties properties = this._transformer.getProperties();
        if (properties == null && this._transformer.isIdentity()) {
            if (this._handler instanceof ToUnknownStream) {
                return false;
            }
            if (this._handler instanceof SerializationHandler) {
                ToUnknownStream toUnknownStream = new ToUnknownStream();
                this.transferOutputStreamOrWriter((SerializationHandler)this._handler, toUnknownStream);
                return true;
            }
        }
        if ((string = (object = properties.get("method")) instanceof String ? (String)object : null) == null) {
            if (!(this._handler instanceof ToUnknownStream)) {
                ToUnknownStream toUnknownStream = new ToUnknownStream();
                this.transferOutputStreamOrWriter((SerializationHandler)this._handler, toUnknownStream);
                return true;
            }
        } else if (this._handler instanceof ToStream || this._handler instanceof ToUnknownStream) {
            SerializationHandler serializationHandler = (SerializationHandler)this._handler;
            if ("xml".equals(string) && !(this._handler instanceof ToXMLStream) || "html".equals(string) && !(this._handler instanceof ToHTMLStream) || "text".equals(string) && !(this._handler instanceof ToTextStream)) {
                Properties properties2 = OutputPropertiesFactory.getDefaultMethodProperties(string);
                Serializer serializer = SerializerFactory.getSerializer(properties2);
                ContentHandler contentHandler = null;
                try {
                    contentHandler = serializer.asContentHandler();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                if (contentHandler instanceof SerializationHandler) {
                    this.transferOutputStreamOrWriter(serializationHandler, (SerializationHandler)contentHandler);
                }
                return true;
            }
        }
        return false;
    }

    private void transferOutputStreamOrWriter(SerializationHandler serializationHandler, SerializationHandler serializationHandler2) {
        OutputStream outputStream = serializationHandler.getOutputStream();
        if (outputStream != null) {
            serializationHandler2.setOutputStream(outputStream);
        } else {
            Writer writer = serializationHandler.getWriter();
            if (writer != null) {
                serializationHandler2.setWriter(writer);
            }
        }
        this._handler = serializationHandler2;
        this._lexHandler = this._handler instanceof LexicalHandler ? (LexicalHandler)((Object)this._handler) : null;
    }

    @Override
    public void endDocument() throws SAXException {
        this._handler.endDocument();
        if (!this._isIdentity) {
            this._transformer.setDOM(this._documentCursor);
            if (this._result != null) {
                try {
                    this._transformer.transform(null, this._result);
                }
                catch (TransformerException transformerException) {
                    throw new SAXException(transformerException);
                }
            } else {
                this._done = true;
            }
        }
        if (this._isIdentity && this._result instanceof DOMResult && ((DOMResult)this._result).getNode() == null) {
            ((DOMResult)this._result).setNode(this._transformer.getTransletOutputHandlerFactory().getNode());
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this._handler.startElement(string, string2, string3, attributes);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this._handler.endElement(string, string2, string3);
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        this._handler.processingInstruction(string, string2);
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this._lexHandler != null) {
            this._lexHandler.startCDATA();
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this._lexHandler != null) {
            this._lexHandler.endCDATA();
        }
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this._lexHandler != null) {
            this._lexHandler.comment(cArray, n, n2);
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this._handler.ignorableWhitespace(cArray, n, n2);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
        if (this._handler != null) {
            this._handler.setDocumentLocator(locator);
        }
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
        this._handler.skippedEntity(string);
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        this._handler.startPrefixMapping(string, string2);
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
        this._handler.endPrefixMapping(string);
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
        if (this._lexHandler != null) {
            this._lexHandler.startDTD(string, string2, string3);
        }
    }

    @Override
    public void endDTD() throws SAXException {
        if (this._lexHandler != null) {
            this._lexHandler.endDTD();
        }
    }

    @Override
    public void startEntity(String string) throws SAXException {
        if (this._lexHandler != null) {
            this._lexHandler.startEntity(string);
        }
    }

    @Override
    public void endEntity(String string) throws SAXException {
        if (this._lexHandler != null) {
            this._lexHandler.endEntity(string);
        }
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        if (this._dtdHandler != null) {
            this._dtdHandler.unparsedEntityDecl(string, string2, string3, string4);
        }
    }

    @Override
    public void notationDecl(String string, String string2, String string3) throws SAXException {
        if (this._dtdHandler != null) {
            this._dtdHandler.notationDecl(string, string2, string3);
        }
    }

    @Override
    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        if (this._declHandler != null) {
            this._declHandler.attributeDecl(string, string2, string3, string4, string5);
        }
    }

    @Override
    public void elementDecl(String string, String string2) throws SAXException {
        if (this._declHandler != null) {
            this._declHandler.elementDecl(string, string2);
        }
    }

    @Override
    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        if (this._declHandler != null) {
            this._declHandler.externalEntityDecl(string, string2, string3);
        }
    }

    @Override
    public void internalEntityDecl(String string, String string2) throws SAXException {
        if (this._declHandler != null) {
            this._declHandler.internalEntityDecl(string, string2);
        }
    }

    public void setResultURIResolver(ResultURIResolver resultURIResolver) {
        if (this._transformer instanceof TransformerImpl) {
            this._transformer.setResultURIResolver(resultURIResolver);
        }
    }

    public ResultURIResolver getResultURIResolver() {
        ResultURIResolver resultURIResolver = null;
        if (this._transformer instanceof TransformerImpl) {
            resultURIResolver = this._transformer.getResultURIResolver();
        }
        return resultURIResolver;
    }

    public Object getEntryNamedTemplate() {
        Object object = null;
        if (this._transformer instanceof TransformerImpl) {
            object = this._transformer.getEntryNamedTemplate();
        }
        return object;
    }

    public void setEntryNamedTemplate(String string) {
        if (this._transformer instanceof TransformerImpl) {
            this._transformer.setEntryNamedTemplate(string);
        }
    }

    public void setEntryNamedTemplate(QName qName) {
        if (this._transformer instanceof TransformerImpl) {
            this._transformer.setEntryNamedTemplate(qName);
        }
    }

    public Object getInitialMode() {
        Object object = null;
        if (this._transformer instanceof TransformerImpl) {
            object = this._transformer.getInitialMode();
        }
        return object;
    }

    public void setInitialMode(String string) {
        if (this._transformer instanceof TransformerImpl) {
            this._transformer.setInitialMode(string);
        }
    }

    public void setInitialMode(QName qName) {
        if (this._transformer instanceof TransformerImpl) {
            this._transformer.setInitialMode(qName);
        }
    }
}

