/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.dom;

import com.ibm.xml.enc.dom.DOMCipherData;
import com.ibm.xml.enc.dom.DOMUtils;
import com.ibm.xml.enc.dom.Utils;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.enc.CipherValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMCipherValue
extends DOMCipherData
implements CipherValue {
    private byte[] value;
    private String valueBase64;
    private Element parent;
    private Element elem;
    private XMLCryptoContext context;

    DOMCipherValue(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("value should not be null");
        }
        this.value = (byte[])data.clone();
        this.valueBase64 = Utils.base64Encode(data);
    }

    DOMCipherValue(Element parent, Element elem, XMLCryptoContext context) throws MarshalException {
        this.parent = parent;
        this.elem = elem;
        this.context = context;
        String cipherValue = DOMUtils.getTextContent(elem);
        StringTokenizer tokenizer = new StringTokenizer(cipherValue, " \n\r\t", false);
        StringBuffer cvBuf = new StringBuffer(cipherValue.length());
        while (tokenizer.hasMoreElements()) {
            cvBuf.append(tokenizer.nextToken());
        }
        this.valueBase64 = cvBuf.toString();
        try {
            this.value = Utils.base64Decode(cipherValue);
        }
        catch (IOException ioe) {
            throw new MarshalException(ioe);
        }
    }

    public void marshal(Node parent, String encPrefix, DOMCryptoContext context) throws MarshalException {
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        Element cdElem = DOMUtils.createElement(ownerDoc, "CipherData", "http://www.w3.org/2001/04/xmlenc#", encPrefix);
        Document ownerDoc2 = DOMUtils.getOwnerDocument(cdElem);
        Element cipherValueElem = DOMUtils.createElement(ownerDoc2, "CipherValue", "http://www.w3.org/2001/04/xmlenc#", encPrefix);
        cipherValueElem.appendChild(ownerDoc2.createTextNode(this.valueBase64));
        cdElem.appendChild(cipherValueElem);
        parent.appendChild(cdElem);
    }

    public byte[] getValue() {
        return this.value == null ? null : (byte[])this.value.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CipherValue)) {
            return false;
        }
        CipherValue ocv = (CipherValue)o;
        return Utils.compareArray(this.value, ocv.getValue());
    }
}

