/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.dom;

import com.ibm.xml.enc.dom.DOMCipherData;
import com.ibm.xml.enc.dom.DOMTransform;
import com.ibm.xml.enc.dom.DOMURIDereferencer;
import com.ibm.xml.enc.dom.DOMUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dom.DOMURIReference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.enc.CipherReference;
import javax.xml.crypto.enc.XMLEncryptionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMCipherReference
extends DOMCipherData
implements CipherReference,
DOMURIReference {
    private Element parent;
    private Element elem;
    private List transforms;
    private Attr here;
    private final String uri;
    private byte[] cipherValue;
    private Element crElem;
    private boolean dereferenced = false;
    private XMLCryptoContext context;

    public DOMCipherReference(String uri, List tfs) {
        if (uri == null) {
            throw new NullPointerException("URI must be non-null");
        }
        try {
            new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.uri = uri;
        if (tfs == null) {
            this.transforms = null;
            return;
        }
        ArrayList transformsCopy = new ArrayList(tfs);
        for (int i = 0; i < transformsCopy.size(); ++i) {
            if (transformsCopy.get(i) instanceof Transform) continue;
            throw new ClassCastException("transforms[" + i + "] is not a valid type");
        }
        this.transforms = Collections.unmodifiableList(transformsCopy);
    }

    public DOMCipherReference(Element parent, Element elem, XMLCryptoContext context) throws MarshalException {
        this.parent = parent;
        this.elem = elem;
        this.context = context;
        this.uri = DOMUtils.getAttributeValue(elem, "URI");
        Element nextSibling = DOMUtils.getFirstChildElement(elem);
        ArrayList<DOMTransform> transforms = null;
        if (nextSibling != null) {
            transforms = new ArrayList<DOMTransform>();
            if (nextSibling.getLocalName().equals("Transforms")) {
                Element transformElem = DOMUtils.getFirstChildElement(nextSibling);
                while (transformElem != null) {
                    transforms.add(new DOMTransform(transformElem, context));
                    transformElem = DOMUtils.getNextSiblingElement(transformElem);
                }
                nextSibling = DOMUtils.getNextSiblingElement(nextSibling);
            }
        }
        this.here = elem.getAttributeNodeNS(null, "URI");
        this.crElem = elem;
        if (transforms == null) {
            this.transforms = null;
        } else {
            if (transforms.isEmpty()) {
                throw new MarshalException("Transform should contain at least one Transform");
            }
            this.transforms = Collections.unmodifiableList(transforms);
        }
    }

    public String getType() {
        return null;
    }

    public String getURI() {
        return this.uri;
    }

    public List getTransforms() {
        return this.transforms;
    }

    public InputStream getCipherValue() throws XMLEncryptionException {
        return this.getCipherValue(this.context);
    }

    public InputStream getCipherValue(XMLCryptoContext ctx) throws XMLEncryptionException {
        if (this.dereferenced) {
            if (this.cipherValue != null) {
                return new ByteArrayInputStream((byte[])this.cipherValue.clone());
            }
            return null;
        }
        Data data = this.dereference(this.context);
        InputStream is = this.transform(data, ctx);
        try {
            if (is != null) {
                byte[] temp = new byte[is.available()];
                is.read(temp);
                this.cipherValue = (byte[])temp.clone();
                return new ByteArrayInputStream(temp);
            }
            return null;
        }
        catch (IOException ex) {
            throw new XMLEncryptionException((Throwable)ex);
        }
    }

    public void marshal(Node parent, String encPrefix, DOMCryptoContext context) throws MarshalException {
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        Element cdElem = DOMUtils.createElement(ownerDoc, "CipherData", "http://www.w3.org/2001/04/xmlenc#", encPrefix);
        this.crElem = DOMUtils.createElement(ownerDoc, "CipherReference", "http://www.w3.org/2001/04/xmlenc#", encPrefix);
        cdElem.appendChild(this.crElem);
        DOMUtils.setAttribute(this.crElem, "URI", this.uri);
        if (this.transforms != null && !this.transforms.isEmpty()) {
            Element transformsElem = DOMUtils.createElement(ownerDoc, "Transforms", "http://www.w3.org/2001/04/xmlenc#", encPrefix);
            for (Object obj : this.transforms) {
                if (obj instanceof TransformService) {
                    this.marshalTransform((TransformService)obj, transformsElem, context);
                    continue;
                }
                if (obj instanceof DOMTransform) {
                    ((DOMTransform)obj).marshal(transformsElem, "ds", context);
                    continue;
                }
                String alg = ((Transform)obj).getAlgorithm();
                TransformService ts = null;
                try {
                    ts = TransformService.getInstance(alg, "DOM");
                }
                catch (NoSuchAlgorithmException ex) {
                    throw new MarshalException(ex);
                }
                this.marshalTransform(ts, transformsElem, context);
            }
            this.crElem.appendChild(transformsElem);
        }
        parent.appendChild(cdElem);
        this.here = this.crElem.getAttributeNodeNS(null, "URI");
    }

    private void marshalTransform(TransformService ts, Element parent, DOMCryptoContext context) throws MarshalException {
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        Element transformElem = DOMUtils.createElement(ownerDoc, "Transform", "http://www.w3.org/2000/09/xmldsig#", "ds");
        DOMUtils.setAttribute(transformElem, "Algorithm", ts.getAlgorithm());
        ts.marshalParams(new DOMStructure(transformElem), context);
        parent.appendChild(transformElem);
    }

    private Data dereference(XMLCryptoContext context) throws XMLEncryptionException {
        Data data = null;
        URIDereferencer deref = context.getURIDereferencer();
        if (deref == null) {
            deref = DOMURIDereferencer.INSTANCE;
        }
        try {
            data = deref.dereference(this, context);
            this.dereferenced = true;
        }
        catch (URIReferenceException ure) {
            throw new XMLEncryptionException((Throwable)ure);
        }
        return data;
    }

    private InputStream transform(Data dereferencedData, XMLCryptoContext context) throws XMLEncryptionException {
        Data data = dereferencedData;
        if (this.transforms != null) {
            for (Transform ts : this.transforms) {
                try {
                    data = ts.transform(data, context);
                }
                catch (Exception ex) {
                    throw new XMLEncryptionException((Throwable)ex);
                }
            }
        }
        if (data != null) {
            if (data instanceof OctetStreamData) {
                return ((OctetStreamData)data).getOctetStream();
            }
            if (data instanceof NodeSetData) {
                try {
                    TransformService spi = TransformService.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "DOM");
                    data = spi.transform(data, context);
                    return ((OctetStreamData)data).getOctetStream();
                }
                catch (Exception ex) {
                    throw new XMLEncryptionException((Throwable)ex);
                }
            }
            throw new XMLEncryptionException("unrecognized Data type");
        }
        return null;
    }

    public Node getHere() {
        return this.here;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CipherReference)) {
            return false;
        }
        CipherReference oref = (CipherReference)o;
        boolean urisEqual = this.uri == null ? oref.getURI() == null : this.uri.equals(oref.getURI());
        return urisEqual && this.transforms.equals(oref.getTransforms());
    }
}

