/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.console.views;

import com.ibm.cic.common.core.console.actions.AConActionEntry;

public class ConViewTreeListEntry {
    private final String m_name;
    private final AConActionEntry<ConViewTreeListEntry> m_action;
    protected ConViewTreeListEntry[] m_children;
    protected ConViewTreeListEntry m_parent;
    boolean m_collapsed = false;
    Object m_element;
    protected boolean m_selected;
    private String[] m_keys;

    public ConViewTreeListEntry(Object elem, String a_name, AConActionEntry a_action) {
        this.m_name = a_name;
        this.m_action = a_action;
        if (this.m_action != null) {
            this.m_action.setEntry(this);
        }
        this.setElement(elem);
    }

    public ConViewTreeListEntry[] getChildren() {
        return this.m_children;
    }

    public void setChildren(ConViewTreeListEntry[] a_children) {
        this.m_children = a_children;
        if (this.m_children != null) {
            ConViewTreeListEntry[] conViewTreeListEntryArray = this.m_children;
            int n = this.m_children.length;
            int n2 = 0;
            while (n2 < n) {
                ConViewTreeListEntry entry = conViewTreeListEntryArray[n2];
                entry.setParent(this);
                ++n2;
            }
        }
    }

    public void setSelected(boolean a_selected) {
        if (!a_selected && this.m_children != null) {
            ConViewTreeListEntry[] conViewTreeListEntryArray = this.m_children;
            int n = this.m_children.length;
            int n2 = 0;
            while (n2 < n) {
                ConViewTreeListEntry entry = conViewTreeListEntryArray[n2];
                if (entry.isSelected()) {
                    return;
                }
                ++n2;
            }
        }
        if (this.m_selected != a_selected && this.m_parent != null) {
            this.m_parent.setCollapsed(false);
        }
        this.m_selected = a_selected;
        if (this.m_parent != null) {
            this.m_parent.setSelected(a_selected);
        }
    }

    public ConViewTreeListEntry getParent() {
        return this.m_parent;
    }

    public void setParent(ConViewTreeListEntry m_parent) {
        this.m_parent = m_parent;
    }

    public boolean expand() {
        this.m_collapsed = false;
        return false;
    }

    public boolean isCollapsible() {
        return this.m_children != null && this.m_children.length > 0;
    }

    public boolean isCollapsed() {
        return this.m_collapsed;
    }

    public void setCollapsed(boolean collapsed) {
        this.m_collapsed = collapsed;
    }

    public void setElement(Object a_element) {
        this.m_element = a_element;
    }

    public Object getElement() {
        return this.m_element;
    }

    public boolean isSelected() {
        return this.m_selected;
    }

    String[] getKeys() {
        return this.m_keys;
    }

    void setKeys(String[] a_keys) {
        this.m_keys = a_keys;
    }

    AConActionEntry getAction() {
        return this.m_action;
    }

    public String getName() {
        return this.m_name;
    }
}

