/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.console.views;

import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.manager.IConIO;
import com.ibm.cic.common.core.console.manager.rules.IConLineMatcher;
import com.ibm.cic.common.core.console.views.AConView;
import com.ibm.cic.common.core.console.views.ConViewTreeListEntry;
import com.ibm.cic.common.core.console.views.IConViewContentProvider;
import com.ibm.cic.common.core.utils.OutputFormatter;

public class ConViewTreeList
extends AConView {
    private String m_header;
    protected ConViewTreeListEntry[] m_entries;
    private boolean m_newLineAfterList = true;
    private IConViewContentProvider m_contentProvider;
    protected boolean m_selectable = false;
    private boolean m_collapsible = false;
    private boolean m_displayKeys = true;
    private final int m_startingIndex;
    private int m_current = 0;
    boolean m_refresh = true;
    private int m_indent = 0;
    private boolean m_indentInitialTree = true;

    public ConViewTreeList(String a_header, int a_startingIndex, boolean a_selectable, boolean a_collapsible, int a_indent, boolean a_indentInitialTree, boolean a_displayKeys) {
        this.setHeader(a_header);
        this.m_startingIndex = a_startingIndex;
        this.setSelectable(a_selectable);
        this.setCollapsible(a_collapsible);
        this.m_indent = a_indent;
        this.m_indentInitialTree = a_indentInitialTree;
        this.m_displayKeys = a_displayKeys;
        this.refresh();
    }

    public ConViewTreeList(String a_header, int a_startingIndex, boolean a_selectable, boolean a_collapsible, int a_indent, boolean a_indentInitialTree) {
        this(a_header, a_startingIndex, a_selectable, a_collapsible, a_indent, a_indentInitialTree, true);
    }

    public ConViewTreeList(String a_header, int a_startingIndex, boolean a_selectable, boolean a_collapsible, int a_indent) {
        this(a_header, a_startingIndex, a_selectable, a_collapsible, a_indent, true);
    }

    public ConViewTreeList(String a_header, int a_startingIndex, boolean a_selectable, boolean a_collapsible) {
        this(a_header, a_startingIndex, a_selectable, a_collapsible, 0);
    }

    public ConViewTreeList() {
        this(null, 1, false, false);
    }

    public ConViewTreeList(boolean a_selectable) {
        this(null, 1, a_selectable, false);
    }

    protected ConViewTreeListEntry generateEntry(Object element, String label, AConActionEntry action) {
        return new ConViewTreeListEntry(element, label, action);
    }

    void populateEntries() {
        if (this.m_refresh) {
            Object[] elems;
            IConViewContentProvider cp = this.getContentProvider();
            if (cp != null && !this.matches(this.m_entries, elems = cp.getElements())) {
                if (elems == null) {
                    this.m_entries = null;
                } else {
                    this.m_entries = new ConViewTreeListEntry[elems.length];
                    int i = 0;
                    while (i < elems.length) {
                        AConActionEntry action = cp.getAction(elems[i]);
                        if (action != null) {
                            action.setEntryIndex(i, this.m_startingIndex);
                        }
                        this.m_entries[i] = this.generateEntry(elems[i], cp.getLabel(elems[i]), action);
                        ++i;
                    }
                }
            }
            if (this.m_entries != null) {
                ConViewTreeListEntry[] conViewTreeListEntryArray = this.m_entries;
                int n = this.m_entries.length;
                int n2 = 0;
                while (n2 < n) {
                    ConViewTreeListEntry e = conViewTreeListEntryArray[n2];
                    this.populateNode(e, cp);
                    ++n2;
                }
            }
            this.m_refresh = false;
        }
    }

    private boolean matches(ConViewTreeListEntry[] elements, Object[] els) {
        boolean return_value = true;
        if (elements != null) {
            if (els == null) {
                return_value = false;
            } else if (elements.length != els.length) {
                return_value = false;
            } else {
                int i = 0;
                while (i < elements.length) {
                    if (elements[i].getElement() != els[i]) {
                        return_value = false;
                        break;
                    }
                    ++i;
                }
            }
        } else if (els != null) {
            return_value = false;
        }
        return return_value;
    }

    public void refresh() {
        this.m_refresh = true;
        this.m_current = this.m_startingIndex;
    }

    private void populateNode(ConViewTreeListEntry node, IConViewContentProvider cp) {
        String[] keys = cp.getKeys(node.getElement());
        if (keys != null) {
            node.setKeys(keys);
        } else {
            node.setKeys(new String[]{Integer.toString(this.m_current++)});
        }
        Object[] elems = cp.getChildren(node.getElement());
        if (!this.matches(node.getChildren(), elems)) {
            if (elems == null) {
                node.setChildren(null);
            } else {
                ConViewTreeListEntry[] children = new ConViewTreeListEntry[elems.length];
                int i = 0;
                while (i < elems.length) {
                    AConActionEntry action = cp.getAction(elems[i]);
                    if (action != null) {
                        action.setEntryIndex(i, this.m_startingIndex);
                    }
                    children[i] = this.generateEntry(elems[i], cp.getLabel(elems[i]), action);
                    children[i].setParent(node);
                    this.populateNode(children[i], cp);
                    ++i;
                }
                node.setChildren(children);
            }
        } else {
            ConViewTreeListEntry[] child = node.getChildren();
            if (child != null) {
                ConViewTreeListEntry[] conViewTreeListEntryArray = child;
                int n = child.length;
                int n2 = 0;
                while (n2 < n) {
                    ConViewTreeListEntry element = conViewTreeListEntryArray[n2];
                    this.populateNode(element, cp);
                    ++n2;
                }
            }
        }
    }

    public void setNewLineAfterList(boolean b) {
        this.m_newLineAfterList = b;
    }

    public boolean isNewLineAfterList() {
        return this.m_newLineAfterList;
    }

    public void setHeader(String a_header) {
        this.m_header = a_header;
    }

    @Override
    public AConActionEntry getAction(IConIO a_input) {
        if (this.m_displayKeys) {
            String input = a_input.getString();
            Boolean collapse = null;
            if (this.isCollapsible()) {
                if (input.endsWith("-")) {
                    collapse = Boolean.TRUE;
                } else if (input.endsWith("+")) {
                    collapse = Boolean.FALSE;
                }
                if (collapse != null) {
                    input = input.substring(0, input.length() - 1);
                }
            }
            return this.getActionFromNodes(this.m_entries, input, collapse);
        }
        return null;
    }

    private AConActionEntry getActionFromNodes(ConViewTreeListEntry[] nodes, String key, Boolean collapse) {
        if (nodes != null) {
            ConViewTreeListEntry[] conViewTreeListEntryArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                String[] keys;
                ConViewTreeListEntry e = conViewTreeListEntryArray[n2];
                String[] stringArray = keys = e.getKeys();
                int n3 = keys.length;
                int n4 = 0;
                while (n4 < n3) {
                    String targetKey = stringArray[n4];
                    if (key.equalsIgnoreCase(targetKey)) {
                        if (collapse != null) {
                            if (e.isCollapsible()) {
                                e.setCollapsed(collapse);
                            }
                            return AConActionEntry.NO_ACTION;
                        }
                        AConActionEntry a = e.getAction();
                        return a;
                    }
                    ++n4;
                }
                AConActionEntry a = this.getActionFromNodes(e.getChildren(), key, collapse);
                if (a != null) {
                    return a;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public void present(OutputFormatter a_output) {
        this.populateEntries();
        this.updateEntries(this.m_entries);
        int indent = this.m_indent;
        while (indent > 0) {
            a_output.incTab();
            --indent;
        }
        this.presentHeader(a_output);
        if (this.m_indentInitialTree) {
            a_output.incTab();
        }
        if (this.m_entries != null) {
            ConViewTreeListEntry[] conViewTreeListEntryArray = this.m_entries;
            int n = this.m_entries.length;
            int n2 = 0;
            while (n2 < n) {
                ConViewTreeListEntry e = conViewTreeListEntryArray[n2];
                this.presentBranch(e, a_output);
                ++n2;
            }
        }
        if (this.m_indentInitialTree) {
            a_output.decTab();
        }
        this.presentTail(a_output);
        indent = this.m_indent;
        while (indent > 0) {
            a_output.decTab();
            --indent;
        }
    }

    private void updateEntries(ConViewTreeListEntry[] entries) {
        if (entries != null) {
            IConViewContentProvider cp = this.getContentProvider();
            ConViewTreeListEntry[] conViewTreeListEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                ConViewTreeListEntry entry = conViewTreeListEntryArray[n2];
                cp.updateEntry(entry);
                this.updateEntries(entry.getChildren());
                ++n2;
            }
        }
    }

    public void presentBranch(ConViewTreeListEntry e, OutputFormatter a_output) {
        a_output.appendT(new String[]{this.presentKey(e)});
        a_output.appendNT(this.presentSelected(e));
        a_output.appendNTnl(this.presentName(e));
        if (e.isCollapsible() && !e.isCollapsed()) {
            a_output.incTab();
            ConViewTreeListEntry[] conViewTreeListEntryArray = e.getChildren();
            int n = conViewTreeListEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConViewTreeListEntry ce = conViewTreeListEntryArray[n2];
                this.presentBranch(ce, a_output);
                ++n2;
            }
            a_output.decTab();
        }
    }

    protected String presentKey(ConViewTreeListEntry e) {
        String[] keys = e.getKeys();
        if (keys.length == 0 || !this.m_displayKeys) {
            return "      ";
        }
        if (this.isCollapsible() && e.isCollapsible()) {
            if (e.isCollapsed()) {
                return String.format("%4s+. ", e.getKeys()[0]);
            }
            return String.format("%4s-. ", e.getKeys()[0]);
        }
        return String.format("%4s. ", e.getKeys()[0]);
    }

    protected String presentSelected(ConViewTreeListEntry e) {
        String return_value = "";
        if (this.m_selectable) {
            return_value = "[" + (e.isSelected() ? "X" : " ") + "] ";
        }
        return return_value;
    }

    protected String presentName(ConViewTreeListEntry e) {
        return e.getName();
    }

    protected void presentHeader(OutputFormatter a_output) {
        if (this.m_header != null) {
            a_output.appendTnl(new String[]{this.m_header});
        }
    }

    protected void presentTail(OutputFormatter a_output) {
        if (this.m_newLineAfterList) {
            a_output.nl();
        }
    }

    public void clear() {
        this.refresh();
    }

    public boolean areNoneSet() {
        ConViewTreeListEntry[] conViewTreeListEntryArray = this.m_entries;
        int n = this.m_entries.length;
        int n2 = 0;
        while (n2 < n) {
            ConViewTreeListEntry[] children;
            ConViewTreeListEntry e = conViewTreeListEntryArray[n2];
            if (e.isSelected()) {
                return false;
            }
            ConViewTreeListEntry[] conViewTreeListEntryArray2 = children = e.getChildren();
            int n3 = children.length;
            int n4 = 0;
            while (n4 < n3) {
                ConViewTreeListEntry child = conViewTreeListEntryArray2[n4];
                if (this.childrenSelected(child)) {
                    return false;
                }
                ++n4;
            }
            ++n2;
        }
        return true;
    }

    private boolean childrenSelected(ConViewTreeListEntry child) {
        return child.isSelected();
    }

    public boolean areAllSet() {
        ConViewTreeListEntry[] conViewTreeListEntryArray = this.m_entries;
        int n = this.m_entries.length;
        int n2 = 0;
        while (n2 < n) {
            ConViewTreeListEntry[] children;
            ConViewTreeListEntry e = conViewTreeListEntryArray[n2];
            if (!e.isSelected()) {
                return false;
            }
            ConViewTreeListEntry[] conViewTreeListEntryArray2 = children = e.getChildren();
            int n3 = children.length;
            int n4 = 0;
            while (n4 < n3) {
                ConViewTreeListEntry child = conViewTreeListEntryArray2[n4];
                if (!this.childrenSelected(child)) {
                    return false;
                }
                ++n4;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public String findKey(IConLineMatcher a_matcher) {
        if (this.m_entries != null) {
            ConViewTreeListEntry[] conViewTreeListEntryArray = this.m_entries;
            int n = this.m_entries.length;
            int n2 = 0;
            while (n2 < n) {
                ConViewTreeListEntry e = conViewTreeListEntryArray[n2];
                String retValue = this.findKeyInBranch(e, a_matcher);
                if (retValue != null) {
                    return retValue;
                }
                ++n2;
            }
        }
        return null;
    }

    private String findKeyInBranch(ConViewTreeListEntry entry, IConLineMatcher a_matcher) {
        if (a_matcher.matches(entry.getName()) == 1) {
            String[] keys = entry.getKeys();
            return keys.length > 0 ? entry.getKeys()[0] : null;
        }
        if (entry.isCollapsible()) {
            ConViewTreeListEntry[] conViewTreeListEntryArray = entry.getChildren();
            int n = conViewTreeListEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConViewTreeListEntry ce = conViewTreeListEntryArray[n2];
                String retValue = this.findKeyInBranch(ce, a_matcher);
                if (retValue != null) {
                    return retValue;
                }
                ++n2;
            }
        }
        return null;
    }

    public IConViewContentProvider getContentProvider() {
        return this.m_contentProvider;
    }

    public void setContentProvider(IConViewContentProvider provider) {
        this.m_contentProvider = provider;
        this.refresh();
    }

    public boolean isSelectable() {
        return this.m_selectable;
    }

    public void setSelectable(boolean m_selectable) {
        this.m_selectable = m_selectable;
    }

    public boolean isCollapsible() {
        return this.m_collapsible;
    }

    public void setCollapsible(boolean m_collapsible) {
        this.m_collapsible = m_collapsible;
    }
}

