/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.console.shared.pages;

import com.ibm.cic.common.core.console.ConCommonCommandKeys;
import com.ibm.cic.common.core.console.Messages;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.actions.ConActionExit;
import com.ibm.cic.common.core.console.dialogs.ConStatusMessageDialog;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.pages.ConPageEnterPath;
import com.ibm.cic.common.core.console.shared.manager.ConDiskChangePromptManager;
import com.ibm.cic.common.core.console.shared.manager.DiskChangePrompt;
import com.ibm.cic.common.core.console.views.ConViewGroup;
import com.ibm.cic.common.core.console.views.ConViewList;
import com.ibm.cic.common.core.console.views.ConViewText;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.Statuses;
import org.eclipse.core.runtime.IStatus;

public class ConInsertDiskPage
extends AConPage {
    private ConDiskChangePromptManager context;

    public ConInsertDiskPage(IConManager controller) {
        super(controller);
    }

    @Override
    public void init() {
        this.context = this.conManager().getDataContext(ConDiskChangePromptManager.class);
        StringBuilder sb = new StringBuilder();
        sb.append(this.context.getApplication());
        sb.append("> ");
        sb.append(Messages.ConInsertDiskPage_titleInsertDisk);
        this.setHeaderView(sb.toString());
        super.init();
    }

    private String getLocation() {
        this.context = this.conManager().getDataContext(ConDiskChangePromptManager.class);
        String location = this.context.getLocation();
        if (location == null) {
            location = this.context.getPrompt().getPathLocation();
        }
        return location;
    }

    protected void createContents(ConViewGroup contents) {
        this.context = this.conManager().getDataContext(ConDiskChangePromptManager.class);
        DiskChangePrompt p = this.context.getPrompt();
        contents.addView(new ConViewText(p.getPromptMessage()));
        contents.addView(new ConViewText(""));
        contents.addView(new ConViewText(NLS.bind((String)Messages.ConInsertDiskPage_locationInfo, (Object)this.getLocation())));
        contents.addView(new ConViewText(""));
        ConViewList mainList = new ConViewList(Messages.General_Select);
        mainList.setNewLineAfterList(false);
        mainList.addEntry(Messages.ConInsertDiskPage_continueWithDiskAtLocation, "O", (AConActionEntry)new ConActDiskInserted());
        mainList.addEntry(Messages.ConInsertDiskPage_enterNewLocation, "N", (AConActionEntry)ConPageEnterPath.getEnterPathPageAction(Messages.ConInsertDiskPage_enterNewLocationBreadCrumb, Messages.ConInsertDiskPage_enterNewLocatioForDiskOrAlternativeRepo, new ConPageEnterPath.ConActionEnterPath(){

            @Override
            protected IStatus processInput() {
                String input = this.getInput();
                CicFileLocation location = new CicFileLocation(input);
                IStatus status = ((ConInsertDiskPage)ConInsertDiskPage.this).context.getPrompt().validator.validateDisk((ICicLocation)location);
                ConInsertDiskPage.this.context.setLocation(input);
                ConInsertDiskPage.this.context.setResultStatus(status);
                return status;
            }
        }, true, 7)).setContext(this.context);
        mainList.addEntry(Messages.General_Dlg_Cancel, ConCommonCommandKeys.keys_Cancel[0], (AConActionEntry)new ConActCancel());
        contents.addView(mainList);
        this.setSuggestedInput("O");
    }

    @Override
    public void present(OutputFormatter a_output) {
        this.clear();
        this.createContents(this);
        super.present(a_output);
    }

    class ConActCancel
    extends ConActionExit {
        ConActCancel() {
        }

        @Override
        public void run(IConManager a_conManager) {
            ICicStatus status = Statuses.CANCEL.get(203, "", new Object[0]);
            ConInsertDiskPage.this.context.setResultStatus((IStatus)status);
            super.run(a_conManager);
        }
    }

    class ConActDiskInserted
    extends ConActionExit {
        ConActDiskInserted() {
        }

        @Override
        public boolean shouldExit() {
            return ConInsertDiskPage.this.context.getResultStatus().isOK() || ConInsertDiskPage.this.context.getResultStatus().matches(8);
        }

        @Override
        public void run(IConManager manager) {
            String path = ConInsertDiskPage.this.context.getLocation().trim();
            CicFileLocation location = new CicFileLocation(path);
            IStatus status = ((ConInsertDiskPage)ConInsertDiskPage.this).context.getPrompt().validator.validateDisk((ICicLocation)location);
            ConInsertDiskPage.this.context.setResultStatus(status);
            int filter = 7;
            if (status.matches(filter)) {
                ConStatusMessageDialog.open(manager, Messages.ConInsertDiskPage_titleInsertDisk, null, status, filter, false);
            }
        }
    }
}

