/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.console.shared.manager.licensePanel;

import com.ibm.cic.common.core.console.shared.manager.licensePanel.Messages;
import com.ibm.cic.common.core.internal.LicenseFactory;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class LicensePageData {
    private final Map nameGroupMap;
    private Map<LicenseFactory.License, ILicenseNode> licenseToNodeMap = new HashMap<LicenseFactory.License, ILicenseNode>();
    private final LicenseFactory.License[] licenses;
    private Boolean accepted;
    private static final String English = "English";
    private static final String[] EnglishOnlySelection = new String[]{"English"};

    public static String getLicensePageProblems() {
        return Messages.LicensePage_problems;
    }

    public static String getReadCarefullyStatement() {
        return Messages.LicensePage_description;
    }

    public static String getAcceptanceStatement(boolean plural) {
        return plural ? Messages.LicensePage_multiaccept : Messages.LicensePage_accept;
    }

    public static String getDeclinedStatement(boolean plural) {
        return plural ? Messages.LicensePage_multidecline : Messages.LicensePage_decline;
    }

    public static boolean defaultLocaleIsEnglish() {
        return Locale.getDefault().getLanguage().equals("en");
    }

    public static String getEnglishLanguageName() {
        return English;
    }

    public static String getDefaultLocaleLanguageName() {
        return Locale.getDefault().getDisplayLanguage();
    }

    public static String[] getBiLangSelection() {
        return new String[]{Locale.getDefault().getDisplayLanguage(), English};
    }

    public static int getNonEnglishIndex(String[] choices) {
        int i = 0;
        while (i < choices.length) {
            String choice = choices[i];
            if (!English.equals(choice)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getEnglishIndex(String[] choices) {
        int i = 0;
        while (i < choices.length) {
            String choice = choices[i];
            if (English.equals(choice)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean isEnglishIndex(String[] choices, int index) {
        int englishIndex = LicensePageData.getEnglishIndex(choices);
        return englishIndex == index;
    }

    public static LicenseFactory.License[] fetchLicenses(IOfferingOrFix[] offeringsOrFixes) {
        ArrayList<LicenseFactory.License> licenseList = new ArrayList<LicenseFactory.License>();
        IOfferingOrFix[] iOfferingOrFixArray = offeringsOrFixes;
        int n = offeringsOrFixes.length;
        int n2 = 0;
        while (n2 < n) {
            IOfferingOrFix offeringOrFix = iOfferingOrFixArray[n2];
            LicenseFactory.License[] licensesForOfferingOrFix = LicenseFactory.getInstance().findLicenseTextFor(offeringOrFix);
            if (licensesForOfferingOrFix.length > 0) {
                licenseList.addAll(Arrays.asList(licensesForOfferingOrFix));
            }
            ++n2;
        }
        return licenseList.toArray(new LicenseFactory.License[licenseList.size()]);
    }

    public LicensePageData(LicenseFactory.License[] lics) {
        assert (lics != null);
        this.licenses = lics;
        this.nameGroupMap = new HashMap();
        this.licenseToNodeMap = new HashMap<LicenseFactory.License, ILicenseNode>();
        this.addLicenses(lics);
    }

    public Boolean isAccepted() {
        return this.accepted;
    }

    public void setAccepted(Boolean accepted) {
        this.accepted = accepted;
    }

    public LicenseFactory.License[] getLicenses() {
        return this.licenses;
    }

    public boolean hasLicenses() {
        return this.licenses.length > 0;
    }

    public void addLicenses(LicenseFactory.License[] lics) {
        this.generateLicenseTreeNodes(lics);
    }

    public Collection<IGroupingNode> getRootNodes() {
        return this.nameGroupMap.values();
    }

    public ILicenseNode getLicenseNode(LicenseFactory.License license) {
        return this.licenseToNodeMap.get(license);
    }

    public static int sortRanking(Object element) {
        if (element instanceof IGroupingNode) {
            return 0;
        }
        if (element instanceof ILicenseNode) {
            ILicenseNode licenseNode = (ILicenseNode)element;
            if (licenseNode.getLicense().isPrimary()) {
                return 1;
            }
            return 2;
        }
        return 3;
    }

    private void generateLicenseTreeNodes(LicenseFactory.License[] lics) {
        LicenseFactory.License[] licenseArray = lics;
        int n = lics.length;
        int n2 = 0;
        while (n2 < n) {
            LicenseFactory.License lic = licenseArray[n2];
            String groupName = lic.getGrouping();
            GroupingNode groupNode = (GroupingNode)this.nameGroupMap.get(groupName);
            if (groupNode == null) {
                groupNode = new GroupingNode(groupName);
                this.nameGroupMap.put(groupName, groupNode);
            }
            this.generateNodes(groupNode, new ArrayList(lic.getSubGroups()), lic);
            ++n2;
        }
    }

    private void generateNodes(GroupingNode parentNode, List subGroups, LicenseFactory.License license) {
        if (subGroups == null || subGroups.isEmpty()) {
            LicenseNode licNode = new LicenseNode(license);
            parentNode.addLicense(licNode);
            this.licenseToNodeMap.put(license, licNode);
        } else {
            String subGroupName = (String)subGroups.get(0);
            Collection existingSubGroups = parentNode.getSubGroups();
            GroupingNode subGroupNode = this.getSubGroupNode((List)existingSubGroups, subGroupName);
            if (subGroupNode == null) {
                subGroupNode = new GroupingNode(subGroupName);
                parentNode.addSubGroup(subGroupNode);
            }
            subGroups.remove(0);
            this.generateNodes(subGroupNode, subGroups, license);
        }
    }

    private GroupingNode getSubGroupNode(List subGroups, String subGroupName) {
        GroupingNode node = null;
        if (subGroups != null && !subGroups.isEmpty()) {
            int i = 0;
            while (i < subGroups.size()) {
                GroupingNode subGroupNode = (GroupingNode)subGroups.get(i);
                if (subGroupNode.toString().equals(subGroupName)) {
                    node = subGroupNode;
                    break;
                }
                ++i;
            }
        }
        return node;
    }

    private static class GroupingNode
    implements IGroupingNode {
        private final String name;
        private final Set licenseSet = new HashSet();
        private final List subGroups = new ArrayList();
        private GroupingNode parent;

        GroupingNode(String name) {
            this.name = name;
        }

        public void addSubGroup(GroupingNode subGroup) {
            this.subGroups.add(subGroup);
            subGroup.setParentNode(this);
        }

        public List<IGroupingNode> getSubGroups() {
            return this.subGroups;
        }

        public void addLicense(LicenseNode license) {
            this.licenseSet.add(license);
            license.setParentNode(this);
        }

        @Override
        public ILicenseNode[] getLicenses() {
            return this.licenseSet.toArray(new ILicenseNode[this.licenseSet.size()]);
        }

        public boolean equals(Object obj) {
            if (obj instanceof GroupingNode) {
                return this.name.equals(((GroupingNode)obj).name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }

        public void setParentNode(GroupingNode parent) {
            this.parent = parent;
        }

        @Override
        public GroupingNode getParentNode() {
            return this.parent;
        }
    }

    public static interface IGroupingNode {
        public IGroupingNode getParentNode();

        public Collection<IGroupingNode> getSubGroups();

        public ILicenseNode[] getLicenses();
    }

    public static interface ILicenseNode {
        public IGroupingNode getParentNode();

        public LicenseFactory.License getLicense();
    }

    public static class LanguageChoice {
        private boolean english = false;

        public void setEnglish(boolean english) {
            this.english = english;
        }

        public boolean isEnglish() {
            return this.english;
        }
    }

    public static class LanguageChoicesForLicense {
        private final String englishLicenseText;
        private String nonEnglishLicenseText;

        private LanguageChoicesForLicense(String englishLicenseText) {
            this.englishLicenseText = englishLicenseText;
        }

        private LanguageChoicesForLicense(String englishLicenseText, String localizedLicenseText) {
            this(englishLicenseText);
            this.nonEnglishLicenseText = localizedLicenseText;
        }

        public static LanguageChoicesForLicense create(LicenseFactory.License license) throws IOException {
            String englishLicenseText = license.getLicenseText(new Locale("en"));
            String localizedLicenseText = license.getLicenseText(Locale.getDefault());
            if (localizedLicenseText == null || localizedLicenseText.length() == 0 || localizedLicenseText.equals(englishLicenseText)) {
                return new LanguageChoicesForLicense(englishLicenseText);
            }
            return new LanguageChoicesForLicense(englishLicenseText, localizedLicenseText);
        }

        public boolean hasEnglishLicenseText() {
            return this.englishLicenseText != null && this.englishLicenseText.length() > 0;
        }

        public boolean hasNonEnglishLicenseText() {
            return this.nonEnglishLicenseText != null && this.nonEnglishLicenseText.length() > 0;
        }

        public boolean hasOnlyEnglishLicenseText() {
            return !this.hasNonEnglishLicenseText();
        }

        public String getEnglishLicenseText() {
            return this.englishLicenseText;
        }

        public String getNonEnglishLicenseText() {
            return this.nonEnglishLicenseText;
        }

        public String[] getLanguageChoices() {
            if (!this.hasNonEnglishLicenseText()) {
                return EnglishOnlySelection;
            }
            return LicensePageData.getBiLangSelection();
        }

        public String getEnglishLanguageName() {
            String[] choices = this.getLanguageChoices();
            int i = LicensePageData.getEnglishIndex(choices);
            if (i == -1) {
                return null;
            }
            return choices[i];
        }

        public String getNonEnglishLanguageName() {
            String[] choices = this.getLanguageChoices();
            int i = LicensePageData.getNonEnglishIndex(choices);
            if (i == -1) {
                return null;
            }
            return choices[i];
        }

        public String getLicenseText(LanguageChoice languageChoice) {
            return languageChoice.isEnglish() ? this.englishLicenseText : this.nonEnglishLicenseText;
        }
    }

    private static class LicenseNode
    implements ILicenseNode {
        private GroupingNode parent;
        private final LicenseFactory.License linkLicense;

        public LicenseNode(LicenseFactory.License lic) {
            this.linkLicense = lic;
        }

        public void setParentNode(GroupingNode parent) {
            this.parent = parent;
        }

        @Override
        public GroupingNode getParentNode() {
            return this.parent;
        }

        public String toString() {
            return this.linkLicense.toString();
        }

        @Override
        public LicenseFactory.License getLicense() {
            return this.linkLicense;
        }
    }
}

