/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.console.manager;

import com.ibm.cic.common.core.console.Messages;
import com.ibm.cic.common.core.console.actions.ConActionReturnToPreviousPage;
import com.ibm.cic.common.core.console.actions.IConAction;
import com.ibm.cic.common.core.console.actions.IConActionExit;
import com.ibm.cic.common.core.console.dialogs.ConStatusMessageDialog;
import com.ibm.cic.common.core.console.manager.ConIOSimple;
import com.ibm.cic.common.core.console.manager.IConDataCtxt;
import com.ibm.cic.common.core.console.manager.IConIO;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.pages.AConPage;
import com.ibm.cic.common.core.console.pages.AConPageWizard;
import com.ibm.cic.common.core.console.pages.ConPageUnexpectedException;
import com.ibm.cic.common.core.console.views.ConViewHeader;
import com.ibm.cic.common.core.console.views.ConViewText;
import com.ibm.cic.common.core.utils.OutputFormatter;
import com.ibm.cic.common.core.utils.RuntimeStatusException;
import com.ibm.cic.common.core.utils.StandardInputDetector;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public abstract class AConManager
implements IConManager {
    private final List<AConPage> m_pages = new ArrayList<AConPage>();
    private AConPage m_currentPage;
    IConDataCtxt m_dataContext;
    private IConIO m_conIO;
    private final String m_applicationName;
    private static IConIO m_currentIO = null;
    private static int ioCount = 0;

    protected abstract AConPage getWelcomePage();

    protected AConManager(IConIO a_conInput, String a_applicationName) {
        if (a_conInput != null) {
            this.m_conIO = a_conInput;
            if (m_currentIO == null) {
                m_currentIO = this.m_conIO;
                ++ioCount;
            }
        } else if (m_currentIO != null) {
            this.m_conIO = m_currentIO;
            ++ioCount;
        } else {
            m_currentIO = this.m_conIO = new ConIOSimple();
            ++ioCount;
        }
        this.m_applicationName = a_applicationName != null ? a_applicationName : "";
    }

    protected AConManager() {
        this(null, "");
    }

    @Override
    public <T extends IConDataCtxt> T getDataContext(Class<T> c) {
        if (this.m_dataContext != null) {
            return this.m_dataContext.getAdapter(c);
        }
        return null;
    }

    @Override
    public void setDataContext(IConDataCtxt a_context) {
        if (this.m_dataContext != a_context) {
            if (this.m_dataContext != null) {
                this.m_dataContext.dispose();
            }
            this.m_dataContext = a_context;
        }
    }

    @Override
    public AConPage getCurrentPage() {
        return this.m_currentPage;
    }

    public AConPage getUnexpectedExceptionPage(Throwable e) {
        return new ConPageUnexpectedException(this, e);
    }

    public IStatus run() {
        IStatus return_value = Status.OK_STATUS;
        this.addPage(this.getWelcomePage());
        IConAction action = null;
        do {
            try {
                return_value = this.present();
                if (!return_value.isOK() || !(return_value = this.m_currentPage.isPageSecure() ? this.m_conIO.getPassword(this) : this.m_conIO.getUserInput(this, this.m_currentPage.getSuggestedInput())).isOK()) continue;
                action = this.m_currentPage.getAction(this.m_conIO);
                if (action != null) {
                    action.run(this);
                    continue;
                }
                this.presentInvalidEntryError();
                if (!StandardInputDetector.INSTANCE.isActive()) continue;
                this.present();
                break;
            }
            catch (RuntimeStatusException e) {
                ConStatusMessageDialog.openError(this, Messages.PageUnexpectedException_Header, null, e.getStatus());
                this.returnToPageNr(1);
            }
            catch (Throwable e) {
                this.addPage(this.getUnexpectedExceptionPage(e));
            }
        } while (return_value.isOK() && !this.shouldExit(action));
        this.returnToPageNr(0);
        if (--ioCount == 0) {
            m_currentIO = null;
        }
        return return_value;
    }

    private IStatus present() {
        OutputFormatter of = new OutputFormatter();
        this.m_currentPage.present(of);
        return this.m_conIO.display(this, of);
    }

    private void presentInvalidEntryError() {
        this.addPage(new ConInvalidEntryPage(this));
    }

    @Override
    public void addPage(AConPage p) {
        this.m_pages.add(p);
        if (this.m_currentPage != null) {
            this.m_currentPage.setVisible(false);
        }
        this.m_currentPage = p;
        p.initialize();
        this.m_currentPage.setVisible(true);
    }

    @Override
    public void returnToPreviousPage(int pageNr) {
        int len = this.m_pages.size();
        while (len > 0 && pageNr > 0) {
            this.m_pages.remove(--len).dispose();
            --pageNr;
        }
        if (len > 0) {
            this.setCurrentPage(this.m_pages.get(len - 1));
        } else {
            this.setCurrentPage(null);
        }
    }

    @Override
    public void returnToPageNr(int pageNr) {
        int len = this.m_pages.size();
        while (len > pageNr) {
            this.m_pages.remove(--len).dispose();
        }
        if (len > 0) {
            this.setCurrentPage(this.m_pages.get(len - 1));
        } else {
            this.setCurrentPage(null);
        }
    }

    @Override
    public void returnToWizardPage() {
        int i = this.m_pages.size() - 1;
        while (i >= 0) {
            AConPage page = this.m_pages.get(i);
            if (page instanceof AConPageWizard) {
                if (page != this.m_currentPage) {
                    this.setCurrentPage(page);
                }
                return;
            }
            this.m_pages.remove(i).dispose();
            --i;
        }
        this.setCurrentPage(null);
    }

    @Override
    public AConPage getPreviousPage() {
        int len = this.m_pages.size();
        if (len > 1) {
            return this.m_pages.get(len - 2);
        }
        return null;
    }

    @Override
    public AConPageWizard getWizardPage() {
        int i = this.m_pages.size() - 1;
        while (i >= 0) {
            AConPage page = this.m_pages.get(i);
            if (page instanceof AConPageWizard) {
                return (AConPageWizard)page;
            }
            --i;
        }
        return null;
    }

    private void setCurrentPage(AConPage a_page) {
        if (this.m_currentPage != null) {
            this.m_currentPage.setVisible(false);
        }
        this.m_currentPage = a_page;
        if (this.m_currentPage != null) {
            this.m_currentPage.setVisible(true);
        }
    }

    @Override
    public void setIOStatus(IStatus a_status) {
        this.m_conIO.setStatus(a_status);
    }

    @Override
    public String getApplicationName() {
        return this.m_applicationName;
    }

    @Override
    public IConIO getConIO() {
        return this.m_conIO;
    }

    protected boolean shouldExit(IConAction action) {
        if (action instanceof IConActionExit) {
            IConActionExit exitAction = (IConActionExit)action;
            return exitAction.shouldExit();
        }
        return false;
    }

    private class ConInvalidEntryPage
    extends AConPage {
        public ConInvalidEntryPage(IConManager conManager) {
            super(conManager);
        }

        @Override
        public IConAction getAction(IConIO a_input) {
            return new ConActionReturnToPreviousPage();
        }

        @Override
        public void init() {
            this.setHeaderView(new ConViewHeader(this.calculatePreviousHeader(this)));
            this.addView(new ConViewText(String.valueOf(Messages.General_Error) + ' ' + NLS.bind((String)Messages.AConManager_InvalidEntry, (Object)AConManager.this.m_conIO.getString())));
            this.addView(new ConViewText(""));
            super.init();
        }
    }
}

