/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.console.dialogs;

import com.ibm.cic.common.core.console.ConCommonCommandKeys;
import com.ibm.cic.common.core.console.Messages;
import com.ibm.cic.common.core.console.actions.AConActionEntry;
import com.ibm.cic.common.core.console.actions.ConActionExit;
import com.ibm.cic.common.core.console.dialogs.AConDialog;
import com.ibm.cic.common.core.console.manager.IConManager;
import com.ibm.cic.common.core.console.views.ConViewList;
import com.ibm.cic.common.core.console.views.ConViewText;

public class ConMessageDialog
extends AConDialog {
    public static final int NO_DEFAULT_INDEX = -1;
    protected static final Action[] OK_ONLY_ACTION = new Action[]{new Action(Messages.General_Dlg_Ok, ConCommonCommandKeys.keys_OK)};
    protected static final Action[] OK_AND_CANCEL_ACTIONS = new Action[]{new Action(Messages.General_Dlg_Ok, ConCommonCommandKeys.keys_OK), new Action(Messages.General_Dlg_Cancel, ConCommonCommandKeys.keys_Cancel)};
    protected static final Action[] YES_AND_NO_ACTIONS = new Action[]{new Action(Messages.General_Yes, ConCommonCommandKeys.keys_Yes), new Action(Messages.General_No, ConCommonCommandKeys.keys_No)};
    private final String message;
    private final Kind kind;
    private final Action[] actions;
    private final int defaultIndex;

    public ConMessageDialog(IConManager parent, String title, String message, Kind kind, Action[] actions, int defaultIndex) {
        super(parent, title);
        assert (message != null);
        this.message = message;
        assert (kind != null);
        this.kind = kind;
        assert (actions != null && actions.length > 0);
        this.actions = actions;
        assert (defaultIndex == -1 || defaultIndex >= 0 && defaultIndex < actions.length);
        this.defaultIndex = defaultIndex;
    }

    @Override
    public int open() {
        return super.open();
    }

    public static boolean open(Kind kind, IConManager parent, String title, String message) {
        ConMessageDialog dialog = new ConMessageDialog(parent, title, message, kind, ConMessageDialog.getActions(kind), 0);
        return dialog.open() == 0;
    }

    public static boolean openConfirm(IConManager parent, String title, String message) {
        return ConMessageDialog.open(Kind.CONFIRM, parent, title, message);
    }

    public static boolean openError(IConManager parent, String title, String message) {
        return ConMessageDialog.open(Kind.ERROR, parent, title, message);
    }

    public static boolean openInformation(IConManager parent, String title, String message) {
        return ConMessageDialog.open(Kind.INFORMATION, parent, title, message);
    }

    public static boolean openQuestion(IConManager parent, String title, String message) {
        return ConMessageDialog.open(Kind.QUESTION, parent, title, message);
    }

    public static boolean openWarning(IConManager parent, String title, String message) {
        return ConMessageDialog.open(Kind.WARNING, parent, title, message);
    }

    @Override
    protected MDPage createPage() {
        return new MDPage(this);
    }

    protected String getMessage() {
        return this.message;
    }

    protected Kind getKind() {
        return this.kind;
    }

    protected Action[] getActions() {
        return this.actions;
    }

    protected int getDefaultIndex() {
        return this.defaultIndex;
    }

    protected static Action[] getActions(Kind kind) {
        Action[] actions;
        switch (kind) {
            case ERROR: 
            case INFORMATION: 
            case WARNING: {
                actions = OK_ONLY_ACTION;
                break;
            }
            case CONFIRM: {
                actions = OK_AND_CANCEL_ACTIONS;
                break;
            }
            case QUESTION: {
                actions = YES_AND_NO_ACTIONS;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return actions;
    }

    public static class Action {
        private final String name;
        private final String[] keys;

        public Action(String name, String[] keys) {
            this.name = name;
            this.keys = keys;
        }

        public String getName() {
            return this.name;
        }

        public String[] getKeys() {
            return this.keys;
        }
    }

    private static class ActionEntry
    extends ConActionExit {
        private ActionEntry() {
        }

        @Override
        public void run(IConManager manager) {
            AConDialog.ConDialogManager dialogManager = (AConDialog.ConDialogManager)manager;
            dialogManager.getDialog().setReturnCode(this.getEntryIndex());
        }
    }

    public static enum Kind {
        CONFIRM,
        ERROR,
        INFORMATION,
        QUESTION,
        WARNING;

    }

    protected static class MDPage
    extends AConDialog.AConDialogPage {
        protected MDPage(ConMessageDialog dialog) {
            super(dialog);
        }

        @Override
        protected void createContent() {
            ConMessageDialog dialog = (ConMessageDialog)this.getDialog();
            StringBuilder sb = new StringBuilder();
            switch (dialog.getKind()) {
                case ERROR: {
                    sb.append(Messages.General_Error).append(" ");
                    break;
                }
                case WARNING: {
                    sb.append(Messages.General_Warning).append(" ");
                    break;
                }
            }
            sb.append(dialog.getMessage());
            this.addView(new ConViewText(sb.toString()));
            this.addView(ConViewText.NEW_LINE);
        }

        @Override
        protected ConViewList createActions() {
            ConViewList listView = new ConViewList(null, false);
            ConMessageDialog dialog = (ConMessageDialog)this.getDialog();
            Action[] actions = dialog.getActions();
            int defaultIndex = dialog.getDefaultIndex();
            String suggestedInput = null;
            int i = 0;
            while (i < actions.length) {
                Action action = actions[i];
                String name = action.getName();
                String[] keys = action.getKeys();
                listView.addEntry(name, keys, (AConActionEntry)new ActionEntry());
                if (i == defaultIndex && keys.length > 0) {
                    suggestedInput = keys[0];
                }
                ++i;
            }
            listView.setNewLineAfterList(true);
            this.setSuggestedInput(suggestedInput);
            return listView;
        }
    }
}

