/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.ui.swt.controls;

import com.ibm.cic.common.core.internal.LicenseFactory;
import com.ibm.cic.common.ui.internal.CommonUIUtils;
import com.ibm.cic.common.ui.internal.licensePanel.BaseEclipseStyleLicensePage;
import com.ibm.cic.common.ui.internal.licensePanel.LicensePart;
import java.io.IOException;
import java.util.Locale;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;

public class SwtLicensePart
extends LicensePart {
    public SwtLicensePart(BaseEclipseStyleLicensePage parentPage) {
        super(parentPage);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    protected void createPrintControls(Composite buttonContainer) {
        PrinterData[] printerList;
        boolean skipDisablePrintButton;
        super.createPrintControls(buttonContainer);
        boolean bl = skipDisablePrintButton = Platform.getOS().equals("solaris") || Platform.getOS().equals("linux");
        if (!(skipDisablePrintButton || (printerList = Printer.getPrinterList()) != null && printerList.length > 0)) {
            this.printButton.setEnabled(false);
        }
        this.printButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrintDialog dialog = new PrintDialog(SwtLicensePart.this.printButton.getShell(), 32768);
                dialog.setScope(0);
                PrinterData printerData = dialog.open();
                if (printerData != null) {
                    final Printer printer = new Printer(printerData);
                    String originalContent = SwtLicensePart.this.text.getText();
                    StringBuffer printText = new StringBuffer();
                    if (SwtLicensePart.this.licenseArray != null && SwtLicensePart.this.licenseArray.length > 1) {
                        LicenseFactory.License[] licenseArray = SwtLicensePart.this.licenseArray;
                        int n = licenseArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            LicenseFactory.License element = licenseArray[n2];
                            String licenseTextToPrint = null;
                            Locale currentLocale = null;
                            currentLocale = SwtLicensePart.this.currentLanguageChoice.isEnglish() ? Locale.ENGLISH : Locale.getDefault();
                            try {
                                licenseTextToPrint = element.getLicenseText(currentLocale);
                            }
                            catch (IOException iOException) {
                                licenseTextToPrint = "";
                            }
                            printText.append(element.getGrouping());
                            printText.append(":");
                            printText.append(element.getFileFullPathName(currentLocale));
                            printText.append(SwtLicensePart.this.text.getLineDelimiter());
                            printText.append(SwtLicensePart.this.text.getLineDelimiter());
                            printText.append(licenseTextToPrint);
                            printText.append(SwtLicensePart.this.text.getLineDelimiter());
                            printText.append(SwtLicensePart.this.text.getLineDelimiter());
                            ++n2;
                        }
                    }
                    if (printText.length() > 0) {
                        SwtLicensePart.this.text.setText(printText.toString());
                    }
                    final Runnable styledTextPrinter = SwtLicensePart.this.text.print((Device)printer);
                    Thread printingThread = new Thread("Printing License Files"){

                        @Override
                        public void run() {
                            styledTextPrinter.run();
                            printer.dispose();
                        }
                    };
                    printingThread.start();
                    if (printText.length() > 0) {
                        SwtLicensePart.this.text.setText(originalContent);
                    }
                }
            }
        });
    }

    protected void resetLicenseTextOrientation(boolean englishLicense) {
        if (CommonUIUtils.runningBiDiLocale()) {
            int orientation = englishLicense ? 0x2000000 : 0x4000000;
            this.text.setOrientation(orientation);
            this.text.getParent().layout();
        }
    }
}

