/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.ILGenMacros;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.ThunkTable;
import java.lang.invoke.WrongMethodTypeException;

final class VarargsCollectorHandle
extends MethodHandle {
    final MethodHandle next;
    final Class<?> arrayType;
    private static final ThunkTable _thunkTable = new ThunkTable();

    VarargsCollectorHandle(MethodHandle next, Class<?> arrayType) {
        super(VarargsCollectorHandle.varargsCollectorType(next.type, arrayType), null, null, 17, null);
        this.next = next;
        if (arrayType == null) {
            throw new IllegalArgumentException();
        }
        this.arrayType = arrayType;
        this.rawModifiers = next.rawModifiers & 0xFFFFFF7F;
        this.defc = next.defc;
    }

    VarargsCollectorHandle(VarargsCollectorHandle originalHandle, MethodType newType) {
        super(originalHandle, newType);
        this.next = originalHandle.next;
        this.arrayType = originalHandle.arrayType;
    }

    static MethodType varargsCollectorType(MethodType nextType, Class<?> arrayType) {
        return nextType.changeParameterType(nextType.parameterCount() - 1, arrayType);
    }

    @Override
    public MethodHandle asType(MethodType newType) throws ClassCastException {
        int newTypeParameterCount;
        if (this.type.equals(newType)) {
            return this;
        }
        int parameterCount = this.type.parameterCount();
        if (parameterCount == (newTypeParameterCount = newType.parameterCount()) && this.type.parameterType(parameterCount - 1).isAssignableFrom(newType.parameterType(parameterCount - 1))) {
            return this.next.asType(newType);
        }
        int collectCount = newTypeParameterCount - parameterCount + 1;
        if (collectCount < 0) {
            throw new WrongMethodTypeException();
        }
        return this.next.asCollector(this.arrayType, collectCount).asType(newType);
    }

    @Override
    public MethodHandle asVarargsCollector(Class<?> arrayParameter) throws IllegalArgumentException {
        if (!this.arrayType.isAssignableFrom(arrayParameter)) {
            throw new IllegalArgumentException("Cannot assign '" + arrayParameter + "' to methodtype '" + this.type + "'");
        }
        return this.next.asVarargsCollector(arrayParameter);
    }

    @Override
    public MethodHandle asFixedArity() {
        MethodHandle fixedArity = this.next;
        while (fixedArity.isVarargsCollector()) {
            fixedArity = ((VarargsCollectorHandle)fixedArity).next;
        }
        return fixedArity.asType(this.type());
    }

    @Override
    protected final ThunkTable thunkTable() {
        return _thunkTable;
    }

    @MethodHandle.Invisible
    private final void invokeExact_thunkArchetype_V(int argPlaceholder) throws Throwable {
        ILGenMacros.invokeExact_V(this.next, argPlaceholder);
    }

    @MethodHandle.Invisible
    private final int invokeExact_thunkArchetype_I(int argPlaceholder) throws Throwable {
        return ILGenMacros.invokeExact_I(this.next, argPlaceholder);
    }

    @MethodHandle.Invisible
    private final long invokeExact_thunkArchetype_J(int argPlaceholder) throws Throwable {
        return ILGenMacros.invokeExact_J(this.next, argPlaceholder);
    }

    @MethodHandle.Invisible
    private final float invokeExact_thunkArchetype_F(int argPlaceholder) throws Throwable {
        return ILGenMacros.invokeExact_F(this.next, argPlaceholder);
    }

    @MethodHandle.Invisible
    private final double invokeExact_thunkArchetype_D(int argPlaceholder) throws Throwable {
        return ILGenMacros.invokeExact_D(this.next, argPlaceholder);
    }

    @MethodHandle.Invisible
    private final Object invokeExact_thunkArchetype_L(int argPlaceholder) throws Throwable {
        return ILGenMacros.invokeExact_L(this.next, argPlaceholder);
    }

    @Override
    MethodHandle cloneWithNewType(MethodType newType) {
        return new VarargsCollectorHandle(this, newType);
    }
}

