/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.SharedClassPermission;
import com.ibm.oti.shared.SharedHelper;
import java.lang.ref.WeakReference;
import java.security.AccessControlException;

public abstract class SharedAbstractHelper
implements SharedHelper {
    private Boolean verbose;
    private WeakReference loaderRef;
    private SharedClassPermission readPerm;
    private SharedClassPermission writePerm;
    boolean canFind;
    boolean canStore;
    int id;

    void initialize(ClassLoader loader, int id, boolean canFind, boolean canStore) {
        this.id = id;
        this.canFind = canFind;
        this.canStore = canStore;
        this.loaderRef = new WeakReference<ClassLoader>(loader);
        this.printVerboseInfo("Created " + this.getHelperType() + " with id " + id);
    }

    @Override
    public ClassLoader getClassLoader() {
        return (ClassLoader)this.loaderRef.get();
    }

    private native boolean getIsVerboseImpl();

    private boolean checkPermission(SecurityManager sm, ClassLoader loader, String type) {
        boolean result = false;
        try {
            sm.checkPermission(new SharedClassPermission(loader, type));
            result = true;
        }
        catch (AccessControlException e) {
            // empty catch block
        }
        return result;
    }

    boolean checkReadPermission(ClassLoader loader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return this.checkPermission(sm, loader, "read");
        }
        return true;
    }

    boolean checkWritePermission(ClassLoader loader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return this.checkPermission(sm, loader, "write");
        }
        return true;
    }

    private boolean isVerbose() {
        if (this.verbose == null) {
            boolean verboseSet = this.getIsVerboseImpl();
            this.verbose = new Boolean(verboseSet);
            if (verboseSet) {
                this.printVerboseInfo("Verbose output enabled for " + this.getHelperType() + " id " + this.id);
            }
        }
        return this.verbose;
    }

    void printVerboseError(String message) {
        if (this.isVerbose()) {
            System.err.println("Error for " + this.getHelperType() + " id " + this.id + ": " + message);
        }
    }

    void printVerboseInfo(String message) {
        if (this.isVerbose()) {
            System.err.println("Info for " + this.getHelperType() + " id " + this.id + ": " + message);
        }
    }

    abstract String getHelperType();
}

