/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import sun.reflect.ConstantPool;

public class AnnotationParser {
    public static Annotation[] parseAnnotations(Field field) {
        return AnnotationParser.parseAnnotations(AnnotationParser.getAnnotationsData(field), field.getDeclaringClass());
    }

    public static Annotation[] parseAnnotations(Constructor constructor) {
        return AnnotationParser.parseAnnotations(AnnotationParser.getAnnotationsData(constructor), constructor.getDeclaringClass());
    }

    public static Annotation[] parseAnnotations(Method method) {
        return AnnotationParser.parseAnnotations(AnnotationParser.getAnnotationsData(method), method.getDeclaringClass());
    }

    public static Annotation[][] parseParameterAnnotations(Constructor constructor) {
        return AnnotationParser.parseParameterAnnotations(AnnotationParser.getParameterAnnotationsData(constructor), constructor.getDeclaringClass(), constructor.getParameterTypes().length);
    }

    public static Annotation[][] parseParameterAnnotations(Method method) {
        return AnnotationParser.parseParameterAnnotations(AnnotationParser.getParameterAnnotationsData(method), method.getDeclaringClass(), method.getParameterTypes().length);
    }

    public static byte[] getAnnotationsData(Class clazz) {
        byte[] result = null;
        if (null != clazz) {
            result = AnnotationParser.getAnnotationsDataImpl(clazz);
        }
        return result;
    }

    public static Object parseDefaultValue(Method method) {
        byte[] elementValueData = AnnotationParser.getDefaultValueData(method);
        if (elementValueData == null) {
            return null;
        }
        ByteBuffer buf = ByteBuffer.wrap(elementValueData);
        Class<?> clazz = method.getDeclaringClass();
        Class<Object> returnType = method.getReturnType();
        if (returnType.isPrimitive()) {
            if (returnType == Boolean.TYPE) {
                returnType = Boolean.class;
            } else if (returnType == Character.TYPE) {
                returnType = Character.class;
            } else if (returnType == Byte.TYPE) {
                returnType = Byte.class;
            } else if (returnType == Short.TYPE) {
                returnType = Short.class;
            } else if (returnType == Integer.TYPE) {
                returnType = Integer.class;
            } else if (returnType == Long.TYPE) {
                returnType = Long.class;
            } else if (returnType == Float.TYPE) {
                returnType = Float.class;
            } else if (returnType == Double.TYPE) {
                returnType = Double.class;
            }
        }
        return sun.reflect.annotation.AnnotationParser.parseMemberValue(returnType, (ByteBuffer)buf, (ConstantPool)AnnotationParser.getConstantPool(clazz), clazz);
    }

    public static Annotation[] parseAnnotations(byte[] annotationsData, Class clazz) {
        return sun.reflect.annotation.AnnotationParser.toArray(sun.reflect.annotation.AnnotationParser.parseAnnotations((byte[])annotationsData, (ConstantPool)AnnotationParser.getConstantPool(clazz), (Class)clazz));
    }

    private static native byte[] getAnnotationsData(Field var0);

    private static native byte[] getAnnotationsData(Constructor var0);

    private static native byte[] getAnnotationsData(Method var0);

    private static native byte[] getParameterAnnotationsData(Constructor var0);

    private static native byte[] getParameterAnnotationsData(Method var0);

    private static native byte[] getDefaultValueData(Method var0);

    private static native ConstantPool getConstantPool(Class var0);

    private static native byte[] getAnnotationsDataImpl(Class var0);

    private static Annotation[][] parseParameterAnnotations(byte[] annotationsData, Class<?> declaringClass, int parametersCount) {
        if (annotationsData == null) {
            Annotation[][] annotations = new Annotation[parametersCount][];
            for (int i = 0; i < parametersCount; ++i) {
                annotations[i] = new Annotation[0];
            }
            return annotations;
        }
        return sun.reflect.annotation.AnnotationParser.parseParameterAnnotations((byte[])annotationsData, (ConstantPool)AnnotationParser.getConstantPool(declaringClass), declaringClass);
    }
}

