/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm;

import com.ibm.jvm.DumpPermission;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class Dump {
    private static final DumpPermission DUMP_PERMISSION = new DumpPermission();
    private static final String LEGACY_PERMISSION_PROPERTY = "com.ibm.jvm.enableLegacyDumpSecurity";

    public static void JavaDump() {
        Dump.checkLegacySecurityPermssion();
        Dump.JavaDumpImpl();
    }

    public static void HeapDump() {
        Dump.checkLegacySecurityPermssion();
        Dump.HeapDumpImpl();
    }

    public static void SystemDump() {
        Dump.checkLegacySecurityPermssion();
        Dump.SystemDumpImpl();
    }

    private Dump() {
    }

    private static native int JavaDumpImpl();

    private static native int HeapDumpImpl();

    private static native int SystemDumpImpl();

    private static void checkDumpSecurityPermssion() throws SecurityException {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(DUMP_PERMISSION);
        }
    }

    private static void checkLegacySecurityPermssion() throws SecurityException {
        String flag = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(Dump.LEGACY_PERMISSION_PROPERTY);
            }
        });
        boolean legacyDumpSecurityEnabled = Boolean.TRUE.toString().equals(flag);
        if (legacyDumpSecurityEnabled) {
            Dump.checkDumpSecurityPermssion();
        }
    }
}

