/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.agent.internal.installAdaptors;

import com.ibm.cic.agent.core.InstallContext;
import com.ibm.cic.agent.internal.installAdaptors.ConfigurationContributorEditor;
import com.ibm.cic.agent.internal.installAdaptors.EclipseConfigureOperation;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.CommonAdapterData;
import com.ibm.cic.common.eclipseAdapterData.EclipseRestartData;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class RestartConfigurationOperation
extends EclipseConfigureOperation {
    private static final String RESTART_FILENAME = "restart";

    public RestartConfigurationOperation(IInstallableUnit unit, InstallContext context, ConfigurationContributorEditor targetedConfig, boolean configure) {
        super(unit, context, targetedConfig, configure);
    }

    protected CommonAdapterData getData() {
        return new EclipseRestartData();
    }

    protected IStatus doPerform(IProgressMonitor monitor) throws CoreException {
        if (this.targetedConfig.isDirty()) {
            this.targetedConfig.save(monitor);
        }
        this.restart();
        this.getInstallContext().setNeedsRestart(false);
        return Status.OK_STATUS;
    }

    private void restart() {
        try {
            if (this.targetedConfig.isRunning()) {
                new File(this.targetedConfig.getConfigurationLocation(), RESTART_FILENAME).createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

